/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.java.hints;

import com.sun.source.util.TreePath;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.type.TypeMirror;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.java.hints.spiimpl.JavaFixImpl;
import org.netbeans.modules.java.hints.spiimpl.batch.BatchUtilities;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFixUtilities;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Parameters;

public abstract class JavaFix {
    private final TreePathHandle handle;
    private final Map<String, String> options;
    private final String sortText;
    private volatile Function<ModificationResult, ChangeInfo> modResult2ChangeInfo;

    protected JavaFix(@NonNull CompilationInfo info, @NonNull TreePath tp) {
        this(info, tp, Collections.emptyMap());
    }

    protected JavaFix(@NonNull CompilationInfo info, @NonNull TreePath tp, @NullAllowed String sortText) {
        this(TreePathHandle.create((TreePath)tp, (CompilationInfo)info), Collections.emptyMap(), sortText);
    }

    JavaFix(CompilationInfo info, TreePath tp, Map<String, String> options) {
        this(TreePathHandle.create((TreePath)tp, (CompilationInfo)info), options, null);
    }

    protected JavaFix(@NonNull TreePathHandle handle) {
        this(handle, Collections.emptyMap());
    }

    protected JavaFix(@NonNull TreePathHandle handle, @NullAllowed String sortText) {
        this(handle, Collections.emptyMap());
    }

    JavaFix(TreePathHandle handle, Map<String, String> options) {
        this(handle, options, null);
    }

    JavaFix(TreePathHandle handle, Map<String, String> options, String sortText) {
        this.handle = handle;
        this.options = Collections.unmodifiableMap(new HashMap<String, String>(options));
        this.sortText = sortText;
    }

    @NonNull
    protected abstract String getText();

    protected abstract void performRewrite(@NonNull TransformationContext var1) throws Exception;

    public final Fix toEditorFix() {
        return this.sortText != null ? new JavaFixImpl.EnhancedJavaFixImpl(this) : new JavaFixImpl(this);
    }

    static {
        JavaFixImpl.Accessor.INSTANCE = new JavaFixImpl.Accessor(){

            @Override
            public String getText(JavaFix jf) {
                return jf.getText();
            }

            @Override
            public ChangeInfo process(JavaFix jf, WorkingCopy wc, boolean canShowUI, Map<FileObject, byte[]> resourceContent, Collection<? super RefactoringElementImplementation> fileChanges) throws Exception {
                TreePath tp = jf.handle.resolve((CompilationInfo)wc);
                if (tp == null) {
                    Logger.getLogger(JavaFix.class.getName()).log(Level.SEVERE, "Cannot resolve handle={0}", jf.handle);
                    return null;
                }
                GeneratorUtilities.get((WorkingCopy)wc).importComments(tp.getLeaf(), wc.getCompilationUnit());
                jf.performRewrite(new TransformationContext(wc, tp, canShowUI, resourceContent, fileChanges));
                return null;
            }

            @Override
            public FileObject getFile(JavaFix jf) {
                return jf.handle.getFileObject();
            }

            @Override
            public Map<String, String> getOptions(JavaFix jf) {
                return jf.options;
            }

            @Override
            public Fix rewriteFix(CompilationInfo info, String displayName, TreePath what, String to, Map<String, TreePath> parameters, Map<String, Collection<? extends TreePath>> parametersMulti, Map<String, String> parameterNames, Map<String, TypeMirror> constraints, Map<String, String> options, String ... imports) {
                return JavaFixUtilities.rewriteFix(info, displayName, what, to, parameters, parametersMulti, parameterNames, constraints, options, imports);
            }

            @Override
            public Fix createSuppressWarningsFix(CompilationInfo compilationInfo, TreePath treePath, String ... keys) {
                return ErrorDescriptionFactory.createSuppressWarningsFix(compilationInfo, treePath, keys);
            }

            @Override
            public List<Fix> createSuppressWarnings(CompilationInfo compilationInfo, TreePath treePath, String ... keys) {
                return ErrorDescriptionFactory.createSuppressWarnings(compilationInfo, treePath, keys);
            }

            @Override
            public List<Fix> resolveDefaultFixes(HintContext ctx, Fix ... provided) {
                return ErrorDescriptionFactory.resolveDefaultFixes(ctx, provided);
            }

            @Override
            public String getSortText(JavaFix jf) {
                return jf.sortText;
            }

            @Override
            public void setChangeInfoConvertor(JavaFix jf, Function<ModificationResult, ChangeInfo> modResult2ChangeInfo) {
                jf.modResult2ChangeInfo = modResult2ChangeInfo;
            }

            @Override
            public Function<ModificationResult, ChangeInfo> getChangeInfoConvertor(JavaFix jf) {
                return jf.modResult2ChangeInfo;
            }
        };
    }

    public static final class TransformationContext {
        private final WorkingCopy workingCopy;
        private final TreePath path;
        private final boolean canShowUI;
        private final Map<FileObject, byte[]> resourceContentChanges;
        private final Collection<? super RefactoringElementImplementation> fileChanges;

        TransformationContext(WorkingCopy workingCopy, TreePath path, boolean canShowUI, Map<FileObject, byte[]> resourceContentChanges, Collection<? super RefactoringElementImplementation> fileChanges) {
            this.workingCopy = workingCopy;
            this.path = path;
            this.canShowUI = canShowUI;
            this.resourceContentChanges = resourceContentChanges;
            this.fileChanges = fileChanges;
        }

        boolean isCanShowUI() {
            return this.canShowUI;
        }

        @NonNull
        public TreePath getPath() {
            return this.path;
        }

        @NonNull
        public WorkingCopy getWorkingCopy() {
            return this.workingCopy;
        }

        @NonNull
        public InputStream getResourceContent(@NonNull FileObject file) throws IOException, IllegalArgumentException {
            byte[] newContent;
            Parameters.notNull((CharSequence)"file", (Object)file);
            if ("text/x-java".equals(file.getMIMEType(new String[]{"text/x-java"}))) {
                throw new IllegalArgumentException("Cannot access Java files");
            }
            byte[] byArray = newContent = this.resourceContentChanges != null ? this.resourceContentChanges.get(file) : null;
            if (newContent == null) {
                final Document doc = BatchUtilities.getDocument(file);
                if (doc != null) {
                    final String[] result = new String[1];
                    doc.render(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                result[0] = doc.getText(0, doc.getLength());
                            }
                            catch (BadLocationException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    });
                    if (result[0] != null) {
                        ByteBuffer encoded = FileEncodingQuery.getEncoding((FileObject)file).encode(result[0]);
                        byte[] encodedBytes = new byte[encoded.remaining()];
                        encoded.get(encodedBytes);
                        return new ByteArrayInputStream(encodedBytes);
                    }
                }
                return file.getInputStream();
            }
            return new ByteArrayInputStream(newContent);
        }

        @NonNull
        public OutputStream getResourceOutput(final @NonNull FileObject file) throws IOException {
            Parameters.notNull((CharSequence)"file", (Object)file);
            if ("text/x-java".equals(file.getMIMEType(new String[]{"text/x-java"}))) {
                throw new IllegalArgumentException("Cannot access Java files");
            }
            if (this.resourceContentChanges == null) {
                return file.getOutputStream();
            }
            return new ByteArrayOutputStream(){

                @Override
                public void close() throws IOException {
                    super.close();
                    resourceContentChanges.put(file, this.toByteArray());
                }
            };
        }

        Collection<? super RefactoringElementImplementation> getFileChanges() {
            return this.fileChanges;
        }
    }
}

