/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.progress;

import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lsp4j.ProgressParams;
import org.eclipse.lsp4j.WorkDoneProgressBegin;
import org.eclipse.lsp4j.WorkDoneProgressEnd;
import org.eclipse.lsp4j.WorkDoneProgressNotification;
import org.eclipse.lsp4j.WorkDoneProgressReport;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.netbeans.modules.java.lsp.server.progress.OperationContext;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.netbeans.modules.progress.spi.Controller;
import org.netbeans.modules.progress.spi.InternalHandle;
import org.netbeans.modules.progress.spi.ProgressEvent;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public final class LspInternalHandle
extends InternalHandle {
    private static final Logger LOG = Logger.getLogger(LspInternalHandle.class.getName());
    private final NbCodeLanguageClient lspClient;
    private final OperationContext opContext;
    private final Function<InternalHandle, Controller> controllerProvider;
    private final Lookup operationLookup;
    private final StackTraceElement[] creatorTrace = new Throwable().getStackTrace();
    private CompletableFuture<Either<String, Number>> tokenPromise;
    private int reportedPercentage;
    private boolean started;
    private boolean explicitCancelRequest;
    private static Field controllerField;

    public LspInternalHandle(OperationContext opContext, NbCodeLanguageClient lspClient, Function<InternalHandle, Controller> controllerProvider, String displayName, Cancellable cancel, boolean userInitiated) {
        super(displayName, cancel, userInitiated);
        this.lspClient = lspClient;
        this.opContext = opContext;
        this.controllerProvider = controllerProvider;
        this.operationLookup = Lookup.getDefault();
        if (opContext != null) {
            opContext.internalHandleCreated(this);
        }
    }

    public StackTraceElement[] getCreatorTrace() {
        return this.creatorTrace;
    }

    public Lookup getOperationLookup() {
        return this.operationLookup;
    }

    public void forceRequestCancel() {
        this.explicitCancelRequest = true;
        this.requestCancel();
    }

    public boolean isAllowCancel() {
        return super.isAllowCancel() && (this.explicitCancelRequest || !this.opContext.isDisableCancels());
    }

    public OperationContext getContext() {
        return this.opContext;
    }

    private synchronized Controller findController() {
        if (controllerField == null) {
            try {
                controllerField = InternalHandle.class.getDeclaredField("controller");
                controllerField.setAccessible(true);
            }
            catch (NoSuchFieldException | SecurityException ex) {
                throw new IllegalStateException();
            }
        }
        try {
            return (Controller)controllerField.get((Object)this);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public synchronized void start(String message, int workunits, long estimate) {
        Controller attached = this.findController();
        if (attached == null) {
            this.setController(this.controllerProvider.apply(this));
        }
        super.start(message, workunits, estimate);
    }

    public void requestView() {
    }

    public boolean isCustomPlaced() {
        return false;
    }

    public boolean isAllowView() {
        return false;
    }

    String id() {
        return Integer.toHexString(System.identityHashCode((Object)this));
    }

    void sendStartMessage(ProgressEvent e) {
        WorkDoneProgressBegin start = new WorkDoneProgressBegin();
        boolean determinate = this.getTotalUnits() > 0;
        start.setCancellable(Boolean.valueOf(this.isAllowCancel()));
        start.setTitle(this.getDisplayName());
        if (determinate) {
            double percent = e.getPercentageDone();
            if (percent != -1.0) {
                start.setPercentage(Integer.valueOf(LspInternalHandle.cleverFloor(percent)));
            } else {
                start.setPercentage(Integer.valueOf(0));
            }
        }
        LOG.log(Level.FINE, "Starting progress: {0}", (Object)this);
        this.started = true;
        this.notify((WorkDoneProgressNotification)start);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LspProgress@").append(this.id()).append("[");
        sb.append("display: ").append(this.getDisplayName()).append(", total: ").append(this.getTotalUnits()).append(", percent: ").append(String.format("%3.2f", this.getPercentageDone())).append(", state: ").append(this.getState());
        sb.append("]");
        return sb.toString();
    }

    static int cleverFloor(double percent) {
        return (int)(percent > 90.0 ? Math.floor(percent) : (double)Math.round(percent));
    }

    void sendProgress(ProgressEvent e) {
        if (!this.started) {
            this.sendStartMessage(e);
            return;
        }
        WorkDoneProgressReport report = new WorkDoneProgressReport();
        double percent = e.getPercentageDone();
        if (percent != -1.0) {
            report.setPercentage(Integer.valueOf(LspInternalHandle.cleverFloor(percent)));
        }
        report.setMessage(e.getMessage());
        report.setCancellable(Boolean.valueOf(this.isAllowCancel()));
        this.notify((WorkDoneProgressNotification)report);
    }

    Either<String, Number> token() {
        if (this.tokenPromise == null || this.tokenPromise.isCompletedExceptionally()) {
            return null;
        }
        return this.tokenPromise.getNow(null);
    }

    void sendFinish(ProgressEvent e) {
        WorkDoneProgressEnd end = new WorkDoneProgressEnd();
        end.setMessage(e.getMessage());
        this.notify((WorkDoneProgressNotification)end);
        this.opContext.removeHandle(this.token(), this);
    }

    CompletableFuture<Either<String, Number>> findProgressToken() {
        if (this.tokenPromise != null) {
            return this.tokenPromise;
        }
        this.tokenPromise = this.opContext.acquireOrObtainToken(this);
        return this.tokenPromise;
    }

    void notify(WorkDoneProgressNotification msg) {
        this.findProgressToken().thenAccept(token -> {
            LOG.log(Level.FINER, () -> MessageFormat.format("Sending progress {0}, msg: {1}", this.id(), msg));
            ProgressParams param = new ProgressParams(token, msg);
            this.lspClient.notifyProgress(param);
        });
    }
}

