/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.io.InputOutput;
import org.netbeans.modules.debugger.jpda.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.console.DebuggerOutput;
import org.netbeans.spi.debugger.ContextProvider;

public final class DebuggerConsoleIO {
    private final JPDADebuggerImpl debugger;
    private final DebuggerOutput output;

    DebuggerConsoleIO(JPDADebuggerImpl debugger, ContextProvider lookupProvider) {
        this.debugger = debugger;
        this.output = new DebuggerOutput(debugger, lookupProvider);
    }

    @CheckForNull
    public InputOutput getIO() {
        return this.output.getIOManager().getIO();
    }

    public void println(String text, Line line) {
        this.output.getIOManager().println(text, line);
    }

    public void println(String text, Line line, boolean important) {
        this.output.getIOManager().println(text, line, important);
    }

    public static final class Line {
        private final String url;
        private final int lineNumber;
        private final Reference<JPDADebugger> debuggerRef;

        public Line(String url, int lineNumber, JPDADebugger debuggerTimeStamp) {
            this.url = url;
            this.lineNumber = lineNumber;
            this.debuggerRef = new WeakReference<JPDADebugger>(debuggerTimeStamp);
        }

        public void show() {
            EditorContextBridge.getContext().showSource(this.url, this.lineNumber, (Object)this.debuggerRef.get());
        }
    }
}

