/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.manager.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class MethodExceptionDialog
extends JPanel {
    private final JButton okButton = new JButton(NbBundle.getMessage(this.getClass(), (String)"OPTION_OK"));
    private JEditorPane messagePane;
    private JScrollPane scrollPane;

    public MethodExceptionDialog(Throwable exception) {
        this.initComponents();
        Throwable throwable = exception;
        if (throwable instanceof InvocationTargetException) {
            throwable = ((InvocationTargetException)throwable).getTargetException();
        }
        this.initMessage(throwable);
    }

    public void showDialog(JComponent invoker) {
        DialogDescriptor dlg = new DialogDescriptor((Object)this, NbBundle.getMessage(this.getClass(), (String)"CLIENT_EXCEPTION"), false, 2, DialogDescriptor.OK_OPTION, 0, HelpCtx.DEFAULT_HELP, null);
        dlg.setOptions(new Object[]{this.okButton});
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dlg);
        dialog.setPreferredSize(new Dimension(500, 300));
        dialog.setLocationRelativeTo(invoker);
        dialog.setVisible(true);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.messagePane = new JEditorPane();
        this.messagePane.setContentType("text/html");
        this.messagePane.setEditable(false);
        this.messagePane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(this.getClass(), (String)"MethodExceptionDialog.messagePane.ACC_name"));
        this.messagePane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(this.getClass(), (String)"MethodExceptionDialog.messagePane.ACC_desc"));
        this.scrollPane = new JScrollPane();
        this.scrollPane.setViewportView(this.messagePane);
        this.add((Component)this.scrollPane, "Center");
    }

    private void initMessage(Throwable exception) {
        StringBuilder builder = new StringBuilder();
        builder.append("<html><body>");
        for (Throwable cause = exception; cause != null; cause = cause.getCause()) {
            builder.append("<h3>");
            builder.append(cause.getLocalizedMessage());
            builder.append("</h3>");
            builder.append(cause.getClass().getName()).append(" at <br>");
            for (StackTraceElement element : cause.getStackTrace()) {
                builder.append(this.escape(element.toString()));
                builder.append("<br>");
            }
        }
        builder.append("</body></html>");
        this.messagePane.setText(builder.toString());
    }

    private String escape(String line) {
        return line.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }
}

