/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.v8debug;

import org.netbeans.lib.v8debug.PropertyLong;

public final class V8Breakpoint {
    private final Type type;
    private final PropertyLong scriptId;
    private final String scriptName;
    private final long number;
    private final PropertyLong line;
    private final PropertyLong column;
    private final PropertyLong groupId;
    private final long hitCount;
    private final boolean active;
    private final String condition;
    private final long ignoreCount;
    private final ActualLocation[] actualLocations;

    public V8Breakpoint(Type type, PropertyLong scriptId, String scriptName, long number, PropertyLong line, PropertyLong column, PropertyLong groupId, long hitCount, boolean active, String condition, long ignoreCount, ActualLocation[] actualLocations) {
        this.type = type;
        this.scriptId = scriptId;
        this.scriptName = scriptName;
        this.number = number;
        this.line = line;
        this.column = column;
        this.groupId = groupId;
        this.hitCount = hitCount;
        this.active = active;
        this.condition = condition;
        this.ignoreCount = ignoreCount;
        this.actualLocations = actualLocations;
    }

    public Type getType() {
        return this.type;
    }

    public PropertyLong getScriptId() {
        return this.scriptId;
    }

    public String getScriptName() {
        return this.scriptName;
    }

    public long getNumber() {
        return this.number;
    }

    public PropertyLong getLine() {
        return this.line;
    }

    public PropertyLong getColumn() {
        return this.column;
    }

    public PropertyLong getGroupId() {
        return this.groupId;
    }

    public long getHitCount() {
        return this.hitCount;
    }

    public boolean isActive() {
        return this.active;
    }

    public String getCondition() {
        return this.condition;
    }

    public long getIgnoreCount() {
        return this.ignoreCount;
    }

    public ActualLocation[] getActualLocations() {
        return this.actualLocations;
    }

    public static final class ActualLocation {
        private final long line;
        private final long column;
        private final PropertyLong scriptId;
        private final String scriptName;

        public ActualLocation(long line, long column, long scriptId) {
            this.line = line;
            this.column = column;
            this.scriptId = new PropertyLong(scriptId);
            this.scriptName = null;
        }

        public ActualLocation(long line, long column, String scriptName) {
            this.line = line;
            this.column = column;
            this.scriptId = new PropertyLong(null);
            this.scriptName = scriptName;
        }

        public long getLine() {
            return this.line;
        }

        public long getColumn() {
            return this.column;
        }

        public PropertyLong getScriptId() {
            return this.scriptId;
        }

        public String getScriptName() {
            return this.scriptName;
        }
    }

    public static enum Type {
        function,
        scriptName,
        scriptId,
        scriptRegExp;

    }
}

