/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.EmbeddingProvider;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.netbeans.modules.parsing.spi.TaskFactory;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.parser.GSFPHPParser;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class PhpEmbeddingProvider
extends EmbeddingProvider {
    public static final String GENERATED_CODE = "@@@";
    private static final int MAX_EMBEDDING_LENGTH = 5000000;
    private static final Logger LOGGER = Logger.getLogger(PhpEmbeddingProvider.class.getName());
    private static final String HTML_MIME_TYPE = "text/html";

    public List<Embedding> getEmbeddings(Snapshot snapshot) {
        FileObject fileObject;
        long textSize;
        if (!GSFPHPParser.PARSE_BIG_FILES && (textSize = this.getTextSize(fileObject = snapshot.getSource().getFileObject(), snapshot)) > (long)GSFPHPParser.BIG_FILE_SIZE) {
            LOGGER.log(Level.INFO, "Parsing of big file cancelled. Size: {0} Name: {1}", new Object[]{textSize, fileObject != null ? FileUtil.getFileDisplayName((FileObject)fileObject) : "<no file>"});
            return Collections.emptyList();
        }
        TokenHierarchy th = snapshot.getTokenHierarchy();
        TokenSequence sequence = th.tokenSequence(PHPTokenId.language());
        if (sequence == null) {
            Logger.getLogger("PhpEmbeddingProvider").log(Level.WARNING, "TokenHierarchy.tokenSequence(PhpTokenId.language()) == null for static immutable PHP TokenHierarchy!\nFile = ''{0}'' ;snapshot mimepath=''{1}''", new Object[]{snapshot.getSource().getFileObject().getPath(), snapshot.getMimePath()});
            return Collections.emptyList();
        }
        sequence.moveStart();
        ArrayList<Embedding> embeddings = new ArrayList<Embedding>();
        int from = -1;
        int len = 0;
        while (sequence.moveNext()) {
            Token t = sequence.token();
            if (t.id() == PHPTokenId.T_INLINE_HTML) {
                if (from < 0) {
                    from = sequence.offset();
                }
                len += t.length();
                continue;
            }
            if (from >= 0) {
                PhpEmbeddingProvider.createHtmlEmbedding(embeddings, snapshot, from, len);
                embeddings.add(snapshot.create((CharSequence)GENERATED_CODE, HTML_MIME_TYPE));
            }
            from = -1;
            len = 0;
        }
        if (from >= 0) {
            PhpEmbeddingProvider.createHtmlEmbedding(embeddings, snapshot, from, len);
        }
        if (embeddings.isEmpty()) {
            return Collections.singletonList(snapshot.create((CharSequence)"", HTML_MIME_TYPE));
        }
        return Collections.singletonList(Embedding.create(embeddings));
    }

    private static void createHtmlEmbedding(List<Embedding> embeddings, Snapshot snapshot, int from, int length) {
        assert (embeddings != null);
        assert (snapshot != null);
        if (length <= 5000000) {
            embeddings.add(snapshot.create(from, length, HTML_MIME_TYPE));
        } else {
            LOGGER.log(Level.FINE, "HTML embedding wasn''t created - from: {0}, length: {1}", new Object[]{from, length});
        }
    }

    public int getPriority() {
        return 110;
    }

    public void cancel() {
    }

    private long getTextSize(@NullAllowed FileObject fileObject, Snapshot snapshot) {
        if (fileObject != null) {
            return fileObject.getSize();
        }
        return snapshot.getText().length();
    }

    public static final class Factory
    extends TaskFactory {
        public Collection<SchedulerTask> create(Snapshot snapshot) {
            return Collections.singletonList(new PhpEmbeddingProvider());
        }
    }
}

