/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.ui.build2;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.docker.api.BuildEvent;
import org.netbeans.modules.docker.api.DockerAction;
import org.netbeans.modules.docker.api.DockerImage;
import org.netbeans.modules.docker.api.DockerInstance;
import org.netbeans.modules.docker.api.StatusEvent;
import org.netbeans.modules.docker.ui.build2.Bundle;
import org.netbeans.modules.docker.ui.output.StatusOutputListener;
import org.openide.filesystems.FileObject;
import org.openide.util.Cancellable;
import org.openide.windows.FoldHandle;
import org.openide.windows.IOColorLines;
import org.openide.windows.IOFolding;
import org.openide.windows.InputOutput;

public class BuildTask
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(BuildTask.class.getName());
    private final WeakReference<DockerInstance> instance;
    private final WeakReference<InputOutput> inputOutput;
    private final Hook hook;
    private final FileObject buildContext;
    private final FileObject dockerfile;
    private final Map<String, String> buildargs;
    private final String repository;
    private final String tag;
    private final boolean pull;
    private final boolean noCache;

    public BuildTask(DockerInstance instance, InputOutput inputOutput, Hook hook, FileObject buildContext, FileObject dockerfile, Map<String, String> buildargs, String repository, String tag, boolean pull, boolean noCache) {
        this.instance = new WeakReference<DockerInstance>(instance);
        this.inputOutput = new WeakReference<InputOutput>(inputOutput);
        this.hook = hook;
        this.buildContext = buildContext;
        this.dockerfile = dockerfile;
        this.repository = repository;
        this.tag = tag;
        this.pull = pull;
        this.noCache = noCache;
        this.buildargs = buildargs;
    }

    public WeakReference<DockerInstance> getInstance() {
        return this.instance;
    }

    public WeakReference<InputOutput> getInputOutput() {
        return this.inputOutput;
    }

    public FileObject getBuildContext() {
        return this.buildContext;
    }

    public FileObject getDockerfile() {
        return this.dockerfile;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getTag() {
        return this.tag;
    }

    public boolean isPull() {
        return this.pull;
    }

    public boolean isNoCache() {
        return this.noCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        final InputOutput io = (InputOutput)this.inputOutput.get();
        if (io == null) {
            return;
        }
        DockerInstance inst = (DockerInstance)this.instance.get();
        if (inst == null) {
            return;
        }
        DockerAction facade = new DockerAction(inst);
        final FutureTask task = facade.createBuildTask(this.buildContext, this.dockerfile, this.buildargs, this.repository, this.tag, this.pull, this.noCache, (BuildEvent.Listener)new ListenerImpl(io), (StatusEvent.Listener)new StatusOutputListener(io));
        this.hook.onStart(task);
        ProgressHandle handle = ProgressHandleFactory.createHandle((String)Bundle.MSG_Building(this.buildContext), (Cancellable)new Cancellable(){

            public boolean cancel() {
                return task.cancel(true);
            }
        }, (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                io.select();
            }
        });
        handle.start();
        try {
            io.getOut().reset();
            io.select();
            task.run();
            if (!task.isCancelled()) {
                task.get();
            } else {
                io.getErr().println(Bundle.MSG_BuildCancelled());
            }
        }
        catch (ExecutionException ex) {
            Throwable cause = ex.getCause();
            if (cause == null) {
                cause = ex;
            }
            LOGGER.log(Level.INFO, null, cause);
            io.getErr().println(cause.getMessage());
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
        catch (InterruptedException ex) {
            LOGGER.log(Level.INFO, null, ex);
            Thread.currentThread().interrupt();
        }
        finally {
            io.getOut().close();
            handle.finish();
            this.hook.onFinish();
        }
    }

    private static class ListenerImpl
    implements BuildEvent.Listener {
        private final InputOutput io;
        private final boolean foldingSupported;
        private final boolean colorSupported;

        public ListenerImpl(InputOutput io) {
            this.io = io;
            this.foldingSupported = IOFolding.isSupported((InputOutput)io);
            this.colorSupported = IOColorLines.isSupported((InputOutput)io);
        }

        public void onEvent(BuildEvent event) {
            String message = event.getMessage();
            if (event.isUpload()) {
                this.io.getOut().println(Bundle.MSG_Uploading(message));
            } else if (event.isError()) {
                this.io.getErr().println(message);
            } else if (this.colorSupported && this.foldingSupported && message.startsWith("POST")) {
                String[] split = message.split("\n", 2);
                this.println(this.io, split[0]);
                if (split.length > 1 && !split[1].isEmpty()) {
                    FoldHandle fold = IOFolding.startFold((InputOutput)this.io, (boolean)false);
                    this.println(this.io, split[1]);
                    fold.silentFinish();
                }
                this.io.getOut().println();
            } else {
                this.io.getOut().println(event.getMessage());
            }
        }

        private void println(InputOutput io, String message) {
            if (this.colorSupported) {
                try {
                    IOColorLines.println((InputOutput)io, (CharSequence)message, (Color)Color.GRAY);
                }
                catch (IOException iOException) {}
            } else {
                io.getOut().println(message);
            }
        }
    }

    public static interface Hook {
        public void onStart(FutureTask<DockerImage> var1);

        public void onFinish();
    }
}

