/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeimage.api;

import java.util.Objects;

public final class SourceInfo {
    private final String fileName;
    private final String fullName;

    private SourceInfo(String fileName, String fullName) {
        this.fileName = fileName;
        this.fullName = fullName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public int hashCode() {
        int hash = 7;
        hash = 17 * hash + Objects.hashCode(this.fileName);
        hash = 17 * hash + Objects.hashCode(this.fullName);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SourceInfo other = (SourceInfo)obj;
        if (!Objects.equals(this.fileName, other.fileName)) {
            return false;
        }
        return Objects.equals(this.fullName, other.fullName);
    }

    public String toString() {
        return "SourceInfo{fileName=" + this.fileName + ", fullName=" + this.fullName + '}';
    }

    public static final class Builder {
        private String fileName;
        private String fullName;

        Builder() {
        }

        public void fileName(String fileName) {
            this.fileName = fileName;
        }

        public void fullName(String fullName) {
            this.fullName = fullName;
        }

        public SourceInfo build() {
            return new SourceInfo(this.fileName, this.fullName);
        }
    }
}

