/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.osgi;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.osgi.Bundle;
import org.netbeans.modules.maven.osgi.Matcher;
import org.netbeans.modules.maven.spi.queries.ForeignClassBundler;
import org.netbeans.spi.project.ui.ProjectProblemsProvider;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class ForeignClassBundlerImpl
implements ForeignClassBundler,
ProjectProblemsProvider {
    private static final ProjectProblemsProvider.ProjectProblem PROBLEM_REPORT = ProjectProblemsProvider.ProjectProblem.createWarning((String)Bundle.PRBL_Name(), (String)Bundle.PRBL_DESC());
    private static final RequestProcessor RP = new RequestProcessor(ForeignClassBundlerImpl.class);
    private final AtomicBoolean hasProblem = new AtomicBoolean(false);
    private final Project project;
    private boolean calculated = false;
    private boolean calculatedValue = false;
    private final PropertyChangeSupport pchs = new PropertyChangeSupport(this);

    public ForeignClassBundlerImpl(Project p) {
        this.project = p;
    }

    public synchronized boolean preferSources() {
        if (this.calculated) {
            return this.calculatedValue;
        }
        this.calculatedValue = this.calculateValue();
        this.calculated = true;
        return this.calculatedValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean calculateValue() {
        boolean newVal;
        boolean oldVal;
        block9: {
            boolean bl;
            block10: {
                NbMavenProject nbmp = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
                if (nbmp == null) {
                    return true;
                }
                oldVal = this.hasProblem.get();
                newVal = false;
                try {
                    MavenProject mp = nbmp.getMavenProject();
                    Properties props = PluginPropertyUtils.getPluginPropertyParameter((Project)this.project, (String)"org.apache.felix", (String)"maven-bundle-plugin", (String)"instructions", (String)"bundle");
                    if (props == null) break block9;
                    String exportedPack = props.getProperty("Export-Package");
                    String privatePack = props.getProperty("Private-Package");
                    if (exportedPack == null && privatePack == null) break block9;
                    Matcher exported = new Matcher(exportedPack);
                    Matcher prived = new Matcher(privatePack);
                    for (Artifact a : mp.getRuntimeArtifacts()) {
                        File f = a.getFile();
                        if (f == null || !f.isFile()) continue;
                        try {
                            JarFile jf = new JarFile(f);
                            Enumeration<JarEntry> en = jf.entries();
                            while (en.hasMoreElements()) {
                                String pack;
                                JarEntry je = en.nextElement();
                                if (!je.isDirectory() || je.getName().startsWith("META-INF") || !exported.matches(pack = je.getName().substring(0, je.getName().length() - 1).replace("/", ".")) && !prived.matches(pack)) continue;
                                newVal = true;
                                bl = false;
                                if (newVal == oldVal) return bl;
                                this.hasProblem.set(newVal);
                                break block10;
                            }
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                    break block9;
                }
                catch (Throwable throwable) {
                    if (newVal == oldVal) throw throwable;
                    this.hasProblem.set(newVal);
                    RP.post(new Runnable(){

                        @Override
                        public void run() {
                            ForeignClassBundlerImpl.this.pchs.firePropertyChange("problems", null, null);
                        }
                    });
                    throw throwable;
                }
            }
            RP.post(new /* invalid duplicate definition of identical inner class */);
            return bl;
        }
        if (newVal == oldVal) return true;
        this.hasProblem.set(newVal);
        RP.post(new /* invalid duplicate definition of identical inner class */);
        return true;
    }

    public synchronized void resetCachedValue() {
        this.calculated = false;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pchs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pchs.removePropertyChangeListener(listener);
    }

    public Collection<? extends ProjectProblemsProvider.ProjectProblem> getProblems() {
        return this.hasProblem.get() ? Collections.singleton(PROBLEM_REPORT) : Collections.emptySet();
    }
}

