/**
 * The CSSMediaRule interface represents a @media rule in a CSS style sheet. A @media rule can be used to delimit style rules for specific media types.
 */
var CSSMediaRule = {
}
/**
 * Used to delete a rule from the media block.
 * @syntax cSSMediaRule.deleteRule(index)
 * @param {Number} index The index within the media block's rule collection of the rule to remove.
 * @returns {undefined} 
 */
CSSMediaRule.prototype.deleteRule = function(index) {};

/**
 * A list of all CSS rules contained within the media block.
 * @syntax cSSMediaRule.cssRules
 * @returns {CSSRuleList} 
 */
CSSMediaRule.prototype.cssRules = new CSSRuleList();

/**
 * A list of media types for this rule.
 * @syntax cSSMediaRule.media
 * @returns {stylesheets::MediaList} 
 */
CSSMediaRule.prototype.media = new stylesheets::MediaList();

/**
 * Used to insert a new rule into the media block.
 * @syntax cSSMediaRule.insertRule(rule, index)
 * @param {String} rule The parsable text representing the rule. For rule sets this contains both the selector and the style declaration. For at-rules, this specifies both the at-identifier and the rule content.
 * @param {Number} index The index within the media block's rule collection of the rule before which to insert the specified rule. If the specified index is equal to the length of the media blocks's rule collection, the rule will be added to the end of the media block.
 * @returns {Number} The index within the media block's rule collection of the newly inserted rule.
 */
CSSMediaRule.prototype.insertRule = function(rule,  index) {};

/**
 * Represents the CSSMediaRule prototype object.
 * @syntax CSSMediaRule.prototype
 * @static
 */
CSSMediaRule.prototype;

