/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.analysis.analyzer.field;

import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.web.beans.analysis.CdiAnalysisResult;
import org.netbeans.modules.web.beans.analysis.analyzer.AbstractProducerAnalyzer;
import org.netbeans.modules.web.beans.analysis.analyzer.AnnotationUtil;
import org.netbeans.modules.web.beans.analysis.analyzer.FieldElementAnalyzer;
import org.openide.util.NbBundle;

public class ProducerFieldAnalyzer
extends AbstractProducerAnalyzer
implements FieldElementAnalyzer.FieldAnalyzer {
    @Override
    public void analyze(VariableElement element, TypeMirror elementType, TypeElement parent, AtomicBoolean cancel, CdiAnalysisResult result) {
        CompilationInfo compInfo = result.getInfo();
        if (!AnnotationUtil.hasAnnotation(element, "javax.enterprise.inject.Produces", compInfo)) {
            return;
        }
        result.requireCdiEnabled(element);
        if (cancel.get()) {
            return;
        }
        this.checkSessionBean(element, parent, result);
        if (cancel.get()) {
            return;
        }
        this.checkType(element, elementType, result);
    }

    @Override
    protected void hasTypeVar(Element element, TypeMirror type, CdiAnalysisResult result) {
        result.addError(element, NbBundle.getMessage(ProducerFieldAnalyzer.class, (String)"ERR_ProducerHasTypeVar"));
    }

    @Override
    protected void hasWildCard(Element element, TypeMirror type, CdiAnalysisResult result) {
        result.addError(element, NbBundle.getMessage(ProducerFieldAnalyzer.class, (String)"ERR_ProducerHasWildcard"));
    }

    private void checkSessionBean(VariableElement element, TypeElement parent, CdiAnalysisResult result) {
        if (!AnnotationUtil.isSessionBean(parent, result.getInfo())) {
            return;
        }
        Set<Modifier> modifiers = element.getModifiers();
        if (!modifiers.contains((Object)Modifier.STATIC)) {
            result.addError(element, NbBundle.getMessage(ProducerFieldAnalyzer.class, (String)"ERR_NonStaticProducerSessionBean"));
        }
    }
}

