/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.analysis.analyzer.field;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.web.beans.analysis.analyzer.AbstractScopedAnalyzer;
import org.netbeans.modules.web.beans.analysis.analyzer.AnnotationUtil;
import org.netbeans.modules.web.beans.analysis.analyzer.FieldModelAnalyzer;
import org.netbeans.modules.web.beans.analysis.analyzer.ModelAnalyzer;
import org.netbeans.modules.web.beans.api.model.WebBeansModel;
import org.openide.util.NbBundle;

public class ScopedFieldAnalyzer
extends AbstractScopedAnalyzer
implements FieldModelAnalyzer.FieldAnalyzer {
    @Override
    public void analyze(VariableElement element, TypeMirror elementType, TypeElement parent, WebBeansModel model, AtomicBoolean cancel, ModelAnalyzer.Result result) {
        if (AnnotationUtil.hasAnnotation(element, "javax.enterprise.inject.Produces", (CompilationInfo)model.getCompilationController())) {
            result.requireCdiEnabled(element, model);
            this.analyzeScope(element, model, cancel, result);
        }
    }

    @Override
    protected void checkScope(TypeElement scopeElement, Element element, WebBeansModel model, AtomicBoolean cancel, ModelAnalyzer.Result result) {
        if (scopeElement.getQualifiedName().contentEquals("javax.enterprise.context.Dependent")) {
            return;
        }
        if (cancel.get()) {
            return;
        }
        if (this.hasTypeVarParameter(element.asType())) {
            result.addError(element, model, NbBundle.getMessage(ScopedFieldAnalyzer.class, (String)"ERR_WrongScopeParameterizedProducer", (Object)scopeElement.getQualifiedName().toString()));
        }
        if (cancel.get()) {
            return;
        }
        this.checkPassivationCapable(scopeElement, element, model, result);
    }

    private void checkPassivationCapable(TypeElement scopeElement, Element element, WebBeansModel model, ModelAnalyzer.Result result) {
        if (!this.isPassivatingScope(scopeElement, model)) {
            return;
        }
        TypeMirror type = element.asType();
        if (type.getKind().isPrimitive()) {
            return;
        }
        if (this.isSerializable(type, model)) {
            return;
        }
        Element typeElement = model.getCompilationController().getTypes().asElement(type);
        if (typeElement == null) {
            return;
        }
        if (typeElement.getModifiers().contains((Object)Modifier.FINAL)) {
            result.addError(element, model, NbBundle.getMessage(ScopedFieldAnalyzer.class, (String)"ERR_NotPassivationProducer", (Object)scopeElement.getQualifiedName().toString()));
        }
    }
}

