/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.csl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.netbeans.modules.csl.api.DeclarationFinder;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.OverridingMethods;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.ElementQueryFactory;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.api.elements.ElementFilter;
import org.netbeans.modules.php.editor.api.elements.MethodElement;
import org.netbeans.modules.php.editor.api.elements.PhpElement;
import org.netbeans.modules.php.editor.api.elements.TypeElement;
import org.netbeans.modules.php.editor.csl.DeclarationFinderImpl;
import org.netbeans.modules.php.editor.model.MethodScope;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.openide.filesystems.FileObject;

public class OverridingMethodsImpl
implements OverridingMethods {
    private String classSignatureForInheritedMethods = "";
    private String classSignatureForInheritedByMethods = "";
    private String classSignatureForInheritedByTypes = "";
    private Set<MethodElement> inheritedMethods = Collections.emptySet();
    private Set<MethodElement> inheritedByMethods = Collections.emptySet();
    private Set<TypeElement> inheritedByTypes = new LinkedHashSet<TypeElement>();

    public Collection<? extends DeclarationFinder.AlternativeLocation> overrides(ParserResult info, ElementHandle handle) {
        assert (handle instanceof ModelElement);
        if (handle instanceof MethodScope) {
            MethodScope method = (MethodScope)handle;
            ElementFilter methodNameFilter = ElementFilter.forName(NameKind.exact(method.getName()));
            Set<MethodElement> overridenMethods = methodNameFilter.filter(this.getInheritedMethods(info, method));
            ArrayList<MethodLocation> retval = new ArrayList<MethodLocation>();
            for (MethodElement methodElement : overridenMethods) {
                retval.add(MethodLocation.newInstance(methodElement));
            }
            return retval;
        }
        return null;
    }

    public Collection<? extends DeclarationFinder.AlternativeLocation> overriddenBy(ParserResult info, ElementHandle handle) {
        assert (handle instanceof ModelElement);
        if (handle instanceof MethodScope) {
            MethodScope method = (MethodScope)handle;
            ElementFilter methodNameFilter = ElementFilter.forName(NameKind.exact(method.getName()));
            Set<MethodElement> overridenByMethods = methodNameFilter.filter(this.getInheritedByMethods(info, method));
            ArrayList<MethodLocation> retval = new ArrayList<MethodLocation>();
            for (MethodElement methodElement : overridenByMethods) {
                retval.add(MethodLocation.newInstance(methodElement));
            }
            return retval;
        }
        if (handle instanceof TypeScope) {
            ArrayList<TypeLocation> retval = new ArrayList<TypeLocation>();
            for (TypeElement typeElement : this.getInheritedByTypes(info, (TypeScope)handle)) {
                retval.add(TypeLocation.newInstance(typeElement));
            }
            return retval;
        }
        return null;
    }

    public boolean isOverriddenBySupported(ParserResult info, ElementHandle handle) {
        return true;
    }

    private Set<MethodElement> getInheritedMethods(ParserResult info, MethodScope method) {
        Scope inScope = method.getInScope();
        assert (inScope instanceof TypeScope);
        TypeScope typeScope = (TypeScope)inScope;
        String signature = typeScope.getIndexSignature();
        if (signature != null && !signature.equals(this.classSignatureForInheritedMethods)) {
            ElementQuery.Index index = ElementQueryFactory.getIndexQuery(info);
            this.inheritedMethods = index.getInheritedMethods(typeScope);
        }
        this.classSignatureForInheritedMethods = signature;
        return this.inheritedMethods;
    }

    private Set<TypeElement> getInheritedByTypes(ParserResult info, TypeScope type) {
        String signature = type.getIndexSignature();
        if (signature != null && !signature.equals(this.classSignatureForInheritedByTypes)) {
            ElementQuery.Index index = ElementQueryFactory.getIndexQuery(info);
            this.inheritedByTypes = index.getInheritedByTypes(type);
        }
        this.classSignatureForInheritedByTypes = signature;
        return this.inheritedByTypes;
    }

    private Set<MethodElement> getInheritedByMethods(ParserResult info, MethodScope method) {
        Scope inScope = method.getInScope();
        assert (inScope instanceof TypeScope);
        TypeScope typeScope = (TypeScope)inScope;
        String signature = ((TypeScope)inScope).getIndexSignature();
        if (signature != null && !signature.equals(this.classSignatureForInheritedByMethods)) {
            ElementQuery.Index index = ElementQueryFactory.getIndexQuery(info);
            this.inheritedByMethods = new HashSet<MethodElement>();
            for (TypeElement nextType : this.getInheritedByTypes(info, typeScope)) {
                this.inheritedByMethods.addAll(index.getDeclaredMethods(nextType));
            }
        }
        this.classSignatureForInheritedByMethods = signature;
        return this.inheritedByMethods;
    }

    private static final class TypeLocation
    extends DeclarationFinderImpl.AlternativeLocationImpl {
        public static TypeLocation newInstance(PhpElement modelElement) {
            FileObject fileObject = modelElement.getFileObject();
            DeclarationFinder.DeclarationLocation declarationLocation = fileObject == null ? DeclarationFinder.DeclarationLocation.NONE : new DeclarationFinder.DeclarationLocation(fileObject, modelElement.getOffset(), (ElementHandle)modelElement);
            return new TypeLocation(modelElement, declarationLocation);
        }

        private TypeLocation(PhpElement modelElement, DeclarationFinder.DeclarationLocation declarationLocation) {
            super(modelElement, declarationLocation);
        }

        @Override
        public String getDisplayHtml(HtmlFormatter formatter) {
            StringBuilder sb = new StringBuilder(30);
            TypeElement type = (TypeElement)this.getElement();
            sb.append(type.getFullyQualifiedName().toNotFullyQualified().toString());
            FileObject fileObject = type.getFileObject();
            if (fileObject != null) {
                sb.append(" (");
                sb.append(fileObject.getNameExt());
                sb.append(")");
            }
            return sb.toString();
        }
    }

    private static final class MethodLocation
    extends DeclarationFinderImpl.AlternativeLocationImpl {
        public static MethodLocation newInstance(PhpElement modelElement) {
            FileObject fileObject = modelElement.getFileObject();
            DeclarationFinder.DeclarationLocation declarationLocation = fileObject == null ? DeclarationFinder.DeclarationLocation.NONE : new DeclarationFinder.DeclarationLocation(fileObject, modelElement.getOffset(), (ElementHandle)modelElement);
            return new MethodLocation(modelElement, declarationLocation);
        }

        private MethodLocation(PhpElement modelElement, DeclarationFinder.DeclarationLocation declarationLocation) {
            super(modelElement, declarationLocation);
        }

        @Override
        public String getDisplayHtml(HtmlFormatter formatter) {
            StringBuilder sb = new StringBuilder(30);
            MethodElement method = (MethodElement)this.getElement();
            TypeElement type = method.getType();
            sb.append(type.getFullyQualifiedName().toNotFullyQualified().toString());
            FileObject fileObject = type.getFileObject();
            if (fileObject != null) {
                sb.append(" (");
                sb.append(fileObject.getNameExt());
                sb.append(")");
            }
            return sb.toString();
        }
    }
}

