/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.indent;

import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.editor.indent.api.Reformat;
import org.netbeans.modules.options.editor.spi.PreferencesCustomizer;
import org.netbeans.modules.options.editor.spi.PreviewProvider;
import org.netbeans.modules.php.editor.indent.CodeStyle;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class FmtOptions {
    private static final Logger LOGGER = Logger.getLogger(FmtOptions.class.getName());
    public static final String EXPAND_TAB_TO_SPACES = "expand-tabs";
    public static final String TAB_SIZE = "tab-size";
    public static final String SPACES_PER_TAB = "spaces-per-tab";
    public static final String INDENT_SIZE = "indent-shift-width";
    public static final String CONTINUATION_INDENT_SIZE = "continuationIndentSize";
    public static final String ITEMS_IN_ARRAY_DECLARATION_INDENT_SIZE = "itemsInArrayDeclarationIndentSize";
    public static final String REFORMAT_COMMENTS = "reformatComments";
    public static final String INDENT_HTML = "indentHtml";
    public static final String RIGHT_MARGIN = "text-limit-width";
    public static final String INITIAL_INDENT = "init.indent";
    public static final String CLASS_DECL_BRACE_PLACEMENT = "classDeclBracePlacement";
    public static final String ANONYMOUS_CLASS_BRACE_PLACEMENT = "anonymousClassBracePlacement";
    public static final String METHOD_DECL_BRACE_PLACEMENT = "methodDeclBracePlacement";
    public static final String IF_BRACE_PLACEMENT = "ifBracePlacement";
    public static final String FOR_BRACE_PLACEMENT = "forBracePlacement";
    public static final String WHILE_BRACE_PLACEMENT = "whileBracePlacement";
    public static final String SWITCH_BRACE_PLACEMENT = "switchBracePlacement";
    public static final String MATCH_BRACE_PLACEMENT = "matchBracePlacement";
    public static final String CATCH_BRACE_PLACEMENT = "catchBracePlacement";
    public static final String USE_TRAIT_BODY_BRACE_PLACEMENT = "useTraitBodyBracePlacement";
    public static final String GROUP_USE_BRACE_PLACEMENT = "groupUseBracePlacement";
    public static final String OTHER_BRACE_PLACEMENT = "otherBracePlacement";
    public static final String BLANK_LINES_BEFORE_NAMESPACE = "blankLinesBeforeNamespace";
    public static final String BLANK_LINES_AFTER_NAMESPACE = "blankLinesAfterNamespace";
    public static final String BLANK_LINES_BEFORE_USE = "blankLinesBeforeUse";
    public static final String BLANK_LINES_BEFORE_USE_TRAIT = "blankLinesBeforeUseTrait";
    public static final String BLANK_LINES_AFTER_USE = "blankLinesAfterUse";
    public static final String BLANK_LINES_BEFORE_CLASS = "blankLinesBeforeClass";
    public static final String BLANK_LINES_BEFORE_CLASS_END = "blankLinesBeforeClassEnd";
    public static final String BLANK_LINES_AFTER_CLASS = "blankLinesAfterClass";
    public static final String BLANK_LINES_AFTER_CLASS_HEADER = "blankLinesAfterClassHeader";
    public static final String BLANK_LINES_BEFORE_FIELDS = "blankLinesBeforeField";
    public static final String BLANK_LINES_BETWEEN_FIELDS = "blankLinesBetweenField";
    public static final String BLANK_LINES_AFTER_FIELDS = "blankLinesAfterField";
    public static final String BLANK_LINES_GROUP_FIELDS_WITHOUT_DOC_AND_ATTRIBUTES = "blankLinesGroupFieldsWithoutDocAndAttributes";
    public static final String BLANK_LINES_BEFORE_FUNCTION = "blankLinesBeforeFunction";
    public static final String BLANK_LINES_AFTER_FUNCTION = "blankLinesAfterFunction";
    public static final String BLANK_LINES_BEFORE_FUNCTION_END = "blankLinesBeforeFunctionEnd";
    public static final String BLANK_LINES_AFTER_OPEN_PHP_TAG = "blankLinesAfterOpenPHPTag";
    public static final String BLANK_LINES_AFTER_OPEN_PHP_TAG_IN_HTML = "blankLinesAfterOpenPHPTagInHTML";
    public static final String BLANK_LINES_BEFORE_CLOSE_PHP_TAG = "blankLinesBeforeClosePHPTag";
    public static final String BLANK_LINES_MAX_PRESERVED = "blankLinesMaxPreserved";
    public static final String SPACE_BEFORE_WHILE = "spaceBeforeWhile";
    public static final String SPACE_BEFORE_ELSE = "spaceBeforeElse";
    public static final String SPACE_BEFORE_CATCH = "spaceBeforeCatch";
    public static final String SPACE_BEFORE_FINALLY = "spaceBeforeFinally";
    public static final String SPACE_BEFORE_ANONYMOUS_CLASS_PAREN = "spaceBeforeAnonymousClassParen";
    public static final String SPACE_BEFORE_ANONYMOUS_FUNCTION_PAREN = "spaceBeforeAnonymousFunctionParen";
    public static final String SPACE_BEFORE_ATTRIBUTE_DECL_PAREN = "spaceBeforeAttributeDeclParen";
    public static final String SPACE_BEFORE_METHOD_DECL_PAREN = "spaceBeforeMethodDeclParen";
    public static final String SPACE_BEFORE_METHOD_CALL_PAREN = "spaceBeforeMethodCallParen";
    public static final String SPACE_BEFORE_IF_PAREN = "spaceBeforeIfParen";
    public static final String SPACE_BEFORE_FOR_PAREN = "spaceBeforeForParen";
    public static final String SPACE_BEFORE_WHILE_PAREN = "spaceBeforeWhileParen";
    public static final String SPACE_BEFORE_CATCH_PAREN = "spaceBeforeCatchParen";
    public static final String SPACE_BEFORE_SWITCH_PAREN = "spaceBeforeSwitchParen";
    public static final String SPACE_BEFORE_MATCH_PAREN = "spaceBeforeMatchParen";
    public static final String SPACE_BEFORE_ARRAY_DECL_PAREN = "spaceBeforeArrayDeclParen";
    public static final String SPACE_AROUND_UNARY_OPS = "spaceAroundUnaryOps";
    public static final String SPACE_AROUND_BINARY_OPS = "spaceAroundBinaryOps";
    public static final String SPACE_AROUND_TERNARY_OPS = "spaceAroundTernaryOps";
    public static final String SPACE_AROUND_STRING_CONCAT_OPS = "spaceAroundStringConcatOps";
    public static final String SPACE_AROUND_ASSIGN_OPS = "spaceAroundAssignOps";
    public static final String SPACE_AROUND_KEY_VALUE_OPS = "spaceAroundKeyValueOps";
    public static final String SPACE_AROUND_OBJECT_OPS = "spaceAroundObjectOps";
    public static final String SPACE_AROUND_NULLSAFE_OBJECT_OPS = "spaceAroundNullsafeObjectOps";
    public static final String SPACE_AROUND_DECLARE_EQUAL = "spaceAroundDeclareEqual";
    public static final String SPACE_AROUND_UNION_TYPE_SEPARATOR = "spaceAroundUnionTypeSeparator";
    public static final String SPACE_BEFORE_CLASS_DECL_LEFT_BRACE = "spaceBeforeClassDeclLeftBrace";
    public static final String SPACE_BEFORE_ANONYMOUS_CLASS_LEFT_BRACE = "spaceBeforeAnonymousClassLeftBrace";
    public static final String SPACE_BEFORE_METHOD_DECL_LEFT_BRACE = "spaceBeforeMethodDeclLeftBrace";
    public static final String SPACE_BEFORE_IF_LEFT_BRACE = "spaceBeforeIfLeftBrace";
    public static final String SPACE_BEFORE_ELSE_LEFT_BRACE = "spaceBeforeElseLeftBrace";
    public static final String SPACE_BEFORE_WHILE_LEFT_BRACE = "spaceBeforeWhileLeftBrace";
    public static final String SPACE_BEFORE_FOR_LEFT_BRACE = "spaceBeforeForLeftBrace";
    public static final String SPACE_BEFORE_DO_LEFT_BRACE = "spaceBeforeDoLeftBrace";
    public static final String SPACE_BEFORE_SWITCH_LEFT_BRACE = "spaceBeforeSwitchLeftBrace";
    public static final String SPACE_BEFORE_MATCH_LEFT_BRACE = "spaceBeforeMatchLeftBrace";
    public static final String SPACE_BEFORE_TRY_LEFT_BRACE = "spaceBeforeTryLeftBrace";
    public static final String SPACE_BEFORE_CATCH_LEFT_BRACE = "spaceBeforeCatchLeftBrace";
    public static final String SPACE_BEFORE_FINALLY_LEFT_BRACE = "spaceBeforeFinallyLeftBrace";
    public static final String SPACE_BEFORE_USE_TRAIT_BODY_LEFT_BRACE = "spaceBeforeUseTraitBodyLeftBrace";
    public static final String SPACE_WITHIN_ARRAY_DECL_PARENS = "spaceWithinArrayDeclParens";
    public static final String SPACE_WITHIN_ANONYMOUS_CLASS_PARENS = "spaceWithinAnonymousClassParens";
    public static final String SPACE_WITHIN_METHOD_DECL_PARENS = "spaceWithinMethodDeclParens";
    public static final String SPACE_WITHIN_METHOD_CALL_PARENS = "spaceWithinMethodCallParens";
    public static final String SPACE_WITHIN_IF_PARENS = "spaceWithinIfParens";
    public static final String SPACE_WITHIN_FOR_PARENS = "spaceWithinForParens";
    public static final String SPACE_WITHIN_WHILE_PARENS = "spaceWithinWhileParens";
    public static final String SPACE_WITHIN_SWITCH_PARENS = "spaceWithinSwitchParens";
    public static final String SPACE_WITHIN_MATCH_PARENS = "spaceWithinMatchParens";
    public static final String SPACE_WITHIN_CATCH_PARENS = "spaceWithinCatchParens";
    public static final String SPACE_WITHIN_TYPE_CAST_PARENS = "spaceWithinTypeCastParens";
    public static final String SPACE_WITHIN_ARRAY_BRACKETS = "spaceWithinArrayBrackets";
    public static final String SPACE_WITHIN_ATTRIBUTE_BRACKETS = "spaceWithinAttributeBrackets";
    public static final String SPACE_WITHIN_ATTRIBUTE_DECL_PARENS = "spaceWithinAttributeDeclParens";
    public static final String SPACE_BEFORE_COMMA = "spaceBeforeComma";
    public static final String SPACE_AFTER_COMMA = "spaceAfterComma";
    public static final String SPACE_BEFORE_SEMI = "spaceBeforeSemi";
    public static final String SPACE_AFTER_SEMI = "spaceAfterSemi";
    public static final String SPACE_AFTER_TYPE_CAST = "spaceAfterTypeCast";
    public static final String SPACE_CHECK_AFTER_KEYWORDS = "spaceCheckAfterKeywords";
    public static final String SPACE_AFTER_SHORT_PHP_TAG = "spaceAfterShortPHPTag";
    public static final String SPACE_BEFORE_CLOSE_PHP_TAG = "spaceBeforeClosePHPTag";
    public static final String SPACE_BETWEEN_OPEN_PHP_TAG_AND_NAMESPACE = "spaceBetweenOpenPHPTagAndNamespace";
    public static final String PLACE_ELSE_ON_NEW_LINE = "placeElseOnNewLine";
    public static final String PLACE_WHILE_ON_NEW_LINE = "placeWhileOnNewLine";
    public static final String PLACE_CATCH_ON_NEW_LINE = "placeCatchOnNewLine";
    public static final String PLACE_FINALLY_ON_NEW_LINE = "placeFinallyOnNewLine";
    public static final String PLACE_NEW_LINE_AFTER_MODIFIERS = "placeNewLineAfterModifiers";
    public static final String ALIGN_MULTILINE_METHOD_PARAMS = "alignMultilineMethodParams";
    public static final String ALIGN_MULTILINE_CALL_ARGS = "alignMultilineCallArgs";
    public static final String ALIGN_MULTILINE_IMPLEMENTS = "alignMultilineImplements";
    public static final String ALIGN_MULTILINE_PARENTHESIZED = "alignMultilineParenthesized";
    public static final String ALIGN_MULTILINE_BINARY_OP = "alignMultilineBinaryOp";
    public static final String ALIGN_MULTILINE_TERNARY_OP = "alignMultilineTernaryOp";
    public static final String ALIGN_MULTILINE_ASSIGNMENT = "alignMultilineAssignment";
    public static final String ALIGN_MULTILINE_FOR = "alignMultilineFor";
    public static final String ALIGN_MULTILINE_ARRAY_INIT = "alignMultilineArrayInit";
    public static final String GROUP_ALIGNMENT_ASSIGNMENT = "groupAlignmentAssignment";
    public static final String GROUP_ALIGNMENT_ARRAY_INIT = "groupAlignmentArrayInit";
    public static final String WRAP_GROUP_USE_LIST = "wrapGroupUseList";
    public static final String WRAP_EXTENDS_IMPLEMENTS_KEYWORD = "wrapExtendsImplementsKeyword";
    public static final String WRAP_EXTENDS_IMPLEMENTS_LIST = "wrapExtendsImplementsList";
    public static final String WRAP_METHOD_PARAMS = "wrapMethodParams";
    public static final String WRAP_METHOD_PARAMS_AFTER_LEFT_PAREN = "wrapMethodParamsAfterLeftParen";
    public static final String WRAP_METHOD_PARAMS_RIGHT_PAREN = "wrapMethodParamsRightParen";
    public static final String WRAP_METHOD_PARAMS_KEEP_PAREN_AND_BRACE_ON_THE_SAME_LINE = "wrapKeepParenAndBraceOnTheSameLine";
    public static final String WRAP_METHOD_CALL_ARGS = "wrapMethodCallArgs";
    public static final String WRAP_METHOD_CALL_ARGS_AFTER_LEFT_PAREN = "wrapMethodCallArgsAfterLeftParen";
    public static final String WRAP_METHOD_CALL_ARGS_RIGHT_PAREN = "wrapMethodCallArgsRightParen";
    public static final String WRAP_CHAINED_METHOD_CALLS = "wrapChainedMethodCalls";
    public static final String WRAP_ARRAY_INIT = "wrapArrayInit";
    public static final String WRAP_FOR = "wrapFor";
    public static final String WRAP_FOR_AFTER_LEFT_PAREN = "wrapForAfterLeftParen";
    public static final String WRAP_FOR_RIGHT_PAREN = "wrapForRightParen";
    public static final String WRAP_FOR_STATEMENT = "wrapForStatement";
    public static final String WRAP_IF_STATEMENT = "wrapIfStatement";
    public static final String WRAP_WHILE_STATEMENT = "wrapWhileStatement";
    public static final String WRAP_DO_WHILE_STATEMENT = "wrapDoWhileStatement";
    public static final String WRAP_BINARY_OPS = "wrapBinaryOps";
    public static final String WRAP_TERNARY_OPS = "wrapTernaryOps";
    public static final String WRAP_ASSIGN_OPS = "wrapAssignOps";
    public static final String WRAP_BLOCK_BRACES = "wrapBlockBraces";
    public static final String WRAP_GROUP_USE_BRACES = "wrapGroupUseBraces";
    public static final String WRAP_STATEMENTS_ON_THE_LINE = "wrapStateMentsOnTheLine";
    public static final String WRAP_AFTER_BIN_OPS = "wrapAfterBinOps";
    public static final String WRAP_AFTER_ASSIGN_OPS = "wrapAfterAssignOps";
    public static final String PREFER_FULLY_QUALIFIED_NAMES = "preferFullyQualifiedNames";
    public static final String PREFER_MULTIPLE_USE_STATEMENTS_COMBINED = "preferMultipleUseStatementsCombined";
    public static final String PREFER_GROUP_USES = "preferGroupUses";
    public static final String START_USE_WITH_NAMESPACE_SEPARATOR = "startUseWithNamespaceSeparator";
    public static final String ALIASES_CAPITALS_OF_NAMESPACES = "aliasesCapitalsOfNamespacesNames";
    public static CodeStyleProducer codeStyleProducer;
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    public static final String OBRACE_NEWLINE;
    public static final String OBRACE_SAMELINE;
    public static final String OBRACE_PRESERVE;
    public static final String OBRACE_NEWLINE_INDENTED;
    public static final String WRAP_ALWAYS;
    public static final String WRAP_IF_LONG;
    public static final String WRAP_NEVER;
    private static Map<String, String> defaults;

    private FmtOptions() {
    }

    public static int getDefaultAsInt(String key) {
        return Integer.parseInt(defaults.get(key));
    }

    public static boolean getDefaultAsBoolean(String key) {
        return Boolean.parseBoolean(defaults.get(key));
    }

    public static String getDefaultAsString(String key) {
        return defaults.get(key);
    }

    private static void createDefaults() {
        String[][] defaultValues = new String[][]{{EXPAND_TAB_TO_SPACES, TRUE}, {TAB_SIZE, "8"}, {INDENT_SIZE, "4"}, {CONTINUATION_INDENT_SIZE, "8"}, {ITEMS_IN_ARRAY_DECLARATION_INDENT_SIZE, "4"}, {REFORMAT_COMMENTS, FALSE}, {INDENT_HTML, TRUE}, {RIGHT_MARGIN, "80"}, {INITIAL_INDENT, "0"}, {CLASS_DECL_BRACE_PLACEMENT, OBRACE_SAMELINE}, {ANONYMOUS_CLASS_BRACE_PLACEMENT, OBRACE_SAMELINE}, {METHOD_DECL_BRACE_PLACEMENT, OBRACE_SAMELINE}, {IF_BRACE_PLACEMENT, OBRACE_SAMELINE}, {FOR_BRACE_PLACEMENT, OBRACE_SAMELINE}, {WHILE_BRACE_PLACEMENT, OBRACE_SAMELINE}, {SWITCH_BRACE_PLACEMENT, OBRACE_SAMELINE}, {MATCH_BRACE_PLACEMENT, OBRACE_SAMELINE}, {CATCH_BRACE_PLACEMENT, OBRACE_SAMELINE}, {USE_TRAIT_BODY_BRACE_PLACEMENT, OBRACE_SAMELINE}, {GROUP_USE_BRACE_PLACEMENT, OBRACE_SAMELINE}, {OTHER_BRACE_PLACEMENT, OBRACE_SAMELINE}, {BLANK_LINES_BEFORE_NAMESPACE, "1"}, {BLANK_LINES_AFTER_NAMESPACE, "1"}, {BLANK_LINES_BEFORE_USE, "1"}, {BLANK_LINES_BEFORE_USE_TRAIT, "1"}, {BLANK_LINES_AFTER_USE, "1"}, {BLANK_LINES_BEFORE_CLASS, "1"}, {BLANK_LINES_AFTER_CLASS, "1"}, {BLANK_LINES_AFTER_CLASS_HEADER, "0"}, {BLANK_LINES_BEFORE_CLASS_END, "0"}, {BLANK_LINES_BEFORE_FIELDS, "1"}, {BLANK_LINES_GROUP_FIELDS_WITHOUT_DOC_AND_ATTRIBUTES, TRUE}, {BLANK_LINES_BETWEEN_FIELDS, "1"}, {BLANK_LINES_AFTER_FIELDS, "1"}, {BLANK_LINES_BEFORE_FUNCTION, "1"}, {BLANK_LINES_AFTER_FUNCTION, "1"}, {BLANK_LINES_BEFORE_FUNCTION_END, "0"}, {BLANK_LINES_AFTER_OPEN_PHP_TAG, "1"}, {BLANK_LINES_AFTER_OPEN_PHP_TAG_IN_HTML, "0"}, {BLANK_LINES_BEFORE_CLOSE_PHP_TAG, "0"}, {BLANK_LINES_MAX_PRESERVED, "1"}, {SPACE_BEFORE_WHILE, TRUE}, {SPACE_BEFORE_ELSE, TRUE}, {SPACE_BEFORE_CATCH, TRUE}, {SPACE_BEFORE_FINALLY, TRUE}, {SPACE_BEFORE_ANONYMOUS_CLASS_PAREN, FALSE}, {SPACE_BEFORE_ANONYMOUS_FUNCTION_PAREN, TRUE}, {SPACE_BEFORE_ATTRIBUTE_DECL_PAREN, FALSE}, {SPACE_BEFORE_METHOD_DECL_PAREN, FALSE}, {SPACE_BEFORE_METHOD_CALL_PAREN, FALSE}, {SPACE_BEFORE_IF_PAREN, TRUE}, {SPACE_BEFORE_FOR_PAREN, TRUE}, {SPACE_BEFORE_WHILE_PAREN, TRUE}, {SPACE_BEFORE_CATCH_PAREN, TRUE}, {SPACE_BEFORE_SWITCH_PAREN, TRUE}, {SPACE_BEFORE_MATCH_PAREN, TRUE}, {SPACE_BEFORE_ARRAY_DECL_PAREN, FALSE}, {SPACE_AROUND_UNARY_OPS, FALSE}, {SPACE_AROUND_BINARY_OPS, TRUE}, {SPACE_AROUND_TERNARY_OPS, TRUE}, {SPACE_AROUND_STRING_CONCAT_OPS, TRUE}, {SPACE_AROUND_KEY_VALUE_OPS, TRUE}, {SPACE_AROUND_ASSIGN_OPS, TRUE}, {SPACE_AROUND_OBJECT_OPS, FALSE}, {SPACE_AROUND_NULLSAFE_OBJECT_OPS, FALSE}, {SPACE_AROUND_DECLARE_EQUAL, FALSE}, {SPACE_AROUND_UNION_TYPE_SEPARATOR, FALSE}, {SPACE_BEFORE_CLASS_DECL_LEFT_BRACE, TRUE}, {SPACE_BEFORE_METHOD_DECL_LEFT_BRACE, TRUE}, {SPACE_BEFORE_IF_LEFT_BRACE, TRUE}, {SPACE_BEFORE_ELSE_LEFT_BRACE, TRUE}, {SPACE_BEFORE_WHILE_LEFT_BRACE, TRUE}, {SPACE_BEFORE_FOR_LEFT_BRACE, TRUE}, {SPACE_BEFORE_DO_LEFT_BRACE, TRUE}, {SPACE_BEFORE_SWITCH_LEFT_BRACE, TRUE}, {SPACE_BEFORE_MATCH_LEFT_BRACE, TRUE}, {SPACE_BEFORE_TRY_LEFT_BRACE, TRUE}, {SPACE_BEFORE_CATCH_LEFT_BRACE, TRUE}, {SPACE_BEFORE_FINALLY_LEFT_BRACE, TRUE}, {SPACE_BEFORE_USE_TRAIT_BODY_LEFT_BRACE, TRUE}, {SPACE_WITHIN_ARRAY_DECL_PARENS, FALSE}, {SPACE_WITHIN_ANONYMOUS_CLASS_PARENS, FALSE}, {SPACE_WITHIN_METHOD_DECL_PARENS, FALSE}, {SPACE_WITHIN_METHOD_CALL_PARENS, FALSE}, {SPACE_WITHIN_IF_PARENS, FALSE}, {SPACE_WITHIN_FOR_PARENS, FALSE}, {SPACE_WITHIN_WHILE_PARENS, FALSE}, {SPACE_WITHIN_SWITCH_PARENS, FALSE}, {SPACE_WITHIN_MATCH_PARENS, FALSE}, {SPACE_WITHIN_CATCH_PARENS, FALSE}, {SPACE_WITHIN_TYPE_CAST_PARENS, FALSE}, {SPACE_WITHIN_ARRAY_BRACKETS, FALSE}, {SPACE_WITHIN_ATTRIBUTE_BRACKETS, FALSE}, {SPACE_WITHIN_ATTRIBUTE_DECL_PARENS, FALSE}, {SPACE_BEFORE_COMMA, FALSE}, {SPACE_AFTER_COMMA, TRUE}, {SPACE_BEFORE_SEMI, FALSE}, {SPACE_AFTER_SEMI, TRUE}, {SPACE_AFTER_TYPE_CAST, TRUE}, {SPACE_CHECK_AFTER_KEYWORDS, TRUE}, {SPACE_AFTER_SHORT_PHP_TAG, TRUE}, {SPACE_BEFORE_CLOSE_PHP_TAG, TRUE}, {SPACE_BETWEEN_OPEN_PHP_TAG_AND_NAMESPACE, FALSE}, {ALIGN_MULTILINE_METHOD_PARAMS, FALSE}, {ALIGN_MULTILINE_CALL_ARGS, FALSE}, {ALIGN_MULTILINE_IMPLEMENTS, FALSE}, {ALIGN_MULTILINE_PARENTHESIZED, FALSE}, {ALIGN_MULTILINE_BINARY_OP, FALSE}, {ALIGN_MULTILINE_TERNARY_OP, FALSE}, {ALIGN_MULTILINE_ASSIGNMENT, FALSE}, {ALIGN_MULTILINE_FOR, FALSE}, {ALIGN_MULTILINE_ARRAY_INIT, FALSE}, {PLACE_ELSE_ON_NEW_LINE, FALSE}, {PLACE_WHILE_ON_NEW_LINE, FALSE}, {PLACE_CATCH_ON_NEW_LINE, FALSE}, {PLACE_FINALLY_ON_NEW_LINE, FALSE}, {PLACE_NEW_LINE_AFTER_MODIFIERS, FALSE}, {GROUP_ALIGNMENT_ARRAY_INIT, FALSE}, {GROUP_ALIGNMENT_ASSIGNMENT, FALSE}, {WRAP_GROUP_USE_LIST, WRAP_ALWAYS}, {WRAP_EXTENDS_IMPLEMENTS_KEYWORD, WRAP_NEVER}, {WRAP_EXTENDS_IMPLEMENTS_LIST, WRAP_NEVER}, {WRAP_METHOD_PARAMS, WRAP_NEVER}, {WRAP_METHOD_PARAMS_AFTER_LEFT_PAREN, FALSE}, {WRAP_METHOD_PARAMS_RIGHT_PAREN, FALSE}, {WRAP_METHOD_PARAMS_KEEP_PAREN_AND_BRACE_ON_THE_SAME_LINE, FALSE}, {WRAP_METHOD_CALL_ARGS, WRAP_NEVER}, {WRAP_METHOD_CALL_ARGS_AFTER_LEFT_PAREN, FALSE}, {WRAP_METHOD_CALL_ARGS_RIGHT_PAREN, FALSE}, {WRAP_CHAINED_METHOD_CALLS, WRAP_NEVER}, {WRAP_ARRAY_INIT, WRAP_NEVER}, {WRAP_FOR, WRAP_NEVER}, {WRAP_FOR_AFTER_LEFT_PAREN, FALSE}, {WRAP_FOR_RIGHT_PAREN, FALSE}, {WRAP_FOR_STATEMENT, WRAP_ALWAYS}, {WRAP_IF_STATEMENT, WRAP_ALWAYS}, {WRAP_WHILE_STATEMENT, WRAP_ALWAYS}, {WRAP_DO_WHILE_STATEMENT, WRAP_ALWAYS}, {WRAP_BINARY_OPS, WRAP_NEVER}, {WRAP_TERNARY_OPS, WRAP_NEVER}, {WRAP_ASSIGN_OPS, WRAP_NEVER}, {WRAP_BLOCK_BRACES, TRUE}, {WRAP_GROUP_USE_BRACES, TRUE}, {WRAP_STATEMENTS_ON_THE_LINE, TRUE}, {WRAP_AFTER_BIN_OPS, FALSE}, {WRAP_AFTER_ASSIGN_OPS, FALSE}, {PREFER_FULLY_QUALIFIED_NAMES, FALSE}, {PREFER_MULTIPLE_USE_STATEMENTS_COMBINED, FALSE}, {PREFER_GROUP_USES, FALSE}, {START_USE_WITH_NAMESPACE_SEPARATOR, FALSE}, {ALIASES_CAPITALS_OF_NAMESPACES, FALSE}};
        defaults = new HashMap<String, String>();
        for (String[] strings : defaultValues) {
            defaults.put(strings[0], strings[1]);
        }
    }

    public static Map<String, String> getDefaults() {
        return defaults;
    }

    public static boolean isInteger(String optionID) {
        String value = defaults.get(optionID);
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    static {
        OBRACE_NEWLINE = CodeStyle.BracePlacement.NEW_LINE.name();
        OBRACE_SAMELINE = CodeStyle.BracePlacement.SAME_LINE.name();
        OBRACE_PRESERVE = CodeStyle.BracePlacement.PRESERVE_EXISTING.name();
        OBRACE_NEWLINE_INDENTED = CodeStyle.BracePlacement.NEW_LINE_INDENTED.name();
        WRAP_ALWAYS = CodeStyle.WrapStyle.WRAP_ALWAYS.name();
        WRAP_IF_LONG = CodeStyle.WrapStyle.WRAP_IF_LONG.name();
        WRAP_NEVER = CodeStyle.WrapStyle.WRAP_NEVER.name();
        FmtOptions.createDefaults();
    }

    public static interface CodeStyleProducer {
        public CodeStyle create(Preferences var1);
    }

    public static final class ProxyPreferences
    extends AbstractPreferences {
        private final Preferences[] delegates;

        public ProxyPreferences(Preferences ... delegates) {
            super(null, "");
            this.delegates = delegates;
        }

        @Override
        protected void putSpi(String key, String value) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected String getSpi(String key) {
            for (Preferences p : this.delegates) {
                String value = p.get(key, null);
                if (value == null) continue;
                return value;
            }
            return null;
        }

        @Override
        protected void removeSpi(String key) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected void removeNodeSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected String[] keysSpi() throws BackingStoreException {
            HashSet<String> keys = new HashSet<String>();
            for (Preferences p : this.delegates) {
                keys.addAll(Arrays.asList(p.keys()));
            }
            return keys.toArray(new String[keys.size()]);
        }

        @Override
        protected String[] childrenNamesSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected AbstractPreferences childSpi(String name) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected void syncSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected void flushSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    public static class PreviewPreferences
    extends AbstractPreferences {
        private Map<String, Object> map = new HashMap<String, Object>();

        public PreviewPreferences() {
            super(null, "");
        }

        @Override
        protected void putSpi(String key, String value) {
            this.map.put(key, value);
        }

        @Override
        protected String getSpi(String key) {
            return (String)this.map.get(key);
        }

        @Override
        protected void removeSpi(String key) {
            this.map.remove(key);
        }

        @Override
        protected void removeNodeSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected String[] keysSpi() throws BackingStoreException {
            String[] array = new String[this.map.keySet().size()];
            return this.map.keySet().toArray(array);
        }

        @Override
        protected String[] childrenNamesSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected AbstractPreferences childSpi(String name) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected void syncSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected void flushSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    public static class CategorySupport
    implements ActionListener,
    DocumentListener,
    PreviewProvider,
    PreferencesCustomizer {
        public static final String OPTION_ID = "org.netbeans.modules.php.editor.indent.FormatingOptions.ID";
        private static final ComboItem[] BRACE_PLACEMENT = new ComboItem[]{new ComboItem(OBRACE_NEWLINE, "LBL_bp_NEWLINE"), new ComboItem(OBRACE_NEWLINE_INDENTED, "LBL_bp_NEWLINE_INDENTED"), new ComboItem(OBRACE_SAMELINE, "LBL_bp_SAMELINE"), new ComboItem(OBRACE_PRESERVE, "LBL_bp_PRESERVE")};
        private static final ComboItem[] WRAP = new ComboItem[]{new ComboItem(CodeStyle.WrapStyle.WRAP_ALWAYS.name(), "LBL_wrp_WRAP_ALWAYS"), new ComboItem(CodeStyle.WrapStyle.WRAP_IF_LONG.name(), "LBL_wrp_WRAP_IF_LONG"), new ComboItem(CodeStyle.WrapStyle.WRAP_NEVER.name(), "LBL_wrp_WRAP_NEVER")};
        private final String previewText;
        private final String id;
        protected final JPanel panel;
        private final List<JComponent> components = new LinkedList<JComponent>();
        private JEditorPane previewPane;
        private final Preferences preferences;
        private final Preferences previewPrefs;

        protected CategorySupport(Preferences preferences, String id, JPanel panel, String previewText, String[] ... forcedOptions) {
            this.preferences = preferences;
            this.id = id;
            this.panel = panel;
            this.previewText = previewText != null ? previewText : NbBundle.getMessage(FmtOptions.class, (String)"SAMPLE_Default");
            this.scan(panel, this.components);
            PreviewPreferences forcedPrefs = new PreviewPreferences();
            for (String[] option : forcedOptions) {
                ((Preferences)forcedPrefs).put(option[0], option[1]);
            }
            this.previewPrefs = new ProxyPreferences(preferences, forcedPrefs);
            this.loadFrom(preferences);
            this.addListeners();
        }

        protected void addListeners() {
            this.scan(Operation.ADD_LISTENERS, null);
        }

        protected void loadFrom(Preferences preferences) {
            this.scan(Operation.LOAD, preferences);
        }

        protected void storeTo(Preferences p) {
            this.scan(Operation.STORE, p);
        }

        public void notifyChanged() {
            this.storeTo(this.preferences);
            this.refreshPreview();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.notifyChanged();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.notifyChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.notifyChanged();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.notifyChanged();
        }

        public JComponent getPreviewComponent() {
            if (this.previewPane == null) {
                this.previewPane = new JEditorPane();
                this.previewPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FmtOptions.class, (String)"AN_Preview"));
                this.previewPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FmtOptions.class, (String)"AD_Preview"));
                this.previewPane.setEditorKit(CloneableEditorSupport.getEditorKit((String)"text/x-php5"));
                this.previewPane.setEditable(false);
            }
            return this.previewPane;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void refreshPreview() {
            JEditorPane pane = (JEditorPane)this.getPreviewComponent();
            try {
                int rm = this.previewPrefs.getInt(FmtOptions.RIGHT_MARGIN, FmtOptions.getDefaultAsInt(FmtOptions.RIGHT_MARGIN));
                pane.putClientProperty("TextLimitLine", rm);
            }
            catch (NumberFormatException rm) {
                // empty catch block
            }
            Rectangle visibleRectangle = pane.getVisibleRect();
            pane.setText(this.previewText);
            pane.setIgnoreRepaint(true);
            final Document doc = pane.getDocument();
            if (doc instanceof BaseDocument) {
                final Reformat reformat = Reformat.get((Document)doc);
                reformat.lock();
                try {
                    ((BaseDocument)doc).runAtomic(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                reformat.reformat(0, doc.getLength());
                            }
                            catch (BadLocationException ble) {
                                LOGGER.log(Level.WARNING, null, ble);
                            }
                        }
                    });
                }
                finally {
                    reformat.unlock();
                }
            } else {
                LOGGER.warning(String.format("Can't format %s; it's not BaseDocument.", doc));
            }
            pane.setIgnoreRepaint(false);
            pane.scrollRectToVisible(visibleRectangle);
            pane.repaint(100L);
        }

        public JComponent getComponent() {
            return this.panel;
        }

        public String getDisplayName() {
            return this.panel.getName();
        }

        public String getId() {
            return this.id;
        }

        public HelpCtx getHelpCtx() {
            return null;
        }

        private void performOperation(Operation operation, JComponent jc, String optionID, Preferences p) {
            switch (operation) {
                case LOAD: {
                    this.loadData(jc, optionID, p);
                    break;
                }
                case STORE: {
                    this.storeData(jc, optionID, p);
                    break;
                }
                case ADD_LISTENERS: {
                    this.addListener(jc);
                    break;
                }
                default: {
                    assert (false) : operation;
                    break;
                }
            }
        }

        private void scan(Operation what, Preferences p) {
            for (JComponent jc : this.components) {
                Object o = jc.getClientProperty(OPTION_ID);
                if (o instanceof String) {
                    this.performOperation(what, jc, (String)o, p);
                    continue;
                }
                if (!(o instanceof String[])) continue;
                for (String oid : (String[])o) {
                    this.performOperation(what, jc, oid, p);
                }
            }
        }

        private void scan(Container container, List<JComponent> components) {
            for (Component c : container.getComponents()) {
                JComponent jc;
                Object o;
                if (c instanceof JComponent && ((o = (jc = (JComponent)c).getClientProperty(OPTION_ID)) instanceof String || o instanceof String[])) {
                    components.add(jc);
                }
                if (!(c instanceof Container)) continue;
                this.scan((Container)c, components);
            }
        }

        private void loadData(JComponent jc, String optionID, Preferences node) {
            if (jc instanceof JTextField) {
                JTextField field = (JTextField)jc;
                field.setText(node.get(optionID, FmtOptions.getDefaultAsString(optionID)));
            } else if (jc instanceof JCheckBox) {
                JCheckBox checkBox = (JCheckBox)jc;
                boolean df = FmtOptions.getDefaultAsBoolean(optionID);
                checkBox.setSelected(node.getBoolean(optionID, df));
            } else if (jc instanceof JComboBox) {
                JComboBox cb = (JComboBox)jc;
                String value = node.get(optionID, FmtOptions.getDefaultAsString(optionID));
                ComboBoxModel model = this.createModel(value);
                cb.setModel(model);
                ComboItem item = CategorySupport.whichItem(value, model);
                cb.setSelectedItem(item);
            } else if (jc instanceof JRadioButton) {
                JRadioButton radioButton = (JRadioButton)jc;
                boolean df = FmtOptions.getDefaultAsBoolean(optionID);
                radioButton.setSelected(node.getBoolean(optionID, df));
            }
        }

        private void storeData(JComponent jc, String optionID, Preferences node) {
            if (jc instanceof JTextField) {
                JTextField field = (JTextField)jc;
                String text = field.getText();
                if (FmtOptions.isInteger(optionID)) {
                    try {
                        Integer.parseInt(text);
                    }
                    catch (NumberFormatException e) {
                        return;
                    }
                }
                if (!optionID.equals(FmtOptions.TAB_SIZE) && !optionID.equals(FmtOptions.SPACES_PER_TAB) && !optionID.equals(FmtOptions.INDENT_SIZE) && FmtOptions.getDefaultAsString(optionID).equals(text)) {
                    node.remove(optionID);
                } else {
                    node.put(optionID, text);
                }
            } else if (jc instanceof JCheckBox) {
                JCheckBox checkBox = (JCheckBox)jc;
                if (!optionID.equals(FmtOptions.EXPAND_TAB_TO_SPACES) && FmtOptions.getDefaultAsBoolean(optionID) == checkBox.isSelected()) {
                    node.remove(optionID);
                } else {
                    node.putBoolean(optionID, checkBox.isSelected());
                }
            } else if (jc instanceof JComboBox) {
                String value;
                JComboBox cb = (JComboBox)jc;
                ComboItem comboItem = (ComboItem)cb.getSelectedItem();
                String string = value = comboItem == null ? FmtOptions.getDefaultAsString(optionID) : comboItem.value;
                if (FmtOptions.getDefaultAsString(optionID).equals(value)) {
                    node.remove(optionID);
                } else {
                    node.put(optionID, value);
                }
            }
        }

        private void addListener(JComponent jc) {
            if (jc instanceof JTextField) {
                JTextField field = (JTextField)jc;
                field.addActionListener(this);
                field.getDocument().addDocumentListener(this);
            } else if (jc instanceof JCheckBox) {
                JCheckBox checkBox = (JCheckBox)jc;
                checkBox.addActionListener(this);
            } else if (jc instanceof JComboBox) {
                JComboBox cb = (JComboBox)jc;
                cb.addActionListener(this);
            }
        }

        private ComboBoxModel createModel(String value) {
            for (ComboItem comboItem : BRACE_PLACEMENT) {
                if (!value.equals(comboItem.value)) continue;
                return new DefaultComboBoxModel<ComboItem>(BRACE_PLACEMENT);
            }
            for (ComboItem comboItem : WRAP) {
                if (!value.equals(comboItem.value)) continue;
                return new DefaultComboBoxModel<ComboItem>(WRAP);
            }
            return null;
        }

        private static ComboItem whichItem(String value, ComboBoxModel model) {
            for (int i = 0; i < model.getSize(); ++i) {
                ComboItem item = (ComboItem)model.getElementAt(i);
                if (!value.equals(item.value)) continue;
                return item;
            }
            return null;
        }

        private static class ComboItem {
            String value;
            String displayName;

            public ComboItem(String value, String key) {
                this.value = value;
                this.displayName = NbBundle.getMessage(FmtOptions.class, (String)key);
            }

            public String toString() {
                return this.displayName;
            }
        }

        public static final class Factory
        implements PreferencesCustomizer.Factory {
            private final String id;
            private final Class<? extends JPanel> panelClass;
            private final String previewText;
            private final String[][] forcedOptions;

            public Factory(String id, Class<? extends JPanel> panelClass, String previewText, String[] ... forcedOptions) {
                this.id = id;
                this.panelClass = panelClass;
                this.previewText = previewText;
                this.forcedOptions = forcedOptions;
            }

            public PreferencesCustomizer create(Preferences preferences) {
                try {
                    return new CategorySupport(preferences, this.id, this.panelClass.newInstance(), this.previewText, this.forcedOptions);
                }
                catch (IllegalAccessException | InstantiationException e) {
                    LOGGER.log(Level.WARNING, "Exception during creating formatter customiezer", e);
                    return null;
                }
            }
        }

        private static enum Operation {
            LOAD,
            STORE,
            ADD_LISTENERS;

        }
    }
}

