/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.laf.flatlaf;

import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.util.SystemInfo;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.netbeans.swing.laf.flatlaf.FlatLafOptionsPanelController;
import org.netbeans.swing.laf.flatlaf.FlatLafPrefs;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class FlatLafOptionsPanel
extends JPanel {
    private final FlatLafOptionsPanelController controller;
    private JCheckBox alwaysShowMnemonicsCheckBox;
    private JCheckBox menuBarEmbeddedCheckBox;
    private JCheckBox underlineMenuSelectionCheckBox;
    private JCheckBox unifiedTitleBarCheckBox;
    private JCheckBox useWindowDecorationsCheckBox;

    public FlatLafOptionsPanel(FlatLafOptionsPanelController controller) {
        this.controller = controller;
        this.initComponents();
        this.updateEnabled();
    }

    private void updateEnabled() {
        boolean supportsWindowDecorations = FlatLaf.supportsNativeWindowDecorations();
        this.useWindowDecorationsCheckBox.setEnabled(supportsWindowDecorations);
        this.unifiedTitleBarCheckBox.setEnabled(supportsWindowDecorations && this.useWindowDecorationsCheckBox.isSelected());
        this.menuBarEmbeddedCheckBox.setEnabled(supportsWindowDecorations && this.useWindowDecorationsCheckBox.isSelected());
        this.underlineMenuSelectionCheckBox.setEnabled(!SystemInfo.isMacOS);
    }

    private void initComponents() {
        this.useWindowDecorationsCheckBox = new JCheckBox();
        this.menuBarEmbeddedCheckBox = new JCheckBox();
        this.unifiedTitleBarCheckBox = new JCheckBox();
        this.underlineMenuSelectionCheckBox = new JCheckBox();
        this.alwaysShowMnemonicsCheckBox = new JCheckBox();
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        Mnemonics.setLocalizedText((AbstractButton)this.useWindowDecorationsCheckBox, (String)NbBundle.getMessage(FlatLafOptionsPanel.class, (String)"FlatLafOptionsPanel.useWindowDecorationsCheckBox.text"));
        this.useWindowDecorationsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FlatLafOptionsPanel.this.useWindowDecorationsCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.menuBarEmbeddedCheckBox, (String)NbBundle.getMessage(FlatLafOptionsPanel.class, (String)"FlatLafOptionsPanel.menuBarEmbeddedCheckBox.text"));
        this.menuBarEmbeddedCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FlatLafOptionsPanel.this.menuBarEmbeddedCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.unifiedTitleBarCheckBox, (String)NbBundle.getMessage(FlatLafOptionsPanel.class, (String)"FlatLafOptionsPanel.unifiedTitleBarCheckBox.text"));
        this.unifiedTitleBarCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FlatLafOptionsPanel.this.unifiedTitleBarCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.underlineMenuSelectionCheckBox, (String)NbBundle.getMessage(FlatLafOptionsPanel.class, (String)"FlatLafOptionsPanel.underlineMenuSelectionCheckBox.text"));
        this.underlineMenuSelectionCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FlatLafOptionsPanel.this.underlineMenuSelectionCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.alwaysShowMnemonicsCheckBox, (String)NbBundle.getMessage(FlatLafOptionsPanel.class, (String)"FlatLafOptionsPanel.alwaysShowMnemonicsCheckBox.text"));
        this.alwaysShowMnemonicsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FlatLafOptionsPanel.this.alwaysShowMnemonicsCheckBoxActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.useWindowDecorationsCheckBox).addComponent(this.unifiedTitleBarCheckBox).addComponent(this.menuBarEmbeddedCheckBox).addComponent(this.underlineMenuSelectionCheckBox).addComponent(this.alwaysShowMnemonicsCheckBox)).addContainerGap(73, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.useWindowDecorationsCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.unifiedTitleBarCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.menuBarEmbeddedCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.underlineMenuSelectionCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.alwaysShowMnemonicsCheckBox).addContainerGap(25, Short.MAX_VALUE)));
    }

    private void useWindowDecorationsCheckBoxActionPerformed(ActionEvent evt) {
        this.updateEnabled();
        this.fireChanged();
    }

    private void unifiedTitleBarCheckBoxActionPerformed(ActionEvent evt) {
        this.fireChanged();
    }

    private void menuBarEmbeddedCheckBoxActionPerformed(ActionEvent evt) {
        this.fireChanged();
    }

    private void underlineMenuSelectionCheckBoxActionPerformed(ActionEvent evt) {
        this.fireChanged();
    }

    private void alwaysShowMnemonicsCheckBoxActionPerformed(ActionEvent evt) {
        this.fireChanged();
    }

    private void fireChanged() {
        boolean isChanged = false;
        if (this.useWindowDecorationsCheckBox.isSelected() != FlatLafPrefs.isUseWindowDecorations() || this.unifiedTitleBarCheckBox.isSelected() != FlatLafPrefs.isUnifiedTitleBar() || this.menuBarEmbeddedCheckBox.isSelected() != FlatLafPrefs.isMenuBarEmbedded() || this.underlineMenuSelectionCheckBox.isSelected() != FlatLafPrefs.isUnderlineMenuSelection() || this.alwaysShowMnemonicsCheckBox.isSelected() != FlatLafPrefs.isAlwaysShowMnemonics()) {
            isChanged = true;
        }
        this.controller.changed(isChanged);
    }

    protected void load() {
        this.useWindowDecorationsCheckBox.setSelected(FlatLafPrefs.isUseWindowDecorations());
        this.unifiedTitleBarCheckBox.setSelected(FlatLafPrefs.isUnifiedTitleBar());
        this.menuBarEmbeddedCheckBox.setSelected(FlatLafPrefs.isMenuBarEmbedded());
        this.underlineMenuSelectionCheckBox.setSelected(FlatLafPrefs.isUnderlineMenuSelection());
        this.alwaysShowMnemonicsCheckBox.setSelected(FlatLafPrefs.isAlwaysShowMnemonics());
        this.updateEnabled();
    }

    protected boolean store() {
        FlatLafPrefs.setUseWindowDecorations(this.useWindowDecorationsCheckBox.isSelected());
        FlatLafPrefs.setUnifiedTitleBar(this.unifiedTitleBarCheckBox.isSelected());
        FlatLafPrefs.setMenuBarEmbedded(this.menuBarEmbeddedCheckBox.isSelected());
        FlatLafPrefs.setUnderlineMenuSelection(this.underlineMenuSelectionCheckBox.isSelected());
        FlatLafPrefs.setAlwaysShowMnemonics(this.alwaysShowMnemonicsCheckBox.isSelected());
        return false;
    }

    boolean valid() {
        return true;
    }
}

