/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import java.awt.event.ActionEvent;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.modules.project.ui.actions.Bundle;
import org.netbeans.modules.project.ui.actions.VerticalGridLayout;
import org.netbeans.spi.project.ProjectContainerProvider;
import org.netbeans.spi.project.SubprojectProvider;
import org.openide.awt.Mnemonics;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;

public class OpenSubprojects
extends NodeAction
implements Presenter.Popup {
    private static final RequestProcessor RP = new RequestProcessor("OpenSubprojects", 1);
    private static final String ICON = "org/netbeans/modules/project/ui/resources/openProject.png";

    public String getName() {
        return Bundle.LBL_OpenSubprojectsAction_Name();
    }

    public String iconResource() {
        return ICON;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return true;
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length == 0) {
            return false;
        }
        boolean someSubprojects = false;
        for (int i = 0; i < activatedNodes.length; ++i) {
            Project p = (Project)activatedNodes[i].getLookup().lookup(Project.class);
            if (p == null) {
                return false;
            }
            SubprojectProvider spp = (SubprojectProvider)p.getLookup().lookup(SubprojectProvider.class);
            if (spp == null) continue;
            someSubprojects = true;
        }
        return someSubprojects;
    }

    protected void performAction(Node[] activatedNodes) {
        this.openAllRequiredProjects(activatedNodes);
    }

    public JMenuItem getPopupPresenter() {
        Node[] activatedNodes = this.getActivatedNodes();
        return new LazyMenu(activatedNodes);
    }

    private void openAllRequiredProjects(Node[] activatedNodes) {
        if (activatedNodes != null) {
            for (int i = 0; i < activatedNodes.length; ++i) {
                Project p = (Project)activatedNodes[i].getLookup().lookup(Project.class);
                if (p == null) continue;
                OpenProjectList.getDefault().open(new Project[]{p}, true, true);
            }
        }
    }

    private class LazyMenu
    extends JMenu {
        private final Node[] activatedNodes;
        boolean initialized;
        private Set<? extends Project> subProjects;

        private LazyMenu(Node[] nodes) {
            super(Bundle.LBL_OpenSubprojectsAction_Name());
            this.activatedNodes = nodes;
            JMenuItem item = new JMenuItem(Bundle.LBL_SubProjectPopupMenu_Initializing());
            item.setEnabled(false);
            this.add(item);
            RP.post(new Runnable(){

                @Override
                public void run() {
                    LazyMenu.this.getSubProjects();
                }
            });
        }

        @Override
        public JPopupMenu getPopupMenu() {
            if (this.initialized) {
                this.createSubMenu();
            }
            return super.getPopupMenu();
        }

        private void createSubMenu() {
            this.removeAll();
            if (this.subProjects != null && !this.subProjects.isEmpty()) {
                super.getPopupMenu().setLayout(new VerticalGridLayout());
                JMenuItem openAllProjectsItem = new JMenuItem(new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        OpenSubprojects.this.openAllRequiredProjects(OpenSubprojects.this.getActivatedNodes());
                    }
                });
                Mnemonics.setLocalizedText((AbstractButton)openAllProjectsItem, (String)Bundle.OpenProjectMenu_Open_All_Projects());
                this.add(openAllProjectsItem);
                this.addSeparator();
            } else {
                JMenuItem nothingItem = new JMenuItem(Bundle.OpenProjectMenu_Nothing());
                nothingItem.setEnabled(false);
                this.add(nothingItem);
            }
            if (this.subProjects != null && !this.subProjects.isEmpty()) {
                for (final Project project : this.subProjects) {
                    JMenuItem selectPrjAction = new JMenuItem(new AbstractAction(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            OpenProjectList.getDefault().open(new Project[]{project}, true, true);
                        }
                    });
                    selectPrjAction.setText(ProjectUtils.getInformation((Project)project).getDisplayName());
                    this.add(selectPrjAction);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void getSubProjects() {
            try {
                if (this.activatedNodes != null) {
                    for (int i = 0; i < this.activatedNodes.length; ++i) {
                        Project p = (Project)this.activatedNodes[i].getLookup().lookup(Project.class);
                        if (p == null) continue;
                        ProjectContainerProvider pcp = (ProjectContainerProvider)p.getLookup().lookup(ProjectContainerProvider.class);
                        if (pcp != null) {
                            this.subProjects = pcp.getContainedProjects().getProjects();
                            continue;
                        }
                        SubprojectProvider spp = (SubprojectProvider)p.getLookup().lookup(SubprojectProvider.class);
                        if (spp == null) continue;
                        this.subProjects = spp.getSubprojects();
                    }
                }
            }
            finally {
                this.initialized = true;
            }
        }
    }
}

