/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.ReferenceTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.DocSourcePositions;
import com.sun.source.util.DocTreePath;
import com.sun.source.util.DocTreePathScanner;
import com.sun.source.util.DocTrees;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import com.sun.tools.javac.api.JavacScope;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.parser.JavacParser;
import com.sun.tools.javac.parser.Parser;
import com.sun.tools.javac.parser.ParserFactory;
import com.sun.tools.javac.tree.DCTree;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.Log;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.CharBuffer;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.UnionType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.lexer.JavadocTokenId;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.support.ErrorAwareTreePathScanner;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.lib.nbjavac.services.NBAttr;
import org.netbeans.lib.nbjavac.services.NBResolve;
import org.netbeans.modules.java.source.TreeShims;
import org.netbeans.modules.java.source.TreeUtilitiesAccessor;
import org.netbeans.modules.java.source.builder.CommentHandlerService;
import org.netbeans.modules.java.source.builder.CommentSetImpl;
import org.netbeans.modules.java.source.matching.CopyFinder;
import org.netbeans.modules.java.source.pretty.ImportAnalysis2;
import org.netbeans.modules.java.source.transform.ImmutableDocTreeTranslator;
import org.netbeans.modules.java.source.transform.ImmutableTreeTranslator;

public final class TreeUtilities {
    private static final Logger LOG;
    public static final Set<Tree.Kind> CLASS_TREE_KINDS;
    private final CompilationInfo info;
    private final CommentHandlerService handler;
    private static final Set<JavaTokenId> IGNORE_TOKENS;
    private static boolean VARIABLE_CAN_OWN_VARIABLES;
    static Set<Character> EXOTIC_ESCAPE;
    private static final Map<Character, Character> ESCAPE_UNENCODE;
    private static final Map<Character, Character> ESCAPE_ENCODE;

    TreeUtilities(CompilationInfo info) {
        assert (info != null);
        this.info = info;
        this.handler = CommentHandlerService.instance(info.impl.getJavacTask().getContext());
    }

    @Deprecated
    public boolean isClass(ClassTree tree) {
        return (((JCTree.JCModifiers)tree.getModifiers()).flags & 0x6200L) == 0L;
    }

    @Deprecated
    public boolean isInterface(ClassTree tree) {
        long flags = ((JCTree.JCModifiers)tree.getModifiers()).flags;
        return (flags & 0x200L) != 0L && (flags & 0x2000L) == 0L;
    }

    @Deprecated
    public boolean isEnum(ClassTree tree) {
        return (((JCTree.JCModifiers)tree.getModifiers()).flags & 0x4000L) != 0L;
    }

    public boolean isEnumConstant(VariableTree tree) {
        return (((JCTree.JCModifiers)tree.getModifiers()).flags & 0x4000L) != 0L;
    }

    @Deprecated
    public boolean isAnnotation(ClassTree tree) {
        return (((JCTree.JCModifiers)tree.getModifiers()).flags & 0x2000L) != 0L;
    }

    public boolean isPackageInfo(CompilationUnitTree tree) {
        return TreeInfo.isPackageInfo((JCTree.JCCompilationUnit)tree);
    }

    public boolean isModuleInfo(CompilationUnitTree tree) {
        return TreeInfo.isModuleInfo((JCTree.JCCompilationUnit)tree);
    }

    public boolean isSynthetic(TreePath path) throws NullPointerException {
        if (path == null) {
            throw new NullPointerException();
        }
        while (path != null) {
            NewClassTree nct;
            ClassTree body;
            if (this.isSynthetic(path.getCompilationUnit(), path.getLeaf())) {
                return true;
            }
            if (path.getParentPath() != null && path.getParentPath().getParentPath() != null && path.getParentPath().getParentPath().getLeaf().getKind() == Tree.Kind.NEW_CLASS && (body = (nct = (NewClassTree)path.getParentPath().getParentPath().getLeaf()).getClassBody()) != null && (body.getExtendsClause() == path.getLeaf() || body.getImplementsClause().contains(path.getLeaf()))) {
                return true;
            }
            path = path.getParentPath();
        }
        return false;
    }

    boolean isSynthetic(CompilationUnitTree cut, Tree leaf) throws NullPointerException {
        IdentifierTree it;
        MethodInvocationTree mit;
        ExpressionStatementTree est;
        JCTree tree = (JCTree)leaf;
        if (tree.pos == -1) {
            return true;
        }
        if (leaf.getKind() == Tree.Kind.METHOD) {
            return (((JCTree.JCMethodDecl)leaf).mods.flags & 0x1000000000L) != 0L;
        }
        if (leaf.getKind() == Tree.Kind.EXPRESSION_STATEMENT && (est = (ExpressionStatementTree)leaf).getExpression().getKind() == Tree.Kind.METHOD_INVOCATION && (mit = (MethodInvocationTree)est.getExpression()).getMethodSelect().getKind() == Tree.Kind.IDENTIFIER && "super".equals((it = (IdentifierTree)mit.getMethodSelect()).getName().toString())) {
            SourcePositions sp = this.info.getTrees().getSourcePositions();
            return sp.getEndPosition(cut, leaf) == -1L;
        }
        return false;
    }

    public TreePath getPathElementOfKind(Tree.Kind kind, TreePath path) {
        return this.getPathElementOfKind(EnumSet.of(kind), path);
    }

    public TreePath getPathElementOfKind(Set<Tree.Kind> kinds, TreePath path) {
        while (path != null) {
            if (kinds.contains((Object)path.getLeaf().getKind())) {
                return path;
            }
            path = path.getParentPath();
        }
        return null;
    }

    public List<Comment> getComments(Tree tree, boolean preceding) {
        CommentSetImpl set = this.handler.getComments(tree);
        TreeUtilities.ensureCommentsMapped(this.info, tree, set);
        List<Comment> comments = preceding ? set.getPrecedingComments() : set.getTrailingComments();
        return Collections.unmodifiableList(comments);
    }

    static void ensureCommentsMapped(CompilationInfo info, @NullAllowed Tree tree, CommentSetImpl set) {
        if (!set.areCommentsMapped() && tree != null) {
            TreePath tp;
            boolean assertsEnabled = false;
            boolean automap = true;
            if (!$assertionsDisabled) {
                assertsEnabled = true;
                if (!true) {
                    throw new AssertionError();
                }
            }
            TreePath treePath = tp = info.getCompilationUnit() == tree ? new TreePath(info.getCompilationUnit()) : TreePath.getPath(info.getCompilationUnit(), tree);
            if (tp == null) {
                if (!(!assertsEnabled || info.getTreeUtilities().isSynthetic(info.getCompilationUnit(), tree) || info instanceof WorkingCopy && ((WorkingCopy)info).validateIsReplacement(tree))) {
                    Logger.getLogger(TreeUtilities.class.getName()).log(assertsEnabled ? Level.WARNING : Level.FINE, "Comment automap requested for Tree not from the root compilation info. Please, make sure to call GeneratorUtilities.importComments before Treeutilities.getComments. Tree: {0}", tree);
                    Logger.getLogger(TreeUtilities.class.getName()).log(assertsEnabled ? Level.INFO : Level.FINE, "Caller", new Exception());
                }
                automap = false;
            }
            if (automap) {
                GeneratorUtilities.importComments(info, tree, info.getCompilationUnit());
            }
        }
    }

    public TreePath pathFor(int pos) {
        return this.pathFor(new TreePath(this.info.getCompilationUnit()), pos);
    }

    public TreePath pathFor(TreePath path, int pos) {
        return this.pathFor(path, pos, this.info.getTrees().getSourcePositions());
    }

    public TreePath pathFor(TreePath path, int pos, SourcePositions sourcePositions) {
        class Result
        extends Error {
            TreePath path;

            Result(TreePath path) {
                this.path = path;
            }
        }
        if (this.info == null || path == null || sourcePositions == null) {
            throw new IllegalArgumentException();
        }
        try {
            class PathFinder
            extends ErrorAwareTreePathScanner<Void, Void> {
                private int pos;
                private SourcePositions sourcePositions;

                PathFinder(int pos, SourcePositions sourcePositions) {
                    this.pos = pos;
                    this.sourcePositions = sourcePositions;
                }

                @Override
                public Void scan(Tree tree, Void p) {
                    if (tree != null) {
                        long endPos = this.sourcePositions.getEndPosition(this.getCurrentPath().getCompilationUnit(), tree);
                        if (endPos == -1L && tree.getKind() == Tree.Kind.ASSIGNMENT && this.getCurrentPath().getLeaf().getKind() == Tree.Kind.ANNOTATION) {
                            ExpressionTree value = ((AssignmentTree)tree).getExpression();
                            endPos = this.sourcePositions.getEndPosition(this.getCurrentPath().getCompilationUnit(), value);
                        }
                        if (this.sourcePositions.getStartPosition(this.getCurrentPath().getCompilationUnit(), tree) < (long)this.pos && endPos >= (long)this.pos) {
                            if (tree.getKind() == Tree.Kind.ERRONEOUS) {
                                tree.accept(this, p);
                                throw new Result(this.getCurrentPath());
                            }
                            super.scan(tree, p);
                            throw new Result(new TreePath(this.getCurrentPath(), tree));
                        }
                    }
                    return null;
                }

                @Override
                public Void visitVariable(VariableTree node, Void p) {
                    int[] span = TreeUtilities.this.findNameSpan(node);
                    if (span != null && span[0] <= this.pos && this.pos < span[1]) {
                        throw new Result(this.getCurrentPath());
                    }
                    return (Void)super.visitVariable(node, p);
                }

                @Override
                public Void visitMethod(MethodTree node, Void p) {
                    int[] span = TreeUtilities.this.findNameSpan(node);
                    if (span != null && span[0] <= this.pos && this.pos < span[1]) {
                        throw new Result(this.getCurrentPath());
                    }
                    return (Void)super.visitMethod(node, p);
                }

                @Override
                public Void visitEnhancedForLoop(EnhancedForLoopTree node, Void p) {
                    int exprEndPos = (int)this.sourcePositions.getEndPosition(this.getCurrentPath().getCompilationUnit(), node.getExpression());
                    if (exprEndPos < this.pos) {
                        boolean hasNonWhiteSpace;
                        TokenSequence ts = TreeUtilities.this.info.getTokenHierarchy().tokenSequence(JavaTokenId.language()).subSequence(exprEndPos, this.pos);
                        while ((hasNonWhiteSpace = ts.moveNext()) && IGNORE_TOKENS.contains(ts.token().id())) {
                        }
                        if (!hasNonWhiteSpace) {
                            this.pos = exprEndPos;
                        }
                    }
                    return (Void)super.visitEnhancedForLoop(node, p);
                }
            }
            new PathFinder(pos, sourcePositions).scan(path, null);
        }
        catch (Result result) {
            path = result.path;
        }
        if (path.getLeaf() == path.getCompilationUnit()) {
            return path;
        }
        TokenSequence<JavaTokenId> tokenList = this.tokensFor(path.getLeaf(), sourcePositions, pos);
        tokenList.moveEnd();
        if (tokenList.movePrevious() && tokenList.offset() < pos) {
            block1 : switch ((JavaTokenId)tokenList.token().id()) {
                case GTGTGT: 
                case GTGT: 
                case GT: {
                    if (path.getLeaf().getKind() == Tree.Kind.MEMBER_SELECT || CLASS_TREE_KINDS.contains((Object)path.getLeaf().getKind()) || path.getLeaf().getKind() == Tree.Kind.MEMBER_REFERENCE || path.getLeaf().getKind() == Tree.Kind.GREATER_THAN) break;
                }
                case RPAREN: {
                    if (path.getLeaf().getKind() == Tree.Kind.PARENTHESIZED) {
                        path = path.getParentPath();
                        break;
                    }
                    if (path.getLeaf().getKind() == Tree.Kind.ENHANCED_FOR_LOOP || path.getLeaf().getKind() == Tree.Kind.FOR_LOOP || path.getLeaf().getKind() == Tree.Kind.IF || path.getLeaf().getKind() == Tree.Kind.WHILE_LOOP || path.getLeaf().getKind() == Tree.Kind.DO_WHILE_LOOP || path.getLeaf().getKind() == Tree.Kind.TYPE_CAST || path.getLeaf().getKind() == Tree.Kind.LAMBDA_EXPRESSION) break;
                }
                case SEMICOLON: {
                    if (path.getLeaf().getKind() == Tree.Kind.EMPTY_STATEMENT || path.getLeaf().getKind() == Tree.Kind.TRY || path.getLeaf().getKind() == Tree.Kind.FOR_LOOP && (long)tokenList.offset() <= sourcePositions.getStartPosition(path.getCompilationUnit(), ((ForLoopTree)path.getLeaf()).getUpdate().get(0))) break;
                    if (path.getParentPath().getLeaf().getKind() == Tree.Kind.TRY && ((TryTree)path.getParentPath().getLeaf()).getResources().contains(path.getLeaf())) {
                        path = path.getParentPath();
                        break;
                    }
                }
                case RBRACE: {
                    path = path.getParentPath();
                    switch (path.getLeaf().getKind()) {
                        case CATCH: {
                            path = path.getParentPath();
                        }
                        case METHOD: 
                        case FOR_LOOP: 
                        case ENHANCED_FOR_LOOP: 
                        case SYNCHRONIZED: 
                        case WHILE_LOOP: 
                        case TRY: {
                            path = path.getParentPath();
                            break block1;
                        }
                        case IF: {
                            while ((path = path.getParentPath()) != null && path.getLeaf().getKind() == Tree.Kind.IF) {
                            }
                            break block1;
                        }
                    }
                }
            }
        }
        return path;
    }

    public DocTreePath pathFor(TreePath treepath, DocCommentTree doc, int pos) {
        return this.pathFor(new DocTreePath(treepath, doc), pos);
    }

    public DocTreePath pathFor(DocTreePath path, int pos) {
        return this.pathFor(path, pos, this.info.getDocTrees().getSourcePositions());
    }

    public DocTreePath pathFor(DocTreePath path, int pos, DocSourcePositions sourcePositions) {
        class Result
        extends Error {
            DocTreePath path;

            Result(DocTreePath path) {
                this.path = path;
            }
        }
        if (this.info == null || path == null || sourcePositions == null) {
            throw new IllegalArgumentException();
        }
        try {
            class PathFinder
            extends DocTreePathScanner<Void, TreePath> {
                private int pos;
                private DocSourcePositions sourcePositions;

                PathFinder(int pos, DocSourcePositions sourcePositions) {
                    this.pos = pos;
                    this.sourcePositions = sourcePositions;
                }

                @Override
                public Void scan(DocTree tree, TreePath p) {
                    if (tree != null && this.sourcePositions.getStartPosition(p.getCompilationUnit(), this.getCurrentPath().getDocComment(), tree) < (long)this.pos && this.sourcePositions.getEndPosition(p.getCompilationUnit(), this.getCurrentPath().getDocComment(), tree) >= (long)this.pos) {
                        if (tree.getKind() == DocTree.Kind.ERRONEOUS) {
                            tree.accept(this, p);
                            throw new Result(this.getCurrentPath());
                        }
                        super.scan(tree, p);
                        throw new Result(new DocTreePath(this.getCurrentPath(), tree));
                    }
                    return null;
                }
            }
            new PathFinder(pos, sourcePositions).scan(path, path.getTreePath());
        }
        catch (Result result) {
            path = result.path;
        }
        if (path.getLeaf() == path.getDocComment()) {
            return path;
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeMirror parseType(String expr, TypeElement scope) {
        Enter enter = Enter.instance(this.info.impl.getJavacTask().getContext());
        TreeMaker jcMaker = TreeMaker.instance(this.info.impl.getJavacTask().getContext());
        int oldPos = jcMaker.pos;
        try {
            if (enter.getClassEnv((Symbol.TypeSymbol)((Object)scope)) == null && this.info.getTrees().getTree(scope) == null) {
                TypeMirror typeMirror = null;
                return typeMirror;
            }
            Type type = this.info.impl.getJavacTask().parseType(expr, scope);
            return type;
        }
        finally {
            jcMaker.pos = oldPos;
        }
    }

    Tree parseType(String expr) {
        return this.doParse(expr, null, 0, Parser::parseType);
    }

    public StatementTree parseStatement(String stmt, SourcePositions[] sourcePositions) {
        return TreeUtilities.parseStatementImpl(this.info.impl.getJavacTask(), stmt, sourcePositions);
    }

    private static StatementTree parseStatementImpl(JavacTaskImpl task, String stmt, SourcePositions[] sourcePositions) {
        return TreeUtilities.doParse(task, stmt, sourcePositions, 0, Parser::parseStatement);
    }

    public ExpressionTree parseExpression(String expr, SourcePositions[] sourcePositions) {
        return this.doParse(expr, sourcePositions, 0, Parser::parseExpression);
    }

    public ExpressionTree parseVariableInitializer(String init, SourcePositions[] sourcePositions) {
        return this.doParse(init, sourcePositions, 0, p -> ((JavacParser)p).variableInitializer());
    }

    public BlockTree parseStaticBlock(String block, SourcePositions[] sourcePositions) {
        return this.doParse("{ class C { " + block + " }", sourcePositions, "{ class C { ".length(), p -> {
            JCTree.JCClassDecl decl = (JCTree.JCClassDecl)((BlockTree)((Object)p.parseStatement())).getStatements().get(0);
            return ((JCTree)decl.defs.head).getKind() == Tree.Kind.BLOCK ? (BlockTree)decl.defs.head : null;
        });
    }

    private <T extends Tree> T doParse(String text, SourcePositions[] sourcePositions, int offset, Function<Parser, T> actualParse) {
        return TreeUtilities.doParse(this.info.impl.getJavacTask(), text, sourcePositions, offset, actualParse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T extends Tree> T doParse(JavacTaskImpl task, String text, SourcePositions[] sourcePositions, int offset, Function<Parser, T> actualParse) {
        if (text == null || sourcePositions != null && sourcePositions.length != 1) {
            throw new IllegalArgumentException();
        }
        JavaCompiler.instance(task.getContext());
        TreeMaker jcMaker = TreeMaker.instance(task.getContext());
        int oldPos = jcMaker.pos;
        try {
            Log.DiscardDiagnosticHandler discardHandler;
            JavaFileObject prev;
            JavaCompiler compiler;
            block10: {
                Tree tree;
                Context context = task.getContext();
                compiler = JavaCompiler.instance(context);
                prev = compiler.log.useSource(new DummyJFO());
                discardHandler = new Log.DiscardDiagnosticHandler(compiler.log){

                    @Override
                    public void report(JCDiagnostic diag) {
                    }
                };
                try {
                    CharBuffer buf = CharBuffer.wrap((text + "\u0000").toCharArray(), 0, text.length());
                    ParserFactory factory = ParserFactory.instance(context);
                    JavacParser parser = factory.newParser(buf, false, true, false, false);
                    if (!(parser instanceof JavacParser)) break block10;
                    if (sourcePositions != null) {
                        sourcePositions[0] = new ParserSourcePositions(parser, offset);
                    }
                    tree = (Tree)actualParse.apply(parser);
                }
                catch (Throwable throwable) {
                    compiler.log.useSource(prev);
                    compiler.log.popDiagnosticHandler(discardHandler);
                    throw throwable;
                }
                compiler.log.useSource(prev);
                compiler.log.popDiagnosticHandler(discardHandler);
                return (T)tree;
            }
            T t = null;
            compiler.log.useSource(prev);
            compiler.log.popDiagnosticHandler(discardHandler);
            return t;
        }
        finally {
            jcMaker.pos = oldPos;
        }
    }

    public Scope scopeFor(int pos) {
        List<? extends StatementTree> stmts = null;
        SourcePositions sourcePositions = this.info.getTrees().getSourcePositions();
        TreePath path = this.pathFor(pos);
        CompilationUnitTree root = path.getCompilationUnit();
        switch (path.getLeaf().getKind()) {
            case BLOCK: {
                stmts = ((BlockTree)path.getLeaf()).getStatements();
                break;
            }
            case FOR_LOOP: {
                stmts = ((ForLoopTree)path.getLeaf()).getInitializer();
                break;
            }
            case ENHANCED_FOR_LOOP: {
                stmts = Collections.singletonList(((EnhancedForLoopTree)path.getLeaf()).getStatement());
                break;
            }
            case CASE: {
                stmts = ((CaseTree)path.getLeaf()).getStatements();
                break;
            }
            case METHOD: {
                stmts = ((MethodTree)path.getLeaf()).getParameters();
            }
        }
        if (stmts != null) {
            StatementTree tree = null;
            for (StatementTree statementTree : stmts) {
                if (sourcePositions.getStartPosition(root, statementTree) >= (long)pos) continue;
                tree = statementTree;
            }
            if (tree != null) {
                path = new TreePath(path, tree);
            }
        }
        Scope scope = this.info.getTrees().getScope(path);
        if (CLASS_TREE_KINDS.contains((Object)path.getLeaf().getKind())) {
            TokenSequence ts = this.info.getTokenHierarchy().tokenSequence(JavaTokenId.language());
            ts.move(pos);
            block12: while (ts.movePrevious()) {
                switch ((JavaTokenId)ts.token().id()) {
                    case WHITESPACE: 
                    case LINE_COMMENT: 
                    case BLOCK_COMMENT: 
                    case JAVADOC_COMMENT: {
                        continue block12;
                    }
                    case EXTENDS: 
                    case IMPLEMENTS: {
                        ((JavacScope)scope).getEnv().baseClause = true;
                    }
                }
                return scope;
            }
        }
        return scope;
    }

    public Scope toScopeWithDisabledAccessibilityChecks(Scope scope) {
        return new NBScope((JavacScope)scope);
    }

    private static Env<AttrContext> getEnv(Scope scope) {
        if (scope instanceof NBScope) {
            scope = ((NBScope)scope).delegate;
        }
        if (scope instanceof CopyFinder.HackScope) {
            return ((CopyFinder.HackScope)scope).getEnv();
        }
        return ((JavacScope)scope).getEnv();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeMirror attributeTree(Tree tree, Scope scope) {
        Env<AttrContext> env = TreeUtilities.getEnv(scope);
        if (scope instanceof NBScope && ((NBScope)scope).areAccessibilityChecksDisabled()) {
            NBResolve.instance((Context)this.info.impl.getJavacTask().getContext()).disableAccessibilityChecks();
        }
        try {
            TypeMirror typeMirror = TreeUtilities.attributeTree(this.info.impl.getJavacTask(), env.toplevel, (JCTree)tree, scope, new ArrayList<Diagnostic<? extends JavaFileObject>>());
            return typeMirror;
        }
        finally {
            NBResolve.instance((Context)this.info.impl.getJavacTask().getContext()).restoreAccessbilityChecks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Scope attributeTreeTo(Tree tree, Scope scope, Tree to) {
        Env<AttrContext> env = TreeUtilities.getEnv(scope);
        if (scope instanceof NBScope && ((NBScope)scope).areAccessibilityChecksDisabled()) {
            NBResolve.instance((Context)this.info.impl.getJavacTask().getContext()).disableAccessibilityChecks();
        }
        try {
            Scope scope2 = TreeUtilities.attributeTreeTo(this.info.impl.getJavacTask(), env.toplevel, (JCTree)tree, scope, (JCTree)to, new ArrayList<Diagnostic<? extends JavaFileObject>>());
            return scope2;
        }
        finally {
            NBResolve.instance((Context)this.info.impl.getJavacTask().getContext()).restoreAccessbilityChecks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeMirror reattributeTree(Tree tree, Scope scope) {
        Env<AttrContext> env = TreeUtilities.getEnv(scope);
        if (scope instanceof NBScope && ((NBScope)scope).areAccessibilityChecksDisabled()) {
            NBResolve.instance((Context)this.info.impl.getJavacTask().getContext()).disableAccessibilityChecks();
        }
        try {
            TypeMirror typeMirror = TreeUtilities.attributeTree(this.info.impl.getJavacTask(), env.toplevel, (JCTree)tree, scope, new ArrayList<Diagnostic<? extends JavaFileObject>>());
            return typeMirror;
        }
        finally {
            NBResolve.instance((Context)this.info.impl.getJavacTask().getContext()).restoreAccessbilityChecks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Scope reattributeTreeTo(Tree tree, Scope scope, Tree to) {
        Env<AttrContext> env = TreeUtilities.getEnv(scope);
        if (scope instanceof NBScope && ((NBScope)scope).areAccessibilityChecksDisabled()) {
            NBResolve.instance((Context)this.info.impl.getJavacTask().getContext()).disableAccessibilityChecks();
        }
        try {
            Scope scope2 = TreeUtilities.attributeTreeTo(this.info.impl.getJavacTask(), env.toplevel, (JCTree)tree, scope, (JCTree)to, new ArrayList<Diagnostic<? extends JavaFileObject>>());
            return scope2;
        }
        finally {
            NBResolve.instance((Context)this.info.impl.getJavacTask().getContext()).restoreAccessbilityChecks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TypeMirror attributeTree(JavacTaskImpl jti, CompilationUnitTree cut, Tree tree, Scope scope, final List<Diagnostic<? extends JavaFileObject>> errors) {
        Log log = Log.instance(jti.getContext());
        JavaFileObject prev = log.useSource(new DummyJFO());
        Log.DiscardDiagnosticHandler discardHandler = new Log.DiscardDiagnosticHandler(log){

            @Override
            public void report(JCDiagnostic diag) {
                errors.add(diag);
            }
        };
        NBResolve resolve = NBResolve.instance((Context)jti.getContext());
        resolve.disableAccessibilityChecks();
        try {
            Attr attr = Attr.instance(jti.getContext());
            Env<AttrContext> env = TreeUtilities.getEnv(scope);
            if (tree instanceof JCTree.JCExpression) {
                Type type = attr.attribExpr((JCTree)tree, env, Type.noType);
                return type;
            }
            if (env.tree != null && env.tree.getKind() == Tree.Kind.VARIABLE && !VARIABLE_CAN_OWN_VARIABLES) {
                env = env.next;
            }
            Type type = attr.attribStat((JCTree)tree, env);
            return type;
        }
        finally {
            TreeUtilities.unenter(jti.getContext(), (JCTree.JCCompilationUnit)cut, (JCTree)tree);
            log.useSource(prev);
            log.popDiagnosticHandler(discardHandler);
            resolve.restoreAccessbilityChecks();
        }
    }

    private static void unenter(Context ctx, JCTree.JCCompilationUnit cut, JCTree tree) {
        try {
            Method m = Enter.class.getDeclaredMethod("unenter", JCTree.JCCompilationUnit.class, JCTree.class);
            m.invoke((Object)Enter.instance(ctx), cut, tree);
        }
        catch (Throwable t) {
            LOG.log(Level.FINE, null, t);
        }
    }

    private static Scope attributeTreeTo(JavacTaskImpl jti, CompilationUnitTree cut, Tree tree, Scope scope, Tree to, final List<Diagnostic<? extends JavaFileObject>> errors) {
        Log log = Log.instance(jti.getContext());
        JavaFileObject prev = log.useSource(new DummyJFO());
        Log.DiscardDiagnosticHandler discardHandler = new Log.DiscardDiagnosticHandler(log){

            @Override
            public void report(JCDiagnostic diag) {
                errors.add(diag);
            }
        };
        NBResolve resolve = NBResolve.instance((Context)jti.getContext());
        resolve.disableAccessibilityChecks();
        try {
            NBAttr attr = (NBAttr)NBAttr.instance((Context)jti.getContext());
            Env<AttrContext> env = TreeUtilities.getEnv(scope);
            Env result = attr.attributeAndCapture((JCTree)tree, env, (JCTree)to);
            try {
                Constructor c = JavacScope.class.getDeclaredConstructor(Env.class);
                c.setAccessible(true);
                Scope scope2 = (Scope)c.newInstance(result);
                return scope2;
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                throw new IllegalStateException(ex);
            }
        }
        finally {
            TreeUtilities.unenter(jti.getContext(), (JCTree.JCCompilationUnit)cut, (JCTree)tree);
            log.useSource(prev);
            log.popDiagnosticHandler(discardHandler);
            resolve.restoreAccessbilityChecks();
        }
    }

    public TokenSequence<JavaTokenId> tokensFor(Tree tree) {
        return this.tokensFor(tree, this.info.getTrees().getSourcePositions());
    }

    public TokenSequence<JavaTokenId> tokensFor(Tree tree, SourcePositions sourcePositions) {
        return this.tokensFor(tree, sourcePositions, -1);
    }

    private TokenSequence<JavaTokenId> tokensFor(Tree tree, SourcePositions sourcePositions, int farEnd) {
        int start = (int)sourcePositions.getStartPosition(this.info.getCompilationUnit(), tree);
        int end = (int)sourcePositions.getEndPosition(this.info.getCompilationUnit(), tree);
        return this.info.getTokenHierarchy().tokenSequence(JavaTokenId.language()).subSequence(start, Math.max(end, farEnd));
    }

    public boolean isAccessible(Scope scope, Element member, TypeMirror type) {
        return type instanceof DeclaredType ? this.info.getTrees().isAccessible(scope, member, (DeclaredType)type) : false;
    }

    public boolean isStaticContext(Scope scope) {
        return NBResolve.isStatic(TreeUtilities.getEnv(scope));
    }

    public Set<TypeMirror> getUncaughtExceptions(TreePath path) {
        UnrelatedTypeMirrorSet set = new UnrelatedTypeMirrorSet(this.info.getTypes());
        new UncaughtExceptionsVisitor(this.info).scan(path, set);
        return set;
    }

    public Set<? extends VariableElement> getUninitializedFields(TreePath path) {
        final LinkedHashSet<VariableElement> fields = new LinkedHashSet<VariableElement>();
        if (path == null) {
            return fields;
        }
        final Trees trees = this.info.getTrees();
        Element element = trees.getElement(path);
        if (element == null || !element.getKind().isClass()) {
            return fields;
        }
        for (VariableElement ve : ElementFilter.fieldsIn(((TypeElement)element).getEnclosedElements())) {
            if (!(ve instanceof Symbol) || (((Symbol)((Object)ve)).flags() & 0x40008L) != 0L) continue;
            fields.add(ve);
        }
        new ErrorAwareTreePathScanner<Void, Boolean>(){

            @Override
            public Void visitAssignment(AssignmentTree node, Boolean p) {
                Element el = trees.getElement(new TreePath(this.getCurrentPath(), node.getVariable()));
                fields.remove(el);
                return null;
            }

            @Override
            public Void visitClass(ClassTree node, Boolean p) {
                return p != false ? (Void)super.visitClass(node, Boolean.FALSE) : null;
            }

            @Override
            public Void visitMethod(MethodTree node, Boolean p) {
                return null;
            }
        }.scan(path, Boolean.TRUE);
        return fields;
    }

    public int[] findBodySpan(ClassTree clazz) {
        JCTree jcTree = (JCTree)((Object)clazz);
        int pos = jcTree.pos;
        if (pos < 0) {
            return null;
        }
        TokenSequence tokenSequence = this.info.getTokenHierarchy().tokenSequence(JavaTokenId.language());
        tokenSequence.move(pos);
        int startPos = -1;
        int endPos = (int)this.info.getTrees().getSourcePositions().getEndPosition(this.info.getCompilationUnit(), clazz);
        while (tokenSequence.moveNext()) {
            if (tokenSequence.token().id() != JavaTokenId.LBRACE) continue;
            startPos = tokenSequence.offset();
            break;
        }
        if (startPos == -1 || endPos == -1) {
            return null;
        }
        return new int[]{startPos, endPos};
    }

    public int[] findNameSpan(ClassTree clazz) {
        return this.findNameSpan(clazz.getSimpleName().toString(), clazz, JavaTokenId.CLASS, JavaTokenId.INTERFACE, JavaTokenId.ENUM, JavaTokenId.AT, JavaTokenId.WHITESPACE, JavaTokenId.BLOCK_COMMENT, JavaTokenId.LINE_COMMENT, JavaTokenId.JAVADOC_COMMENT);
    }

    public int[] findNameSpan(MethodTree method) {
        String name;
        if (this.isSynthetic(this.info.getCompilationUnit(), method)) {
            return null;
        }
        JCTree.JCMethodDecl jcm = (JCTree.JCMethodDecl)method;
        if (jcm.name == jcm.name.table.names.init) {
            Element clazz;
            TreePath path = this.info.getTrees().getPath(this.info.getCompilationUnit(), jcm);
            if (path == null) {
                return null;
            }
            Element em = this.info.getTrees().getElement(path);
            if (em == null || (clazz = em.getEnclosingElement()) == null || !clazz.getKind().isClass()) {
                return null;
            }
            name = clazz.getSimpleName().toString();
        } else {
            name = method.getName().toString();
        }
        return this.findNameSpan(name, method, new JavaTokenId[0]);
    }

    public int[] findNameSpan(VariableTree var) {
        return this.findNameSpan(var.getName().toString(), var, new JavaTokenId[0]);
    }

    public int[] findNameSpan(LabeledStatementTree lst) {
        return this.findNameSpan(lst.getLabel().toString(), lst, new JavaTokenId[0]);
    }

    public int[] findNameSpan(TypeParameterTree tpt) {
        return this.findNameSpan(tpt.getName().toString(), tpt, new JavaTokenId[0]);
    }

    public int[] findNameSpan(BreakTree brk) {
        return this.findNameSpan(brk.getLabel().toString(), brk, new JavaTokenId[0]);
    }

    public int[] findNameSpan(ContinueTree cont) {
        return this.findNameSpan(cont.getLabel().toString(), cont, new JavaTokenId[0]);
    }

    @CheckForNull
    public int[] findMethodParameterSpan(@NonNull MethodTree method) {
        JCTree jcTree = (JCTree)((Object)method);
        int pos = jcTree.pos;
        if (pos < 0) {
            return null;
        }
        TokenSequence tokenSequence = this.info.getTokenHierarchy().tokenSequence(JavaTokenId.language());
        tokenSequence.move(pos);
        int startPos = -1;
        int endPos = -1;
        while (tokenSequence.moveNext()) {
            if (tokenSequence.token().id() == JavaTokenId.LPAREN) {
                startPos = tokenSequence.offset();
            }
            if (tokenSequence.token().id() == JavaTokenId.RPAREN) {
                endPos = tokenSequence.offset();
                break;
            }
            if (tokenSequence.token().id() != JavaTokenId.LBRACE) continue;
            return null;
        }
        if (startPos == -1 || endPos == -1) {
            return null;
        }
        return new int[]{startPos, endPos};
    }

    public int[] findNameSpan(MemberSelectTree mst) {
        return this.findNameSpan(mst.getIdentifier().toString(), mst, JavaTokenId.DOT, JavaTokenId.WHITESPACE, JavaTokenId.BLOCK_COMMENT, JavaTokenId.LINE_COMMENT, JavaTokenId.JAVADOC_COMMENT);
    }

    public int[] findNameSpan(MemberReferenceTree mst) {
        return this.findNameSpan(mst.getName().toString(), mst, JavaTokenId.DOT, JavaTokenId.WHITESPACE, JavaTokenId.BLOCK_COMMENT, JavaTokenId.LINE_COMMENT, JavaTokenId.JAVADOC_COMMENT);
    }

    public int[] findNameSpan(DocCommentTree docTree, ReferenceTree ref) {
        boolean wasNext;
        Name name = ((DCTree.DCReference)ref).memberName;
        if (name == null || !SourceVersion.isIdentifier(name)) {
            return null;
        }
        int pos = (int)this.info.getDocTrees().getSourcePositions().getStartPosition(this.info.getCompilationUnit(), docTree, ref);
        if (pos < 0) {
            return null;
        }
        TokenSequence tokenSequence = this.info.getTokenHierarchy().tokenSequence(JavaTokenId.language());
        tokenSequence.move(pos);
        if (!tokenSequence.moveNext() || tokenSequence.token().id() != JavaTokenId.JAVADOC_COMMENT) {
            return null;
        }
        TokenSequence jdocTS = tokenSequence.embedded(JavadocTokenId.language());
        jdocTS.move(pos);
        while ((wasNext = jdocTS.moveNext()) && jdocTS.token().id() != JavadocTokenId.HASH) {
        }
        if (wasNext && jdocTS.moveNext() && jdocTS.token().id() == JavadocTokenId.IDENT && name.contentEquals(jdocTS.token().text())) {
            return new int[]{jdocTS.offset(), jdocTS.offset() + jdocTS.token().length()};
        }
        return null;
    }

    private int[] findNameSpan(String name, Tree t, JavaTokenId ... allowedTokens) {
        boolean wasNext;
        if (!SourceVersion.isIdentifier(name)) {
            return null;
        }
        JCTree jcTree = (JCTree)t;
        int pos = jcTree.pos;
        if (pos < 0) {
            return null;
        }
        EnumSet<JavaTokenId> allowedTokensSet = EnumSet.noneOf(JavaTokenId.class);
        allowedTokensSet.addAll(Arrays.asList(allowedTokens));
        TokenSequence tokenSequence = this.info.getTokenHierarchy().tokenSequence(JavaTokenId.language());
        tokenSequence.move(pos);
        while ((wasNext = tokenSequence.moveNext()) && allowedTokensSet.contains(tokenSequence.token().id())) {
        }
        if (wasNext && tokenSequence.token().id() == JavaTokenId.IDENTIFIER) {
            boolean nameMatches = name.contentEquals(tokenSequence.token().text());
            if (!nameMatches) {
                ExpressionTree expr = this.info.getTreeUtilities().parseExpression(tokenSequence.token().text().toString(), new SourcePositions[1]);
                boolean bl = nameMatches = expr.getKind() == Tree.Kind.IDENTIFIER && name.contentEquals(((IdentifierTree)expr).getName());
            }
            if (nameMatches) {
                return new int[]{tokenSequence.offset(), tokenSequence.offset() + tokenSequence.token().length()};
            }
        }
        tokenSequence.move(pos);
        if (tokenSequence.moveNext() && tokenSequence.token().id() == JavaTokenId.JAVADOC_COMMENT) {
            return new int[]{pos + 1, pos + name.length() + 1};
        }
        return null;
    }

    public Tree getBreakContinueTargetTree(TreePath breakOrContinue) throws IllegalArgumentException {
        if (this.info.getPhase().compareTo(JavaSource.Phase.RESOLVED) < 0) {
            throw new IllegalArgumentException("Not in correct Phase. Required: Phase.RESOLVED, got: Phase." + this.info.getPhase().toString());
        }
        Tree leaf = breakOrContinue.getLeaf();
        switch (leaf.getKind()) {
            case BREAK: {
                return ((JCTree.JCBreak)leaf).target;
            }
            case CONTINUE: {
                JCTree target = ((JCTree.JCContinue)leaf).target;
                if (target == null) {
                    return null;
                }
                if (((JCTree.JCContinue)leaf).label == null) {
                    return target;
                }
                TreePath tp = breakOrContinue;
                while (tp.getLeaf() != target) {
                    tp = tp.getParentPath();
                }
                Tree parent = tp.getParentPath().getLeaf();
                if (parent.getKind() == Tree.Kind.LABELED_STATEMENT) {
                    return (StatementTree)parent;
                }
                return target;
            }
        }
        if ("YIELD".equals(leaf.getKind().name())) {
            return TreeShims.getTarget(leaf);
        }
        throw new IllegalArgumentException("Unsupported kind: " + (Object)((Object)leaf.getKind()));
    }

    public StatementTree getBreakContinueTarget(TreePath breakOrContinue) throws IllegalArgumentException {
        if (this.info.getPhase().compareTo(JavaSource.Phase.RESOLVED) < 0) {
            throw new IllegalArgumentException("Not in correct Phase. Required: Phase.RESOLVED, got: Phase." + this.info.getPhase().toString());
        }
        Tree leaf = breakOrContinue.getLeaf();
        switch (leaf.getKind()) {
            case BREAK: {
                JCTree breakTarget = ((JCTree.JCBreak)leaf).target;
                if (breakTarget == null || !(breakTarget instanceof StatementTree)) {
                    return null;
                }
                return (StatementTree)((Object)breakTarget);
            }
            case CONTINUE: {
                StatementTree target = (StatementTree)((Object)((JCTree.JCContinue)leaf).target);
                if (target == null) {
                    return null;
                }
                if (((JCTree.JCContinue)leaf).label == null) {
                    return target;
                }
                TreePath tp = breakOrContinue;
                while (tp.getLeaf() != target) {
                    tp = tp.getParentPath();
                }
                Tree parent = tp.getParentPath().getLeaf();
                if (parent.getKind() == Tree.Kind.LABELED_STATEMENT) {
                    return (StatementTree)parent;
                }
                return target;
            }
        }
        throw new IllegalArgumentException("Unsupported kind: " + (Object)((Object)leaf.getKind()));
    }

    @NonNull
    public CharSequence decodeIdentifier(@NonNull CharSequence text) {
        return TreeUtilities.decodeIdentifierInternal(text);
    }

    @NonNull
    public CharSequence encodeIdentifier(@NonNull CharSequence ident) {
        return TreeUtilities.encodeIdentifierInternal(ident);
    }

    @NonNull
    static CharSequence decodeIdentifierInternal(@NonNull CharSequence text) {
        if (text.charAt(0) != '#') {
            return text;
        }
        int count = text.charAt(text.length() - 1) == '\"' ? text.length() - 1 : text.length();
        StringBuilder sb = new StringBuilder(text.length());
        for (int c = 2; c < count; ++c) {
            if (text.charAt(c) == '\\' && ++c < count) {
                if (EXOTIC_ESCAPE.contains(Character.valueOf(text.charAt(c)))) {
                    sb.append('\\');
                    sb.append(text.charAt(c));
                    continue;
                }
                Character remaped = ESCAPE_UNENCODE.get(Character.valueOf(text.charAt(c)));
                if (remaped != null) {
                    sb.append(remaped);
                    continue;
                }
                sb.append(text.charAt(c));
                continue;
            }
            sb.append(text.charAt(c));
        }
        return sb.toString();
    }

    @NonNull
    static CharSequence encodeIdentifierInternal(@NonNull CharSequence ident) {
        if (ident.length() == 0) {
            return ident;
        }
        StringBuilder sb = new StringBuilder(ident.length());
        boolean needsExotic = Character.isJavaIdentifierStart(ident.charAt(0));
        for (int i = 0; i < ident.length(); ++i) {
            char c = ident.charAt(i);
            if (Character.isJavaIdentifierPart(c)) {
                sb.append(c);
                continue;
            }
            needsExotic = true;
            Character target = ESCAPE_ENCODE.get(Character.valueOf(c));
            if (target != null) {
                sb.append('\\');
                sb.append(target);
                continue;
            }
            sb.append(c);
        }
        if (needsExotic) {
            sb.append("\"");
            sb.insert(0, "#\"");
            return sb.toString();
        }
        return ident;
    }

    @NonNull
    public Tree translate(@NonNull Tree original, @NonNull Map<? extends Tree, ? extends Tree> original2Translated) {
        return this.translate(original, original2Translated, (ImportAnalysis2)new NoImports(this.info), null);
    }

    @NonNull
    Tree translate(@NonNull Tree original, final @NonNull Map<? extends Tree, ? extends Tree> original2Translated, ImportAnalysis2 ia, Map<Tree, Object> tree2Tag) {
        ImmutableTreeTranslator itt = new ImmutableTreeTranslator(this.info instanceof WorkingCopy ? (WorkingCopy)this.info : null){
            @NonNull
            private Map<Tree, Tree> map;
            {
                super(copy);
                this.map = new HashMap<Tree, Tree>(original2Translated);
            }

            @Override
            public Tree translate(Tree tree) {
                Tree translated = this.map.remove(tree);
                if (translated != null) {
                    return this.translate(translated);
                }
                return super.translate(tree);
            }
        };
        Context c = this.info.impl.getJavacTask().getContext();
        itt.attach(c, ia, tree2Tag);
        return itt.translate(original);
    }

    @NonNull
    public DocTree translate(@NonNull DocTree original, @NonNull Map<? extends DocTree, ? extends DocTree> original2Translated) {
        return this.translate(original, original2Translated, (ImportAnalysis2)new NoImports(this.info), null);
    }

    @NonNull
    DocTree translate(@NonNull DocTree original, final @NonNull Map<? extends DocTree, ? extends DocTree> original2Translated, ImportAnalysis2 ia, Map<Tree, Object> tree2Tag) {
        ImmutableDocTreeTranslator itt = new ImmutableDocTreeTranslator(this.info instanceof WorkingCopy ? (WorkingCopy)this.info : null){
            @NonNull
            private Map<DocTree, DocTree> map;
            {
                super(copy);
                this.map = new HashMap<DocTree, DocTree>(original2Translated);
            }

            @Override
            public DocTree translate(DocTree tree) {
                DocTree translated = this.map.remove(tree);
                if (translated != null) {
                    return this.translate(translated);
                }
                return super.translate(tree);
            }
        };
        Context c = this.info.impl.getJavacTask().getContext();
        itt.attach(c, ia, tree2Tag);
        return itt.translate(original);
    }

    public boolean isCompileTimeConstantExpression(TreePath expression) {
        TypeMirror attributeTree = this.info.getTrees().getTypeMirror(expression);
        Type attributeTreeImpl = (Type)attributeTree;
        return attributeTreeImpl != null && attributeTreeImpl.constValue() != null;
    }

    @CheckForNull
    public ExpressionTree getReferenceClass(@NonNull DocTreePath path) {
        TreePath tp = path.getTreePath();
        DCTree.DCReference ref = (DCTree.DCReference)path.getLeaf();
        ((DocTrees)this.info.getTrees()).getElement(path);
        return (ExpressionTree)((Object)ref.qualifierExpression);
    }

    @CheckForNull
    public Name getReferenceName(@NonNull DocTreePath path) {
        return ((DCTree.DCReference)path.getLeaf()).memberName;
    }

    @CheckForNull
    public List<? extends Tree> getReferenceParameters(@NonNull DocTreePath path) {
        TreePath tp = path.getTreePath();
        DCTree.DCReference ref = (DCTree.DCReference)path.getLeaf();
        ((DocTrees)this.info.getTrees()).getElement(path);
        return ref.paramTypes;
    }

    public boolean isVarType(@NonNull TreePath path) {
        TokenSequence<JavaTokenId> tokenSequence = this.tokensFor(path.getLeaf());
        tokenSequence.moveStart();
        while (tokenSequence.moveNext() && tokenSequence.token().id() != JavaTokenId.EQ && tokenSequence.token().id() != JavaTokenId.COLON && tokenSequence.token().id() != JavaTokenId.RPAREN && tokenSequence.token().id() != JavaTokenId.SEMICOLON) {
            if (tokenSequence.token().id() != JavaTokenId.VAR) continue;
            return true;
        }
        return false;
    }

    public boolean isEndOfCompoundVariableDeclaration(@NonNull Tree tree) {
        TokenSequence<JavaTokenId> tokenSequence = this.tokensFor(tree);
        tokenSequence.moveEnd();
        return tokenSequence.movePrevious() && tokenSequence.token().id() != JavaTokenId.COMMA;
    }

    public boolean isPartOfCompoundVariableDeclaration(@NonNull Tree tree) {
        TokenSequence<JavaTokenId> tokenSequence = this.tokensFor(tree);
        if (tree.getKind() != Tree.Kind.VARIABLE) {
            return false;
        }
        tokenSequence.moveEnd();
        if (tokenSequence.movePrevious() && tokenSequence.token().id() == JavaTokenId.COMMA) {
            return true;
        }
        int startPos = (int)this.info.getTrees().getSourcePositions().getStartPosition(this.info.getCompilationUnit(), tree);
        tokenSequence.moveStart();
        int tokensLength = 0;
        while (tokenSequence.moveNext()) {
            tokensLength += tokenSequence.token().length();
            if (tokenSequence.token().id() != JavaTokenId.IDENTIFIER) continue;
            Tree path = this.pathFor(startPos + tokensLength).getLeaf();
            TokenSequence<JavaTokenId> TokenSeq = this.tokensFor(path);
            TokenSeq.moveEnd();
            if (!TokenSeq.movePrevious() || TokenSeq.token().id() != JavaTokenId.COMMA) break;
            return true;
        }
        return false;
    }

    public boolean hasError(@NonNull Tree tree, String ... errors) {
        long startPos = this.info.getTrees().getSourcePositions().getStartPosition(this.info.getCompilationUnit(), tree);
        long endPos = this.info.getTrees().getSourcePositions().getEndPosition(this.info.getCompilationUnit(), tree);
        List<Diagnostic> diagnosticsList = this.info.getDiagnostics();
        for (Diagnostic d : diagnosticsList) {
            if (d.getKind() != Diagnostic.Kind.ERROR || d.getStartPosition() < startPos || d.getEndPosition() > endPos) continue;
            if (errors == null || errors.length == 0) {
                return true;
            }
            for (String error : errors) {
                if (!error.equals(d.getCode())) continue;
                return true;
            }
        }
        return false;
    }

    static {
        boolean result;
        LOG = Logger.getLogger(TreeUtilities.class.getName());
        CLASS_TREE_KINDS = EnumSet.of(Tree.Kind.ANNOTATION_TYPE, Tree.Kind.CLASS, Tree.Kind.ENUM, Tree.Kind.INTERFACE);
        Tree.Kind recKind = null;
        try {
            recKind = Tree.Kind.valueOf("RECORD");
            CLASS_TREE_KINDS.add(recKind);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        IGNORE_TOKENS = EnumSet.of(JavaTokenId.BLOCK_COMMENT, JavaTokenId.JAVADOC_COMMENT, JavaTokenId.LINE_COMMENT, JavaTokenId.WHITESPACE);
        try {
            SourceVersion.valueOf("RELEASE_12");
            result = true;
        }
        catch (IllegalArgumentException ex) {
            result = false;
        }
        VARIABLE_CAN_OWN_VARIABLES = result;
        EXOTIC_ESCAPE = new HashSet<Character>(Arrays.asList(Character.valueOf('!'), Character.valueOf('#'), Character.valueOf('$'), Character.valueOf('%'), Character.valueOf('&'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('*'), Character.valueOf('+'), Character.valueOf(','), Character.valueOf('-'), Character.valueOf(':'), Character.valueOf('='), Character.valueOf('?'), Character.valueOf('@'), Character.valueOf('^'), Character.valueOf('_'), Character.valueOf('`'), Character.valueOf('{'), Character.valueOf('|'), Character.valueOf('}')));
        HashMap<Character, Character> unencode = new HashMap<Character, Character>();
        unencode.put(Character.valueOf('n'), Character.valueOf('\n'));
        unencode.put(Character.valueOf('t'), Character.valueOf('\t'));
        unencode.put(Character.valueOf('b'), Character.valueOf('\b'));
        unencode.put(Character.valueOf('r'), Character.valueOf('\r'));
        ESCAPE_UNENCODE = Collections.unmodifiableMap(unencode);
        HashMap<Character, Character> encode = new HashMap<Character, Character>();
        encode.put(Character.valueOf('\n'), Character.valueOf('n'));
        encode.put(Character.valueOf('\t'), Character.valueOf('t'));
        encode.put(Character.valueOf('\b'), Character.valueOf('b'));
        encode.put(Character.valueOf('\r'), Character.valueOf('r'));
        ESCAPE_ENCODE = Collections.unmodifiableMap(encode);
        TreeUtilitiesAccessor.setInstance(new TreeUtilitiesAccessor(){

            @Override
            public StatementTree parseStatement(JavacTaskImpl task, String stmt, SourcePositions[] sourcePositions) {
                return TreeUtilities.parseStatementImpl(task, stmt, sourcePositions);
            }
        });
    }

    private static final class NBScope
    implements Scope {
        private final JavacScope delegate;

        private NBScope(JavacScope delegate) {
            this.delegate = delegate;
        }

        private boolean areAccessibilityChecksDisabled() {
            return true;
        }

        @Override
        public Scope getEnclosingScope() {
            return this.delegate.getEnclosingScope();
        }

        @Override
        public TypeElement getEnclosingClass() {
            return this.delegate.getEnclosingClass();
        }

        @Override
        public ExecutableElement getEnclosingMethod() {
            return this.delegate.getEnclosingMethod();
        }

        @Override
        public Iterable<? extends Element> getLocalElements() {
            return this.delegate.getLocalElements();
        }
    }

    private static class UnrelatedTypeMirrorSet
    extends AbstractSet<TypeMirror> {
        private Types types;
        private LinkedList<TypeMirror> list = new LinkedList();

        public UnrelatedTypeMirrorSet(Types types) {
            this.types = types;
        }

        @Override
        public boolean add(TypeMirror typeMirror) {
            ListIterator it = this.list.listIterator();
            while (it.hasNext()) {
                TypeMirror tm = (TypeMirror)it.next();
                if (this.types.isSubtype(typeMirror, tm)) {
                    return false;
                }
                if (!this.types.isSubtype(tm, typeMirror)) continue;
                it.remove();
            }
            return this.list.add(typeMirror);
        }

        @Override
        public Iterator<TypeMirror> iterator() {
            return this.list.iterator();
        }

        @Override
        public int size() {
            return this.list.size();
        }
    }

    private static class UncaughtExceptionsVisitor
    extends ErrorAwareTreePathScanner<Void, Set<TypeMirror>> {
        private final CompilationInfo info;

        private UncaughtExceptionsVisitor(CompilationInfo info) {
            this.info = info;
        }

        @Override
        public Void visitMethodInvocation(MethodInvocationTree node, Set<TypeMirror> p) {
            super.visitMethodInvocation(node, p);
            Element el = this.info.getTrees().getElement(this.getCurrentPath());
            if (el != null && el.getKind() == ElementKind.METHOD) {
                p.addAll(((ExecutableElement)el).getThrownTypes());
            }
            return null;
        }

        @Override
        public Void visitNewClass(NewClassTree node, Set<TypeMirror> p) {
            super.visitNewClass(node, p);
            Element el = this.info.getTrees().getElement(this.getCurrentPath());
            if (el != null && el.getKind() == ElementKind.CONSTRUCTOR) {
                p.addAll(((ExecutableElement)el).getThrownTypes());
            }
            return null;
        }

        @Override
        public Void visitThrow(ThrowTree node, Set<TypeMirror> p) {
            super.visitThrow(node, p);
            TypeMirror tm = this.info.getTrees().getTypeMirror(new TreePath(this.getCurrentPath(), node.getExpression()));
            if (tm != null) {
                if (tm.getKind() == TypeKind.DECLARED) {
                    p.add(tm);
                } else if (tm.getKind() == TypeKind.UNION) {
                    p.addAll(((UnionType)tm).getAlternatives());
                }
            }
            return null;
        }

        @Override
        public Void visitTry(TryTree node, Set<TypeMirror> p) {
            LinkedHashSet<? extends TypeMirror> s = new LinkedHashSet<TypeMirror>();
            Trees trees = this.info.getTrees();
            Types types = this.info.getTypes();
            Elements elements = this.info.getElements();
            for (Tree tree : node.getResources()) {
                TypeMirror typeMirror = trees.getTypeMirror(new TreePath(this.getCurrentPath(), tree));
                if (typeMirror == null || typeMirror.getKind() != TypeKind.DECLARED) continue;
                for (ExecutableElement method : ElementFilter.methodsIn(elements.getAllMembers((TypeElement)((DeclaredType)typeMirror).asElement()))) {
                    if (!"close".contentEquals(method.getSimpleName()) || !method.getParameters().isEmpty() || !method.getTypeParameters().isEmpty()) continue;
                    s.addAll(method.getThrownTypes());
                }
            }
            this.scan(node.getBlock(), s);
            LinkedHashSet<TypeMirror> c = new LinkedHashSet<TypeMirror>();
            for (CatchTree catchTree : node.getCatches()) {
                TypeMirror t = trees.getTypeMirror(new TreePath(this.getCurrentPath(), catchTree.getParameter().getType()));
                if (t == null) continue;
                if (t.getKind() == TypeKind.UNION) {
                    for (TypeMirror typeMirror : ((UnionType)t).getAlternatives()) {
                        if (typeMirror == null || typeMirror.getKind() == TypeKind.ERROR) continue;
                        c.add(typeMirror);
                    }
                    continue;
                }
                if (t.getKind() == TypeKind.ERROR) continue;
                c.add(t);
            }
            for (TypeMirror typeMirror : c) {
                Iterator it = s.iterator();
                while (it.hasNext()) {
                    if (!types.isSubtype((TypeMirror)it.next(), typeMirror)) continue;
                    it.remove();
                }
            }
            p.addAll(s);
            this.scan(node.getCatches(), p);
            this.scan(node.getFinallyBlock(), p);
            return null;
        }

        @Override
        public Void visitMethod(MethodTree node, Set<TypeMirror> p) {
            LinkedHashSet s = new LinkedHashSet();
            this.scan(node.getBody(), s);
            for (ExpressionTree expressionTree : node.getThrows()) {
                TypeMirror t = this.info.getTrees().getTypeMirror(new TreePath(this.getCurrentPath(), expressionTree));
                if (t == null || t.getKind() == TypeKind.ERROR) continue;
                Iterator it = s.iterator();
                while (it.hasNext()) {
                    if (!this.info.getTypes().isSubtype((TypeMirror)it.next(), t)) continue;
                    it.remove();
                }
            }
            p.addAll(s);
            return null;
        }

        @Override
        public Void visitClass(ClassTree node, Set<TypeMirror> p) {
            return null;
        }

        @Override
        public Void visitLambdaExpression(LambdaExpressionTree node, Set<TypeMirror> p) {
            return null;
        }
    }

    private static final class NoImports
    extends ImportAnalysis2 {
        public NoImports(CompilationInfo info) {
            super(info);
        }

        @Override
        public void classEntered(ClassTree clazz) {
        }

        @Override
        public void enterVisibleThroughClasses(ClassTree clazz) {
        }

        @Override
        public void classLeft() {
        }

        @Override
        public ExpressionTree resolveImport(MemberSelectTree orig, Element element) {
            return orig;
        }

        @Override
        public void setCompilationUnit(CompilationUnitTree cut) {
        }

        @Override
        public void setImports(List<? extends ImportTree> importsToAdd) {
        }

        @Override
        public Set<? extends Element> getImports() {
            return Collections.emptySet();
        }

        @Override
        public void setPackage(ExpressionTree packageNameTree) {
        }
    }

    private static class ParserSourcePositions
    implements SourcePositions {
        private final JavacParser parser;
        private final int offset;

        private ParserSourcePositions(JavacParser parser, int offset) {
            this.parser = parser;
            this.offset = offset;
        }

        @Override
        public long getStartPosition(CompilationUnitTree file, Tree tree) {
            return this.parser.getStartPos((JCTree)tree) - this.offset;
        }

        @Override
        public long getEndPosition(CompilationUnitTree file, Tree tree) {
            return this.parser.getEndPos((JCTree)tree) - this.offset;
        }
    }

    private static final class DummyJFO
    extends SimpleJavaFileObject {
        private DummyJFO() {
            super(URI.create("dummy.java"), JavaFileObject.Kind.SOURCE);
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
            return "";
        }
    }
}

