/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.palette;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.lang.reflect.Field;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.netbeans.modules.form.palette.PaletteUtils;
import org.netbeans.modules.form.palette.ScrollPopupMenu;
import org.openide.awt.JMenuPlus;
import org.openide.explorer.view.MenuView;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.util.Utilities;

public class PaletteMenuView
extends JMenuPlus {
    private Node menuNode;
    private NodeAcceptor menuAction;
    private boolean hacked = false;
    private boolean filled = false;
    private int level;
    private static int maxHeight = Utilities.getUsableScreenBounds().height - 25;
    private boolean shouldHack = true;

    public PaletteMenuView(NodeAcceptor acceptor) {
        this(PaletteUtils.getPaletteNode(), acceptor);
    }

    public PaletteMenuView(Node node, NodeAcceptor acceptor) {
        this(node, acceptor, 0);
    }

    private PaletteMenuView(Node node, NodeAcceptor acceptor, int level) {
        this.menuNode = node;
        this.menuAction = acceptor;
        this.level = level;
        this.setText(node.getDisplayName());
        this.getSubNodes();
    }

    public void disableHack() {
        this.shouldHack = false;
    }

    public JPopupMenu getPopupMenu() {
        if (this.shouldHack && !this.hacked) {
            try {
                Field f = JMenu.class.getDeclaredField("popupMenu");
                f.setAccessible(true);
                if (f.get((Object)this) == null) {
                    ScrollPopupMenu popup = new ScrollPopupMenu(maxHeight);
                    popup.setInvoker((Component)((Object)this));
                    f.set((Object)this, popup);
                }
                this.hacked = true;
            }
            catch (Exception ex) {
                System.out.println("[WARNING] Cannot create scrollable popup menu.");
            }
        }
        JPopupMenu popup = super.getPopupMenu();
        if (this.menuNode != null) {
            this.fillSubMenu(popup);
        }
        return popup;
    }

    private void fillSubMenu(JPopupMenu popup) {
        if (!this.filled) {
            this.filled = true;
            popup.addPopupMenuListener(new PopupListener(popup));
            this.removeAll();
            Node[] nodes = this.getSubNodes();
            if (nodes.length > 0) {
                for (int i = 0; i < nodes.length; ++i) {
                    Object item;
                    if (nodes[i].isLeaf()) {
                        item = new MenuView.MenuItem(nodes[i], this.menuAction);
                    } else {
                        PaletteMenuView view = new PaletteMenuView(nodes[i], this.menuAction, this.level + 1);
                        if (!this.shouldHack) {
                            view.disableHack();
                        }
                        item = view;
                    }
                    this.add((JMenuItem)item);
                }
            } else {
                JMenuItem empty = new JMenuItem(PaletteUtils.getBundleString("CTL_EmptyPaletteMenu"));
                empty.setEnabled(false);
                this.add(empty);
            }
        }
    }

    private Node[] getSubNodes() {
        return this.level == 0 ? PaletteUtils.getCategoryNodes(this.menuNode, true) : PaletteUtils.getItemNodes(this.menuNode, true);
    }

    protected Point getPopupMenuOrigin() {
        int x = 0;
        int y = 0;
        JPopupMenu pm = this.getPopupMenu();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension s = this.getSize();
        Dimension pmSize = pm.getSize();
        if (pmSize.width == 0) {
            pmSize = pm.getPreferredSize();
        }
        if (pmSize.height > maxHeight) {
            pmSize.height = maxHeight + 2;
            pmSize.width += 14;
        }
        Point position = this.getLocationOnScreen();
        Container parent = this.getParent();
        if (parent instanceof JPopupMenu) {
            x = this.getComponentOrientation().isLeftToRight() ? (position.x + s.width + pmSize.width < screenSize.width ? s.width : 0 - pmSize.width) : (position.x < pmSize.width ? s.width : 0 - pmSize.width);
            if (position.y + pmSize.height < screenSize.height) {
                y = 0;
            } else {
                y = s.height - pmSize.height;
                if (y < -position.y) {
                    y = -position.y + 6;
                }
            }
        } else {
            x = this.getComponentOrientation().isLeftToRight() ? (position.x + pmSize.width < screenSize.width ? 0 : s.width - pmSize.width) : (position.x + s.width < pmSize.width ? 0 : s.width - pmSize.width);
            y = position.y + s.height + pmSize.height < screenSize.height ? s.height : -pmSize.height;
        }
        return new Point(x, y);
    }

    private class PopupListener
    implements PopupMenuListener {
        private JPopupMenu popup;

        PopupListener(JPopupMenu popup) {
            this.popup = popup;
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            PaletteMenuView.this.filled = false;
            this.popup.removePopupMenuListener(this);
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }
    }
}

