/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.spi;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.gradle.spi.GradleSettings;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;

public final class GradleFiles
implements Serializable {
    private static final Logger LOG = Logger.getLogger(GradleFiles.class.getName());
    public static final String SETTINGS_FILE_NAME = "settings.gradle";
    public static final String SETTINGS_FILE_NAME_KTS = "settings.gradle.kts";
    public static final String BUILD_FILE_NAME = "build.gradle";
    public static final String BUILD_FILE_NAME_KTS = "build.gradle.kts";
    public static final String GRADLE_PROPERTIES_NAME = "gradle.properties";
    public static final String WRAPPER_PROPERTIES = "gradle/wrapper/gradle-wrapper.properties";
    final File projectDir;
    final boolean knownProject;
    File rootDir;
    File buildScript;
    File parentScript;
    File settingsScript;
    File gradlew;
    File wrapperProperties;

    public GradleFiles(File dir) {
        this(dir, false);
    }

    public GradleFiles(File dir, boolean knownProject) {
        LOG.fine("Gradle Files for: " + dir.getAbsolutePath());
        this.knownProject = knownProject;
        try {
            dir = dir.getCanonicalFile();
        }
        catch (IOException ex) {
            dir = FileUtil.normalizeFile((File)dir);
        }
        this.rootDir = this.projectDir = dir;
        this.searchBuildScripts();
        this.searchWrapper();
    }

    private List<File> searchPropertyFiles() {
        ArrayList<File> ret = new ArrayList<File>(3);
        for (Kind kind : Kind.PROPERTIES) {
            File f = this.getFile(kind);
            if (!f.exists()) continue;
            ret.add(f);
        }
        return Collections.unmodifiableList(ret);
    }

    private void searchBuildScripts() {
        File settingsDir;
        File f2;
        File f1 = new File(this.projectDir, BUILD_FILE_NAME_KTS);
        if (!f1.canRead()) {
            f1 = new File(this.projectDir, BUILD_FILE_NAME);
        }
        if (!(f2 = new File(this.projectDir, this.projectDir.getName() + ".gradle.kts")).canRead()) {
            f2 = new File(this.projectDir, this.projectDir.getName() + ".gradle");
        }
        this.settingsScript = this.searchPathUp(this.projectDir, SETTINGS_FILE_NAME_KTS);
        if (this.settingsScript == null) {
            this.settingsScript = this.searchPathUp(this.projectDir, SETTINGS_FILE_NAME);
        }
        File file = settingsDir = this.settingsScript != null ? this.settingsScript.getParentFile() : null;
        File file2 = f1.canRead() ? f1 : (this.buildScript = f2.canRead() ? f2 : null);
        if (settingsDir != null) {
            this.rootDir = settingsDir;
            File rootScript = new File(settingsDir, BUILD_FILE_NAME);
            if (rootScript.canRead() && !rootScript.equals(this.buildScript)) {
                this.parentScript = rootScript;
            }
        } else if (this.buildScript != null) {
            this.rootDir = this.buildScript.getParentFile();
        }
    }

    private void searchWrapper() {
        File w = new File(this.rootDir, WRAPPER_PROPERTIES);
        if (w.isFile()) {
            this.gradlew = new File(this.rootDir, Utilities.isWindows() ? "gradlew.bat" : "gradlew");
            this.wrapperProperties = w;
        }
    }

    private File searchPathUp(@NonNull File baseDir, @NonNull String name) {
        File ret = null;
        File dir = baseDir;
        do {
            File f;
            ret = (f = new File(dir, name)).canRead() ? f : null;
            File file = dir = f.canRead() ? dir : dir.getParentFile();
        } while (ret == null && dir != null);
        return ret;
    }

    public File getBuildScript() {
        return this.buildScript;
    }

    public File getParentScript() {
        return this.parentScript;
    }

    public File getSettingsScript() {
        return this.settingsScript;
    }

    public List<File> getPropertyFiles() {
        return this.searchPropertyFiles();
    }

    public File getProjectDir() {
        return this.isProject() ? this.projectDir : null;
    }

    public File getRootDir() {
        return this.rootDir;
    }

    public File getGradlew() {
        return this.gradlew;
    }

    public File getWrapperProperties() {
        return this.wrapperProperties;
    }

    public boolean hasWrapper() {
        return this.wrapperProperties != null;
    }

    public boolean isBuildSrcProject() {
        return "buildSrc".equals(this.projectDir.getName()) && this.rootDir.equals(this.projectDir.getParentFile());
    }

    public boolean isRootProject() {
        return this.buildScript != null && this.rootDir.equals(this.projectDir);
    }

    public boolean isSubProject() {
        return this.isProject() && !this.isRootProject();
    }

    public boolean isScriptlessSubProject() {
        return this.buildScript == null && this.isSubProject();
    }

    public boolean isProject() {
        if (this.knownProject || this.buildScript != null) {
            return true;
        }
        if (this.settingsScript != null) {
            if (this.projectDir.equals(this.settingsScript.getParentFile())) {
                return true;
            }
            Set<File> parsed = SettingsFile.getSubProjects(this.settingsScript);
            return parsed.contains(this.projectDir);
        }
        return false;
    }

    public Set<File> getProjectFiles() {
        if (this.isProject()) {
            HashSet<File> ret = new HashSet<File>();
            if (this.parentScript != null) {
                ret.add(this.parentScript);
            }
            if (this.buildScript != null) {
                ret.add(this.buildScript);
            }
            if (this.settingsScript != null) {
                ret.add(this.settingsScript);
            }
            return ret;
        }
        return Collections.emptySet();
    }

    public File getFile(Kind kind) {
        if (this.isBuildSrcProject()) {
            switch (kind) {
                case BUILD_SCRIPT: {
                    return this.buildScript != null ? this.buildScript : new File(this.projectDir, BUILD_FILE_NAME);
                }
                case PROJECT_PROPERTIES: {
                    return new File(this.projectDir, GRADLE_PROPERTIES_NAME);
                }
                case USER_PROPERTIES: {
                    File guh = GradleSettings.getDefault().getGradleUserHome();
                    return new File(guh, GRADLE_PROPERTIES_NAME);
                }
            }
            return null;
        }
        switch (kind) {
            case BUILD_SCRIPT: {
                return this.buildScript != null ? this.buildScript : new File(this.projectDir, BUILD_FILE_NAME);
            }
            case ROOT_SCRIPT: {
                return this.parentScript != null ? this.parentScript : new File(this.rootDir, BUILD_FILE_NAME);
            }
            case SETTINGS_SCRIPT: {
                return this.settingsScript != null ? this.settingsScript : new File(this.rootDir, SETTINGS_FILE_NAME);
            }
            case PROJECT_PROPERTIES: {
                return new File(this.projectDir, GRADLE_PROPERTIES_NAME);
            }
            case ROOT_PROPERTIES: {
                return new File(this.rootDir, GRADLE_PROPERTIES_NAME);
            }
            case USER_PROPERTIES: {
                File guh = GradleSettings.getDefault().getGradleUserHome();
                return new File(guh, GRADLE_PROPERTIES_NAME);
            }
            case BUILD_SRC: {
                return new File(this.rootDir, "buildSrc");
            }
        }
        return null;
    }

    public long lastChanged() {
        long time;
        long l = time = this.buildScript != null ? this.buildScript.lastModified() : 0L;
        if (this.settingsScript != null) {
            time = Math.max(this.settingsScript.lastModified(), time);
        }
        if (this.parentScript != null) {
            time = Math.max(this.parentScript.lastModified(), time);
        }
        return time;
    }

    public int hashCode() {
        return Objects.hashCode(this.projectDir) * 83;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GradleFiles other = (GradleFiles)obj;
        return Objects.equals(this.projectDir, other.projectDir);
    }

    public String toString() {
        return "GradleFiles[projectDir=" + this.projectDir + ", rootDir=" + this.rootDir + "]";
    }

    public static class SettingsFile {
        private static final Pattern SET_PROJECTDIR_PATTERN = Pattern.compile(".*['\\\"](.+)['\\\"].*\\.projectDir.*=.*['\\\"](.+)['\\\"].*");
        private static final Map<File, SettingsFile> CACHE = new WeakHashMap<File, SettingsFile>();
        final Set<File> subProjects = new HashSet<File>();
        final long time;

        public SettingsFile(File f) {
            this.time = f.lastModified();
            this.parse(f);
        }

        private void parse(File f) {
            HashMap<String, String> projectPaths = new HashMap<String, String>();
            String rootDir = f.getParentFile().getAbsolutePath();
            try {
                List<String> lines = Files.readAllLines(f.toPath(), StandardCharsets.UTF_8);
                for (String string : lines) {
                    Matcher matcher;
                    String string2 = string.trim();
                    if (string2.startsWith("//")) continue;
                    String[] split = string2.split("[\\s'\",\\(\\)]+");
                    if (split.length > 1 && "include".equals(split[0])) {
                        for (int i = 1; i < split.length; ++i) {
                            String s = split[i];
                            projectPaths.put(s, rootDir + "/" + s.replace(':', '/'));
                        }
                    }
                    if (!(matcher = SET_PROJECTDIR_PATTERN.matcher(string2)).matches()) continue;
                    String project = matcher.group(1);
                    String dir = matcher.group(2);
                    dir = dir.replace("$rootDir", rootDir);
                    dir = dir.replace("${rootDir}", rootDir);
                    projectPaths.put(project, dir);
                }
            }
            catch (IOException lines) {
                // empty catch block
            }
            File root = f.getParentFile();
            for (Map.Entry entry : projectPaths.entrySet()) {
                this.subProjects.add(this.guessDir((String)entry.getKey(), root, new File((String)entry.getValue())));
            }
        }

        File guessDir(String projectName, File rootDir, File firstGuess) {
            if (firstGuess.isDirectory()) {
                return firstGuess;
            }
            for (String subdirName : Arrays.asList("subProjects", "modules")) {
                File subdir = new File(rootDir, subdirName);
                if (!subdir.isDirectory()) continue;
                if (new File(subdir, projectName).isDirectory()) {
                    return new File(subdir, projectName);
                }
                String gradleStyle = projectName.replaceAll("\\p{Upper}", "-$0").toLowerCase();
                if (!new File(subdir, gradleStyle).isDirectory()) continue;
                return new File(subdir, gradleStyle);
            }
            return firstGuess;
        }

        public static Set<File> getSubProjects(File f) {
            SettingsFile sf = CACHE.get(f);
            if (sf == null || sf.time < f.lastModified()) {
                sf = new SettingsFile(f);
                CACHE.put(f, sf);
            }
            return sf.subProjects;
        }
    }

    public static enum Kind {
        BUILD_SCRIPT,
        ROOT_SCRIPT,
        SETTINGS_SCRIPT,
        USER_PROPERTIES,
        PROJECT_PROPERTIES,
        ROOT_PROPERTIES,
        BUILD_SRC;

        public static final Set<Kind> SCRIPTS;
        public static final Set<Kind> PROPERTIES;
        public static final Set<Kind> PROJECT_FILES;

        static {
            SCRIPTS = EnumSet.of(ROOT_SCRIPT, BUILD_SCRIPT, SETTINGS_SCRIPT, BUILD_SRC);
            PROPERTIES = EnumSet.of(USER_PROPERTIES, PROJECT_PROPERTIES, ROOT_PROPERTIES);
            PROJECT_FILES = EnumSet.of(ROOT_SCRIPT, BUILD_SCRIPT, SETTINGS_SCRIPT, PROJECT_PROPERTIES, ROOT_PROPERTIES);
        }
    }
}

