/*
 * Decompiled with CFR 0.152.
 */
package io.foojay.api.discoclient.pkg;

import io.foojay.api.discoclient.pkg.ApiFeature;
import io.foojay.api.discoclient.pkg.LibCType;
import java.util.Arrays;
import java.util.List;

public enum OperatingSystem implements ApiFeature
{
    ALPINE_LINUX("Alpine Linux", "linux", LibCType.MUSL),
    LINUX("Linux", "linux", LibCType.GLIBC),
    LINUX_MUSL("Linux Musl", "linux", LibCType.MUSL),
    MACOS("Mac OS", "macos", LibCType.LIBC),
    WINDOWS("Windows", "windows", LibCType.C_STD_LIB),
    SOLARIS("Solaris", "solaris", LibCType.LIBC),
    QNX("QNX", "qnx", LibCType.LIBC),
    AIX("AIX", "aix", LibCType.LIBC),
    NONE("-", "", LibCType.NONE),
    NOT_FOUND("", "", LibCType.NOT_FOUND);

    private final String uiString;
    private final String apiString;
    private final LibCType libCType;

    private OperatingSystem(String uiString, String apiString, LibCType libCType) {
        this.uiString = uiString;
        this.apiString = apiString;
        this.libCType = libCType;
    }

    @Override
    public String getUiString() {
        return this.uiString;
    }

    @Override
    public String getApiString() {
        return this.apiString;
    }

    @Override
    public OperatingSystem getDefault() {
        return NONE;
    }

    @Override
    public OperatingSystem getNotFound() {
        return NOT_FOUND;
    }

    public OperatingSystem[] getAll() {
        return OperatingSystem.values();
    }

    public static OperatingSystem fromText(String text) {
        switch (text) {
            case "-linux": 
            case "linux": 
            case "Linux": 
            case "LINUX": {
                return LINUX;
            }
            case "-linux-musl": 
            case "-linux_musl": 
            case "Linux-Musl": 
            case "linux-musl": 
            case "Linux_Musl": 
            case "LINUX_MUSL": 
            case "linux_musl": 
            case "alpine-linux": 
            case "ALPINE-LINUX": 
            case "alpine_linux": 
            case "Alpine Linux": 
            case "alpine linux": 
            case "ALPINE LINUX": {
                return ALPINE_LINUX;
            }
            case "-solaris": 
            case "solaris": 
            case "SOLARIS": 
            case "Solaris": {
                return SOLARIS;
            }
            case "-qnx": 
            case "qnx": 
            case "QNX": {
                return QNX;
            }
            case "-aix": 
            case "aix": 
            case "AIX": {
                return AIX;
            }
            case "darwin": 
            case "-darwin": 
            case "-macosx": 
            case "-MACOSX": 
            case "MacOS": 
            case "Mac OS": 
            case "mac_os": 
            case "Mac_OS": 
            case "mac-os": 
            case "Mac-OS": 
            case "mac": 
            case "MAC": 
            case "macos": 
            case "MACOS": 
            case "osx": 
            case "OSX": 
            case "macosx": 
            case "MACOSX": 
            case "Mac OSX": 
            case "mac osx": {
                return MACOS;
            }
            case "-win": 
            case "windows": 
            case "Windows": 
            case "WINDOWS": 
            case "win": 
            case "Win": 
            case "WIN": {
                return WINDOWS;
            }
        }
        return NOT_FOUND;
    }

    public LibCType getLibCType() {
        return this.libCType;
    }

    public static List<OperatingSystem> getAsList() {
        return Arrays.asList(OperatingSystem.values());
    }
}

