/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.languages.ASTItem;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.Highlighting;
import org.netbeans.api.languages.ParserManager;
import org.netbeans.api.languages.database.DatabaseContext;
import org.netbeans.api.languages.database.DatabaseDefinition;
import org.netbeans.api.languages.database.DatabaseItem;
import org.netbeans.api.languages.database.DatabaseUsage;
import org.netbeans.editor.BaseAction;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.languages.ParserManagerImpl;
import org.netbeans.modules.languages.features.DatabaseManager;
import org.netbeans.modules.languages.features.MarkOccurrencesSupport;
import org.openide.util.RequestProcessor;

public class InstantRenameAction
extends BaseAction {
    private RenameImplementation renameImplementation;
    private static final AttributeSet defaultSyncedTextBlocksHighlight = AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.Background, new Color(138, 191, 236)});

    public InstantRenameAction() {
        super("in-place-refactoring", 14);
    }

    public void actionPerformed(ActionEvent evt, JTextComponent editor) {
        if (this.renameImplementation != null) {
            return;
        }
        int offset = editor.getCaretPosition();
        ParserManagerImpl parserManager = ParserManagerImpl.getImpl(editor.getDocument());
        if (parserManager.getState() == ParserManager.State.PARSING) {
            return;
        }
        try {
            ASTNode node = parserManager.getAST();
            DatabaseContext root = DatabaseManager.getRoot(node);
            if (root == null) {
                return;
            }
            DatabaseItem databaseItem = root.getDatabaseItem(offset);
            if (databaseItem == null) {
                databaseItem = root.getDatabaseItem(offset - 1);
            }
            if (databaseItem == null) {
                return;
            }
            this.renameImplementation = new RenameImplementation(databaseItem, editor, node);
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
        }
    }

    protected Class getShortDescriptionBundleClass() {
        return InstantRenameAction.class;
    }

    private static AttributeSet getHighlightAS() {
        FontColorSettings fcs = (FontColorSettings)MimeLookup.getLookup((MimePath)MimePath.EMPTY).lookup(FontColorSettings.class);
        AttributeSet as = fcs.getFontColors("synchronized-text-blocks");
        return as == null ? defaultSyncedTextBlocksHighlight : as;
    }

    private static class Element {
        private Position start;
        private Position end;
        private ASTItem item;
        private Document doc;

        Element(ASTItem item, Position start, Position end, Document doc) {
            this.item = item;
            this.start = start;
            this.end = end;
            this.doc = doc;
        }

        boolean contains(int offset) {
            return this.start.getOffset() <= offset && offset <= this.end.getOffset();
        }

        void setText(String text) {
            try {
                if (text.equals(this.getText())) {
                    return;
                }
                this.doc.insertString(this.end.getOffset(), text, null);
                this.doc.remove(this.start.getOffset(), this.end.getOffset() - this.start.getOffset() - text.length());
            }
            catch (BadLocationException ex) {
                ex.printStackTrace();
            }
        }

        ASTItem getItem() {
            return this.item;
        }

        String getText() throws BadLocationException {
            return this.doc.getText(this.start.getOffset(), this.end.getOffset() - this.start.getOffset());
        }
    }

    private class RenameImplementation
    implements KeyListener,
    DocumentListener {
        private List<Element> elements;
        private List<Highlighting.Highlight> highlights;
        private JTextComponent editor;
        private NbEditorDocument document;
        private String text;
        private RequestProcessor requestProcessor;
        private RequestProcessor.Task task;

        RenameImplementation(DatabaseItem databaseItem, JTextComponent editor, ASTNode node) throws BadLocationException {
            this.editor = editor;
            this.document = (NbEditorDocument)editor.getDocument();
            this.elements = this.getUssages(databaseItem, node);
            MarkOccurrencesSupport.removeHighlights(editor);
            if (!this.elements.isEmpty()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RenameImplementation.this.highlights = new ArrayList();
                        Highlighting highlighting = Highlighting.getHighlighting((Document)RenameImplementation.this.document);
                        for (Element element : RenameImplementation.this.elements) {
                            ASTItem item = element.getItem();
                            RenameImplementation.this.highlights.add(highlighting.highlight(item.getOffset(), item.getEndOffset(), InstantRenameAction.getHighlightAS()));
                        }
                    }
                });
            }
            this.document.addDocumentListener((DocumentListener)this);
            editor.addKeyListener(this);
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 27 && e.getModifiers() == 0 || e.getKeyCode() == 10 && e.getModifiers() == 0) {
                if (this.highlights == null) {
                    return;
                }
                final List<Highlighting.Highlight> oldHighlights = this.highlights;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Iterator it = oldHighlights.iterator();
                        while (it.hasNext()) {
                            ((Highlighting.Highlight)it.next()).remove();
                        }
                    }
                });
                this.editor.removeKeyListener(this);
                this.document.removeDocumentListener((DocumentListener)this);
                this.highlights = null;
                this.elements = null;
                this.editor = null;
                this.document = null;
                InstantRenameAction.this.renameImplementation = null;
                e.consume();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.update();
        }

        private List<Element> getUssages(DatabaseItem item, ASTNode root) throws BadLocationException {
            ASTItem i;
            ArrayList<Element> result = new ArrayList<Element>();
            DatabaseDefinition definition = null;
            if (item instanceof DatabaseDefinition) {
                definition = (DatabaseDefinition)item;
            } else {
                definition = ((DatabaseUsage)item).getDefinition();
                i = root.findPath(item.getOffset()).getLeaf();
                result.add(new Element(i, this.document.createPosition(i.getOffset()), this.document.createPosition(i.getEndOffset()), (Document)this.document));
            }
            i = root.findPath(definition.getOffset()).getLeaf();
            Element element = new Element(i, this.document.createPosition(i.getOffset()), this.document.createPosition(i.getEndOffset()), (Document)this.document);
            result.add(element);
            this.text = element.getText();
            for (DatabaseUsage databaseUsage : definition.getUsages()) {
                i = root.findPath(databaseUsage.getOffset()).getLeaf();
                if (i == ((Element)result.get(0)).getItem()) continue;
                result.add(new Element(i, this.document.createPosition(i.getOffset()), this.document.createPosition(i.getEndOffset()), (Document)this.document));
            }
            return result;
        }

        private void update() {
            int offset = this.editor.getCaretPosition();
            if (!this.elements.get(0).contains(offset)) {
                return;
            }
            try {
                String newText = this.elements.get(0).getText();
                if (this.text.equals(newText)) {
                    return;
                }
                this.text = newText;
            }
            catch (BadLocationException ex) {
                ex.printStackTrace();
            }
            if (this.requestProcessor == null) {
                this.requestProcessor = new RequestProcessor("InstantRename");
            }
            if (this.task != null) {
                this.task.cancel();
            }
            this.task = this.requestProcessor.post(new Runnable(){

                @Override
                public void run() {
                    RenameImplementation.this.document.removeDocumentListener((DocumentListener)RenameImplementation.this);
                    RenameImplementation.this.document.runAtomicAsUser(new Runnable(){

                        @Override
                        public void run() {
                            Iterator it = RenameImplementation.this.elements.iterator();
                            try {
                                String text = ((Element)it.next()).getText();
                                while (it.hasNext()) {
                                    ((Element)it.next()).setText(text);
                                }
                            }
                            catch (BadLocationException ex) {
                                ex.printStackTrace();
                            }
                        }
                    });
                    RenameImplementation.this.document.addDocumentListener((DocumentListener)RenameImplementation.this);
                }
            });
        }
    }
}

