/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpRetryException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.hudson.api.ConnectionBuilder;
import org.netbeans.modules.hudson.api.HudsonFolder;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.api.HudsonJobBuild;
import org.netbeans.modules.hudson.api.HudsonMavenModuleBuild;
import org.netbeans.modules.hudson.api.HudsonVersion;
import org.netbeans.modules.hudson.api.Utilities;
import org.netbeans.modules.hudson.impl.HudsonConsoleDataProvider;
import org.netbeans.modules.hudson.impl.HudsonFailureDataProvider;
import org.netbeans.modules.hudson.impl.HudsonRemoteFileSystem;
import org.netbeans.modules.hudson.spi.BuilderConnector;
import org.netbeans.modules.hudson.spi.HudsonJobChangeItem;
import org.netbeans.modules.hudson.spi.HudsonSCM;
import org.netbeans.modules.hudson.spi.RemoteFileSystem;
import org.openide.util.Lookup;
import org.openide.windows.OutputListener;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class HudsonConnector
extends BuilderConnector {
    private static final Logger LOG = Logger.getLogger(HudsonConnector.class.getName());
    public static final HudsonFailureDataProvider HUDSON_FAILURE_DISPLAYER = new HudsonFailureDataProvider();
    public static final HudsonConsoleDataProvider HUDSON_CONSOLE_DISPLAYER = new HudsonConsoleDataProvider();
    private HudsonVersion version;
    private boolean connected = false;
    boolean forbidden;
    private Map<String, BuilderConnector.ViewData> cache = new HashMap<String, BuilderConnector.ViewData>();
    private String instanceUrl;
    private static final Map<String, Pattern> tailPatterns = new HashMap<String, Pattern>();

    public HudsonConnector(String instanceUrl) {
        this.instanceUrl = instanceUrl;
    }

    private boolean canUseTree(boolean authentication) {
        HudsonVersion v = this.getHudsonVersion(authentication);
        return v != null && v.compareTo(new HudsonVersion("1.367")) >= 0;
    }

    @Override
    public synchronized BuilderConnector.InstanceData getInstanceData(boolean authentication) {
        Document docInstance = this.getDocument(this.instanceUrl + "api/xml" + (this.canUseTree(authentication) ? "?tree=primaryView[name],views[name,url,jobs[name]],jobs[name,url,color,displayName,buildable,inQueue,primaryView,lastBuild[number],lastFailedBuild[number],lastStableBuild[number],lastSuccessfulBuild[number],lastCompletedBuild[number],modules[name,displayName,url,color]],securedJobs[name,url]" : "?depth=1&xpath=/&exclude=//assignedLabel&exclude=//primaryView/job&exclude=//view/job/url&exclude=//view/job/color&exclude=//description&exclude=//job/build&exclude=//healthReport&exclude=//firstBuild&exclude=//keepDependencies&exclude=//nextBuildNumber&exclude=//property&exclude=//action&exclude=//upstreamProject&exclude=//downstreamProject&exclude=//queueItem&exclude=//scm&exclude=//concurrentBuild&exclude=//job/lastUnstableBuild&exclude=//job/lastUnsuccessfulBuild"), authentication);
        if (null == docInstance) {
            return new BuilderConnector.InstanceData(Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        }
        this.cache.clear();
        Collection<BuilderConnector.ViewData> viewsData = this.getViewData(docInstance, this.instanceUrl);
        ArrayList<BuilderConnector.FolderData> foldersData = new ArrayList<BuilderConnector.FolderData>();
        Collection<BuilderConnector.JobData> jobsData = this.getJobsData(docInstance, this.instanceUrl, viewsData, foldersData, null);
        return new BuilderConnector.InstanceData(jobsData, viewsData, foldersData);
    }

    @Override
    public BuilderConnector.InstanceData getInstanceData(HudsonFolder parentFolder, boolean authentication) {
        Document docInstance = this.getDocument(parentFolder.getUrl() + "api/xml" + "?tree=jobs[name,url,color,displayName,buildable,inQueue,primaryView,lastBuild[number],lastFailedBuild[number],lastStableBuild[number],lastSuccessfulBuild[number],lastCompletedBuild[number],modules[name,displayName,url,color]],securedJobs[name,url]", authentication);
        if (null == docInstance) {
            return new BuilderConnector.InstanceData(Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        }
        this.cache.clear();
        ArrayList<BuilderConnector.FolderData> foldersData = new ArrayList<BuilderConnector.FolderData>();
        Collection<BuilderConnector.JobData> jobsData = this.getJobsData(docInstance, parentFolder.getUrl(), Collections.emptySet(), foldersData, parentFolder);
        return new BuilderConnector.InstanceData(jobsData, Collections.emptySet(), foldersData);
    }

    @Override
    public synchronized void startJob(HudsonJob job) {
        try {
            new ConnectionBuilder().homeURL(this.instanceUrl).url(job.getUrl() + "build").postData("delay=0sec".getBytes("UTF-8")).followRedirects(false).connection();
        }
        catch (MalformedURLException mue) {
            LOG.log(Level.INFO, "Malformed URL " + this.instanceUrl, mue);
        }
        catch (IOException e) {
            LOG.log(Level.FINE, "Could not start {0}: {1}", new Object[]{job, e});
        }
    }

    @Override
    public Collection<BuilderConnector.BuildData> getJobBuildsData(HudsonJob job) {
        Document docBuild = this.getDocument(job.getUrl() + "api/xml" + (this.canUseTree(true) ? "?tree=builds[number,result,building]" : "?xpath=/*/build&wrapper=root&exclude=//url"), true);
        if (docBuild == null) {
            return Collections.emptySet();
        }
        ArrayList<BuilderConnector.BuildData> builds = new ArrayList<BuilderConnector.BuildData>();
        NodeList buildNodes = docBuild.getElementsByTagName("build");
        for (int i = 0; i < buildNodes.getLength(); ++i) {
            Node build = buildNodes.item(i);
            int number = 0;
            boolean building = false;
            HudsonJobBuild.Result result = null;
            NodeList details = build.getChildNodes();
            for (int j = 0; j < details.getLength(); ++j) {
                Node detail = details.item(j);
                if (detail.getNodeType() != 1) continue;
                String nodeName = detail.getNodeName();
                Node firstChild = detail.getFirstChild();
                if (firstChild == null) {
                    LOG.log(Level.WARNING, "#170267: unexpected empty <build> child: {0}", nodeName);
                    continue;
                }
                String text = firstChild.getTextContent();
                if (nodeName.equals("number")) {
                    number = Integer.parseInt(text);
                    continue;
                }
                if (nodeName.equals("building")) {
                    building = Boolean.valueOf(text);
                    continue;
                }
                if (nodeName.equals("result")) {
                    result = HudsonJobBuild.Result.valueOf(text);
                    continue;
                }
                LOG.log(Level.WARNING, "unexpected <build> child: {0}", nodeName);
            }
            builds.add(new BuilderConnector.BuildData(number, result, building));
        }
        return builds;
    }

    @Override
    public void getJobBuildResult(HudsonJobBuild build, AtomicBoolean building, AtomicReference<HudsonJobBuild.Result> result) {
        Element buildingEl;
        Document doc = this.getDocument(build.getUrl() + "api/xml" + "?xpath=/*/*[name()='result'%20or%20name()='building']&wrapper=root", true);
        if (doc == null) {
            return;
        }
        Element docEl = doc.getDocumentElement();
        Element resultEl = XMLUtil.findElement((Element)docEl, (String)"result", null);
        if (resultEl != null) {
            result.set(HudsonJobBuild.Result.valueOf(XMLUtil.findText((Node)resultEl)));
        }
        if ((buildingEl = XMLUtil.findElement((Element)docEl, (String)"building", null)) != null) {
            building.set(Boolean.parseBoolean(XMLUtil.findText((Node)buildingEl)));
        }
    }

    @Override
    @CheckForNull
    public synchronized HudsonVersion getHudsonVersion(boolean authentication) {
        if (this.version == null) {
            this.version = this.retrieveHudsonVersion(authentication);
        }
        return this.version;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    private Collection<BuilderConnector.ViewData> getViewData(Document doc, String baseUrl) {
        Element nameEl;
        String primaryViewName = null;
        Element primaryViewEl = XMLUtil.findElement((Element)doc.getDocumentElement(), (String)"primaryView", null);
        if (primaryViewEl != null && (nameEl = XMLUtil.findElement((Element)primaryViewEl, (String)"name", null)) != null) {
            primaryViewName = XMLUtil.findText((Node)nameEl);
        }
        ArrayList<BuilderConnector.ViewData> views = new ArrayList<BuilderConnector.ViewData>();
        NodeList nodes = doc.getDocumentElement().getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            if (!n.getNodeName().equals("view")) continue;
            String name = null;
            String url = null;
            boolean isPrimary = false;
            for (int j = 0; j < n.getChildNodes().getLength(); ++j) {
                Node o = n.getChildNodes().item(j);
                if (o.getNodeType() != 1) continue;
                if (o.getNodeName().equals("name")) {
                    name = o.getFirstChild().getTextContent();
                    isPrimary = name.equals(primaryViewName);
                    continue;
                }
                if (!o.getNodeName().equals("url")) continue;
                url = HudsonConnector.normalizeUrl(baseUrl, o.getFirstChild().getTextContent(), isPrimary ? "" : "view/[^/]+/");
            }
            if (null == name || null == url) continue;
            Element docView = (Element)n;
            BuilderConnector.ViewData viewData = new BuilderConnector.ViewData(name, url, isPrimary);
            NodeList jobsList = docView.getElementsByTagName("job");
            for (int k = 0; k < jobsList.getLength(); ++k) {
                Node d = jobsList.item(k);
                for (int l = 0; l < d.getChildNodes().getLength(); ++l) {
                    Node e = d.getChildNodes().item(l);
                    if (e.getNodeType() != 1) continue;
                    String nodeName = e.getNodeName();
                    if (nodeName.equals("name")) {
                        this.cache.put(viewData.getName() + "/" + e.getFirstChild().getTextContent(), viewData);
                        continue;
                    }
                    LOG.log(Level.FINE, "unexpected view <job> child: {0}", nodeName);
                }
            }
            views.add(viewData);
        }
        return views;
    }

    private Collection<BuilderConnector.JobData> getJobsData(Document doc, String baseUrl, Collection<BuilderConnector.ViewData> viewsData, Collection<BuilderConnector.FolderData> foldersData, HudsonFolder parentFolder) {
        HashMap<String, BuilderConnector.JobData> jobs = new HashMap<String, BuilderConnector.JobData>();
        NodeList nodes = doc.getDocumentElement().getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            boolean secured = n.getNodeName().equals("securedJob");
            if (!n.getNodeName().equals("job") && !secured) continue;
            BuilderConnector.JobData jd = new BuilderConnector.JobData();
            jd.setSecured(secured);
            BuilderConnector.FolderData fd = new BuilderConnector.FolderData();
            boolean isFolder = false;
            NodeList jobDetails = n.getChildNodes();
            for (int k = 0; k < jobDetails.getLength(); ++k) {
                Node d = jobDetails.item(k);
                if (d.getNodeType() != 1) continue;
                String nodeName = d.getNodeName();
                if (nodeName.equals("name")) {
                    String folder = parentFolder == null ? "" : parentFolder.getName() + "/";
                    String name = folder + d.getFirstChild().getTextContent();
                    jd.setJobName(name);
                    fd.setName(name);
                    continue;
                }
                if (nodeName.equals("url")) {
                    String u = HudsonConnector.normalizeUrl(baseUrl, d.getFirstChild().getTextContent(), "job/[^/]+/");
                    jd.setJobUrl(u);
                    fd.setUrl(u);
                    continue;
                }
                if (nodeName.equals("primaryView")) {
                    isFolder = true;
                    continue;
                }
                if (nodeName.equals("color")) {
                    jd.setColor(HudsonJob.Color.find(d.getFirstChild().getTextContent().trim()));
                    continue;
                }
                if (nodeName.equals("displayName")) {
                    jd.setDisplayName(d.getFirstChild().getTextContent());
                    continue;
                }
                if (nodeName.equals("buildable")) {
                    jd.setBuildable(Boolean.valueOf(d.getFirstChild().getTextContent()));
                    continue;
                }
                if (nodeName.equals("inQueue")) {
                    jd.setInQueue(Boolean.valueOf(d.getFirstChild().getTextContent()));
                    continue;
                }
                if (nodeName.equals("lastBuild")) {
                    jd.setLastBuild(Integer.valueOf(d.getFirstChild().getFirstChild().getTextContent()));
                    continue;
                }
                if (nodeName.equals("lastFailedBuild")) {
                    jd.setLastFailedBuild(Integer.valueOf(d.getFirstChild().getFirstChild().getTextContent()));
                    continue;
                }
                if (nodeName.equals("lastStableBuild")) {
                    jd.setLastStableBuild(Integer.valueOf(d.getFirstChild().getFirstChild().getTextContent()));
                    continue;
                }
                if (nodeName.equals("lastSuccessfulBuild")) {
                    jd.setLastSuccessfulBuild(Integer.valueOf(d.getFirstChild().getFirstChild().getTextContent()));
                    continue;
                }
                if (nodeName.equals("lastCompletedBuild")) {
                    jd.setLastCompletedBuild(Integer.valueOf(d.getFirstChild().getFirstChild().getTextContent()));
                    continue;
                }
                if (nodeName.equals("module")) {
                    String name = null;
                    String displayName = null;
                    String url = null;
                    HudsonJob.Color color = null;
                    NodeList moduleDetails = d.getChildNodes();
                    for (int j = 0; j < moduleDetails.getLength(); ++j) {
                        Node n2 = moduleDetails.item(j);
                        if (n2.getNodeType() != 1) continue;
                        String nodeName2 = n2.getNodeName();
                        Node firstChild = n2.getFirstChild();
                        if (firstChild != null) {
                            String text = firstChild.getTextContent();
                            if (nodeName2.equals("name")) {
                                name = text;
                                continue;
                            }
                            if (nodeName2.equals("displayName")) {
                                displayName = text;
                                continue;
                            }
                            if (nodeName2.equals("url")) {
                                url = HudsonConnector.normalizeUrl(baseUrl, text, "job/[^/]+/[^/]+/");
                                continue;
                            }
                            if (nodeName2.equals("color")) {
                                color = HudsonJob.Color.find(text);
                                continue;
                            }
                            LOG.log(Level.FINE, "unexpected <module> child: {0}", nodeName);
                            continue;
                        }
                        LOG.log(Level.FINE, "#178360: unexpected empty <module> child: {0}", nodeName);
                    }
                    if (name != null && url != null && color != null) {
                        if (displayName == null) {
                            LOG.log(Level.FINE, "#202671: missing displayName in {0}", jd.getJobUrl());
                            displayName = name;
                        }
                        jd.addModule(name, displayName, color, url);
                        continue;
                    }
                    LOG.log(Level.FINE, "#202671: missing name/url/color in {0}", jd.getJobUrl());
                    continue;
                }
                LOG.log(Level.FINE, "unexpected global <job> child: {0}", nodeName);
            }
            for (BuilderConnector.ViewData v : viewsData) {
                if (!secured && null == this.cache.get(v.getName() + "/" + jd.getJobName())) continue;
                jd.addView(v.getName());
            }
            if (isFolder) {
                foldersData.add(fd);
                continue;
            }
            this.addJobToMap(jobs, jd);
        }
        return jobs.values();
    }

    private void addJobToMap(Map<String, BuilderConnector.JobData> jobs, BuilderConnector.JobData jd) {
        BuilderConnector.JobData existingJob;
        if (jd != null && jd.getJobName() != null && !jd.getJobName().isEmpty() && ((existingJob = jobs.get(jd.getJobName())) == null || existingJob.isSecured() && !jd.isSecured())) {
            jobs.put(jd.getJobName(), jd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String normalizeUrl(String instanceUrl, String suggested, String relativePattern) {
        Pattern tailPattern;
        Map<String, Pattern> map = tailPatterns;
        synchronized (map) {
            tailPattern = tailPatterns.get(relativePattern);
            if (tailPattern == null) {
                tailPattern = Pattern.compile(".+/(" + relativePattern + ")");
                tailPatterns.put(relativePattern, tailPattern);
            }
        }
        Matcher m = tailPattern.matcher(suggested);
        if (m.matches()) {
            String result = instanceUrl + m.group(1);
            if (!result.equals(suggested)) {
                LOG.log(Level.FINER, "Normalizing {0} -> {1}", new Object[]{suggested, result});
            }
            return result;
        }
        LOG.log(Level.WARNING, "Anomalous URL {0} not ending with {1} from {2}", new Object[]{suggested, relativePattern, instanceUrl});
        return suggested;
    }

    @CheckForNull
    private synchronized HudsonVersion retrieveHudsonVersion(boolean authentication) {
        HudsonVersion v = null;
        try {
            String sVersion = new ConnectionBuilder().homeURL(this.instanceUrl).url(this.instanceUrl).authentication(authentication).httpConnection().getHeaderField("X-Hudson");
            if (sVersion != null) {
                v = new HudsonVersion(sVersion);
            }
        }
        catch (MalformedURLException mue) {
            LOG.log(Level.INFO, "Malformed URL " + this.instanceUrl, mue);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return v;
    }

    Document getDocument(String url, boolean authentication) {
        Document doc;
        block7: {
            this.forbidden = false;
            doc = null;
            try {
                HttpURLConnection conn = new ConnectionBuilder().homeURL(this.instanceUrl).url(url).authentication(authentication).httpConnection();
                if (!this.isConnected()) {
                    this.connected = true;
                    this.version = this.retrieveHudsonVersion(authentication);
                }
                InputStream stream = conn.getInputStream();
                InputSource source = new InputSource(stream);
                source.setSystemId(url);
                doc = XMLUtil.parse((InputSource)source, (boolean)false, (boolean)false, (ErrorHandler)XMLUtil.defaultErrorHandler(), null);
                if (!Utilities.isSupportedVersion(this.getHudsonVersion(authentication))) {
                    HudsonVersion v = this.retrieveHudsonVersion(authentication);
                    if (!Utilities.isSupportedVersion(v)) {
                        return null;
                    }
                    this.version = v;
                }
                conn.disconnect();
            }
            catch (SAXParseException x) {
                LOG.log(Level.INFO, null, x);
            }
            catch (MalformedURLException mue) {
                LOG.log(Level.INFO, "Invalid URL " + this.instanceUrl, mue);
            }
            catch (Exception x) {
                LOG.log(Level.FINE, url, x);
                if (authentication || !(x instanceof HttpRetryException) || ((HttpRetryException)x).responseCode() != 403) break block7;
                this.forbidden = true;
            }
        }
        return doc;
    }

    @Override
    public RemoteFileSystem getArtifacts(HudsonJobBuild build) {
        try {
            return new HudsonRemoteFileSystem(build);
        }
        catch (MalformedURLException ex) {
            LOG.log(Level.INFO, null, ex);
            return null;
        }
    }

    @Override
    public RemoteFileSystem getArtifacts(HudsonMavenModuleBuild build) {
        try {
            return new HudsonRemoteFileSystem(build);
        }
        catch (MalformedURLException ex) {
            LOG.log(Level.INFO, null, ex);
            return null;
        }
    }

    @Override
    public RemoteFileSystem getWorkspace(HudsonJob job) {
        try {
            return new HudsonRemoteFileSystem(job);
        }
        catch (MalformedURLException ex) {
            LOG.log(Level.INFO, null, ex);
            return null;
        }
    }

    @Override
    public boolean isForbidden() {
        return this.forbidden;
    }

    @Override
    public BuilderConnector.ConsoleDataProvider getConsoleDataProvider() {
        return HUDSON_CONSOLE_DISPLAYER;
    }

    @Override
    public BuilderConnector.FailureDataProvider getFailureDataProvider() {
        return HUDSON_FAILURE_DISPLAYER;
    }

    @Override
    public Collection<? extends HudsonJobChangeItem> getJobBuildChanges(HudsonJobBuild build) {
        HudsonSCM scm;
        Collection<? extends HudsonJobChangeItem> changes = null;
        Iterator iterator = Lookup.getDefault().lookupAll(HudsonSCM.class).iterator();
        while (iterator.hasNext() && (changes = (scm = (HudsonSCM)iterator.next()).parseChangeSet(build)) == null) {
        }
        if (changes == null) {
            changes = this.parseChangeSetGeneric(build);
        }
        return changes;
    }

    private Collection<? extends HudsonJobChangeItem> parseChangeSetGeneric(HudsonJobBuild build) {
        Element changeSet;
        try {
            changeSet = XMLUtil.findElement((Element)new ConnectionBuilder().job(build.getJob()).url(build.getUrl() + "api/xml?tree=changeSet[items[author[fullName],msg,affectedFile[path,editType]]]").parseXML().getDocumentElement(), (String)"changeSet", null);
        }
        catch (IOException x) {
            LOG.log(Level.WARNING, "could not parse changelog for {0}: {1}", new Object[]{this, x});
            return Collections.emptyList();
        }
        class Item
        implements HudsonJobChangeItem {
            final Element itemXML;

            Item(Element itemXML) {
                this.itemXML = itemXML;
            }

            @Override
            public String getUser() {
                return Utilities.xpath("author/fullName", this.itemXML);
            }

            @Override
            public String getMessage() {
                return Utilities.xpath("msg", this.itemXML);
            }

            @Override
            public Collection<? extends HudsonJobChangeItem.HudsonJobChangeFile> getFiles() {
                class AffectedFile
                implements HudsonJobChangeItem.HudsonJobChangeFile {
                    final Element fileXML;

                    AffectedFile(Element fileXML) {
                        this.fileXML = fileXML;
                    }

                    @Override
                    public String getName() {
                        return Utilities.xpath("path", this.fileXML);
                    }

                    @Override
                    public HudsonJobChangeItem.HudsonJobChangeFile.EditType getEditType() {
                        return HudsonJobChangeItem.HudsonJobChangeFile.EditType.valueOf(Utilities.xpath("editType", this.fileXML));
                    }

                    @Override
                    public OutputListener hyperlink() {
                        return null;
                    }
                }
                ArrayList<AffectedFile> files = new ArrayList<AffectedFile>();
                NodeList nl = this.itemXML.getElementsByTagName("affectedFile");
                for (int i = 0; i < nl.getLength(); ++i) {
                    files.add(new AffectedFile((Element)nl.item(i)));
                }
                return files;
            }
        }
        ArrayList<Item> items = new ArrayList<Item>();
        NodeList nl = changeSet.getElementsByTagName("item");
        for (int i = 0; i < nl.getLength(); ++i) {
            items.add(new Item((Element)nl.item(i)));
        }
        return items;
    }
}

