/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.compiler;

import groovy.lang.GroovyClassLoader;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.CodeSource;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.CancellationException;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.MixinNode;
import org.codehaus.groovy.control.ClassNodeResolver;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.SourceUnit;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.groovy.editor.api.parser.GroovyParser;
import org.netbeans.modules.groovy.editor.compiler.ClassNodeCache;
import org.netbeans.modules.groovy.editor.java.ElementSearch;
import org.netbeans.modules.groovy.editor.java.Utilities;
import org.netbeans.modules.parsing.api.Snapshot;
import org.openide.util.Exceptions;

public class CompilationUnit
extends org.codehaus.groovy.control.CompilationUnit {
    protected final Snapshot mainSnapshot;
    private static Method getCachedClassPathMethod;

    static CompilerConfiguration processConfiguration(CompilerConfiguration configuration, boolean isIndexing) {
        Map opts = configuration.getOptimizationOptions();
        opts.put("classLoaderResolving", Boolean.FALSE);
        return configuration;
    }

    public CompilationUnit(GroovyParser parser, CompilerConfiguration configuration, CodeSource security, @NonNull GroovyClassLoader loader, @NonNull GroovyClassLoader transformationLoader, @NonNull ClasspathInfo cpInfo, @NonNull ClassNodeCache classNodeCache) {
        this(parser, configuration, security, loader, transformationLoader, cpInfo, classNodeCache, true, null);
    }

    public CompilationUnit(GroovyParser parser, CompilerConfiguration configuration, CodeSource security, @NonNull GroovyClassLoader loader, @NonNull GroovyClassLoader transformationLoader, @NonNull ClasspathInfo cpInfo, @NonNull ClassNodeCache classNodeCache, boolean isIndexing, Snapshot snapshot) {
        super(CompilationUnit.processConfiguration(configuration, isIndexing), security, loader, transformationLoader);
        this.mainSnapshot = snapshot;
        Map opts = this.configuration.getOptimizationOptions();
        opts.put("classLoaderResolving", Boolean.FALSE);
        this.configuration.setOptimizationOptions(opts);
        this.ast = new CompileUnit(parser, this.classLoader, n -> {
            ClassNodeResolver.LookupResult lr = this.getClassNodeResolver().resolveName(n, (org.codehaus.groovy.control.CompilationUnit)this);
            if (lr != null && lr.isClassNode()) {
                return lr.getClassNode();
            }
            return null;
        }, security, this.configuration, cpInfo, classNodeCache);
    }

    protected void runSourceVisitor(String visitorName, Consumer<SourceUnit> callback) {
        for (SourceUnit su : this.sources.values()) {
            callback.accept(su);
        }
    }

    public static ClassPath pryOutCachedClassPath(ClasspathInfo cpInfo, ClasspathInfo.PathKind kind) {
        try {
            if (getCachedClassPathMethod == null) {
                Method m = ClasspathInfo.class.getDeclaredMethod("getCachedClassPath", ClasspathInfo.PathKind.class);
                m.setAccessible(true);
                getCachedClassPathMethod = m;
            } else if (getCachedClassPathMethod.getDeclaringClass() == String.class) {
                return cpInfo.getClassPath(kind);
            }
            return (ClassPath)getCachedClassPathMethod.invoke((Object)cpInfo, kind);
        }
        catch (ReflectiveOperationException | SecurityException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            try {
                getCachedClassPathMethod = String.class.getMethod("toString", new Class[0]);
            }
            catch (ReflectiveOperationException | SecurityException ex2) {
                Exceptions.printStackTrace((Throwable)ex2);
            }
            return cpInfo.getClassPath(kind);
        }
    }

    private static class CompileUnit
    extends org.codehaus.groovy.ast.CompileUnit {
        private final Function<String, ClassNode> classResolver;
        private final ClassNodeCache cache;
        private final GroovyParser parser;
        private final JavaSource javaSource;
        private final HashMap<String, ClassNode> temp = new HashMap();

        public CompileUnit(GroovyParser parser, GroovyClassLoader classLoader, Function<String, ClassNode> classResolver, CodeSource codeSource, CompilerConfiguration config, ClasspathInfo cpInfo, ClassNodeCache classNodeCache) {
            super(classLoader, codeSource, config);
            this.parser = parser;
            this.cache = classNodeCache;
            this.javaSource = this.cache.createResolver(cpInfo);
            this.classResolver = classResolver;
        }

        public ClassNode getClass(final String name) {
            if (this.parser.isCancelled()) {
                throw new CancellationException();
            }
            if (this.cache.isNonExistent(name)) {
                return null;
            }
            ClassNode classNode = this.cache.get(name);
            if (classNode != null) {
                return classNode;
            }
            classNode = this.temp.get(name);
            if (classNode != null) {
                return classNode;
            }
            classNode = super.getClass(name);
            if (classNode != null) {
                return classNode;
            }
            classNode = this.classResolver.apply(name);
            if (classNode != null) {
                this.cache.put(name, classNode);
                return classNode;
            }
            classNode = super.getClass(name);
            if (classNode != null) {
                return classNode;
            }
            try {
                final ClassNode[] holder = new ClassNode[1];
                Task<CompilationController> task = new Task<CompilationController>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run(CompilationController controller) throws Exception {
                        controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        Elements elements = controller.getElements();
                        TypeElement typeElement = ElementSearch.getClass(elements, name);
                        if (typeElement != null) {
                            try {
                                ClassNode node = this.createClassNode(name, 0, null, ClassNode.EMPTY_ARRAY, null);
                                temp.put(name, node);
                                this.initClassNode(node, typeElement);
                                if (node != null) {
                                    cache.put(name, node);
                                }
                                holder[0] = node;
                            }
                            finally {
                                temp.remove(name);
                            }
                        } else {
                            cache.put(name, null);
                        }
                    }
                };
                this.javaSource.runUserActionTask((Task)task, true);
                return holder[0];
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return null;
            }
        }

        private void initClassNode(ClassNode node, TypeElement typeElement) {
            ElementKind kind = typeElement.getKind();
            if (kind == ElementKind.ANNOTATION_TYPE) {
                this.initAnnotationType(node, typeElement);
            } else if (kind == ElementKind.INTERFACE) {
                this.initInterfaceKind(node, typeElement);
            } else {
                this.initClassType(node, typeElement);
            }
        }

        private void initAnnotationType(ClassNode node, TypeElement typeElement) {
            node.setModifiers(8192);
            node.setSuperClass(ClassHelper.Annotation_TYPE);
            this.initTypeInterfaces(node, typeElement);
        }

        private void initTypeInterfaces(ClassNode node, TypeElement typeElement) {
            HashSet<ClassNode> interfaces = new HashSet<ClassNode>();
            HashSet<GenericsType> generics = new HashSet<GenericsType>();
            for (TypeParameterElement typeParameterElement : typeElement.getTypeParameters()) {
                List<? extends TypeMirror> bounds = typeParameterElement.getBounds();
                for (TypeMirror typeMirror : bounds) {
                    ClassNode typeParam = this.getClass(typeMirror.toString());
                    generics.add(new GenericsType(typeParam));
                }
            }
            for (TypeMirror typeMirror : typeElement.getInterfaces()) {
                interfaces.add(new ClassNode(Utilities.getClassName(typeMirror).toString(), 512, null));
            }
            node.setInterfaces(interfaces.toArray(new ClassNode[interfaces.size()]));
            node.setGenericsTypes(generics.toArray(new GenericsType[generics.size()]));
        }

        private void initInterfaceKind(ClassNode node, TypeElement typeElement) {
            int modifiers = 0;
            node.setModifiers(modifiers |= 0x200);
            this.initTypeInterfaces(node, typeElement);
        }

        private void initClassType(ClassNode node, TypeElement typeElement) {
            Stack<DeclaredType> supers = new Stack<DeclaredType>();
            HashSet<GenericsType> generics = new HashSet<GenericsType>();
            while (typeElement != null && typeElement.asType().getKind() != TypeKind.NONE) {
                for (TypeParameterElement typeParameterElement : typeElement.getTypeParameters()) {
                    List<? extends TypeMirror> bounds = typeParameterElement.getBounds();
                    block2: for (TypeMirror typeMirror : bounds) {
                        ClassNode typeParam = this.getClass(typeMirror.toString());
                        for (GenericsType generic : generics) {
                            if (!generic.getType().equals((Object)typeParam)) continue;
                            continue block2;
                        }
                        generics.add(new GenericsType(typeParam));
                    }
                }
                TypeMirror type = typeElement.getSuperclass();
                if (type.getKind() != TypeKind.DECLARED) break;
                DeclaredType declaredType = (DeclaredType)typeElement.getSuperclass();
                supers.push(declaredType);
                Element element = declaredType.asElement();
                if ((element.getKind() == ElementKind.CLASS || element.getKind() == ElementKind.ENUM) && element instanceof TypeElement) {
                    typeElement = (TypeElement)element;
                    continue;
                }
                typeElement = null;
            }
            ClassNode superClass = null;
            while (!supers.empty()) {
                superClass = this.createClassNode(Utilities.getClassName((TypeMirror)supers.pop()).toString(), 0, superClass, new ClassNode[0], generics);
            }
            node.setSuperClass(superClass);
            node.setGenericsTypes(generics.toArray(new GenericsType[generics.size()]));
        }

        private ClassNode createClassNode(String name, int modifiers, ClassNode superClass, ClassNode[] interfaces, Set<GenericsType> generics) {
            ClassNode classNode = new ClassNode(name, modifiers, superClass, interfaces, MixinNode.EMPTY_ARRAY);
            if (generics != null) {
                classNode.setGenericsTypes(generics.toArray(new GenericsType[generics.size()]));
            }
            return classNode;
        }
    }
}

