/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.externalization;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.commons.core.XmlStringConverter;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskCategory;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.DayDateRange;
import org.eclipse.mylyn.internal.tasks.core.ITransferList;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.core.RepositoryModel;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.core.RepositoryTaskHandleUtil;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityUtil;
import org.eclipse.mylyn.internal.tasks.core.TaskCategory;
import org.eclipse.mylyn.internal.tasks.core.TaskTask;
import org.eclipse.mylyn.internal.tasks.core.UncategorizedTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.WeekDateRange;
import org.eclipse.mylyn.tasks.core.AbstractTaskListMigrator;
import org.eclipse.mylyn.tasks.core.IAttributeContainer;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DelegatingTaskExternalizer {
    static final String DEFAULT_PRIORITY = ITask.PriorityLevel.P3.toString();
    static final String OUT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.S Z";
    static final String IN_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.S z";
    static final String KEY_NOTIFIED_INCOMING = "NotifiedIncoming";
    public static final String KEY_NAME = "Name";
    public static final String KEY_LABEL = "Label";
    public static final String KEY_QUERY = "Query";
    public static final String KEY_QUERY_STRING = "QueryString";
    static final String KEY_HANDLE = "Handle";
    public static final String KEY_REPOSITORY_URL = "RepositoryUrl";
    public static final String KEY_CATEGORY = "Category";
    static final String VAL_ROOT = "Root";
    static final String KEY_SUBTASK = "SubTask";
    static final String KEY_KIND = "Kind";
    static final String KEY_TASK_CATEGORY = "TaskCategory";
    static final String KEY_LINK = "Link";
    static final String KEY_PLAN = "Plan";
    static final String KEY_TIME_ESTIMATED = "Estimated";
    static final String KEY_ISSUEURL = "IssueURL";
    static final String KEY_NOTES = "Notes";
    static final String KEY_ACTIVE = "Active";
    static final String KEY_PRIORITY = "Priority";
    static final String KEY_PATH = "Path";
    static final String VAL_FALSE = "false";
    static final String VAL_TRUE = "true";
    static final String KEY_DATE_END = "EndDate";
    static final String KEY_QUERY_HIT = "QueryHit";
    static final String KEY_TASK_REFERENCE = "TaskReference";
    static final String KEY_DATE_CREATION = "CreationDate";
    static final String KEY_DATE_REMINDER = "ReminderDate";
    static final String KEY_DATE_SCHEDULED_START = "ScheduledStartDate";
    static final String KEY_DATE_SCHEDULED_END = "ScheduledEndDate";
    static final String KEY_DATE_MODIFICATION = "ModificationDate";
    static final String KEY_DATE_DUE = "DueDate";
    static final String KEY_REMINDED = "Reminded";
    static final String KEY_FLOATING = "Floating";
    static final String KEY_LAST_MOD_DATE = "LastModified";
    static final String KEY_DIRTY = "Dirty";
    static final String KEY_SYNC_STATE = "offlineSyncState";
    static final String KEY_OWNER = "Owner";
    static final String KEY_MARK_READ_PENDING = "MarkReadPending";
    static final String KEY_STALE = "Stale";
    static final String KEY_CONNECTOR_KIND = "ConnectorKind";
    static final String KEY_TASK_ID = "TaskId";
    public static final String KEY_LAST_REFRESH = "LastRefreshTimeStamp";
    static final String NODE_ATTRIBUTE = "Attribute";
    static final String NODE_QUERY = "Query";
    static final String NODE_TASK = "Task";
    static final String KEY_KEY = "Key";
    private final Map<AbstractTask, String> parentCategoryMap;
    private final RepositoryModel repositoryModel;
    private List<AbstractTaskListMigrator> migrators;
    private boolean taskActivated;
    private final IRepositoryManager repositoryManager;
    private final List<IStatus> errors;

    public DelegatingTaskExternalizer(RepositoryModel repositoryModel, IRepositoryManager repositoryManager) {
        Assert.isNotNull((Object)repositoryModel);
        Assert.isNotNull((Object)repositoryManager);
        this.repositoryModel = repositoryModel;
        this.repositoryManager = repositoryManager;
        this.parentCategoryMap = new HashMap<AbstractTask, String>();
        this.errors = new ArrayList<IStatus>();
        this.migrators = Collections.emptyList();
    }

    public void initialize(List<AbstractTaskListMigrator> migrators) {
        Assert.isNotNull(migrators);
        this.migrators = migrators;
    }

    public Element createCategoryElement(AbstractTaskCategory category, Document doc, Element parent) {
        Element node = doc.createElement(this.getCategoryTagName());
        node.setAttribute(KEY_HANDLE, category.getHandleIdentifier());
        node.setAttribute(KEY_NAME, category.getSummary());
        parent.appendChild(node);
        for (ITask task : category.getChildren()) {
            this.createTaskReference(KEY_TASK_REFERENCE, task, doc, node);
        }
        return node;
    }

    public Element createTaskElement(AbstractTask task, Document doc, Element parent) {
        if (task.getClass() != TaskTask.class && !(task instanceof LocalTask)) {
            this.errors.add((IStatus)new Status(2, "org.eclipse.mylyn.tasks.core", "No externalizer for task: " + task));
            return null;
        }
        Element node = doc.createElement(NODE_TASK);
        node.setAttribute(KEY_CONNECTOR_KIND, task.getConnectorKind());
        node.setAttribute(KEY_REPOSITORY_URL, task.getRepositoryUrl());
        node.setAttribute(KEY_TASK_ID, task.getTaskId());
        if (task.getTaskKey() != null) {
            node.setAttribute(KEY_KEY, task.getTaskKey());
        }
        node.setAttribute(KEY_HANDLE, task.getHandleIdentifier());
        node.setAttribute(KEY_LABEL, this.stripControlCharacters(task.getSummary()));
        node.setAttribute(KEY_PRIORITY, task.getPriority());
        node.setAttribute(KEY_KIND, task.getTaskKind());
        if (task.isActive()) {
            node.setAttribute(KEY_ACTIVE, VAL_TRUE);
        } else {
            node.setAttribute(KEY_ACTIVE, VAL_FALSE);
        }
        if (task.getUrl() != null) {
            node.setAttribute(KEY_ISSUEURL, task.getUrl());
        }
        node.setAttribute(KEY_NOTES, this.stripControlCharacters(task.getNotes()));
        node.setAttribute(KEY_TIME_ESTIMATED, "" + task.getEstimatedTimeHours());
        node.setAttribute(KEY_DATE_END, this.formatExternDate(task.getCompletionDate()));
        node.setAttribute(KEY_DATE_CREATION, this.formatExternDate(task.getCreationDate()));
        node.setAttribute(KEY_DATE_MODIFICATION, this.formatExternDate(task.getModificationDate()));
        node.setAttribute(KEY_DATE_DUE, this.formatExternDate(task.getDueDate()));
        if (task.getScheduledForDate() != null) {
            node.setAttribute(KEY_DATE_SCHEDULED_START, this.formatExternCalendar(task.getScheduledForDate().getStartDate()));
            node.setAttribute(KEY_DATE_SCHEDULED_END, this.formatExternCalendar(task.getScheduledForDate().getEndDate()));
        }
        if (task.isReminded()) {
            node.setAttribute(KEY_REMINDED, VAL_TRUE);
        } else {
            node.setAttribute(KEY_REMINDED, VAL_FALSE);
        }
        if (task.isStale()) {
            node.setAttribute(KEY_STALE, VAL_TRUE);
        } else {
            node.setAttribute(KEY_STALE, VAL_FALSE);
        }
        if (task.isMarkReadPending()) {
            node.setAttribute(KEY_MARK_READ_PENDING, VAL_TRUE);
        } else {
            node.setAttribute(KEY_MARK_READ_PENDING, VAL_FALSE);
        }
        if (task.getLastReadTimeStamp() != null) {
            node.setAttribute(KEY_LAST_MOD_DATE, task.getLastReadTimeStamp());
        }
        if (task.isNotified()) {
            node.setAttribute(KEY_NOTIFIED_INCOMING, VAL_TRUE);
        } else {
            node.setAttribute(KEY_NOTIFIED_INCOMING, VAL_FALSE);
        }
        if (task.getSynchronizationState() != null) {
            node.setAttribute(KEY_SYNC_STATE, task.getSynchronizationState().name());
        } else {
            node.setAttribute(KEY_SYNC_STATE, ITask.SynchronizationState.SYNCHRONIZED.name());
        }
        if (task.getOwner() != null) {
            node.setAttribute(KEY_OWNER, task.getOwner());
        }
        this.createAttributes(task, doc, node);
        for (ITask t : task.getChildren()) {
            this.createTaskReference(KEY_SUBTASK, t, doc, node);
        }
        parent.appendChild(node);
        return node;
    }

    private void createAttributes(IAttributeContainer container, Document doc, Element parent) {
        Map<String, String> attributes = container.getAttributes();
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            Element node = doc.createElement(NODE_ATTRIBUTE);
            node.setAttribute(KEY_KEY, entry.getKey());
            node.setTextContent(entry.getValue());
            parent.appendChild(node);
        }
    }

    public Element createTaskReference(String nodeName, ITask task, Document doc, Element parent) {
        Element node = doc.createElement(nodeName);
        node.setAttribute(KEY_HANDLE, task.getHandleIdentifier());
        parent.appendChild(node);
        return node;
    }

    public void readTaskReferences(AbstractTaskContainer task, NodeList nodes, ITransferList tasklist) {
        int j = 0;
        while (j < nodes.getLength()) {
            Node child = nodes.item(j);
            Element element = (Element)child;
            if (element.hasAttribute(KEY_HANDLE)) {
                String handle = element.getAttribute(KEY_HANDLE);
                AbstractTask subTask = tasklist.getTask(handle);
                if (subTask != null) {
                    tasklist.addTask(subTask, task);
                } else {
                    this.errors.add((IStatus)new Status(2, "org.eclipse.mylyn.tasks.core", "Failed to add subtask with handle \"" + handle + "\" to \"" + task + "\""));
                }
            }
            ++j;
        }
    }

    private String stripControlCharacters(String text) {
        if (text == null) {
            return "";
        }
        return XmlStringConverter.cleanXmlString((String)text);
    }

    private String formatExternDate(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat format = new SimpleDateFormat(OUT_DATE_FORMAT, Locale.ENGLISH);
        return format.format(date);
    }

    private String formatExternCalendar(Calendar date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat format = new SimpleDateFormat(OUT_DATE_FORMAT, Locale.ENGLISH);
        return format.format(date.getTime());
    }

    public void readCategory(Node node, ITransferList taskList) {
        Element element = (Element)node;
        AbstractTaskCategory category = null;
        if (element.hasAttribute(KEY_NAME)) {
            String name;
            String handle = name = element.getAttribute(KEY_NAME);
            if (element.hasAttribute(KEY_HANDLE)) {
                handle = element.getAttribute(KEY_HANDLE);
            }
            if ((category = taskList.getContainerForHandle(handle)) == null) {
                category = new TaskCategory(handle, name);
                taskList.addCategory((TaskCategory)category);
            } else if (!UncategorizedTaskContainer.HANDLE.equals(handle)) {
                this.errors.add((IStatus)new Status(2, "org.eclipse.mylyn.tasks.core", "Category with handle \"" + name + "\" already exists in task list"));
            }
        } else {
            this.errors.add((IStatus)new Status(2, "org.eclipse.mylyn.tasks.core", "Category is missing name attribute"));
        }
        NodeList list = node.getChildNodes();
        this.readTaskReferences(category, list, taskList);
    }

    public final AbstractTask readTask(Node node, AbstractTaskCategory legacyCategory, ITask parent) throws CoreException {
        String taskId;
        String repositoryUrl;
        String handle;
        String summary = "";
        final Element element = (Element)node;
        if (element.hasAttribute(KEY_REPOSITORY_URL) && element.hasAttribute(KEY_TASK_ID) && element.hasAttribute(KEY_HANDLE)) {
            handle = element.getAttribute(KEY_HANDLE);
            repositoryUrl = element.getAttribute(KEY_REPOSITORY_URL);
            taskId = element.getAttribute(KEY_TASK_ID);
        } else if (element.hasAttribute(KEY_HANDLE)) {
            handle = element.getAttribute(KEY_HANDLE);
            repositoryUrl = RepositoryTaskHandleUtil.getRepositoryUrl(handle);
            taskId = RepositoryTaskHandleUtil.getTaskId(handle);
        } else {
            this.errors.add((IStatus)new Status(2, "org.eclipse.mylyn.tasks.core", "Task is missing handle attribute"));
            return null;
        }
        if (element.hasAttribute(KEY_LABEL)) {
            summary = element.getAttribute(KEY_LABEL);
        }
        AbstractTask task = null;
        AbstractTaskListMigrator taskMigrator = null;
        if (NODE_TASK.equals(node.getNodeName())) {
            String connectorKind = element.getAttribute(KEY_CONNECTOR_KIND);
            task = this.readDefaultTask(connectorKind, repositoryUrl, taskId, summary, element);
        }
        if (task == null) {
            for (AbstractTaskListMigrator migrator : this.migrators) {
                if (!node.getNodeName().equals(migrator.getTaskElementName())) continue;
                task = this.readDefaultTask(migrator.getConnectorKind(), repositoryUrl, taskId, summary, element);
                taskMigrator = migrator;
                break;
            }
        }
        if (task != null) {
            if (this.repositoryManager.getRepositoryConnector(task.getConnectorKind()) == null) {
                this.errors.add((IStatus)new Status(2, "org.eclipse.mylyn.tasks.core", "Missing connector for task with kind \"" + task.getConnectorKind() + "\""));
                return null;
            }
            this.readTaskInfo(task, element, parent, legacyCategory);
            this.readAttributes(task, element);
            if (taskMigrator != null) {
                if (task.getSynchronizationState() == ITask.SynchronizationState.INCOMING && task.getLastReadTimeStamp() == null) {
                    task.setSynchronizationState(ITask.SynchronizationState.INCOMING_NEW);
                }
                task.setTaskKey(task.getTaskId());
                final AbstractTaskListMigrator finalTaskMigrator = taskMigrator;
                final AbstractTask finalTask = task;
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable e) {
                        DelegatingTaskExternalizer.this.errors.add(new Status(2, "org.eclipse.mylyn.tasks.core", "Task migration failed for task \"" + finalTask + "\"", e));
                    }

                    public void run() throws Exception {
                        finalTaskMigrator.migrateTask(finalTask, element);
                    }
                });
            }
            return task;
        }
        this.errors.add((IStatus)new Status(2, "org.eclipse.mylyn.tasks.core", "Missing connector for task node \"" + node.getNodeName() + "\""));
        return null;
    }

    private void readAttributes(IAttributeContainer container, Element parent) {
        NodeList list = parent.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Element element;
            String key;
            Node child = list.item(i);
            if (child instanceof Element && child.getNodeName().equals(NODE_ATTRIBUTE) && (key = (element = (Element)child).getAttribute(KEY_KEY)).length() > 0) {
                container.setAttribute(key, element.getTextContent());
            }
            ++i;
        }
    }

    private void readTaskInfo(AbstractTask task, Element element, ITask parent, AbstractTaskCategory legacyCategory) {
        Date date;
        if (element.hasAttribute(KEY_CATEGORY)) {
            String categoryHandle = element.getAttribute(KEY_CATEGORY);
            if (categoryHandle.equals(VAL_ROOT)) {
                categoryHandle = UncategorizedTaskContainer.HANDLE;
            }
            this.parentCategoryMap.put(task, categoryHandle);
        }
        if (element.hasAttribute(KEY_PRIORITY)) {
            task.setPriority(element.getAttribute(KEY_PRIORITY));
        } else {
            task.setPriority(DEFAULT_PRIORITY);
        }
        if (element.hasAttribute(KEY_KIND)) {
            task.setTaskKind(element.getAttribute(KEY_KIND));
        }
        if (!this.taskActivated && element.getAttribute(KEY_ACTIVE).compareTo(VAL_TRUE) == 0) {
            task.setActive(true);
            this.taskActivated = true;
        } else {
            task.setActive(false);
        }
        if (element.hasAttribute(KEY_ISSUEURL)) {
            task.setUrl(element.getAttribute(KEY_ISSUEURL));
        } else {
            task.setUrl("");
        }
        if (element.hasAttribute(KEY_NOTES)) {
            task.setNotes(element.getAttribute(KEY_NOTES));
        } else {
            task.setNotes("");
        }
        if (element.hasAttribute(KEY_TIME_ESTIMATED)) {
            String est = element.getAttribute(KEY_TIME_ESTIMATED);
            try {
                int estimate = Integer.parseInt(est);
                task.setEstimatedTimeHours(estimate);
            }
            catch (Exception exception) {
                task.setEstimatedTimeHours(0);
            }
        } else {
            task.setEstimatedTimeHours(0);
        }
        if (element.hasAttribute(KEY_DATE_END)) {
            task.setCompletionDate(this.getDateFromString(element.getAttribute(KEY_DATE_END)));
        } else {
            task.setCompletionDate(null);
        }
        if (element.hasAttribute(KEY_DATE_CREATION)) {
            task.setCreationDate(this.getDateFromString(element.getAttribute(KEY_DATE_CREATION)));
        } else {
            task.setCreationDate(null);
        }
        if (element.hasAttribute(KEY_DATE_MODIFICATION)) {
            task.setModificationDate(this.getDateFromString(element.getAttribute(KEY_DATE_MODIFICATION)));
        } else {
            task.setModificationDate(null);
        }
        if (element.hasAttribute(KEY_DATE_DUE)) {
            task.setDueDate(this.getDateFromString(element.getAttribute(KEY_DATE_DUE)));
        } else {
            task.setDueDate(null);
        }
        boolean isFloating = false;
        isFloating = element.hasAttribute(KEY_FLOATING) && element.getAttribute(KEY_FLOATING).compareTo(VAL_TRUE) == 0;
        if (element.hasAttribute(KEY_DATE_REMINDER) && (date = this.getDateFromString(element.getAttribute(KEY_DATE_REMINDER))) != null) {
            if (isFloating) {
                task.setScheduledForDate(TaskActivityUtil.getWeekOf(date));
            } else {
                task.setScheduledForDate(TaskActivityUtil.getDayOf(date));
            }
        }
        if (element.hasAttribute(KEY_DATE_SCHEDULED_START) && element.hasAttribute(KEY_DATE_SCHEDULED_END)) {
            Date startDate = this.getDateFromString(element.getAttribute(KEY_DATE_SCHEDULED_START));
            Date endDate = this.getDateFromString(element.getAttribute(KEY_DATE_SCHEDULED_END));
            if (startDate != null && endDate != null && startDate.compareTo(endDate) <= 0) {
                Calendar calStart = TaskActivityUtil.getCalendar();
                calStart.setTime(startDate);
                Calendar calEnd = TaskActivityUtil.getCalendar();
                calEnd.setTime(endDate);
                if (DayDateRange.isDayRange(calStart, calEnd)) {
                    task.setScheduledForDate(new DayDateRange(calStart, calEnd));
                } else if (WeekDateRange.isWeekRange(calStart, calEnd)) {
                    task.setScheduledForDate(new WeekDateRange(calStart, calEnd));
                } else {
                    task.setScheduledForDate(TaskActivityUtil.getDayOf(new Date()));
                }
            }
        }
        if (element.hasAttribute(KEY_REMINDED) && element.getAttribute(KEY_REMINDED).compareTo(VAL_TRUE) == 0) {
            task.setReminded(true);
        } else {
            task.setReminded(false);
        }
        if (element.hasAttribute(KEY_STALE) && element.getAttribute(KEY_STALE).compareTo(VAL_TRUE) == 0) {
            task.setStale(true);
        } else {
            task.setStale(false);
        }
        if (element.hasAttribute(KEY_MARK_READ_PENDING) && element.getAttribute(KEY_MARK_READ_PENDING).compareTo(VAL_TRUE) == 0) {
            task.setMarkReadPending(true);
        } else {
            task.setMarkReadPending(false);
        }
        task.setSynchronizing(false);
        if (element.hasAttribute(KEY_REPOSITORY_URL)) {
            task.setRepositoryUrl(element.getAttribute(KEY_REPOSITORY_URL));
        }
        if (element.hasAttribute(KEY_LAST_MOD_DATE) && !element.getAttribute(KEY_LAST_MOD_DATE).equals("")) {
            task.setLastReadTimeStamp(element.getAttribute(KEY_LAST_MOD_DATE));
        }
        if (element.hasAttribute(KEY_OWNER)) {
            task.setOwner(element.getAttribute(KEY_OWNER));
        }
        if (VAL_TRUE.equals(element.getAttribute(KEY_NOTIFIED_INCOMING))) {
            task.setNotified(true);
        } else {
            task.setNotified(false);
        }
        if (element.hasAttribute(KEY_SYNC_STATE)) {
            try {
                ITask.SynchronizationState state = ITask.SynchronizationState.valueOf(element.getAttribute(KEY_SYNC_STATE));
                task.setSynchronizationState(state);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        if (element.hasAttribute(KEY_KEY)) {
            task.setTaskKey(element.getAttribute(KEY_KEY));
        } else {
            task.setTaskKey(null);
        }
    }

    private Date getDateFromString(String dateString) {
        Date date = null;
        if ("".equals(dateString)) {
            return null;
        }
        SimpleDateFormat format = new SimpleDateFormat(IN_DATE_FORMAT, Locale.ENGLISH);
        try {
            date = format.parse(dateString);
        }
        catch (ParseException e) {
            this.errors.add((IStatus)new Status(2, "org.eclipse.mylyn.tasks.core", "Could not parse date \"" + dateString + "\"", (Throwable)e));
        }
        return date;
    }

    private String getCategoryTagName() {
        return KEY_TASK_CATEGORY;
    }

    public Element createQueryElement(RepositoryQuery query, Document doc, Element parent) {
        if (query.getClass() != RepositoryQuery.class) {
            this.errors.add((IStatus)new Status(2, "org.eclipse.mylyn.tasks.core", "Missing factory to externalize query \"" + query + "\""));
            return null;
        }
        Element node = doc.createElement("Query");
        node.setAttribute(KEY_HANDLE, query.getHandleIdentifier());
        node.setAttribute(KEY_CONNECTOR_KIND, query.getConnectorKind());
        node.setAttribute(KEY_NAME, query.getSummary());
        node.setAttribute(KEY_QUERY_STRING, query.getUrl());
        node.setAttribute(KEY_REPOSITORY_URL, query.getRepositoryUrl());
        if (query.getLastSynchronizedTimeStamp() != null) {
            node.setAttribute(KEY_LAST_REFRESH, query.getLastSynchronizedTimeStamp());
        }
        this.createAttributes(query, doc, node);
        for (ITask hit : query.getChildren()) {
            this.createTaskReference(KEY_QUERY_HIT, hit, doc, node);
        }
        parent.appendChild(node);
        return node;
    }

    public Map<AbstractTask, String> getLegacyParentCategoryMap() {
        return this.parentCategoryMap;
    }

    public RepositoryQuery readQuery(Node node) {
        String label;
        final Element element = (Element)node;
        String repositoryUrl = element.getAttribute(KEY_REPOSITORY_URL);
        String queryString = element.getAttribute(KEY_QUERY_STRING);
        if (queryString.length() == 0) {
            queryString = element.getAttribute("Query");
        }
        if ((label = element.getAttribute(KEY_NAME)).length() == 0) {
            label = element.getAttribute(KEY_LABEL);
        }
        AbstractTaskListMigrator queryMigrator = null;
        RepositoryQuery query = null;
        if ("Query".equals(node.getNodeName())) {
            String connectorKind = element.getAttribute(KEY_CONNECTOR_KIND);
            query = this.readDefaultQuery(connectorKind, repositoryUrl, queryString, label, element);
        }
        if (query == null) {
            for (AbstractTaskListMigrator migrator : this.migrators) {
                Set<String> queryTagNames = migrator.getQueryElementNames();
                if (queryTagNames == null || !queryTagNames.contains(node.getNodeName())) continue;
                query = this.readDefaultQuery(migrator.getConnectorKind(), repositoryUrl, queryString, label, element);
                queryMigrator = migrator;
                break;
            }
        }
        if (query != null) {
            String handle;
            if (this.repositoryManager.getRepositoryConnector(query.getConnectorKind()) == null) {
                this.errors.add((IStatus)new Status(2, "org.eclipse.mylyn.tasks.core", "Missing connector for query with kind \"" + query.getConnectorKind() + "\""));
                return null;
            }
            if (element.getAttribute(KEY_LAST_REFRESH) != null && !element.getAttribute(KEY_LAST_REFRESH).equals("")) {
                query.setLastSynchronizedStamp(element.getAttribute(KEY_LAST_REFRESH));
            }
            if ((handle = element.getAttribute(KEY_HANDLE)).length() > 0) {
                query.setHandleIdentifier(handle);
            }
            this.readAttributes(query, element);
            if (queryMigrator != null) {
                query.setHandleIdentifier(label);
                final AbstractTaskListMigrator finalQueryMigrator = queryMigrator;
                final RepositoryQuery finalQuery = query;
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable e) {
                        DelegatingTaskExternalizer.this.errors.add(new Status(2, "org.eclipse.mylyn.tasks.core", "Query migration failed for query \"" + finalQuery + "\"", e));
                    }

                    public void run() throws Exception {
                        finalQueryMigrator.migrateQuery(finalQuery, element);
                    }
                });
            }
            return query;
        }
        this.errors.add((IStatus)new Status(2, "org.eclipse.mylyn.tasks.core", "Missing connector for query node \"" + node.getNodeName() + "\""));
        return null;
    }

    private RepositoryQuery readDefaultQuery(String connectorKind, String repositoryUrl, String queryString, String label, Element childElement) {
        TaskRepository taskRepository = this.repositoryModel.getTaskRepository(connectorKind, repositoryUrl);
        IRepositoryQuery query = this.repositoryModel.createRepositoryQuery(taskRepository);
        query.setSummary(label);
        query.setUrl(queryString);
        return (RepositoryQuery)query;
    }

    private AbstractTask readDefaultTask(String connectorKind, String repositoryUrl, String taskId, String summary, Element element) {
        TaskRepository taskRepository = this.repositoryModel.getTaskRepository(connectorKind, repositoryUrl);
        if (repositoryUrl.equals("local")) {
            LocalTask task = new LocalTask(taskId, summary);
            return task;
        }
        ITask task = this.repositoryModel.createTask(taskRepository, taskId);
        task.setSummary(summary);
        return (AbstractTask)task;
    }

    public void reset() {
        this.parentCategoryMap.clear();
        this.errors.clear();
    }

    public void clearErrorStatus() {
        this.errors.clear();
    }

    public Status getErrorStatus() {
        if (this.errors.size() > 0) {
            return new MultiStatus("org.eclipse.mylyn.tasks.core", 0, this.errors.toArray(new IStatus[0]), "Problems encounted while externalizing task list", null);
        }
        return null;
    }
}

