/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.spi.websvcmgr;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.websvc.jaxwsmodelapi.WSService;
import org.netbeans.modules.websvc.saas.model.SaasServicesModel;

public class WsdlServiceProxyDescriptor {
    public static final int JAX_RPC_TYPE = 0;
    public static final int JAX_WS_TYPE = 1;
    public static final String WEBSVC_HOME = SaasServicesModel.WEBSVC_HOME;
    private String name;
    private String packageName;
    private int wsType;
    private String wsdl;
    private String xmlDescriptor;
    private transient WSService model;
    private List<JarEntry> jars;
    private Map<String, Object> consumerData;

    public WsdlServiceProxyDescriptor() {
    }

    public WsdlServiceProxyDescriptor(String name, String packageName, int wsType, URL wsdl, File xmlDescriptor, WSService model) {
        this.name = name;
        this.packageName = packageName;
        this.wsType = wsType;
        this.wsdl = wsdl.toExternalForm();
        this.xmlDescriptor = xmlDescriptor.getAbsolutePath();
        this.model = model;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public int getWsType() {
        return this.wsType;
    }

    public void setWsType(int wsType) {
        this.wsType = wsType;
    }

    public String getWsdl() {
        return this.wsdl;
    }

    public URL getWsdlUrl() {
        try {
            return new URL(this.wsdl);
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, ex.getLocalizedMessage(), ex);
            return null;
        }
    }

    public void setWsdl(String wsdl) {
        this.wsdl = wsdl;
    }

    public String getXmlDescriptor() {
        return this.xmlDescriptor;
    }

    public File getXmlDescriptorFile() {
        return new File(this.xmlDescriptor);
    }

    public void setXmlDescriptor(String xmlDescriptor) {
        this.xmlDescriptor = xmlDescriptor;
    }

    public Map<String, Object> getConsumerData() {
        if (this.consumerData == null) {
            this.consumerData = new HashMap<String, Object>();
        }
        return this.consumerData;
    }

    public void setConsumerData(Map<String, Object> consumerData) {
        this.consumerData = consumerData;
    }

    public void addConsumerData(String key, Object data) {
        this.getConsumerData().put(key, data);
    }

    public void removeConsumerData(String key) {
        this.getConsumerData().remove(key);
    }

    public List<JarEntry> getJars() {
        if (this.jars == null) {
            this.jars = new LinkedList<JarEntry>();
        }
        return this.jars;
    }

    public void setJars(List<JarEntry> jars) {
        this.jars = jars;
    }

    public WSService getModel() {
        return this.model;
    }

    public void setModel(WSService model) {
        this.model = model;
    }

    public void addJar(String relativePath, String type) {
        this.getJars().add(new JarEntry(relativePath, type));
    }

    public void removeJar(String relativePath, String type) {
        this.getJars().remove(new JarEntry(relativePath, type));
    }

    public static class JarEntry {
        public static final String PROXY_JAR_TYPE = "proxy";
        public static final String SRC_JAR_TYPE = "source";
        private String name;
        private String type;

        public JarEntry() {
        }

        public JarEntry(String name, String type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public boolean equals(Object o) {
            try {
                JarEntry entry = (JarEntry)o;
                return entry.name.equals(this.name) && entry.type.equals(this.type);
            }
            catch (Exception ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, ex.getLocalizedMessage(), ex);
                return false;
            }
        }
    }
}

