/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.extbrowser.plugins.chrome;

import java.io.File;
import java.util.ArrayList;
import org.netbeans.modules.extbrowser.plugins.ExtensionManagerAccessor;
import org.netbeans.modules.extbrowser.plugins.Utils;
import org.netbeans.modules.extbrowser.plugins.chrome.ChromeManagerAccessor;
import org.netbeans.modules.web.browser.api.BrowserFamilyId;
import org.openide.util.Utilities;

public class ChromiumManagerAccessor
implements ExtensionManagerAccessor {
    @Override
    public ExtensionManagerAccessor.BrowserExtensionManager getManager() {
        return new ChromiumExtensionManager();
    }

    private static class ChromiumExtensionManager
    extends ChromeManagerAccessor.ChromeExtensionManager {
        private ChromiumExtensionManager() {
        }

        @Override
        public BrowserFamilyId getBrowserFamilyId() {
            return BrowserFamilyId.CHROMIUM;
        }

        @Override
        protected String[] getUserData() {
            if (Utilities.isWindows()) {
                File f;
                ArrayList<String> result = new ArrayList<String>();
                String localAppData = System.getenv("LOCALAPPDATA");
                if (localAppData != null) {
                    result.add(localAppData + "\\Chromium\\User Data");
                } else {
                    localAppData = Utils.getLOCALAPPDATAonWinXP();
                    if (localAppData != null) {
                        result.add(localAppData + "\\Chromium\\User Data");
                    }
                }
                String appData = System.getenv("APPDATA");
                if (appData != null && (f = new File(appData)).exists()) {
                    String fName = f.getName();
                    f = new File(f.getParentFile(), "Local Settings");
                    if ((f = new File(f, fName)).exists()) {
                        result.add(f.getPath() + "\\Chromium\\User Data");
                    }
                }
                return result.toArray(new String[result.size()]);
            }
            if (Utilities.isMac()) {
                return Utils.getUserPaths("/Library/Application Support/Chromium");
            }
            return Utils.getUserPaths("/snap/chromium/current/.config/chromium", "/.config/chromium");
        }
    }
}

