/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.disco;

import io.foojay.api.discoclient.pkg.Architecture;
import io.foojay.api.discoclient.pkg.OperatingSystem;
import java.io.File;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.openide.util.Utilities;

public class OS {
    public static OperatingSystem getOperatingSystem() {
        if (Utilities.isMac()) {
            return OperatingSystem.MACOS;
        }
        if (Utilities.isWindows()) {
            return OperatingSystem.WINDOWS;
        }
        if (Utilities.isUnix()) {
            String os = System.getProperty("os.name").toLowerCase();
            if (os.contains("sunos")) {
                return OperatingSystem.SOLARIS;
            }
            return OperatingSystem.LINUX;
        }
        return OperatingSystem.NONE;
    }

    public static Architecture getArchitecture() {
        Architecture arch = Architecture.fromText(System.getProperty("os.arch"));
        if (arch == Architecture.NOT_FOUND) {
            return Architecture.NONE;
        }
        return arch;
    }

    public static @Nullable File getDefaultDownloadFolder() {
        String home = System.getProperty("user.home");
        if (home == null) {
            return null;
        }
        switch (OS.getOperatingSystem()) {
            case MACOS: {
                File library = new File(home, "Library");
                if (!library.exists() || !library.isDirectory()) break;
                File d = new File(new File(library, "Java"), "JavaVirtualMachines");
                d.mkdirs();
                return d;
            }
            case WINDOWS: {
                File appdata;
                String local = System.getenv("LOCALAPPDATA");
                if (local == null || !(appdata = new File(local)).exists()) break;
                File d = new File(appdata, "Java");
                d.mkdirs();
                return d;
            }
            case LINUX: {
                File xdgData;
                String xdg = System.getenv("XDG_DATA_HOME");
                if (xdg != null && (xdgData = new File(xdg)).exists()) {
                    File d = new File(xdgData, "jvm");
                    d.mkdirs();
                    return d;
                }
                File d = new File(home, ".local/share/jvm");
                d.mkdirs();
                return d;
            }
        }
        return null;
    }
}

