/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.packages;

import java.io.IOException;
import org.netbeans.modules.profiler.snaptracer.ItemValueFormatter;
import org.netbeans.modules.profiler.snaptracer.ProbeItemDescriptor;
import org.netbeans.modules.profiler.snaptracer.TracerProbe;
import org.netbeans.modules.profiler.snaptracer.impl.IdeSnapshot;
import org.openide.util.Exceptions;

class UiGesturesProbe
extends TracerProbe {
    private IdeSnapshot snapshot;

    public UiGesturesProbe(IdeSnapshot snapshot) {
        super(UiGesturesProbe.descriptors(1, snapshot));
        this.snapshot = snapshot;
    }

    @Override
    public long[] getItemValues(int sampleIndex) {
        return this.values(sampleIndex);
    }

    private static ProbeItemDescriptor[] descriptors(int items, IdeSnapshot snapshot) {
        ProbeItemDescriptor[] descriptors = new ProbeItemDescriptor[items];
        descriptors[0] = ProbeItemDescriptor.iconItem("UI Gesture", "Shows UI actions performed by the user in the IDE", new UiGesturesFormatter(snapshot));
        return descriptors;
    }

    private long[] values(int sampleIndex) {
        long[] values = new long[1];
        try {
            values[0] = this.snapshot.getValue(sampleIndex, 1);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return values;
    }

    private static class UiGesturesFormatter
    extends ItemValueFormatter {
        private IdeSnapshot snapshot;

        UiGesturesFormatter(IdeSnapshot snapshot) {
            this.snapshot = snapshot;
        }

        @Override
        public String formatValue(long value, int format) {
            switch (format) {
                case 0: 
                case 2: 
                case 3: {
                    IdeSnapshot.LogRecordInfo info = this.snapshot.getLogInfoForValue(value);
                    String message = null;
                    if (info != null) {
                        message = info.getDisplayName();
                        if (message == null) {
                            message = info.getName();
                        }
                        if (message == null) {
                            message = "<unknown>";
                        }
                    }
                    return message != null ? message : "<none>";
                }
                case 1: {
                    return "";
                }
            }
            return null;
        }

        @Override
        public String getUnits(int format) {
            return "";
        }
    }
}

