/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.netbeans.installer.utils.LogManager;
import org.netbeans.installer.utils.StringUtils;

public final class ResourceUtils {
    private static HashMap<String, ResourceBundle> loadedBundles = new HashMap();
    public static final int BUFFER_SIZE = 40960;
    public static final String BUNDLE_FILE_SUFFIX = ".Bundle";

    public static String getString(String baseName, String key) {
        return ResourceUtils.getString(baseName, key, ResourceUtils.class.getClassLoader());
    }

    public static String getString(String baseName, String key, ClassLoader loader) {
        return ResourceUtils.getBundleMessage(baseName, Locale.getDefault(), loader, key);
    }

    public static String getString(Class clazz, String key) {
        return ResourceUtils.getBundleMessage(ResourceUtils.getBundleResource(clazz), Locale.getDefault(), clazz.getClassLoader(), key);
    }

    public static String getString(String baseName, String key, Object ... arguments) {
        return ResourceUtils.getString(baseName, key, ResourceUtils.class.getClassLoader(), arguments);
    }

    public static String getString(String baseName, String key, ClassLoader loader, Object ... arguments) {
        return ResourceUtils.format(ResourceUtils.getString(baseName, key, loader), arguments);
    }

    public static String getString(Class clazz, String key, Object ... arguments) {
        return ResourceUtils.format(ResourceUtils.getString(clazz, key), arguments);
    }

    public static Map<Locale, String> getStrings(String baseName, String key, ClassLoader loader, Object ... arguments) {
        Map<Locale, String> map = ResourceUtils.getBundleMessagesMapForKey(baseName, key, loader);
        if (arguments.length == 0) {
            return map;
        }
        HashMap<Locale, String> result = new HashMap<Locale, String>();
        for (Locale locale : map.keySet()) {
            result.put(locale, ResourceUtils.format(map.get(locale), arguments));
        }
        return result;
    }

    public static Map<Locale, String> getStrings(String baseName, String key, Object ... arguments) {
        return ResourceUtils.getStrings(baseName, key, ResourceUtils.class.getClassLoader(), arguments);
    }

    public static Map<Locale, String> getStrings(Class clazz, String key, Object ... arguments) {
        return ResourceUtils.getStrings(ResourceUtils.getBundleResource(clazz), key, clazz.getClassLoader(), arguments);
    }

    private static String format(String message, Object ... arguments) {
        return message == null ? null : StringUtils.format(message, arguments);
    }

    public static InputStream getResource(String name) {
        return ResourceUtils.getResource(name, ResourceUtils.class.getClassLoader());
    }

    public static InputStream getResource(String path, ClassLoader loader) {
        return loader.getResourceAsStream(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getResourceSize(String resource) {
        InputStream is = null;
        long size = 0L;
        try {
            is = ResourceUtils.getResource(resource);
            if (is == null) {
                long l = -1L;
                return l;
            }
            byte[] buf = new byte[40960];
            while (is.available() > 0) {
                size += (long)is.read(buf);
            }
        }
        catch (IOException ex) {
            size = -1L;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
        return size;
    }

    public static String getResourceFileName(String resource) {
        return resource.substring(resource.lastIndexOf("/") + 1);
    }

    public static String getResourceClassName(Class c) {
        return ResourceUtils.getResourceClassName(c.getName());
    }

    public static String getResourceClassName(String className) {
        return className.replace(".", "/") + ".class";
    }

    private static ResourceBundle loadBundle(String baseName, Locale locale, ClassLoader loader) {
        String bundleId = loader.toString() + baseName + (locale.toString().equals("") ? "" : "_" + locale);
        ResourceBundle bundle = loadedBundles.get(bundleId);
        if (bundle == null && !loadedBundles.containsKey(bundleId)) {
            try {
                bundle = ResourceBundle.getBundle(baseName, locale, loader);
            }
            catch (MissingResourceException e) {
                LogManager.log("Can`t find bundle " + baseName + " using [" + locale + "] locale and [" + loader + "] classloader", (Throwable)e);
            }
            loadedBundles.put(bundleId, bundle);
        }
        return bundle;
    }

    private static String getBundleMessage(String baseName, Locale locale, ClassLoader loader, String key) {
        ResourceBundle bundle = ResourceUtils.loadBundle(baseName, locale, loader);
        String message = null;
        if (bundle != null) {
            try {
                message = bundle.getString(key);
            }
            catch (MissingResourceException e) {
                if (locale.toString().length() > 0) {
                    Object[] parts = locale.toString().split("_");
                    String upLocale = StringUtils.asString(parts, 0, parts.length - 1, "_");
                    return ResourceUtils.getBundleMessage(baseName, StringUtils.parseLocale(upLocale), loader, key);
                }
                LogManager.log("Can`t load message in bundle " + baseName + " for key " + key + " using [" + loader + "] classloader");
            }
        }
        return message;
    }

    private static Map<Locale, String> getBundleMessagesMapForKey(String baseName, String key, ClassLoader loader) {
        HashMap<Locale, String> map = new HashMap<Locale, String>();
        ArrayList<Locale> list = new ArrayList<Locale>();
        list.add(new Locale(""));
        list.addAll(Arrays.asList(Locale.getAvailableLocales()));
        for (Locale locale : list) {
            ResourceBundle bundle = ResourceUtils.loadBundle(baseName, locale, loader);
            if (bundle == null || !locale.equals(bundle.getLocale()) || map.containsKey(bundle.getLocale())) continue;
            map.put(locale, ResourceUtils.getBundleMessage(baseName, locale, loader, key));
        }
        return map;
    }

    private static String getBundleResource(Class clazz) {
        return clazz.getPackage().getName() + BUNDLE_FILE_SUFFIX;
    }

    private ResourceUtils() {
    }
}

