/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.debugging.breakpoints;

import java.net.MalformedURLException;
import java.net.URL;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.java.lsp.server.debugging.breakpoints.Bundle;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;

public class GroovyBreakpointFactory {
    private GroovyBreakpointFactory() {
    }

    public static LineBreakpoint create(String url, int lineNumber) {
        LineBreakpoint groovyBreakpoint = LineBreakpoint.create((String)url, (int)lineNumber);
        groovyBreakpoint.setStratum("Groovy");
        FileObject fo = GroovyBreakpointFactory.findFileObjectFromUrl(url);
        String sourceName = GroovyBreakpointFactory.setGroovySourceName(groovyBreakpoint, fo);
        String sourcePath = GroovyBreakpointFactory.setGroovySourcePath(groovyBreakpoint, fo);
        GroovyBreakpointFactory.setImplClassFilter(groovyBreakpoint, sourcePath);
        GroovyBreakpointFactory.setPrintText(groovyBreakpoint, sourceName);
        return groovyBreakpoint;
    }

    private static FileObject findFileObjectFromUrl(String url) {
        FileObject fo;
        try {
            fo = URLMapper.findFileObject((URL)new URL(url));
        }
        catch (MalformedURLException e) {
            fo = null;
        }
        return fo;
    }

    private static void setImplClassFilter(LineBreakpoint b, String relativePath) {
        int dot;
        if (relativePath != null && (dot = relativePath.lastIndexOf(46)) > 0) {
            relativePath = relativePath.substring(0, dot);
            String pattern = relativePath.replace('/', '.') + "*";
            b.setPreferredClassName(pattern);
        }
    }

    private static String setGroovySourceName(LineBreakpoint b, FileObject fo) {
        if (fo != null) {
            String name = fo.getNameExt();
            b.setSourceName(name);
            return name;
        }
        return null;
    }

    private static String setGroovySourcePath(LineBreakpoint b, FileObject fo) {
        FileObject root;
        ClassPath cp;
        if (fo != null && (cp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/source")) != null && (root = cp.findOwnerRoot(fo)) != null) {
            String relativePath = FileUtil.getRelativePath((FileObject)root, (FileObject)fo);
            b.setSourcePath(relativePath);
            return relativePath;
        }
        return null;
    }

    private static void setPrintText(LineBreakpoint b, String sourceName) {
        String printText = sourceName != null ? Bundle.CTL_Default_Print_Text().replace("{groovyName}", sourceName) : Bundle.CTL_Default_Print_Text().replace("{groovyName}", "?");
        b.setPrintText(printText);
    }
}

