/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.protocol;

import com.google.gson.Gson;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Types;
import org.eclipse.lsp4j.ApplyWorkspaceEditParams;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.modules.java.lsp.server.Utils;
import org.netbeans.modules.java.lsp.server.protocol.Bundle;
import org.netbeans.modules.java.lsp.server.protocol.CodeActionsProvider;
import org.netbeans.modules.java.lsp.server.protocol.CodeRefactoring;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.netbeans.modules.java.lsp.server.protocol.QuickPickItem;
import org.netbeans.modules.java.lsp.server.protocol.ShowQuickPickParams;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.java.api.JavaRefactoringUtils;
import org.netbeans.modules.refactoring.java.api.MemberInfo;
import org.openide.filesystems.FileObject;

public final class PushDownRefactoring
extends CodeRefactoring {
    private static final String PUSH_DOWN_REFACTORING_KIND = "refactor.push.down";
    private static final String PUSH_DOWN_REFACTORING_COMMAND = "java.refactor.push.down";
    private final Set<String> commands = Collections.singleton("java.refactor.push.down");
    private final Gson gson = new Gson();

    @Override
    public List<CodeAction> getCodeActions(ResultIterator resultIterator, CodeActionParams params) throws Exception {
        List only = params.getContext().getOnly();
        if (only == null || !only.contains("refactor")) {
            return Collections.emptyList();
        }
        CompilationController info = CompilationController.get((Parser.Result)resultIterator.getParserResult());
        if (info == null || !JavaRefactoringUtils.isRefactorable((FileObject)info.getFileObject())) {
            return Collections.emptyList();
        }
        info.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
        int offset = PushDownRefactoring.getOffset((CompilationInfo)info, params.getRange().getStart());
        String uri = Utils.toUri(info.getFileObject());
        Trees trees = info.getTrees();
        SourcePositions sourcePositions = trees.getSourcePositions();
        TreeUtilities treeUtilities = info.getTreeUtilities();
        Types types = info.getTypes();
        TreePath path = PushDownRefactoring.findSelectedClassMemberDeclaration(treeUtilities.pathFor(offset), (CompilationInfo)info);
        if (path == null) {
            return Collections.emptyList();
        }
        Element element = trees.getElement(path);
        if (!(element instanceof TypeElement)) {
            element = info.getElementUtilities().enclosingTypeElement(element);
        }
        if (!(element instanceof TypeElement)) {
            return Collections.emptyList();
        }
        ElementHandle eh = ElementHandle.create((Element)((TypeElement)element));
        Set resources = info.getClasspathInfo().getClassIndex().getResources(eh, EnumSet.of(ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.SOURCE));
        if (resources.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<QuickPickItem> members = new ArrayList<QuickPickItem>();
        for (Element element2 : element.getEnclosedElements()) {
            if (element2.getKind() == ElementKind.CONSTRUCTOR || element2.getKind() == ElementKind.STATIC_INIT || element2.getKind() == ElementKind.INSTANCE_INIT || element2 instanceof TypeElement && types.isSubtype(element2.asType(), element.asType())) continue;
            TreePath mPath = trees.getPath(element2);
            long startMember = mPath != null ? sourcePositions.getStartPosition(mPath.getCompilationUnit(), mPath.getLeaf()) : -1L;
            long endMember = mPath != null ? sourcePositions.getEndPosition(mPath.getCompilationUnit(), mPath.getLeaf()) : -1L;
            boolean selected = (long)offset > startMember && (long)offset < endMember;
            members.add(new QuickPickItem(PushDownRefactoring.createLabel((CompilationInfo)info, element2), null, null, selected, new CodeActionsProvider.ElementData(element2)));
        }
        if (members.isEmpty()) {
            return Collections.emptyList();
        }
        QuickPickItem elementItem = new QuickPickItem(PushDownRefactoring.createLabel((CompilationInfo)info, element));
        elementItem.setUserData(new CodeActionsProvider.ElementData(element));
        return Collections.singletonList(PushDownRefactoring.createCodeAction(Bundle.DN_PushDown(), PUSH_DOWN_REFACTORING_KIND, PUSH_DOWN_REFACTORING_COMMAND, uri, elementItem, members));
    }

    @Override
    public Set<String> getCommands() {
        return this.commands;
    }

    @Override
    public CompletableFuture<Object> processCommand(NbCodeLanguageClient client, String command, List<Object> arguments) {
        try {
            if (arguments.size() <= 2) {
                throw new IllegalArgumentException(String.format("Illegal number of arguments received for command: %s", command));
            }
            String uri = (String)this.gson.fromJson(this.gson.toJson(arguments.get(0)), String.class);
            QuickPickItem sourceItem = (QuickPickItem)this.gson.fromJson(this.gson.toJson(arguments.get(1)), QuickPickItem.class);
            List<QuickPickItem> members = Arrays.asList((QuickPickItem[])this.gson.fromJson(this.gson.toJson(arguments.get(2)), QuickPickItem[].class));
            client.showQuickPick(new ShowQuickPickParams(Bundle.DN_SelectMembersToPushDown(), true, members)).thenAccept(selected -> {
                if (selected != null && !selected.isEmpty()) {
                    this.pushDown(client, uri, sourceItem, (List<QuickPickItem>)selected);
                }
            });
        }
        catch (Exception ex) {
            client.showMessage(new MessageParams(MessageType.Error, ex.getLocalizedMessage()));
        }
        return CompletableFuture.completedFuture(true);
    }

    private void pushDown(NbCodeLanguageClient client, String uri, QuickPickItem source, List<QuickPickItem> members) {
        try {
            FileObject file = Utils.fromUri(uri);
            ClasspathInfo info = ClasspathInfo.create((FileObject)file);
            JavaSource js = JavaSource.forFileObject((FileObject)file);
            if (js == null) {
                throw new IOException("Cannot get JavaSource for: " + uri);
            }
            ElementHandle sourceHandle = ((CodeActionsProvider.ElementData)this.gson.fromJson(this.gson.toJson(source.getUserData()), CodeActionsProvider.ElementData.class)).toHandle();
            ArrayList memberHandles = new ArrayList();
            js.runUserActionTask(ci -> {
                ci.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                for (QuickPickItem member : members) {
                    Element el = ((CodeActionsProvider.ElementData)this.gson.fromJson(this.gson.toJson(member.getUserData()), CodeActionsProvider.ElementData.class)).resolve((CompilationInfo)ci);
                    MemberInfo memberInfo = MemberInfo.create((Element)el, (CompilationInfo)ci);
                    memberHandles.add(memberInfo);
                }
            }, true);
            org.netbeans.modules.refactoring.java.api.PushDownRefactoring refactoring = new org.netbeans.modules.refactoring.java.api.PushDownRefactoring(TreePathHandle.from((ElementHandle)sourceHandle, (ClasspathInfo)info));
            refactoring.setMembers(memberHandles.toArray(new MemberInfo[memberHandles.size()]));
            refactoring.getContext().add((Object)JavaRefactoringUtils.getClasspathInfoFor((FileObject[])new FileObject[]{file}));
            client.applyEdit(new ApplyWorkspaceEditParams(this.perform((AbstractRefactoring)refactoring, "PushDown")));
        }
        catch (Exception ex) {
            client.showMessage(new MessageParams(MessageType.Error, ex.getLocalizedMessage()));
        }
    }

    private static TreePath findSelectedClassMemberDeclaration(TreePath path, CompilationInfo javac) {
        List<? extends Tree> typeDecls;
        TreePath currentPath = path;
        TreePath selection = null;
        while (currentPath != null && selection == null) {
            switch (currentPath.getLeaf().getKind()) {
                case ANNOTATION_TYPE: 
                case CLASS: 
                case ENUM: 
                case INTERFACE: 
                case NEW_CLASS: 
                case METHOD: {
                    selection = currentPath;
                    break;
                }
                case VARIABLE: {
                    Element elm = javac.getTrees().getElement(currentPath);
                    if (elm == null || !elm.getKind().isField()) break;
                    selection = currentPath;
                }
            }
            if (selection != null && javac.getTreeUtilities().isSynthetic(selection)) {
                selection = null;
            }
            if (selection != null) continue;
            currentPath = currentPath.getParentPath();
        }
        if (selection == null && path != null && !(typeDecls = path.getCompilationUnit().getTypeDecls()).isEmpty() && typeDecls.get(0).getKind().asInterface() == ClassTree.class) {
            selection = TreePath.getPath(path.getCompilationUnit(), typeDecls.get(0));
        }
        return selection;
    }
}

