/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.protocol;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.WorkspaceSymbolParams;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageClientAware;
import org.eclipse.lsp4j.services.WorkspaceService;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.gsf.testrunner.ui.api.TestMethodController;
import org.netbeans.modules.gsf.testrunner.ui.api.TestMethodFinder;
import org.netbeans.modules.java.lsp.server.LspServerState;
import org.netbeans.modules.java.lsp.server.Utils;
import org.netbeans.modules.java.lsp.server.debugging.attach.AttachConfigurations;
import org.netbeans.modules.java.lsp.server.debugging.attach.AttachNativeConfigurations;
import org.netbeans.modules.java.lsp.server.protocol.CodeActionsProvider;
import org.netbeans.modules.java.lsp.server.protocol.LaunchConfigurationCompletion;
import org.netbeans.modules.java.lsp.server.protocol.LspTemplateUI;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.netbeans.modules.java.lsp.server.protocol.TestProgressParams;
import org.netbeans.modules.java.lsp.server.protocol.TestSuiteInfo;
import org.netbeans.modules.java.lsp.server.protocol.TextDocumentServiceImpl;
import org.netbeans.modules.java.source.ui.JavaSymbolProvider;
import org.netbeans.modules.java.source.ui.JavaTypeProvider;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.modules.parsing.lucene.support.Queries;
import org.netbeans.spi.jumpto.type.SearchType;
import org.netbeans.spi.project.ActionProgress;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.ProjectConfiguration;
import org.netbeans.spi.project.ProjectConfigurationProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public final class WorkspaceServiceImpl
implements WorkspaceService,
LanguageClientAware {
    private static final RequestProcessor WORKER = new RequestProcessor(WorkspaceServiceImpl.class.getName(), 1, false, false);
    private final Gson gson = new Gson();
    private final LspServerState server;
    private NbCodeLanguageClient client;
    private final AtomicReference<BiConsumer<FileObject, Collection<TestMethodController.TestMethod>>> testMethodsListener = new AtomicReference();
    private static final String[] SOURCE_TYPES = new String[]{"java", "groovy"};
    private static final String INIT = "<init>";

    WorkspaceServiceImpl(LspServerState server) {
        this.server = server;
    }

    public CompletableFuture<Object> executeCommand(ExecuteCommandParams params) {
        String command;
        switch (command = params.getCommand()) {
            case "graalvm.pause.script": {
                ActionsManager am = DebuggerManager.getDebuggerManager().getCurrentEngine().getActionsManager();
                am.doAction((Object)"pauseInGraalScript");
                return CompletableFuture.completedFuture(true);
            }
            case "java.new.from.template": {
                return LspTemplateUI.createFromTemplate("Templates", this.client, params);
            }
            case "java.new.project": {
                return LspTemplateUI.createProject("Templates/Project", this.client, params);
            }
            case "java.build.workspace": {
                CommandProgress progressOfCompilation = new CommandProgress();
                Lookup ctx = Lookups.singleton((Object)((Object)progressOfCompilation));
                for (Project prj : this.server.openedProjects().getNow(OpenProjects.getDefault().getOpenProjects())) {
                    ActionProvider ap = (ActionProvider)prj.getLookup().lookup(ActionProvider.class);
                    if (ap == null || !ap.isActionEnabled("build", Lookup.EMPTY)) continue;
                    ap.invokeAction("rebuild", ctx);
                }
                progressOfCompilation.checkStatus();
                return progressOfCompilation.getFinishFuture();
            }
            case "java.get.project.source.roots": {
                String uri = ((JsonPrimitive)params.getArguments().get(0)).getAsString();
                String type = params.getArguments().size() > 1 ? ((JsonPrimitive)params.getArguments().get(1)).getAsString() : "java";
                return this.getSourceRoots(uri, type).thenApply(roots -> roots.stream().map(root -> Utils.toUri(root)).collect(Collectors.toList()));
            }
            case "java.get.project.classpath": {
                String uri = ((JsonPrimitive)params.getArguments().get(0)).getAsString();
                ClasspathInfo.PathKind kind = params.getArguments().size() > 1 ? ClasspathInfo.PathKind.valueOf((String)((JsonPrimitive)params.getArguments().get(1)).getAsString()) : ClasspathInfo.PathKind.COMPILE;
                boolean preferSources = params.getArguments().size() > 2 ? ((JsonPrimitive)params.getArguments().get(2)).getAsBoolean() : false;
                return this.getSourceRoots(uri, "java").thenApply(roots -> {
                    HashSet<FileObject> cpRoots = new HashSet<FileObject>();
                    for (FileObject root : roots) {
                        for (FileObject cpRoot : ClasspathInfo.create((FileObject)root).getClassPath(kind).getRoots()) {
                            FileObject[] srcRoots;
                            FileObject[] fileObjectArray = srcRoots = preferSources ? SourceForBinaryQuery.findSourceRoots((URL)cpRoot.toURL()).getRoots() : null;
                            if (srcRoots != null && srcRoots.length > 0) {
                                for (FileObject srcRoot : srcRoots) {
                                    cpRoots.add(srcRoot);
                                }
                                continue;
                            }
                            cpRoots.add(cpRoot);
                        }
                    }
                    return cpRoots.stream().map(fo -> Utils.toUri(fo)).collect(Collectors.toList());
                });
            }
            case "java.get.project.packages": {
                String uri = ((JsonPrimitive)params.getArguments().get(0)).getAsString();
                boolean srcOnly = params.getArguments().size() > 1 ? ((JsonPrimitive)params.getArguments().get(1)).getAsBoolean() : false;
                return this.getSourceRoots(uri, "java").thenCompose(roots -> {
                    CompletableFuture future = new CompletableFuture();
                    JavaSource js = JavaSource.create((ClasspathInfo)ClasspathInfo.create((ClassPath)ClassPath.EMPTY, (ClassPath)ClassPath.EMPTY, (ClassPath)ClassPath.EMPTY), (FileObject[])new FileObject[0]);
                    try {
                        js.runWhenScanFinished(controller -> {
                            HashSet packages = new HashSet();
                            EnumSet<ClassIndex.SearchScope> scope = srcOnly ? EnumSet.of(ClassIndex.SearchScope.SOURCE) : EnumSet.allOf(ClassIndex.SearchScope.class);
                            for (FileObject root : roots) {
                                packages.addAll(ClasspathInfo.create((FileObject)root).getClassIndex().getPackageNames("", false, scope));
                            }
                            ArrayList ret = new ArrayList(packages);
                            Collections.sort(ret);
                            future.complete(ret);
                        }, true);
                    }
                    catch (IOException ex) {
                        future.completeExceptionally(ex);
                    }
                    return future;
                });
            }
            case "java.load.workspace.tests": {
                FileObject file;
                String uri = ((JsonPrimitive)params.getArguments().get(0)).getAsString();
                try {
                    file = URLMapper.findFileObject((URL)new URL(uri));
                }
                catch (MalformedURLException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    return CompletableFuture.completedFuture(Collections.emptyList());
                }
                if (file == null) {
                    return CompletableFuture.completedFuture(Collections.emptyList());
                }
                return ((CompletableFuture)this.server.asyncOpenFileOwner(file).thenCompose(this::getTestRoots)).thenCompose(testRoots -> {
                    CompletableFuture future = new CompletableFuture();
                    JavaSource js = JavaSource.create((ClasspathInfo)ClasspathInfo.create((ClassPath)ClassPath.EMPTY, (ClassPath)ClassPath.EMPTY, (ClassPath)ClassPath.EMPTY), (FileObject[])new FileObject[0]);
                    try {
                        js.runWhenScanFinished(controller -> {
                            BiFunction<FileObject, Collection, Collection> f = (fo, methods) -> {
                                String url = Utils.toUri(fo);
                                LinkedHashMap<String, TestSuiteInfo> suite2infos = new LinkedHashMap<String, TestSuiteInfo>();
                                for (TestMethodController.TestMethod testMethod : methods) {
                                    TestSuiteInfo suite = suite2infos.computeIfAbsent(testMethod.getTestClassName(), name -> {
                                        Position pos = testMethod.getTestClassPosition() != null ? Utils.createPosition(fo, testMethod.getTestClassPosition().getOffset()) : null;
                                        return new TestSuiteInfo((String)name, url, pos != null ? new Range(pos, pos) : null, "loaded", (List<TestSuiteInfo.TestCaseInfo>)new ArrayList<TestSuiteInfo.TestCaseInfo>());
                                    });
                                    String id = testMethod.getTestClassName() + ':' + testMethod.method().getMethodName();
                                    Position startPos = testMethod.start() != null ? Utils.createPosition(fo, testMethod.start().getOffset()) : null;
                                    Position endPos = testMethod.end() != null ? Utils.createPosition(fo, testMethod.end().getOffset()) : startPos;
                                    Range range = startPos != null ? new Range(startPos, endPos) : null;
                                    suite.getTests().add(new TestSuiteInfo.TestCaseInfo(id, testMethod.method().getMethodName(), url, range, "loaded", null));
                                }
                                return suite2infos.values();
                            };
                            this.testMethodsListener.compareAndSet(null, (fo, methods) -> {
                                Logger.getLogger(WorkspaceServiceImpl.class.getName()).info("FileObject reindexed: " + fo.getPath());
                                try {
                                    for (TestSuiteInfo testSuiteInfo : (Collection)f.apply((FileObject)fo, (Collection)methods)) {
                                        this.client.notifyTestProgress(new TestProgressParams(Utils.toUri(fo), testSuiteInfo));
                                    }
                                }
                                catch (Exception e) {
                                    Logger.getLogger(WorkspaceServiceImpl.class.getName()).severe(e.getMessage());
                                    Exceptions.printStackTrace((Throwable)e);
                                    this.testMethodsListener.set(null);
                                }
                            });
                            Logger.getLogger(WorkspaceServiceImpl.class.getName()).info("Attaching listener: " + this.testMethodsListener.get());
                            Map testMethods = TestMethodFinder.findTestMethods((Iterable)testRoots, this.testMethodsListener.get());
                            ArrayList suites = new ArrayList(testMethods.size());
                            for (Map.Entry entry : testMethods.entrySet()) {
                                suites.addAll(f.apply((FileObject)entry.getKey(), (Collection)entry.getValue()));
                            }
                            future.complete(suites);
                        }, true);
                    }
                    catch (IOException ex) {
                        future.completeExceptionally(ex);
                    }
                    return future;
                });
            }
            case "java.super.implementation": {
                String uri = ((JsonPrimitive)params.getArguments().get(0)).getAsString();
                Position pos = (Position)this.gson.fromJson(this.gson.toJson(params.getArguments().get(1)), Position.class);
                return ((TextDocumentServiceImpl)this.server.getTextDocumentService()).superImplementations(uri, pos);
            }
            case "java.project.configurations": {
                FileObject file;
                String fileUri = ((JsonPrimitive)params.getArguments().get(0)).getAsString();
                try {
                    file = URLMapper.findFileObject((URL)new URL(fileUri));
                }
                catch (MalformedURLException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    return CompletableFuture.completedFuture(Collections.emptyList());
                }
                return this.findProjectConfigurations(file);
            }
            case "java.attachDebugger.configurations": {
                return AttachConfigurations.findConnectors();
            }
            case "java.attachDebugger.pickProcess": {
                return AttachConfigurations.findProcessAttachTo(this.client);
            }
            case "nativeImage.attachDebugger.pickProcess": {
                return AttachNativeConfigurations.findProcessAttachTo(this.client);
            }
            case "java.project.configuration.completion": {
                List<CompletableFuture> completionFutures;
                List arguments = params.getArguments();
                Collection configurations = Lookup.getDefault().lookupAll(LaunchConfigurationCompletion.class);
                String configUri = ((JsonPrimitive)arguments.get(0)).getAsString();
                Supplier<CompletableFuture> projectSupplier = () -> {
                    FileObject file;
                    try {
                        file = URLMapper.findFileObject((URL)new URL(configUri));
                    }
                    catch (MalformedURLException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                        return CompletableFuture.completedFuture(null);
                    }
                    return this.server.asyncOpenFileOwner(file);
                };
                switch (arguments.size()) {
                    case 1: {
                        completionFutures = configurations.stream().map(c -> c.configurations(projectSupplier)).collect(Collectors.toList());
                        break;
                    }
                    case 2: {
                        Map<String, Object> attributes = WorkspaceServiceImpl.attributesMap((JsonObject)arguments.get(1));
                        completionFutures = configurations.stream().map(c -> c.attributes(projectSupplier, attributes)).collect(Collectors.toList());
                        break;
                    }
                    case 3: {
                        Map<String, Object> attributes = WorkspaceServiceImpl.attributesMap((JsonObject)arguments.get(1));
                        String attribute = ((JsonPrimitive)arguments.get(2)).getAsString();
                        completionFutures = configurations.stream().map(c -> c.attributeValues(projectSupplier, attributes, attribute)).collect(Collectors.toList());
                        break;
                    }
                    default: {
                        StringBuilder classes = new StringBuilder();
                        for (int i = 0; i < arguments.size(); ++i) {
                            classes.append(arguments.get(i).getClass().toString());
                        }
                        throw new IllegalStateException("Wrong arguments(" + arguments.size() + "): " + arguments + ", classes = " + classes);
                    }
                }
                CompletionStage joinedFuture = CompletableFuture.allOf(completionFutures.toArray(new CompletableFuture[0])).thenApply(avoid -> completionFutures.stream().flatMap(c -> ((List)c.join()).stream()).collect(Collectors.toList()));
                return joinedFuture;
            }
        }
        for (CodeActionsProvider codeActionsProvider : Lookup.getDefault().lookupAll(CodeActionsProvider.class)) {
            if (!codeActionsProvider.getCommands().contains(command)) continue;
            return codeActionsProvider.processCommand(this.client, command, params.getArguments());
        }
        throw new UnsupportedOperationException("Command not supported: " + params.getCommand());
    }

    private static Map<String, Object> attributesMap(JsonObject json) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (Map.Entry entry : json.entrySet()) {
            JsonPrimitive jp = (JsonPrimitive)entry.getValue();
            Boolean value = jp.isBoolean() ? Boolean.valueOf(jp.getAsBoolean()) : (jp.isNumber() ? jp.getAsNumber() : jp.getAsString());
            map.put((String)entry.getKey(), value);
        }
        return map;
    }

    private CompletableFuture<Object> findProjectConfigurations(FileObject ownedFile) {
        return this.server.asyncOpenFileOwner(ownedFile).thenApply(p -> {
            if (p == null) {
                return CompletableFuture.completedFuture(Collections.emptyList());
            }
            ProjectConfigurationProvider provider = (ProjectConfigurationProvider)p.getLookup().lookup(ProjectConfigurationProvider.class);
            ArrayList<String> configDispNames = new ArrayList<String>();
            if (provider != null) {
                for (ProjectConfiguration c : provider.getConfigurations()) {
                    configDispNames.add(c.getDisplayName());
                }
            }
            return configDispNames;
        });
    }

    private CompletableFuture<List<FileObject>> getSourceRoots(String uri, String type) {
        FileObject file;
        try {
            file = URLMapper.findFileObject((URL)new URL(uri));
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        if (file == null) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        return this.server.asyncOpenFileOwner(file).thenApply(project -> {
            if (project != null) {
                ArrayList<FileObject> roots = new ArrayList<FileObject>();
                for (SourceGroup sourceGroup : ProjectUtils.getSources((Project)project).getSourceGroups(type)) {
                    roots.add(sourceGroup.getRootFolder());
                }
                return roots;
            }
            return Collections.emptyList();
        });
    }

    private CompletableFuture<Set<FileObject>> getTestRoots(Project prj) {
        HashSet<FileObject> testRoots = new HashSet<FileObject>();
        List contained = null;
        if (prj != null) {
            for (String sourceType : SOURCE_TYPES) {
                for (SourceGroup sg : ProjectUtils.getSources((Project)prj).getSourceGroups(sourceType)) {
                    if (!this.isTestGroup(sg)) continue;
                    testRoots.add(sg.getRootFolder());
                }
            }
            Set containedProjects = ProjectUtils.getContainedProjects((Project)prj, (boolean)true);
            if (containedProjects != null) {
                contained = containedProjects.stream().map(p -> p.getProjectDirectory()).collect(Collectors.toList());
            }
        }
        return this.server.asyncOpenSelectedProjects(contained).thenApply(projects -> {
            for (Project project : projects) {
                for (String sourceType : SOURCE_TYPES) {
                    for (SourceGroup sg : ProjectUtils.getSources((Project)project).getSourceGroups(sourceType)) {
                        if (!this.isTestGroup(sg)) continue;
                        testRoots.add(sg.getRootFolder());
                    }
                }
            }
            return testRoots;
        });
    }

    private boolean isTestGroup(SourceGroup sg) {
        return UnitTestForSourceQuery.findSources((FileObject)sg.getRootFolder()).length > 0;
    }

    public CompletableFuture<List<? extends SymbolInformation>> symbol(WorkspaceSymbolParams params) {
        if (this.server.openedProjects().getNow(null) == null) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        String query = params.getQuery();
        if (query.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        System.err.println("query=" + query);
        boolean exact = false;
        if (query.endsWith(" ")) {
            query = query.substring(0, query.length() - 1);
            exact = true;
        }
        String queryFin = query;
        boolean exactFin = exact;
        final AtomicBoolean cancel = new AtomicBoolean();
        CompletableFuture<List<? extends SymbolInformation>> result = new CompletableFuture<List<? extends SymbolInformation>>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                cancel.set(mayInterruptIfRunning);
                return super.cancel(mayInterruptIfRunning);
            }
        };
        WORKER.post(() -> {
            try {
                final ArrayList symbols = new ArrayList();
                SearchType searchType = WorkspaceServiceImpl.getSearchType(queryFin, exactFin, false, null, null);
                JavaSymbolProvider.ResultHandler symbolHandler = new JavaSymbolProvider.ResultHandler(){
                    private Map type2Idents;

                    public void setHighlightText(String text) {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void runRoot(FileObject root, ClassIndexImpl ci, JavaSymbolProvider.ResultHandler.Exec exec) throws IOException, InterruptedException {
                        ClasspathInfo cpInfo = ClasspathInfo.create((FileObject)root);
                        try {
                            this.type2Idents = new HashMap();
                            exec.run();
                            HashMap<FileObject, Map> sources = new HashMap<FileObject, Map>();
                            for (Map.Entry e : this.type2Idents.entrySet()) {
                                FileObject sourceFile = SourceUtils.getFile((ElementHandle)((ElementHandle)e.getKey()), (ClasspathInfo)cpInfo);
                                sources.computeIfAbsent(sourceFile, s -> new HashMap()).put((ElementHandle)e.getKey(), (List)e.getValue());
                            }
                            if (!sources.isEmpty()) {
                                JavaSource.create((ClasspathInfo)cpInfo, sources.keySet()).runUserActionTask(cc -> {
                                    if (JavaSource.Phase.ELEMENTS_RESOLVED.compareTo((Enum)cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED)) > 0) {
                                        return;
                                    }
                                    for (Map.Entry e : ((Map)sources.get(cc.getFileObject())).entrySet()) {
                                        TypeElement te = (TypeElement)((ElementHandle)e.getKey()).resolve((CompilationInfo)cc);
                                        if (te == null) continue;
                                        for (String ident : (List)e.getValue()) {
                                            TreePath path;
                                            if (ident.equals(WorkspaceServiceImpl.getSimpleName(te, null, false)) && (path = cc.getTrees().getPath(te)) != null) {
                                                String string = te.getSimpleName().toString();
                                                ElementKind kind = te.getKind();
                                                if (!kind.isClass() && !kind.isInterface()) {
                                                    SymbolInformation symbol = new SymbolInformation(string, Utils.elementKind2SymbolKind(kind), WorkspaceServiceImpl.this.tree2Location((CompilationInfo)cc, path), te.getQualifiedName().toString());
                                                    symbols.add(symbol);
                                                }
                                            }
                                            for (Element element : te.getEnclosedElements()) {
                                                TreePath path2;
                                                if (!ident.equals(WorkspaceServiceImpl.getSimpleName(element, te, false)) || (path2 = cc.getTrees().getPath(element)) == null) continue;
                                                Pair name = JavaSymbolProvider.getDisplayName((Element)element, (Element)te);
                                                String symbolName = (String)name.first() + (name.second() != null ? (String)name.second() : "");
                                                ElementKind kind = element.getKind();
                                                if (kind.isClass() || kind.isInterface()) continue;
                                                SymbolInformation symbol = new SymbolInformation(symbolName, Utils.elementKind2SymbolKind(kind), WorkspaceServiceImpl.this.tree2Location((CompilationInfo)cc, path2), te.getQualifiedName().toString());
                                                symbols.add(symbol);
                                            }
                                        }
                                    }
                                }, true);
                            }
                        }
                        finally {
                            this.type2Idents = null;
                        }
                    }

                    public void handleResult(ElementHandle<TypeElement> owner, String ident, boolean caseSensitive) {
                        this.type2Idents.computeIfAbsent(owner, s -> new ArrayList()).add(ident);
                    }
                };
                JavaSymbolProvider.doComputeSymbols((SearchType)searchType, (String)queryFin, (JavaSymbolProvider.ResultHandler)symbolHandler, (boolean)true, (AtomicBoolean)cancel);
                final ArrayList pairs = new ArrayList();
                JavaTypeProvider.ResultHandler<Pair<ElementHandle<TypeElement>, ClasspathInfo>> typeHandler = new JavaTypeProvider.ResultHandler<Pair<ElementHandle<TypeElement>, ClasspathInfo>>(){
                    private ClasspathInfo cpInfo;

                    public void setMessage(String msg) {
                    }

                    public void setHighlightText(String text) {
                    }

                    public void pendingResult() {
                    }

                    public void runRoot(FileObject root, JavaTypeProvider.ResultHandler.Exec exec) throws IOException, InterruptedException {
                        this.cpInfo = ClasspathInfo.create((FileObject)root);
                        try {
                            exec.run();
                        }
                        finally {
                            this.cpInfo = null;
                        }
                    }

                    public Pair<ElementHandle<TypeElement>, ClasspathInfo> create(JavaTypeProvider.CacheItem cacheItem, ElementHandle<TypeElement> handle, String simpleName, String relativePath) {
                        return Pair.of(handle, (Object)this.cpInfo);
                    }

                    public void addResult(List<? extends Pair<ElementHandle<TypeElement>, ClasspathInfo>> types) {
                        pairs.addAll(types);
                    }
                };
                JavaTypeProvider.doComputeTypes((SearchType)searchType, (String)queryFin, (JavaTypeProvider.ResultHandler)typeHandler, (AtomicBoolean)cancel);
                HashMap location2Handles = new HashMap();
                CompletableFuture[] futures = (CompletableFuture[])pairs.stream().map(pair -> {
                    CompletableFuture future = ElementOpen.getLocation((ClasspathInfo)((ClasspathInfo)pair.second()), (ElementHandle)((ElementHandle)pair.first()), (String)(((ElementHandle)pair.first()).getQualifiedName().replace('.', '/') + ".class"));
                    location2Handles.put(future, (ElementHandle)pair.first());
                    return future;
                }).toArray(CompletableFuture[]::new);
                CompletableFuture.allOf(futures).thenRun(() -> {
                    for (CompletableFuture future : futures) {
                        ElementOpen.Location loc = future.getNow(null);
                        ElementHandle handle = (ElementHandle)location2Handles.get(future);
                        if (loc == null || handle == null) continue;
                        FileObject fo = loc.getFileObject();
                        Location location = new Location(Utils.toUri(fo), new Range(Utils.createPosition(fo, loc.getStartOffset()), Utils.createPosition(fo, loc.getEndOffset())));
                        String fqn = handle.getQualifiedName();
                        int idx = fqn.lastIndexOf(46);
                        String simpleName = idx < 0 ? fqn : fqn.substring(idx + 1);
                        String contextName = idx < 0 ? null : fqn.substring(0, idx);
                        SymbolInformation symbol = new SymbolInformation(simpleName, Utils.elementKind2SymbolKind(handle.getKind()), location, contextName);
                        symbols.add(symbol);
                    }
                    Collections.sort(symbols, (i1, i2) -> i1.getName().compareToIgnoreCase(i2.getName()));
                    result.complete(symbols);
                });
            }
            catch (Throwable t) {
                result.completeExceptionally(t);
            }
        });
        return result;
    }

    private Location tree2Location(CompilationInfo info, TreePath path) {
        return new Location(Utils.toUri(info.getFileObject()), Utils.treeRange(info, path.getLeaf()));
    }

    public static int containsWildCard(String text) {
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) != '?' && text.charAt(i) != '*') continue;
            return i;
        }
        return -1;
    }

    public static boolean isAllUpper(String text) {
        for (int i = 0; i < text.length(); ++i) {
            if (Character.isUpperCase(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static SearchType getSearchType(@NonNull String text, boolean exact, boolean isCaseSensitive, @NullAllowed String camelCaseSeparator, @NullAllowed String camelCasePart) {
        int wildcard = WorkspaceServiceImpl.containsWildCard(text);
        if (exact) {
            return SearchType.EXACT_NAME;
        }
        if (wildcard != -1) {
            return isCaseSensitive ? SearchType.REGEXP : SearchType.CASE_INSENSITIVE_REGEXP;
        }
        if (WorkspaceServiceImpl.isAllUpper(text) && text.length() > 1 || Queries.isCamelCase((String)text, (String)camelCaseSeparator, (String)camelCasePart)) {
            return isCaseSensitive ? SearchType.CAMEL_CASE : SearchType.CASE_INSENSITIVE_CAMEL_CASE;
        }
        return isCaseSensitive ? SearchType.PREFIX : SearchType.CASE_INSENSITIVE_PREFIX;
    }

    @NonNull
    private static String getSimpleName(@NonNull Element element, @NullAllowed Element enclosingElement, boolean caseSensitive) {
        String result = element.getSimpleName().toString();
        if (enclosingElement != null && INIT.equals(result)) {
            result = enclosingElement.getSimpleName().toString();
        }
        if (!caseSensitive) {
            result = result.toLowerCase();
        }
        return result;
    }

    public void didChangeConfiguration(DidChangeConfigurationParams arg0) {
    }

    public void didChangeWatchedFiles(DidChangeWatchedFilesParams arg0) {
    }

    public void connect(LanguageClient client) {
        this.client = (NbCodeLanguageClient)client;
    }

    private static final class CommandProgress
    extends ActionProgress {
        private final CompletableFuture<Object> commandFinished = new CompletableFuture();
        private int running;
        private int success;
        private int failure;

        private CommandProgress() {
        }

        protected synchronized void started() {
            ++this.running;
            ((Object)((Object)this)).notify();
        }

        public synchronized void finished(boolean ok) {
            if (ok) {
                ++this.success;
            } else {
                ++this.failure;
            }
            this.checkStatus();
        }

        final synchronized void checkStatus() {
            if (this.running == 0) {
                try {
                    ((Object)((Object)this)).wait(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.running <= this.success + this.failure) {
                this.commandFinished.complete(this.failure == 0);
            }
        }

        CompletableFuture<Object> getFinishFuture() {
            return this.commandFinished;
        }
    }
}

