/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints.ui;

import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import org.netbeans.lib.profiler.ui.components.LazyComboBox;
import org.netbeans.modules.profiler.api.ProjectUtilities;
import org.netbeans.modules.profiler.api.project.ProjectProfilingSupport;
import org.openide.util.Lookup;

class ProjectSelector
extends LazyComboBox<Lookup.Provider> {
    private static final Lookup.Provider EXTRA_ITEM = new Lookup.Provider(){

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }
    };

    ProjectSelector(String extraItemName) {
        super((LazyComboBox.Populator)new Populator());
        this.setRenderer(new ProjectNameRenderer(extraItemName));
    }

    final Lookup.Provider getProject() {
        Lookup.Provider project = (Lookup.Provider)this.getSelectedItem();
        return project == EXTRA_ITEM ? null : project;
    }

    final void setProject(Lookup.Provider project) {
        if (project != null && !ProjectProfilingSupport.get((Lookup.Provider)project).areProfilingPointsSupported()) {
            project = null;
        }
        this.setSelectedItem(project == null ? EXTRA_ITEM : project);
    }

    void resetProject(Lookup.Provider project) {
        if (this.getProject() == project) {
            this.resetModel();
        }
    }

    private static final class ProjectNameRenderer
    extends DefaultListCellRenderer {
        private Font _plainFont;
        private Font _boldFont;
        private Renderer _renderer;
        private final String extraItemName;

        ProjectNameRenderer(String extraItemName) {
            this.extraItemName = extraItemName;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel renderer = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (this._renderer == null) {
                this._renderer = new Renderer();
            }
            this._renderer.setComponentOrientation(renderer.getComponentOrientation());
            this._renderer.setOpaque(renderer.isOpaque());
            this._renderer.setForeground(renderer.getForeground());
            this._renderer.setBackground(renderer.getBackground());
            this._renderer.setEnabled(renderer.isEnabled());
            this._renderer.setBorder(renderer.getBorder());
            if (value != EXTRA_ITEM) {
                Lookup.Provider p = (Lookup.Provider)value;
                this._renderer.setText(ProjectUtilities.getDisplayName((Lookup.Provider)p));
                this._renderer.setIcon(ProjectUtilities.getIcon((Lookup.Provider)p));
                boolean main = ProjectUtilities.getMainProject() == value;
                this._renderer.setFontEx(main ? this.boldFont(renderer) : this.plainFont(renderer));
            } else {
                this._renderer.setText(this.extraItemName);
                this._renderer.setIcon(null);
                this._renderer.setFontEx(this.plainFont(renderer));
            }
            return this._renderer;
        }

        private Font plainFont(JLabel renderer) {
            if (this._plainFont == null) {
                this._plainFont = renderer.getFont().deriveFont(0);
            }
            return this._plainFont;
        }

        private Font boldFont(JLabel renderer) {
            if (this._boldFont == null) {
                this._boldFont = renderer.getFont().deriveFont(1);
            }
            return this._boldFont;
        }

        private static class Renderer
        extends DefaultListCellRenderer {
            private Renderer() {
            }

            @Override
            public void setFont(Font font) {
            }

            public void setFontEx(Font font) {
                super.setFont(font);
            }
        }
    }

    static class Populator
    extends LazyComboBox.Populator<Lookup.Provider> {
        Populator() {
        }

        protected Lookup.Provider initialProject() {
            return null;
        }

        protected Collection<Lookup.Provider> additionalProjects() {
            return Collections.EMPTY_SET;
        }

        protected final Lookup.Provider initial() {
            Lookup.Provider initial = this.initialProject();
            return initial == null ? EXTRA_ITEM : initial;
        }

        protected final Lookup.Provider[] populate() {
            HashSet<Lookup.Provider> s = new HashSet<Lookup.Provider>();
            for (Lookup.Provider project : ProjectUtilities.getOpenedProjects()) {
                if (!ProjectProfilingSupport.get((Lookup.Provider)project).areProfilingPointsSupported()) continue;
                s.add(project);
            }
            for (Lookup.Provider project : this.additionalProjects()) {
                if (!ProjectProfilingSupport.get((Lookup.Provider)project).areProfilingPointsSupported()) continue;
                s.add(project);
            }
            ArrayList<Lookup.Provider> l = new ArrayList<Lookup.Provider>();
            Lookup.Provider[] pa = s.toArray(new Lookup.Provider[0]);
            l.add(EXTRA_ITEM);
            l.addAll(Arrays.asList(ProjectUtilities.getSortedProjects((Lookup.Provider[])pa)));
            return l.toArray(new Lookup.Provider[0]);
        }
    }
}

