/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jdk;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.Set;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.jdk.Bundle;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.netbeans.spi.java.hints.MatcherUtilities;

public class ConvertToSwitchPatternInstanceOf {
    public static ErrorDescription trivial(HintContext ctx) {
        TreePath parent = ctx.getPath().getParentPath();
        if (parent.getLeaf().getKind() == Tree.Kind.IF) {
            return null;
        }
        Tree ifPath = ctx.getPath().getLeaf();
        Name expr0 = ((IdentifierTree)((TreePath)ctx.getVariables().get("$expr0")).getLeaf()).getName();
        int matchVarIndex = 1;
        while (ifPath != null && ifPath.getKind() == Tree.Kind.IF) {
            IfTree it = (IfTree)ifPath;
            if (MatcherUtilities.matches((HintContext)ctx, (TreePath)new TreePath(ctx.getPath(), it.getCondition()), (String)("($expr" + ++matchVarIndex + " instanceof $typeI" + matchVarIndex + ")"), (boolean)true) && MatcherUtilities.matches((HintContext)ctx, (TreePath)new TreePath(ctx.getPath(), it.getThenStatement()), (String)("{ $typeV" + matchVarIndex + " $var" + matchVarIndex + " = ($typeC" + matchVarIndex + ") $expr" + matchVarIndex + "; $other" + matchVarIndex + "$;}"), (boolean)true)) {
                if (!((IdentifierTree)((TreePath)ctx.getVariables().get("$expr" + matchVarIndex)).getLeaf()).getName().equals(expr0)) {
                    return null;
                }
                for (TreePath tp : (Collection)ctx.getMultiVariables().get("$other" + matchVarIndex + "$")) {
                    if (tp.getLeaf().getKind() != Tree.Kind.BREAK && tp.getLeaf().getKind() != Tree.Kind.CONTINUE) continue;
                    return null;
                }
                TypeMirror typeI = ctx.getInfo().getTrees().getTypeMirror((TreePath)ctx.getVariables().get("$typeI" + matchVarIndex + ""));
                TypeMirror typeC = ctx.getInfo().getTrees().getTypeMirror((TreePath)ctx.getVariables().get("$typeC" + matchVarIndex + ""));
                if (!ctx.getInfo().getTypes().isSameType(typeI, typeC)) {
                    System.err.println("different types (" + typeI + ", " + typeC + ") in " + ctx.getInfo().getFileObject());
                    return null;
                }
            } else {
                return null;
            }
            ifPath = it.getElseStatement();
        }
        if (ifPath != null && ifPath.getKind() == Tree.Kind.BLOCK) {
            Fix fix = new FixImpl(ctx.getInfo(), ctx.getPath(), true, Collections.emptySet()).toEditorFix();
            return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)Bundle.ERR_ConvertToSwitchPatternInstanceOf(), (Fix[])new Fix[]{fix});
        }
        return null;
    }

    private static boolean isValidCaseTree(Tree tree) {
        return tree instanceof BlockTree || tree instanceof ExpressionStatementTree || tree instanceof ThrowTree || tree instanceof CaseTree;
    }

    private static final class FixImpl
    extends JavaFix {
        private final boolean removeFirst;

        public FixImpl(CompilationInfo info, TreePath main, boolean removeFirst, Set<TreePath> replaceOccurrences) {
            super(info, main);
            this.removeFirst = removeFirst;
        }

        protected String getText() {
            return Bundle.FIX_ConvertToSwitchPatternInstanceOf();
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) {
            WorkingCopy wc = ctx.getWorkingCopy();
            TreePath main = ctx.getPath();
            LinkedList<CaseTree> ctl = new LinkedList<CaseTree>();
            Tree ifPath = ctx.getPath().getLeaf();
            int matchVarIndex = 1;
            ArrayList<IfTree> ifTrees = new ArrayList<IfTree>();
            while (ifPath != null && ifPath.getKind() == Tree.Kind.IF) {
                ++matchVarIndex;
                IfTree it = (IfTree)ifPath;
                ifTrees.add(it);
                ifPath = it.getElseStatement();
            }
            InstanceOfTree iot = null;
            for (IfTree ifTree : ifTrees) {
                LinkedList<Tree> caseBindPattern = new LinkedList<Tree>();
                iot = (InstanceOfTree)((ParenthesizedTree)ifTree.getCondition()).getExpression();
                StatementTree bt = ifTree.getThenStatement();
                VariableTree var = (VariableTree)((BlockTree)bt).getStatements().get(0);
                StatementTree thenBlock = this.removeFirst ? wc.getTreeMaker().removeBlockStatement((BlockTree)bt, 0) : bt;
                caseBindPattern.add(wc.getTreeMaker().BindingPattern(wc.getTreeMaker().Variable(wc.getTreeMaker().Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)var.getName().toString(), iot.getType(), null)));
                BlockTree blockTree = (BlockTree)thenBlock;
                StatementTree defaultTree = null;
                defaultTree = blockTree.getStatements().size() == 1 && ConvertToSwitchPatternInstanceOf.isValidCaseTree(blockTree.getStatements().get(0)) ? (Tree)blockTree.getStatements().get(0) : thenBlock;
                CaseTree casePatterns = wc.getTreeMaker().CasePatterns(caseBindPattern, (Tree)defaultTree);
                ctl.add(casePatterns);
            }
            LinkedList<IdentifierTree> caseDefaultLabel = new LinkedList<IdentifierTree>();
            caseDefaultLabel.add(wc.getTreeMaker().Identifier((CharSequence)"default"));
            BlockTree elseTree = (BlockTree)ifPath;
            if (elseTree == null) {
                elseTree = wc.getTreeMaker().Block(new ArrayList(), false);
            }
            BlockTree defaultTree = elseTree.getStatements().size() == 1 && ConvertToSwitchPatternInstanceOf.isValidCaseTree(elseTree.getStatements().get(0)) ? (Tree)elseTree.getStatements().get(0) : elseTree;
            CaseTree casePatterns = wc.getTreeMaker().CasePatterns(caseDefaultLabel, (Tree)defaultTree);
            ctl.add(casePatterns);
            wc.rewrite((Tree)((IfTree)main.getLeaf()), (Tree)wc.getTreeMaker().Switch(iot.getExpression(), ctl));
        }
    }
}

