/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.request;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.springframework.mock.web.MockMultipartHttpServletRequest;
import org.springframework.test.web.servlet.request.MockAsyncContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Servlet3MockMultipartHttpServletRequest
extends MockMultipartHttpServletRequest {
    private boolean asyncStarted;
    private MockAsyncContext asyncContext;
    private Map<String, Part> parts = new HashMap<String, Part>();

    Servlet3MockMultipartHttpServletRequest() {
    }

    public boolean isAsyncSupported() {
        return true;
    }

    public AsyncContext startAsync() {
        return this.startAsync((ServletRequest)this, null);
    }

    public AsyncContext startAsync(ServletRequest request, ServletResponse response) {
        this.asyncStarted = true;
        this.asyncContext = new MockAsyncContext(request, response);
        return this.asyncContext;
    }

    public AsyncContext getAsyncContext() {
        return this.asyncContext;
    }

    public void setAsyncContext(MockAsyncContext asyncContext) {
        this.asyncContext = asyncContext;
    }

    public DispatcherType getDispatcherType() {
        return DispatcherType.REQUEST;
    }

    public boolean isAsyncStarted() {
        return this.asyncStarted;
    }

    public void setAsyncStarted(boolean asyncStarted) {
        this.asyncStarted = asyncStarted;
    }

    public void addPart(Part part) {
        this.parts.put(part.getName(), part);
    }

    public Part getPart(String key) throws IOException, IllegalStateException, ServletException {
        return this.parts.get(key);
    }

    public Collection<Part> getParts() throws IOException, IllegalStateException, ServletException {
        return this.parts.values();
    }

    @Override
    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        throw new UnsupportedOperationException();
    }
}

