/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.netbeans.lib.profiler.heap.File;

class CacheDirectory {
    private static final String DIR_EXT = ".hwcache";
    private static final String DUMP_AUX_FILE = "NBProfiler.nphd";
    private final File.Factory io;
    private File cacheDirectory;

    static CacheDirectory getHeapDumpCacheDirectory(File.Factory io, File heapDump) {
        String dumpName = heapDump.getName();
        File parent = heapDump.getParentFile();
        File dir = io.newFile(parent, dumpName + DIR_EXT);
        return new CacheDirectory(io, dir);
    }

    CacheDirectory(File.Factory io, File cacheDir) {
        io.getClass();
        this.io = io;
        this.cacheDirectory = cacheDir;
        if (cacheDir != null && !cacheDir.exists() && !cacheDir.mkdir()) {
            this.cacheDirectory = null;
        }
        if (this.cacheDirectory != null) assert (this.cacheDirectory.isDirectory() && this.cacheDirectory.canRead() && this.cacheDirectory.canWrite());
    }

    File createTempFile(String prefix, String suffix) throws IOException {
        File newFile;
        if (this.isTemporary()) {
            newFile = this.io.createTempFile(prefix, suffix, null);
            newFile.deleteOnExit();
        } else {
            newFile = this.io.createTempFile(prefix, suffix, this.cacheDirectory);
        }
        return newFile;
    }

    File getHeapDumpAuxFile() {
        assert (!this.isTemporary());
        return this.io.newFile(this.cacheDirectory, DUMP_AUX_FILE);
    }

    boolean isTemporary() {
        return this.cacheDirectory == null;
    }

    File getCacheFile(String fileName) throws FileNotFoundException {
        File f = this.io.newFile(fileName);
        if (CacheDirectory.isFileRW(f)) {
            return f;
        }
        if (CacheDirectory.isFileRW(f = this.io.newFile(this.cacheDirectory, f.getName()))) {
            return f;
        }
        throw new FileNotFoundException(fileName);
    }

    File getHeapFile(String fileName) throws FileNotFoundException {
        File f = this.io.newFile(fileName);
        if (CacheDirectory.isFileR(f)) {
            return f;
        }
        f = this.io.newFile(this.cacheDirectory.getParentFile(), f.getName());
        if (CacheDirectory.isFileR(f)) {
            return f;
        }
        throw new FileNotFoundException(fileName);
    }

    private static boolean isFileR(File f) {
        return f.exists() && f.isFile() && f.canRead();
    }

    private static boolean isFileRW(File f) {
        return CacheDirectory.isFileR(f) && f.canWrite();
    }
}

