/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.openide.util.Parameters;

public final class EditableProperties
extends AbstractMap<String, String>
implements Cloneable {
    private State state;
    private final boolean alphabetize;
    private static final String INDENT = "    ";
    private static final int WAITING_FOR_KEY_VALUE = 1;
    private static final int READING_KEY_VALUE = 2;

    public EditableProperties(boolean alphabetize) {
        this.alphabetize = alphabetize;
        this.state = new State();
    }

    private EditableProperties(EditableProperties ep) {
        this.alphabetize = ep.alphabetize;
        this.state = ep.state;
        this.state.shared = true;
    }

    private void writeOperation() {
        if (this.state.shared) {
            this.state = new State(this.state);
        }
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return new SetImpl();
    }

    public void load(InputStream stream) throws IOException {
        String line;
        int parseState = 1;
        BufferedReader input = new BufferedReader(new InputStreamReader(stream, "ISO-8859-1"));
        LinkedList<String> tempList = new LinkedList<String>();
        int commentLinesCount = 0;
        while (null != (line = input.readLine())) {
            tempList.add(line);
            boolean empty = EditableProperties.isEmpty(line);
            boolean comment = EditableProperties.isComment(line);
            if (parseState == 1) {
                if (empty) {
                    this.createNonKeyItem(tempList);
                    commentLinesCount = 0;
                } else if (comment) {
                    ++commentLinesCount;
                } else {
                    parseState = 2;
                }
            }
            if (parseState != 2 || this.isContinue(line)) continue;
            this.createKeyItem(tempList, commentLinesCount);
            parseState = 1;
            commentLinesCount = 0;
        }
        if (tempList.size() > 0) {
            if (parseState == 2) {
                this.createKeyItem(tempList, commentLinesCount);
            } else {
                this.createNonKeyItem(tempList);
            }
        }
    }

    public void store(OutputStream stream) throws IOException {
        boolean previousLineWasEmpty = true;
        BufferedWriter output = new BufferedWriter(new OutputStreamWriter(stream, "ISO-8859-1"));
        for (Item item : this.state.items) {
            if (item.isSeparate() && !previousLineWasEmpty) {
                output.newLine();
            }
            String line2 = null;
            for (String line2 : item.getRawData()) {
                output.write(line2);
                output.newLine();
            }
            if (line2 == null) continue;
            previousLineWasEmpty = EditableProperties.isEmpty(line2);
        }
        output.flush();
    }

    @Override
    public String get(Object key) {
        if (!(key instanceof String)) {
            return null;
        }
        Item item = this.state.itemIndex.get((String)key);
        return item != null ? item.getValue() : null;
    }

    @Override
    public String put(String key, String value) {
        Parameters.notNull("key", key);
        Parameters.notNull(key, value);
        this.writeOperation();
        Item item = this.state.itemIndex.get(key);
        String result = null;
        if (item != null) {
            result = item.getValue();
            item.setValue(value);
        } else {
            item = new Item(key, value);
            this.addItem(item, this.alphabetize);
        }
        return result;
    }

    public String getProperty(String key) {
        return this.get(key);
    }

    public String setProperty(String key, String value) {
        return this.put(key, value);
    }

    public String setProperty(String key, String[] value) {
        String result = this.get(key);
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        List<String> valueList = Arrays.asList(value);
        this.writeOperation();
        Item item = this.state.itemIndex.get(key);
        if (item != null) {
            item.setValue(valueList);
        } else {
            this.addItem(new Item(key, valueList), this.alphabetize);
        }
        return result;
    }

    public String[] getComment(String key) {
        Item item = this.state.itemIndex.get(key);
        if (item == null) {
            return new String[0];
        }
        return item.getComment();
    }

    public void setComment(String key, String[] comment, boolean separate) {
        this.writeOperation();
        Item item = this.state.itemIndex.get(key);
        if (item == null) {
            throw new IllegalArgumentException("Cannot set comment for non-existing property " + key);
        }
        item.setComment(comment, separate);
    }

    @Override
    public Object clone() {
        return this.cloneProperties();
    }

    public EditableProperties cloneProperties() {
        return new EditableProperties(this);
    }

    private void createNonKeyItem(List<String> lines) {
        Item item;
        this.writeOperation();
        if (!this.state.items.isEmpty() && (item = this.state.items.getLast()).getKey() == null) {
            item.addCommentLines(lines);
            lines.clear();
            return;
        }
        item = new Item(lines);
        this.addItem(item, false);
        lines.clear();
    }

    private void createKeyItem(List<String> lines, int commentLinesCount) {
        Item item = new Item(lines.subList(0, commentLinesCount), lines.subList(commentLinesCount, lines.size()));
        this.addItem(item, false);
        lines.clear();
    }

    private void addItem(Item item, boolean sort) {
        this.writeOperation();
        String key = item.getKey();
        if (sort) {
            assert (key != null);
            ListIterator<Item> it = this.state.items.listIterator();
            while (it.hasNext()) {
                String k = ((Item)it.next()).getKey();
                if (k == null || k.compareToIgnoreCase(key) <= 0) continue;
                it.previous();
                it.add(item);
                this.state.itemIndex.put(key, item);
                return;
            }
        }
        this.state.items.add(item);
        if (key != null) {
            this.state.itemIndex.put(key, item);
        }
    }

    private boolean isContinue(String line) {
        int slashCount = 0;
        for (int index = line.length() - 1; index >= 0 && line.charAt(index) == '\\'; --index) {
            ++slashCount;
        }
        return slashCount % 2 != 0;
    }

    private static boolean isComment(String line) {
        if ((line = EditableProperties.trimLeft(line)).length() > 0) {
            switch (line.charAt(0)) {
                case '!': 
                case '#': {
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isEmpty(String line) {
        return EditableProperties.trimLeft(line).length() == 0;
    }

    private static String trimLeft(String line) {
        int start;
        int len = line.length();
        block3: for (start = 0; start < len; ++start) {
            switch (line.charAt(start)) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
            }
            break;
        }
        return line.substring(start);
    }

    private class MapEntryImpl
    implements Map.Entry<String, String> {
        private Item item;

        public MapEntryImpl(Item item) {
            this.item = item;
        }

        @Override
        public String getKey() {
            return this.item.getKey();
        }

        @Override
        public String getValue() {
            return this.item.getValue();
        }

        @Override
        public String setValue(String value) {
            EditableProperties.this.writeOperation();
            this.item = ((EditableProperties)EditableProperties.this).state.itemIndex.get(this.item.getKey());
            String result = this.item.getValue();
            this.item.setValue(value);
            return result;
        }
    }

    private class IteratorImpl
    implements Iterator<Map.Entry<String, String>> {
        private ListIterator<Item> delegate;

        public IteratorImpl() {
            this.delegate = ((EditableProperties)EditableProperties.this).state.items.listIterator();
        }

        @Override
        public boolean hasNext() {
            return this.findNext() != null;
        }

        @Override
        public Map.Entry<String, String> next() {
            Item item = this.findNext();
            if (item == null) {
                throw new NoSuchElementException();
            }
            this.delegate.next();
            return new MapEntryImpl(item);
        }

        @Override
        public void remove() {
            this.delegate.previous();
            Item item = this.findNext();
            if (item == null) {
                throw new IllegalStateException();
            }
            int index = this.delegate.nextIndex();
            EditableProperties.this.writeOperation();
            Item removed = ((EditableProperties)EditableProperties.this).state.items.remove(index);
            assert (removed.getKey().equals(item.getKey()));
            ((EditableProperties)EditableProperties.this).state.itemIndex.remove(item.getKey());
            this.delegate = ((EditableProperties)EditableProperties.this).state.items.listIterator(index);
        }

        private Item findNext() {
            while (this.delegate.hasNext()) {
                Item item = this.delegate.next();
                if (item.getKey() == null || item.getValue() == null) continue;
                this.delegate.previous();
                return item;
            }
            return null;
        }
    }

    private class SetImpl
    extends AbstractSet<Map.Entry<String, String>> {
        @Override
        public Iterator<Map.Entry<String, String>> iterator() {
            return new IteratorImpl();
        }

        @Override
        public int size() {
            return ((EditableProperties)EditableProperties.this).state.itemIndex.size();
        }
    }

    private static class Item
    implements Cloneable {
        private static List<String> EMPTY_LIST = Collections.emptyList();
        private List<String> commentLines;
        private List<String> keyValueLines;
        private String key;
        private String value;
        private boolean separate;

        private Item() {
        }

        public Item(List<String> commentLines) {
            this.commentLines = commentLines.isEmpty() ? EMPTY_LIST : new ArrayList<String>(commentLines);
        }

        public Item(List<String> commentLines, List<String> keyValueLines) {
            this.commentLines = commentLines.isEmpty() ? EMPTY_LIST : new ArrayList<String>(commentLines);
            this.keyValueLines = keyValueLines.isEmpty() ? EMPTY_LIST : new ArrayList<String>(keyValueLines);
            this.parse(keyValueLines);
        }

        public Item(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public Item(String key, List<String> value) {
            this.key = key;
            this.setValue(value);
        }

        void addCommentLines(List<String> lines) {
            assert (this.key == null);
            if (this.commentLines == EMPTY_LIST) {
                if (!lines.isEmpty()) {
                    this.commentLines = new ArrayList<String>(lines);
                }
            } else {
                this.commentLines.addAll(lines);
            }
        }

        public String[] getComment() {
            String[] res = new String[this.commentLines.size()];
            for (int i = 0; i < res.length; ++i) {
                res[i] = Item.decodeUnicode(this.commentLines.get(i));
            }
            return res;
        }

        public void setComment(String[] commentLines, boolean separate) {
            this.separate = separate;
            if (commentLines.length > 0) {
                this.commentLines = new ArrayList<String>(commentLines.length);
                for (int i = 0; i < commentLines.length; ++i) {
                    this.commentLines.add(Item.encodeUnicode(commentLines[i]));
                }
            } else {
                this.commentLines = EMPTY_LIST;
            }
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
            this.keyValueLines = null;
        }

        public void setValue(List<String> value) {
            StringBuilder val = new StringBuilder();
            ArrayList<String> l = new ArrayList<String>();
            if (!value.isEmpty()) {
                l.add(Item.encode(this.key, true) + "=\\");
                Iterator<String> it = value.iterator();
                while (it.hasNext()) {
                    String s = it.next();
                    val.append(s);
                    s = Item.encode(s, false);
                    l.add(it.hasNext() ? EditableProperties.INDENT + s + '\\' : EditableProperties.INDENT + s);
                }
            } else {
                l.add(Item.encode(this.key, true) + '=');
            }
            this.value = val.toString();
            this.keyValueLines = l.isEmpty() ? EMPTY_LIST : l;
        }

        public boolean isSeparate() {
            return this.separate;
        }

        public List<String> getRawData() {
            ArrayList<String> l = new ArrayList<String>();
            if (this.commentLines != null) {
                l.addAll(this.commentLines);
            }
            if (this.keyValueLines == null) {
                this.keyValueLines = new ArrayList<String>();
                if (this.key != null && this.value != null) {
                    this.keyValueLines.add(Item.encode(this.key, true) + "=" + Item.encode(this.value, false));
                }
            }
            l.addAll(this.keyValueLines);
            return l;
        }

        private void parse(List<String> keyValueLines) {
            String line = Item.mergeLines(keyValueLines);
            this.splitKeyValue(line);
        }

        private static String mergeLines(List<String> lines) {
            if (lines.size() == 1) {
                return EditableProperties.trimLeft(lines.get(0));
            }
            StringBuilder line = new StringBuilder();
            Iterator<String> it = lines.iterator();
            while (it.hasNext()) {
                String l = EditableProperties.trimLeft(it.next());
                if (it.hasNext()) {
                    assert (l.endsWith("\\")) : lines;
                    l = l.substring(0, l.length() - 1);
                }
                line.append(l);
            }
            return line.toString();
        }

        private void splitKeyValue(String line) {
            int separatorIndex;
            int len = line.length();
            block6: for (separatorIndex = 0; separatorIndex < len; ++separatorIndex) {
                char ch = line.charAt(separatorIndex);
                if (ch == '\\') {
                    ++separatorIndex;
                    continue;
                }
                switch (ch) {
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': 
                    case ':': 
                    case '=': {
                        break block6;
                    }
                    default: {
                        continue block6;
                    }
                }
            }
            this.key = Item.decode(line.substring(0, separatorIndex));
            if ((line = EditableProperties.trimLeft(line.substring(separatorIndex))).length() == 0) {
                this.value = "";
                return;
            }
            switch (line.charAt(0)) {
                case ':': 
                case '=': {
                    line = EditableProperties.trimLeft(line.substring(1));
                }
            }
            this.value = Item.decode(line);
        }

        private static String decode(String input) {
            if (input.indexOf(92) == -1) {
                return input;
            }
            int len = input.length();
            StringBuilder output = new StringBuilder(len);
            for (int x = 0; x < len; ++x) {
                int ch = input.charAt(x);
                if (ch != 92) {
                    output.append((char)ch);
                    continue;
                }
                if (++x == len) continue;
                ch = input.charAt(x);
                if (ch == 117) {
                    if (x + 5 > len) {
                        output.append(input.substring(x - 1));
                        x += 4;
                        continue;
                    }
                    String val = input.substring(x + 1, x + 5);
                    try {
                        output.append((char)Integer.parseInt(val, 16));
                    }
                    catch (NumberFormatException e) {
                        output.append(input.substring(x - 1, x + 5));
                    }
                    x += 4;
                    continue;
                }
                if (ch == 116) {
                    ch = 9;
                } else if (ch == 114) {
                    ch = 13;
                } else if (ch == 110) {
                    ch = 10;
                } else if (ch == 102) {
                    ch = 12;
                }
                output.append((char)ch);
            }
            return output.toString();
        }

        private static String encode(String input, boolean forKey) {
            int len = input.length();
            StringBuilder output = new StringBuilder(len * 2);
            block10: for (int x = 0; x < len; ++x) {
                char ch = input.charAt(x);
                switch (ch) {
                    case ' ': {
                        if (x == 0 || forKey) {
                            output.append('\\');
                        }
                        output.append(ch);
                        continue block10;
                    }
                    case '#': {
                        if (x == 0) {
                            output.append('\\');
                        }
                        output.append(ch);
                        continue block10;
                    }
                    case '\\': {
                        output.append("\\\\");
                        continue block10;
                    }
                    case '\t': {
                        output.append("\\t");
                        continue block10;
                    }
                    case '\n': {
                        output.append("\\n");
                        continue block10;
                    }
                    case '\r': {
                        output.append("\\r");
                        continue block10;
                    }
                    case '\f': {
                        output.append("\\f");
                        continue block10;
                    }
                    case ':': 
                    case '=': {
                        if (forKey) {
                            output.append('\\');
                        }
                        output.append(ch);
                        continue block10;
                    }
                    default: {
                        if (ch < ' ' || ch > '~') {
                            output.append("\\u");
                            String hex = Integer.toHexString(ch);
                            for (int i = 0; i < 4 - hex.length(); ++i) {
                                output.append('0');
                            }
                            output.append(hex);
                            continue block10;
                        }
                        output.append(ch);
                    }
                }
            }
            return output.toString();
        }

        private static String decodeUnicode(String input) {
            int len = input.length();
            StringBuilder output = new StringBuilder(len);
            for (int x = 0; x < len; ++x) {
                char ch = input.charAt(x);
                if (ch != '\\') {
                    output.append(ch);
                    continue;
                }
                if (++x == len) continue;
                ch = input.charAt(x);
                if (ch == 'u') {
                    if (x + 5 > len) {
                        output.append(input.substring(x - 1));
                        x += 4;
                        continue;
                    }
                    String val = input.substring(x + 1, x + 5);
                    try {
                        output.append((char)Integer.parseInt(val, 16));
                    }
                    catch (NumberFormatException e) {
                        output.append(input.substring(x - 1, x + 5));
                    }
                    x += 4;
                    continue;
                }
                output.append(ch);
            }
            return output.toString();
        }

        private static String encodeUnicode(String input) {
            int len = input.length();
            StringBuilder output = new StringBuilder(len * 2);
            for (int x = 0; x < len; ++x) {
                char ch = input.charAt(x);
                if (ch < ' ' || ch > '~') {
                    output.append("\\u");
                    String hex = Integer.toHexString(ch);
                    for (int i = 0; i < 4 - hex.length(); ++i) {
                        output.append('0');
                    }
                    output.append(hex);
                    continue;
                }
                output.append(ch);
            }
            return output.toString();
        }

        public Object clone() {
            Item item = new Item();
            if (this.keyValueLines != null) {
                ArrayList<String> arrayList = item.keyValueLines = this.keyValueLines.isEmpty() ? EMPTY_LIST : new ArrayList<String>(this.keyValueLines);
            }
            if (this.commentLines != null) {
                item.commentLines = this.commentLines.isEmpty() ? EMPTY_LIST : new ArrayList<String>(this.commentLines);
            }
            item.key = this.key;
            item.value = this.value;
            item.separate = this.separate;
            return item;
        }
    }

    private static class State {
        boolean shared;
        final LinkedList<Item> items = new LinkedList();
        final Map<String, Item> itemIndex;

        State() {
            this.itemIndex = new HashMap<String, Item>();
        }

        State(State original) {
            this.itemIndex = new HashMap<String, Item>(original.items.size() * 4 / 3 + 1);
            for (Item _i : original.items) {
                Item i = (Item)_i.clone();
                this.items.add(i);
                if (i.getKey() == null) continue;
                this.itemIndex.put(i.getKey(), i);
            }
        }
    }
}

