/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.spi.DeploymentManager;
import org.netbeans.modules.j2ee.deployment.plugins.spi.AntDeploymentProvider;
import org.netbeans.modules.tomcat5.deploy.TomcatManager;
import org.netbeans.modules.tomcat5.util.TomcatProperties;
import org.openide.filesystems.FileUtil;

public class AntDeploymentProviderImpl
implements AntDeploymentProvider {
    private final TomcatManager tm;
    private static final Logger LOGGER = Logger.getLogger(AntDeploymentProviderImpl.class.getName());

    public AntDeploymentProviderImpl(DeploymentManager dm) {
        this.tm = (TomcatManager)dm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDeploymentScript(OutputStream os, Object moduleType) throws IOException {
        String name = null;
        switch (this.tm.getTomcatVersion()) {
            case TOMCAT_110: 
            case TOMCAT_101: 
            case TOMCAT_100: 
            case TOMCAT_90: 
            case TOMCAT_80: 
            case TOMCAT_70: {
                name = "resources/tomcat-ant-deploy70.xml";
                break;
            }
            case TOMCAT_60: {
                name = "resources/tomcat-ant-deploy60.xml";
                break;
            }
            default: {
                name = "resources/tomcat-ant-deploy.xml";
            }
        }
        InputStream is = AntDeploymentProviderImpl.class.getResourceAsStream(name);
        if (is == null) {
            LOGGER.log(Level.SEVERE, "Missing resource {0}.", name);
            return;
        }
        try {
            FileUtil.copy((InputStream)is, (OutputStream)os);
        }
        finally {
            is.close();
        }
    }

    public File getDeploymentPropertiesFile() {
        TomcatProperties tp = this.tm.getTomcatProperties();
        File file = tp.getAntDeploymentPropertiesFile();
        if (!file.exists()) {
            try {
                tp.storeAntDeploymentProperties(file, true);
            }
            catch (IOException ioe) {
                Logger.getLogger(AntDeploymentProviderImpl.class.getName()).log(Level.INFO, null, ioe);
            }
        }
        return file;
    }
}

