/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.nodes;

import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import javax.swing.Action;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.rest.model.api.RestServiceDescription;
import org.netbeans.modules.websvc.rest.model.api.RestServicesModel;
import org.netbeans.modules.websvc.rest.nodes.OpenCookieFactory;
import org.netbeans.modules.websvc.rest.nodes.ResourceToEditorDrop;
import org.netbeans.modules.websvc.rest.nodes.ResourceUriProvider;
import org.netbeans.modules.websvc.rest.nodes.RestServiceChildren;
import org.netbeans.modules.websvc.rest.nodes.TestResourceUriAction;
import org.openide.actions.OpenAction;
import org.openide.actions.PropertiesAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.text.ActiveEditorDrop;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class RestServiceNode
extends AbstractNode {
    private String serviceName;
    private String uriTemplate;
    private String className;
    private ActiveEditorDrop editorDrop;
    private static final Image SERVICE_BADGE = ImageUtilities.loadImage((String)"org/netbeans/modules/websvc/rest/nodes/resources/restservice.png");

    public RestServiceNode(Project project, RestServicesModel model, RestServiceDescription desc) {
        this(project, model, desc, new InstanceContent());
    }

    private RestServiceNode(Project project, RestServicesModel model, final RestServiceDescription desc, InstanceContent content) {
        super((Children)new RestServiceChildren(project, model, desc.getName()), (Lookup)new AbstractLookup((AbstractLookup.Content)content));
        this.serviceName = desc.getName();
        this.uriTemplate = desc.getUriTemplate();
        this.className = desc.getClassName();
        content.add((Object)this);
        content.add((Object)desc);
        content.add((Object)new ResourceUriProvider(){

            @Override
            public String getResourceUri() {
                return desc.getUriTemplate();
            }
        });
        content.add((Object)project);
        content.add((Object)OpenCookieFactory.create(project, this.className));
        this.editorDrop = new ResourceToEditorDrop(this);
    }

    public String getDisplayName() {
        if (this.uriTemplate.length() > 0) {
            return this.serviceName + " [" + this.uriTemplate + "]";
        }
        return this.serviceName;
    }

    public String getShortDescription() {
        return "";
    }

    public static String getKey(RestServiceDescription desc) {
        return desc.getName() + ":" + desc.getUriTemplate();
    }

    public Image getIcon(int type) {
        return SERVICE_BADGE;
    }

    void changeIcon() {
        this.fireIconChange();
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    public Action getPreferredAction() {
        return SystemAction.get(OpenAction.class);
    }

    public Action[] getActions(boolean context) {
        return new SystemAction[]{SystemAction.get(OpenAction.class), SystemAction.get(TestResourceUriAction.class), null, SystemAction.get(PropertiesAction.class)};
    }

    public Transferable clipboardCopy() throws IOException {
        ExTransferable t = ExTransferable.create((Transferable)super.clipboardCopy());
        ActiveEditorDropTransferable s = new ActiveEditorDropTransferable(this.editorDrop);
        t.put((ExTransferable.Single)s);
        return t;
    }

    private static class ActiveEditorDropTransferable
    extends ExTransferable.Single {
        private ActiveEditorDrop drop;

        ActiveEditorDropTransferable(ActiveEditorDrop drop) {
            super(ActiveEditorDrop.FLAVOR);
            this.drop = drop;
        }

        public Object getData() {
            return this.drop;
        }
    }
}

