/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.truffle.access;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassType;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Locatable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.TypeComponent;
import com.sun.jdi.Value;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.request.EventRequest;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.InvalidObjectException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.Field;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.LocalVariable;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointEvent;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointListener;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.expr.InvocationExceptionTranslated;
import org.netbeans.modules.debugger.jpda.expr.JDIVariable;
import org.netbeans.modules.debugger.jpda.jdi.ClassTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.IllegalThreadStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocatableWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocationWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ThreadReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.ClassPrepareEventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.EventSetWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.EventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.LocatableEventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestWrapper;
import org.netbeans.modules.debugger.jpda.models.JPDAClassTypeImpl;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.truffle.LanguageName;
import org.netbeans.modules.debugger.jpda.truffle.RemoteServices;
import org.netbeans.modules.debugger.jpda.truffle.TruffleDebugManager;
import org.netbeans.modules.debugger.jpda.truffle.Utils;
import org.netbeans.modules.debugger.jpda.truffle.access.CurrentPCInfo;
import org.netbeans.modules.debugger.jpda.truffle.access.ExecutionHaltedInfo;
import org.netbeans.modules.debugger.jpda.truffle.actions.StepActionProvider;
import org.netbeans.modules.debugger.jpda.truffle.ast.TruffleNode;
import org.netbeans.modules.debugger.jpda.truffle.breakpoints.impl.HitBreakpointInfo;
import org.netbeans.modules.debugger.jpda.truffle.breakpoints.impl.TruffleBreakpointOutput;
import org.netbeans.modules.debugger.jpda.truffle.frames.TruffleStackFrame;
import org.netbeans.modules.debugger.jpda.truffle.frames.TruffleStackInfo;
import org.netbeans.modules.debugger.jpda.truffle.source.Source;
import org.netbeans.modules.debugger.jpda.truffle.source.SourcePosition;
import org.netbeans.modules.debugger.jpda.truffle.vars.TruffleVariable;
import org.netbeans.modules.debugger.jpda.truffle.vars.impl.TruffleScope;
import org.netbeans.modules.debugger.jpda.truffle.vars.impl.TruffleStackVariable;
import org.netbeans.modules.debugger.jpda.util.Executor;
import org.netbeans.modules.debugger.jpda.util.WeakHashMapActive;
import org.openide.util.Exceptions;

public class TruffleAccess
implements JPDABreakpointListener {
    private static final Logger LOG = Logger.getLogger(TruffleAccess.class.getName());
    public static final String BASIC_CLASS_NAME = "org.netbeans.modules.debugger.jpda.backend.truffle.JPDATruffleAccessor";
    private static final String METHOD_EXEC_HALTED = "executionHalted";
    private static final String METHOD_EXEC_STEP_INTO = "executionStepInto";
    private static final String METHOD_DEBUGGER_ACCESS = "debuggerAccess";
    private static final String VAR_NODE = "astNode";
    private static final String VAR_FRAME = "frame";
    private static final String VAR_SRC_ID = "id";
    private static final String VAR_SRC_URI = "uri";
    private static final String VAR_SRC_MIMETYPE = "mimeType";
    private static final String VAR_SRC_NAME = "name";
    private static final String VAR_SRC_HOST_METHOD = "hostMethodName";
    private static final String VAR_SRC_PATH = "path";
    private static final String VAR_SRC_SOURCESECTION = "sourceSection";
    private static final String VAR_SRC_CODE = "code";
    private static final String VAR_STACK_TRACE = "stackTrace";
    private static final String VAR_TOP_FRAME = "topFrame";
    private static final String VAR_TOP_VARS = "topVariables";
    private static final String VAR_THIS_OBJECT = "thisObject";
    private static final String METHOD_GET_VARIABLES = "getVariables";
    private static final String METHOD_GET_VARIABLES_SGN = "(Lcom/oracle/truffle/api/debug/DebugStackFrame;)[Ljava/lang/Object;";
    private static final String METHOD_GET_SCOPE_VARIABLES = "getScopeVariables";
    private static final String METHOD_GET_SCOPE_VARIABLES_SGN = "(Lcom/oracle/truffle/api/debug/DebugScope;)[Ljava/lang/Object;";
    private static final String METHOD_SUSPEND_HERE = "suspendHere";
    private static final String METHOD_SUSPEND_HERE_SGN = "()[Ljava/lang/Object;";
    private static final String METHOD_SET_UNWIND = "setUnwind";
    private static final String METHOD_SET_UNWIND_SGN = "(I)Z";
    private static final String METHOD_GET_AST = "getTruffleAST";
    private static final String METHOD_GET_AST_SGN = "(I)[Ljava/lang/Object;";
    private static final Map<JPDAThread, ThreadInfo> currentPCInfos = new WeakHashMap<JPDAThread, ThreadInfo>();
    private static final Map<JPDAThread, ThreadInfo> suspendHerePCInfos = new WeakHashMap<JPDAThread, ThreadInfo>();
    private static final PropertyChangeListener threadResumeListener = new ThreadResumeListener();
    private static final TruffleAccess DEFAULT = new TruffleAccess();
    private final Map<JPDADebugger, JPDABreakpoint> execHaltedBP = new WeakHashMapActive();
    private final Map<JPDADebugger, JPDABreakpoint> execStepIntoBP = new WeakHashMapActive();
    private final Map<JPDADebugger, JPDABreakpoint> dbgAccessBP = new WeakHashMapActive();
    private final Object methodCallAccessLock = new Object();
    private MethodCallsAccess methodCallsRunnable;
    private static final MethodCallsAccess METHOD_CALLS_SUCCESSFUL = new MethodCallsAccess(){

        @Override
        public void callMethods(JPDAThread thread) {
        }
    };
    private static final String CLEAR_REFERENCES_CLASS = "com.oracle.truffle.api.debug.SuspendedEvent";
    private static final String CLEAR_REFERENCES_METHOD = "clearLeakingReferences";

    private TruffleAccess() {
    }

    public static void init() {
        DEFAULT.initBPs();
    }

    public static void assureBPSet(JPDADebugger debugger, ClassType accessorClass) {
        TruffleAccess.DEFAULT.execHaltedBP.put(debugger, DEFAULT.createBP(accessorClass.name(), METHOD_EXEC_HALTED, debugger));
        TruffleAccess.DEFAULT.execStepIntoBP.put(debugger, DEFAULT.createBP(accessorClass.name(), METHOD_EXEC_STEP_INTO, debugger));
        TruffleAccess.DEFAULT.dbgAccessBP.put(debugger, DEFAULT.createBP(accessorClass.name(), METHOD_DEBUGGER_ACCESS, debugger));
    }

    private void initBPs() {
    }

    private JPDABreakpoint createBP(String className, String methodName, JPDADebugger debugger) {
        MethodBreakpoint mb = MethodBreakpoint.create((String)className, (String)methodName);
        mb.setBreakpointType(1);
        mb.setHidden(true);
        mb.setSession(debugger);
        mb.addJPDABreakpointListener((JPDABreakpointListener)this);
        DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)mb);
        return mb;
    }

    public static CurrentPCInfo getCurrentPCInfo(JPDAThread thread) {
        CurrentPCInfo cpi = TruffleAccess.getCurrentGuestPCInfo(thread);
        if (cpi == null) {
            cpi = TruffleAccess.getCurrentSuspendHereInfo(thread);
        }
        return cpi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CurrentPCInfo getCurrentGuestPCInfo(JPDAThread thread) {
        ThreadInfo info;
        Map<JPDAThread, ThreadInfo> map = currentPCInfos;
        synchronized (map) {
            info = currentPCInfos.get(thread);
        }
        if (info != null) {
            return info.cpi;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CurrentPCInfo getSomePCInfo(JPDADebugger dbg) {
        Map<JPDAThread, ThreadInfo> map = currentPCInfos;
        synchronized (map) {
            for (Map.Entry<JPDAThread, ThreadInfo> pce : currentPCInfos.entrySet()) {
                CurrentPCInfo cpi;
                if (((JPDAThreadImpl)pce.getKey()).getDebugger() != dbg || (cpi = pce.getValue().cpi) == null) continue;
                return cpi;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CurrentPCInfo getCurrentSuspendHereInfo(JPDAThread thread) {
        Map<JPDAThread, ThreadInfo> map = suspendHerePCInfos;
        synchronized (map) {
            ThreadInfo info = suspendHerePCInfos.get(thread);
            if (info != null) {
                return info.cpi;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CurrentPCInfo getSuspendHere(JPDAThread thread) {
        ThreadInfo info;
        if (TruffleAccess.getCurrentGuestPCInfo(thread) != null) {
            return null;
        }
        Object object = suspendHerePCInfos;
        synchronized (object) {
            info = suspendHerePCInfos.get(thread);
            if (info != null) {
                if (info.cpi != null) {
                    return info.cpi;
                }
                if (info.noCpi) {
                    return null;
                }
            }
            if (info == null) {
                ((JPDAThreadImpl)thread).addPropertyChangeListener("suspended", threadResumeListener);
                info = new ThreadInfo();
                suspendHerePCInfos.put(thread, info);
            }
        }
        object = info;
        synchronized (object) {
            if (info.cpi != null) {
                return info.cpi;
            }
            if (info.noCpi) {
                return null;
            }
            JPDADebuggerImpl debugger = ((JPDAThreadImpl)thread).getDebugger();
            ClassType debugAccessorClass = TruffleDebugManager.getDebugAccessorClass((JPDADebugger)debugger);
            if (debugAccessorClass == null) {
                info.noCpi = true;
                return null;
            }
            ObjectVariable haltInfo = TruffleAccess.invokeSuspendHere(debugAccessorClass, thread);
            if (haltInfo == null) {
                info.noCpi = true;
                return null;
            }
            CurrentPCInfo cpi = TruffleAccess.getCurrentPosition((JPDADebugger)debugger, thread, (Variable[])haltInfo.getFields(0, Integer.MAX_VALUE));
            cpi.setSelectedStackFrame(null);
            info.cpi = cpi;
            return cpi;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ObjectVariable invokeSuspendHere(ClassType debugAccessorClass, JPDAThread thread) {
        JPDAThreadImpl threadImpl = (JPDAThreadImpl)thread;
        ThreadReference tr = threadImpl.getThreadReference();
        try {
            Value haltInfo;
            Method suspendHereMethod = ClassTypeWrapper.concreteMethodByName((ClassType)debugAccessorClass, (String)METHOD_SUSPEND_HERE, (String)METHOD_SUSPEND_HERE_SGN);
            JPDADebuggerImpl debugger = threadImpl.getDebugger();
            threadImpl.notifyMethodInvoking();
            Runnable cleanup = null;
            try {
                cleanup = TruffleAccess.skipSuspendedEventClearLeakingReferences((JPDADebugger)debugger, thread);
                haltInfo = ClassTypeWrapper.invokeMethod((ClassType)debugAccessorClass, (ThreadReference)tr, (Method)suspendHereMethod, Collections.emptyList(), (int)1);
            }
            finally {
                try {
                    cleanup.run();
                }
                finally {
                    threadImpl.notifyMethodInvokeDone();
                }
            }
            if (haltInfo instanceof ObjectReference) {
                return (ObjectVariable)debugger.getVariable(haltInfo);
            }
        }
        catch (InvocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (Exception ex) {
            LOG.log(Level.CONFIG, "Invoking suspendHere", ex);
        }
        return null;
    }

    private static Runnable skipSuspendedEventClearLeakingReferences(JPDADebugger debugger, JPDAThread thread) {
        ThreadReference tr = ((JPDAThreadImpl)thread).getThreadReference();
        MethodBreakpoint clearLeakingReferencesBreakpoint = MethodBreakpoint.create((String)CLEAR_REFERENCES_CLASS, (String)CLEAR_REFERENCES_METHOD);
        clearLeakingReferencesBreakpoint.setBreakpointType(1);
        clearLeakingReferencesBreakpoint.setThreadFilters(debugger, new JPDAThread[]{thread});
        clearLeakingReferencesBreakpoint.setHidden(true);
        Function<EventSet, Boolean> breakpointEventInterceptor = eventSet -> {
            try {
                ThreadReference etr = null;
                TypeComponent method = null;
                for (Object e : eventSet) {
                    if (e instanceof ClassPrepareEvent) {
                        etr = ClassPrepareEventWrapper.thread((ClassPrepareEvent)((ClassPrepareEvent)e));
                        continue;
                    }
                    if (!(e instanceof LocatableEvent)) continue;
                    etr = LocatableEventWrapper.thread((LocatableEvent)((LocatableEvent)e));
                    method = LocationWrapper.method((Location)LocatableWrapper.location((Locatable)((LocatableEvent)e)));
                }
                if (tr.equals(etr) && method != null && CLEAR_REFERENCES_METHOD.equals(method.name()) && CLEAR_REFERENCES_CLASS.equals(method.declaringType().name())) {
                    boolean resume = true;
                    for (Event e : eventSet) {
                        EventRequest r = EventWrapper.request((Event)e);
                        Executor exec = r != null ? (Executor)EventRequestWrapper.getProperty((EventRequest)r, (Object)"executor") : null;
                        resume &= exec.exec(e);
                    }
                    if (resume) {
                        try {
                            EventSetWrapper.resume((EventSet)eventSet);
                        }
                        catch (IllegalThreadStateExceptionWrapper | ObjectCollectedExceptionWrapper ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                    return true;
                }
                return false;
            }
            catch (InternalExceptionWrapper | VMDisconnectedExceptionWrapper ex) {
                return false;
            }
        };
        clearLeakingReferencesBreakpoint.addJPDABreakpointListener(event -> {
            DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)clearLeakingReferencesBreakpoint);
            try {
                ThreadReferenceWrapper.forceEarlyReturn((ThreadReference)tr, (Value)tr.virtualMachine().mirrorOfVoid());
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            event.resume();
            ((JPDADebuggerImpl)debugger).getOperator().removeEventInterceptor(breakpointEventInterceptor);
        });
        ((JPDADebuggerImpl)debugger).getOperator().addEventInterceptor(breakpointEventInterceptor);
        DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)clearLeakingReferencesBreakpoint);
        return () -> {
            ((JPDADebuggerImpl)debugger).getOperator().removeEventInterceptor(breakpointEventInterceptor);
            DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)clearLeakingReferencesBreakpoint);
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void breakpointReached(JPDABreakpointEvent event) {
        Object bp = event.getSource();
        JPDADebugger debugger = event.getDebugger();
        if (this.execHaltedBP.get(debugger) == bp) {
            LOG.log(Level.FINE, "TruffleAccessBreakpoints.breakpointReached({0}), exec halted.", event);
            if (!this.setCurrentPosition(debugger, event.getThread())) {
                event.resume();
            } else {
                StepActionProvider.killJavaStep(debugger);
            }
        } else if (this.execStepIntoBP.get(debugger) == bp) {
            LOG.log(Level.FINE, "TruffleAccessBreakpoints.breakpointReached({0}), exec step into.", event);
            if (!this.setCurrentPosition(debugger, event.getThread())) {
                event.resume();
            } else {
                StepActionProvider.killJavaStep(debugger);
            }
        } else if (this.dbgAccessBP.get(debugger) == bp) {
            LOG.log(Level.FINE, "TruffleAccessBreakpoints.breakpointReached({0}), debugger access.", event);
            try {
                Object object = this.methodCallAccessLock;
                synchronized (object) {
                    if (this.methodCallsRunnable != null) {
                        TruffleAccess.invokeMethodCalls(event.getThread(), this.methodCallsRunnable);
                    }
                    this.methodCallsRunnable = METHOD_CALLS_SUCCESSFUL;
                    this.methodCallAccessLock.notifyAll();
                }
            }
            finally {
                event.resume();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setCurrentPosition(JPDADebugger debugger, JPDAThread thread) {
        CurrentPCInfo cpci = TruffleAccess.getCurrentPosition(debugger, thread);
        if (cpci == null) {
            return false;
        }
        Map<JPDAThread, ThreadInfo> map = currentPCInfos;
        synchronized (map) {
            ThreadInfo info = currentPCInfos.get(thread);
            if (info == null) {
                ((JPDAThreadImpl)thread).addPropertyChangeListener("suspended", threadResumeListener);
                info = new ThreadInfo();
                currentPCInfos.put(thread, info);
            }
            info.cpi = cpci;
        }
        return true;
    }

    private static CurrentPCInfo getCurrentPosition(JPDADebugger debugger, JPDAThread thread) {
        try {
            CallStackFrame csf = thread.getCallStack(0, 1)[0];
            LocalVariable[] localVariables = csf.getLocalVariables();
            return TruffleAccess.getCurrentPosition(debugger, thread, (Variable[])localVariables);
        }
        catch (AbsentInformationException | IllegalStateException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    private static CurrentPCInfo getCurrentPosition(JPDADebugger debugger, JPDAThread thread, Variable[] haltVars) {
        try {
            ExecutionHaltedInfo haltedInfo = ExecutionHaltedInfo.get(haltVars);
            ObjectVariable sourcePositionVar = haltedInfo.sourcePositions;
            SourcePosition sp = TruffleAccess.getSourcePosition(debugger, sourcePositionVar);
            ObjectVariable frameInfoVar = haltedInfo.frameInfo;
            ObjectVariable frame = (ObjectVariable)frameInfoVar.getField(VAR_FRAME);
            ObjectVariable topVars = (ObjectVariable)frameInfoVar.getField(VAR_TOP_VARS);
            TruffleScope[] scopes = TruffleAccess.createScopes(debugger, topVars);
            ObjectVariable stackTrace = (ObjectVariable)frameInfoVar.getField(VAR_STACK_TRACE);
            String topFrameDescription = (String)frameInfoVar.getField(VAR_TOP_FRAME).createMirrorObject();
            ObjectVariable thisObject = null;
            TruffleStackFrame topFrame = new TruffleStackFrame(debugger, thread, 0, frame, topFrameDescription, null, scopes, thisObject, true);
            TruffleStackInfo stack = new TruffleStackInfo(debugger, thread, stackTrace, haltedInfo.supportsJavaFrames);
            HitBreakpointInfo[] breakpointInfos = TruffleAccess.getBreakpointInfos(haltedInfo, thread);
            CurrentPCInfo cpi = new CurrentPCInfo(haltedInfo.stepCmd, thread, sp, scopes, topFrame, stack, depth -> TruffleAccess.getTruffleAST(debugger, (JPDAThreadImpl)thread, depth, sp, stack));
            if (breakpointInfos != null) {
                TruffleBreakpointOutput.breakpointsHit(breakpointInfos, cpi);
            }
            return cpi;
        }
        catch (IllegalStateException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    private static HitBreakpointInfo[] getBreakpointInfos(ExecutionHaltedInfo haltedInfo, JPDAThread thread) {
        ObjectVariable[] breakpointsHit = haltedInfo.breakpointsHit;
        ObjectVariable[] breakpointConditionExceptions = haltedInfo.breakpointConditionExceptions;
        int n = breakpointsHit != null ? breakpointsHit.length : 0;
        HitBreakpointInfo[] breakpointInfos = null;
        for (int i = 0; i < n; ++i) {
            ObjectVariable exception = breakpointConditionExceptions != null ? breakpointConditionExceptions[i] : null;
            HitBreakpointInfo breakpointInfo = HitBreakpointInfo.create(breakpointsHit[i], exception);
            if (breakpointInfo == null) continue;
            if (breakpointInfos == null) {
                breakpointInfos = new HitBreakpointInfo[]{breakpointInfo};
                continue;
            }
            breakpointInfos = (HitBreakpointInfo[])Arrays.copyOf(breakpointInfos, breakpointInfos.length + 1);
            breakpointInfos[breakpointInfos.length - 1] = breakpointInfo;
        }
        return breakpointInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static TruffleNode getTruffleAST(JPDADebugger debugger, JPDAThreadImpl thread, int depth, SourcePosition topPosition, TruffleStackInfo stack) {
        JPDAClassType debugAccessor = TruffleDebugManager.getDebugAccessorJPDAClass(debugger);
        Lock lock = thread.accessLock.writeLock();
        lock.lock();
        try {
            SourcePosition position;
            if (thread.getState() == 0) {
                TruffleNode truffleNode = null;
                return truffleNode;
            }
            boolean[] suspended = new boolean[]{false};
            PropertyChangeListener threadChange = event -> {
                boolean[] blArray = suspended;
                synchronized (suspended) {
                    suspended[0] = (Boolean)event.getNewValue();
                    suspended.notifyAll();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            };
            thread.addPropertyChangeListener("suspended", threadChange);
            while (!thread.isSuspended()) {
                lock.unlock();
                lock = null;
                boolean[] blArray = suspended;
                // MONITORENTER : suspended
                if (!suspended[0]) {
                    try {
                        suspended.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                // MONITOREXIT : blArray
                lock = thread.accessLock.writeLock();
                lock.lock();
            }
            thread.removePropertyChangeListener("suspended", threadChange);
            Variable ast = ((JPDAClassTypeImpl)debugAccessor).invokeMethod((JPDAThread)thread, METHOD_GET_AST, METHOD_GET_AST_SGN, new Variable[]{debugger.createMirrorVar((Object)depth, true)});
            Field[] astInfo = ((ObjectVariable)ast).getFields(0, Integer.MAX_VALUE);
            if (depth == 0) {
                position = topPosition;
            } else {
                TruffleStackFrame[] stackFrames = stack.getStackFrames(true);
                if (depth >= stackFrames.length) {
                    TruffleNode truffleNode = null;
                    return truffleNode;
                }
                position = stackFrames[depth].getSourcePosition();
            }
            TruffleNode truffleNode = TruffleNode.newBuilder().nodes((String)astInfo[0].createMirrorObject()).currentPosition(position).build();
            return truffleNode;
        }
        catch (InvalidObjectException | NoSuchMethodException | InvalidExpressionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            TruffleNode truffleNode = null;
            return truffleNode;
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
    }

    public static SourcePosition getSourcePosition(JPDADebugger debugger, ObjectVariable sourcePositionVar) {
        Field varSrcId = sourcePositionVar.getField(VAR_SRC_ID);
        if (varSrcId == null) {
            return null;
        }
        long id = (Long)varSrcId.createMirrorObject();
        Field varSourceSection = sourcePositionVar.getField(VAR_SRC_SOURCESECTION);
        String sourceSection = (String)varSourceSection.createMirrorObject();
        if (sourceSection == null) {
            return null;
        }
        Source src = Source.getExistingSource(debugger, id);
        if (src == null) {
            String name = (String)sourcePositionVar.getField(VAR_SRC_NAME).createMirrorObject();
            String hostMethodName = (String)sourcePositionVar.getField(VAR_SRC_HOST_METHOD).createMirrorObject();
            String path = (String)sourcePositionVar.getField(VAR_SRC_PATH).createMirrorObject();
            URI uri = (URI)sourcePositionVar.getField(VAR_SRC_URI).createMirrorObject();
            String mimeType = (String)sourcePositionVar.getField(VAR_SRC_MIMETYPE).createMirrorObject();
            StringReference codeRef = (StringReference)((JDIVariable)sourcePositionVar.getField(VAR_SRC_CODE)).getJDIValue();
            src = Source.getSource(debugger, id, name, hostMethodName, path, uri, mimeType, codeRef);
        }
        return new SourcePosition(debugger, id, src, sourceSection);
    }

    private static TruffleScope[] createScopes(JPDADebugger debugger, ObjectVariable varsArrVar) {
        Field[] varsArr = varsArrVar.getFields(0, Integer.MAX_VALUE);
        LinkedList<TruffleScope> scopes = new LinkedList<TruffleScope>();
        int n = varsArr.length;
        int i = 0;
        while (i < n) {
            String scopeName = (String)varsArr[i++].createMirrorObject();
            boolean hasReceiver = (Boolean)varsArr[i++].createMirrorObject();
            int numVars = (Integer)varsArr[i++].createMirrorObject();
            TruffleVariable[] variables = new TruffleVariable[numVars];
            i = TruffleAccess.fillVars(debugger, variables, varsArr, hasReceiver, i);
            scopes.add(new TruffleScope(scopeName, variables));
        }
        return scopes.toArray(new TruffleScope[scopes.size()]);
    }

    private static int fillVars(JPDADebugger debugger, TruffleVariable[] vars, Field[] varsArr, boolean hasReceiver, int i) {
        for (int vi = 0; vi < vars.length; ++vi) {
            String name = (String)varsArr[i++].createMirrorObject();
            LanguageName language = LanguageName.parse((String)varsArr[i++].createMirrorObject());
            String type = (String)varsArr[i++].createMirrorObject();
            boolean readable = (Boolean)varsArr[i++].createMirrorObject();
            boolean writable = (Boolean)varsArr[i++].createMirrorObject();
            boolean internal = (Boolean)varsArr[i++].createMirrorObject();
            String valueStr = (String)varsArr[i++].createMirrorObject();
            ObjectVariable valueSourceDef = (ObjectVariable)varsArr[i++];
            Supplier<SourcePosition> valueSource = TruffleAccess.parseSourceLazy(debugger, (Variable)valueSourceDef, (JDIVariable)varsArr[i++]);
            ObjectVariable typeSourceDef = (ObjectVariable)varsArr[i++];
            Supplier<SourcePosition> typeSource = TruffleAccess.parseSourceLazy(debugger, (Variable)typeSourceDef, (JDIVariable)varsArr[i++]);
            ObjectVariable value = (ObjectVariable)varsArr[i++];
            vars[vi] = new TruffleStackVariable(debugger, name, language, type, readable, writable, internal, valueStr, valueSourceDef.getUniqueID() != 0L, valueSource, typeSourceDef.getUniqueID() != 0L, typeSource, hasReceiver, value);
            hasReceiver = false;
        }
        return i;
    }

    private static Supplier<SourcePosition> parseSourceLazy(JPDADebugger debugger, Variable sourceDefVar, JDIVariable codeRefVar) {
        return () -> TruffleAccess.parseSource(debugger, (String)sourceDefVar.createMirrorObject(), (StringReference)codeRefVar.getJDIValue());
    }

    private static SourcePosition parseSource(JPDADebugger debugger, String sourceDef, StringReference codeRef) {
        String sourceSection;
        String mimeType;
        URI sourceURI;
        String sourcePath;
        String hostMethodName;
        String sourceName;
        int sourceId;
        if (sourceDef == null) {
            return null;
        }
        try {
            int i1 = 0;
            int i2 = sourceDef.indexOf(10, i1);
            sourceId = Integer.parseInt(sourceDef.substring(i1, i2));
            i1 = i2 + 1;
            i2 = sourceDef.indexOf(10, i1);
            sourceName = sourceDef.substring(i1, i2);
            i1 = i2 + 1;
            i2 = sourceDef.indexOf(10, i1);
            hostMethodName = Utils.stringOrNull(sourceDef.substring(i1, i2));
            i1 = i2 + 1;
            i2 = sourceDef.indexOf(10, i1);
            sourcePath = sourceDef.substring(i1, i2);
            i1 = i2 + 1;
            i2 = sourceDef.indexOf(10, i1);
            String uriStr = Utils.stringOrNull(sourceDef.substring(i1, i2));
            if (uriStr != null) {
                try {
                    sourceURI = new URI(uriStr);
                }
                catch (URISyntaxException usex) {
                    Exceptions.printStackTrace((Throwable)new IllegalStateException("Bad URI: " + sourceDef.substring(i1, i2), usex));
                    sourceURI = null;
                }
            } else {
                sourceURI = null;
            }
            i1 = i2 + 1;
            i2 = sourceDef.indexOf(10, i1);
            mimeType = Utils.stringOrNull(sourceDef.substring(i1, i2));
            i1 = i2 + 1;
            if ((i2 = sourceDef.indexOf(10, i1)) < 0) {
                i2 = sourceDef.length();
            }
            sourceSection = sourceDef.substring(i1, i2);
        }
        catch (IndexOutOfBoundsException ioob) {
            throw new IllegalStateException("var source definition='" + sourceDef + "'", ioob);
        }
        Source src = Source.getSource(debugger, sourceId, sourceName, hostMethodName, sourcePath, sourceURI, mimeType, codeRef);
        return new SourcePosition(debugger, sourceId, src, sourceSection);
    }

    public static TruffleScope[] createFrameScopes(JPDADebugger debugger, Variable frameInstance) {
        JPDAClassType debugAccessor = TruffleDebugManager.getDebugAccessorJPDAClass(debugger);
        try {
            Variable frameVars = debugAccessor.invokeMethod(METHOD_GET_VARIABLES, METHOD_GET_VARIABLES_SGN, new Variable[]{frameInstance});
            TruffleScope[] scopes = TruffleAccess.createScopes(debugger, (ObjectVariable)frameVars);
            return scopes;
        }
        catch (NoSuchMethodException | InvalidExpressionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return new TruffleScope[0];
        }
    }

    public static boolean unwind(JPDADebugger debugger, JPDAThread thread, int depth) {
        JPDAClassType debugAccessor = TruffleDebugManager.getDebugAccessorJPDAClass(debugger);
        try {
            Variable arg = debugger.createMirrorVar((Object)depth);
            Variable res = ((JPDAClassTypeImpl)debugAccessor).invokeMethod(thread, METHOD_SET_UNWIND, METHOD_SET_UNWIND_SGN, new Variable[]{arg});
            return (Boolean)res.createMirrorObject();
        }
        catch (InvalidObjectException | NoSuchMethodException | InvalidExpressionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean methodCallingAccess(final JPDADebugger debugger, MethodCallsAccess methodCalls) {
        Object object = TruffleAccess.DEFAULT.methodCallAccessLock;
        synchronized (object) {
            boolean success;
            JPDAThread thread;
            while (TruffleAccess.DEFAULT.methodCallsRunnable != null) {
                try {
                    TruffleAccess.DEFAULT.methodCallAccessLock.wait();
                }
                catch (InterruptedException ex) {
                    return false;
                }
            }
            CurrentPCInfo currentPCInfo = TruffleAccess.getSomePCInfo(debugger);
            if (currentPCInfo != null && (thread = currentPCInfo.getThread()) != null && (success = TruffleAccess.invokeMethodCalls(thread, methodCalls))) {
                return true;
            }
            boolean interrupted = RemoteServices.interruptServiceAccessThread(debugger);
            if (!interrupted) {
                return false;
            }
            PropertyChangeListener finishListener = new PropertyChangeListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (4 == debugger.getState()) {
                        Object object = DEFAULT.methodCallAccessLock;
                        synchronized (object) {
                            DEFAULT.methodCallAccessLock.notifyAll();
                        }
                    }
                }
            };
            debugger.addPropertyChangeListener("state", finishListener);
            TruffleAccess.DEFAULT.methodCallsRunnable = methodCalls;
            try {
                TruffleAccess.DEFAULT.methodCallAccessLock.wait();
            }
            catch (InterruptedException ex) {
                boolean bl = false;
                return bl;
            }
            finally {
                debugger.removePropertyChangeListener("state", finishListener);
            }
            boolean success2 = TruffleAccess.DEFAULT.methodCallsRunnable == METHOD_CALLS_SUCCESSFUL;
            TruffleAccess.DEFAULT.methodCallsRunnable = null;
            return success2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean invokeMethodCalls(JPDAThread thread, MethodCallsAccess methodCalls) {
        assert (Thread.holdsLock(TruffleAccess.DEFAULT.methodCallAccessLock));
        boolean invoking = false;
        InvocationException iex = null;
        try {
            ((JPDAThreadImpl)thread).notifyMethodInvoking();
            invoking = true;
            methodCalls.callMethods(thread);
            boolean bl = true;
            return bl;
        }
        catch (PropertyVetoException pvex) {
            boolean bl = false;
            return bl;
        }
        catch (InvocationException ex) {
            iex = ex;
        }
        finally {
            if (invoking) {
                ((JPDAThreadImpl)thread).notifyMethodInvokeDone();
            }
        }
        if (iex != null) {
            InvocationExceptionTranslated ex = new InvocationExceptionTranslated(iex, ((JPDAThreadImpl)thread).getDebugger()).preload((JPDAThreadImpl)thread);
            Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)ex, (String)("Invoking " + methodCalls)));
        }
        return false;
    }

    private static final class ThreadResumeListener
    implements PropertyChangeListener {
        private ThreadResumeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            JPDAThreadImpl t = (JPDAThreadImpl)evt.getSource();
            if (!((Boolean)evt.getNewValue()).booleanValue() && !t.isMethodInvoking()) {
                Map map = currentPCInfos;
                synchronized (map) {
                    this.clear((ThreadInfo)currentPCInfos.get(t));
                }
                map = suspendHerePCInfos;
                synchronized (map) {
                    this.clear((ThreadInfo)suspendHerePCInfos.get(t));
                }
            }
        }

        private void clear(ThreadInfo info) {
            if (info != null) {
                info.cpi = null;
                info.noCpi = false;
            }
        }
    }

    private static final class ThreadInfo {
        volatile CurrentPCInfo cpi;
        volatile boolean noCpi;

        private ThreadInfo() {
        }
    }

    public static interface MethodCallsAccess {
        public void callMethods(JPDAThread var1) throws InvocationException;
    }
}

