/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.devops.model.RepositoryAuthorCollection;
import com.oracle.bmc.devops.requests.ListAuthorsRequest;
import com.oracle.bmc.devops.responses.ListAuthorsResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListAuthorsConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ListAuthorsConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ListAuthorsRequest interceptRequest(ListAuthorsRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ListAuthorsRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20210630").path("repositories").path(HttpUtils.encodePathSegment((String)request.getRepositoryId())).path("authors");
        if (request.getRefName() != null) {
            target = target.queryParam("refName", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getRefName())});
        }
        if (request.getLimit() != null) {
            target = target.queryParam("limit", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLimit())});
        }
        if (request.getPage() != null) {
            target = target.queryParam("page", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getPage())});
        }
        if (request.getSortOrder() != null) {
            target = target.queryParam("sortOrder", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSortOrder().getValue())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        if (client.getClientConfigurator() != null) {
            client.getClientConfigurator().customizeRequest((BmcRequest)request, ib);
        }
        return ib;
    }

    public static Function<Response, ListAuthorsResponse> fromResponse() {
        Function<Response, ListAuthorsResponse> transformer = new Function<Response, ListAuthorsResponse>(){

            public ListAuthorsResponse apply(Response rawResponse) {
                Optional opcNextPageHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.devops.responses.ListAuthorsResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(RepositoryAuthorCollection.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                ListAuthorsResponse.Builder builder = ListAuthorsResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.repositoryAuthorCollection((RepositoryAuthorCollection)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((opcNextPageHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-next-page")).isPresent()) {
                    builder.opcNextPage((String)HeaderUtils.toValue((String)"opc-next-page", (String)((String)((List)opcNextPageHeader.get()).get(0)), String.class));
                }
                ListAuthorsResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

