/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.devops.model.MirrorRepositoryConfig;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Repository {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="namespace")
    private final String namespace;
    @JsonProperty(value="projectId")
    private final String projectId;
    @JsonProperty(value="projectName")
    private final String projectName;
    @JsonProperty(value="sshUrl")
    private final String sshUrl;
    @JsonProperty(value="httpUrl")
    private final String httpUrl;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="defaultBranch")
    private final String defaultBranch;
    @JsonProperty(value="repositoryType")
    private final RepositoryType repositoryType;
    @JsonProperty(value="mirrorRepositoryConfig")
    private final MirrorRepositoryConfig mirrorRepositoryConfig;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="lifecyleDetails")
    private final String lifecyleDetails;
    @JsonProperty(value="branchCount")
    private final Integer branchCount;
    @JsonProperty(value="commitCount")
    private final Integer commitCount;
    @JsonProperty(value="sizeInBytes")
    private final Long sizeInBytes;
    @JsonProperty(value="triggerBuildEvents")
    private final List<TriggerBuildEvents> triggerBuildEvents;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="systemTags")
    private final Map<String, Map<String, Object>> systemTags;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().id(this.id).name(this.name).compartmentId(this.compartmentId).namespace(this.namespace).projectId(this.projectId).projectName(this.projectName).sshUrl(this.sshUrl).httpUrl(this.httpUrl).description(this.description).defaultBranch(this.defaultBranch).repositoryType(this.repositoryType).mirrorRepositoryConfig(this.mirrorRepositoryConfig).timeCreated(this.timeCreated).timeUpdated(this.timeUpdated).lifecycleState(this.lifecycleState).lifecyleDetails(this.lifecyleDetails).branchCount(this.branchCount).commitCount(this.commitCount).sizeInBytes(this.sizeInBytes).triggerBuildEvents(this.triggerBuildEvents).freeformTags(this.freeformTags).definedTags(this.definedTags).systemTags(this.systemTags);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getSshUrl() {
        return this.sshUrl;
    }

    public String getHttpUrl() {
        return this.httpUrl;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDefaultBranch() {
        return this.defaultBranch;
    }

    public RepositoryType getRepositoryType() {
        return this.repositoryType;
    }

    public MirrorRepositoryConfig getMirrorRepositoryConfig() {
        return this.mirrorRepositoryConfig;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLifecyleDetails() {
        return this.lifecyleDetails;
    }

    public Integer getBranchCount() {
        return this.branchCount;
    }

    public Integer getCommitCount() {
        return this.commitCount;
    }

    public Long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public List<TriggerBuildEvents> getTriggerBuildEvents() {
        return this.triggerBuildEvents;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, Map<String, Object>> getSystemTags() {
        return this.systemTags;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Repository)) {
            return false;
        }
        Repository other = (Repository)o;
        Integer this$branchCount = this.getBranchCount();
        Integer other$branchCount = other.getBranchCount();
        if (this$branchCount == null ? other$branchCount != null : !((Object)this$branchCount).equals(other$branchCount)) {
            return false;
        }
        Integer this$commitCount = this.getCommitCount();
        Integer other$commitCount = other.getCommitCount();
        if (this$commitCount == null ? other$commitCount != null : !((Object)this$commitCount).equals(other$commitCount)) {
            return false;
        }
        Long this$sizeInBytes = this.getSizeInBytes();
        Long other$sizeInBytes = other.getSizeInBytes();
        if (this$sizeInBytes == null ? other$sizeInBytes != null : !((Object)this$sizeInBytes).equals(other$sizeInBytes)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$compartmentId = this.getCompartmentId();
        String other$compartmentId = other.getCompartmentId();
        if (this$compartmentId == null ? other$compartmentId != null : !this$compartmentId.equals(other$compartmentId)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$projectId = this.getProjectId();
        String other$projectId = other.getProjectId();
        if (this$projectId == null ? other$projectId != null : !this$projectId.equals(other$projectId)) {
            return false;
        }
        String this$projectName = this.getProjectName();
        String other$projectName = other.getProjectName();
        if (this$projectName == null ? other$projectName != null : !this$projectName.equals(other$projectName)) {
            return false;
        }
        String this$sshUrl = this.getSshUrl();
        String other$sshUrl = other.getSshUrl();
        if (this$sshUrl == null ? other$sshUrl != null : !this$sshUrl.equals(other$sshUrl)) {
            return false;
        }
        String this$httpUrl = this.getHttpUrl();
        String other$httpUrl = other.getHttpUrl();
        if (this$httpUrl == null ? other$httpUrl != null : !this$httpUrl.equals(other$httpUrl)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$defaultBranch = this.getDefaultBranch();
        String other$defaultBranch = other.getDefaultBranch();
        if (this$defaultBranch == null ? other$defaultBranch != null : !this$defaultBranch.equals(other$defaultBranch)) {
            return false;
        }
        RepositoryType this$repositoryType = this.getRepositoryType();
        RepositoryType other$repositoryType = other.getRepositoryType();
        if (this$repositoryType == null ? other$repositoryType != null : !((Object)((Object)this$repositoryType)).equals((Object)other$repositoryType)) {
            return false;
        }
        MirrorRepositoryConfig this$mirrorRepositoryConfig = this.getMirrorRepositoryConfig();
        MirrorRepositoryConfig other$mirrorRepositoryConfig = other.getMirrorRepositoryConfig();
        if (this$mirrorRepositoryConfig == null ? other$mirrorRepositoryConfig != null : !((Object)this$mirrorRepositoryConfig).equals(other$mirrorRepositoryConfig)) {
            return false;
        }
        Date this$timeCreated = this.getTimeCreated();
        Date other$timeCreated = other.getTimeCreated();
        if (this$timeCreated == null ? other$timeCreated != null : !((Object)this$timeCreated).equals(other$timeCreated)) {
            return false;
        }
        Date this$timeUpdated = this.getTimeUpdated();
        Date other$timeUpdated = other.getTimeUpdated();
        if (this$timeUpdated == null ? other$timeUpdated != null : !((Object)this$timeUpdated).equals(other$timeUpdated)) {
            return false;
        }
        LifecycleState this$lifecycleState = this.getLifecycleState();
        LifecycleState other$lifecycleState = other.getLifecycleState();
        if (this$lifecycleState == null ? other$lifecycleState != null : !((Object)((Object)this$lifecycleState)).equals((Object)other$lifecycleState)) {
            return false;
        }
        String this$lifecyleDetails = this.getLifecyleDetails();
        String other$lifecyleDetails = other.getLifecyleDetails();
        if (this$lifecyleDetails == null ? other$lifecyleDetails != null : !this$lifecyleDetails.equals(other$lifecyleDetails)) {
            return false;
        }
        List<TriggerBuildEvents> this$triggerBuildEvents = this.getTriggerBuildEvents();
        List<TriggerBuildEvents> other$triggerBuildEvents = other.getTriggerBuildEvents();
        if (this$triggerBuildEvents == null ? other$triggerBuildEvents != null : !((Object)this$triggerBuildEvents).equals(other$triggerBuildEvents)) {
            return false;
        }
        Map<String, String> this$freeformTags = this.getFreeformTags();
        Map<String, String> other$freeformTags = other.getFreeformTags();
        if (this$freeformTags == null ? other$freeformTags != null : !((Object)this$freeformTags).equals(other$freeformTags)) {
            return false;
        }
        Map<String, Map<String, Object>> this$definedTags = this.getDefinedTags();
        Map<String, Map<String, Object>> other$definedTags = other.getDefinedTags();
        if (this$definedTags == null ? other$definedTags != null : !((Object)this$definedTags).equals(other$definedTags)) {
            return false;
        }
        Map<String, Map<String, Object>> this$systemTags = this.getSystemTags();
        Map<String, Map<String, Object>> other$systemTags = other.getSystemTags();
        if (this$systemTags == null ? other$systemTags != null : !((Object)this$systemTags).equals(other$systemTags)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $branchCount = this.getBranchCount();
        result = result * 59 + ($branchCount == null ? 43 : ((Object)$branchCount).hashCode());
        Integer $commitCount = this.getCommitCount();
        result = result * 59 + ($commitCount == null ? 43 : ((Object)$commitCount).hashCode());
        Long $sizeInBytes = this.getSizeInBytes();
        result = result * 59 + ($sizeInBytes == null ? 43 : ((Object)$sizeInBytes).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $compartmentId = this.getCompartmentId();
        result = result * 59 + ($compartmentId == null ? 43 : $compartmentId.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $projectId = this.getProjectId();
        result = result * 59 + ($projectId == null ? 43 : $projectId.hashCode());
        String $projectName = this.getProjectName();
        result = result * 59 + ($projectName == null ? 43 : $projectName.hashCode());
        String $sshUrl = this.getSshUrl();
        result = result * 59 + ($sshUrl == null ? 43 : $sshUrl.hashCode());
        String $httpUrl = this.getHttpUrl();
        result = result * 59 + ($httpUrl == null ? 43 : $httpUrl.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $defaultBranch = this.getDefaultBranch();
        result = result * 59 + ($defaultBranch == null ? 43 : $defaultBranch.hashCode());
        RepositoryType $repositoryType = this.getRepositoryType();
        result = result * 59 + ($repositoryType == null ? 43 : ((Object)((Object)$repositoryType)).hashCode());
        MirrorRepositoryConfig $mirrorRepositoryConfig = this.getMirrorRepositoryConfig();
        result = result * 59 + ($mirrorRepositoryConfig == null ? 43 : ((Object)$mirrorRepositoryConfig).hashCode());
        Date $timeCreated = this.getTimeCreated();
        result = result * 59 + ($timeCreated == null ? 43 : ((Object)$timeCreated).hashCode());
        Date $timeUpdated = this.getTimeUpdated();
        result = result * 59 + ($timeUpdated == null ? 43 : ((Object)$timeUpdated).hashCode());
        LifecycleState $lifecycleState = this.getLifecycleState();
        result = result * 59 + ($lifecycleState == null ? 43 : ((Object)((Object)$lifecycleState)).hashCode());
        String $lifecyleDetails = this.getLifecyleDetails();
        result = result * 59 + ($lifecyleDetails == null ? 43 : $lifecyleDetails.hashCode());
        List<TriggerBuildEvents> $triggerBuildEvents = this.getTriggerBuildEvents();
        result = result * 59 + ($triggerBuildEvents == null ? 43 : ((Object)$triggerBuildEvents).hashCode());
        Map<String, String> $freeformTags = this.getFreeformTags();
        result = result * 59 + ($freeformTags == null ? 43 : ((Object)$freeformTags).hashCode());
        Map<String, Map<String, Object>> $definedTags = this.getDefinedTags();
        result = result * 59 + ($definedTags == null ? 43 : ((Object)$definedTags).hashCode());
        Map<String, Map<String, Object>> $systemTags = this.getSystemTags();
        result = result * 59 + ($systemTags == null ? 43 : ((Object)$systemTags).hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public String toString() {
        return "Repository(id=" + this.getId() + ", name=" + this.getName() + ", compartmentId=" + this.getCompartmentId() + ", namespace=" + this.getNamespace() + ", projectId=" + this.getProjectId() + ", projectName=" + this.getProjectName() + ", sshUrl=" + this.getSshUrl() + ", httpUrl=" + this.getHttpUrl() + ", description=" + this.getDescription() + ", defaultBranch=" + this.getDefaultBranch() + ", repositoryType=" + (Object)((Object)this.getRepositoryType()) + ", mirrorRepositoryConfig=" + this.getMirrorRepositoryConfig() + ", timeCreated=" + this.getTimeCreated() + ", timeUpdated=" + this.getTimeUpdated() + ", lifecycleState=" + (Object)((Object)this.getLifecycleState()) + ", lifecyleDetails=" + this.getLifecyleDetails() + ", branchCount=" + this.getBranchCount() + ", commitCount=" + this.getCommitCount() + ", sizeInBytes=" + this.getSizeInBytes() + ", triggerBuildEvents=" + this.getTriggerBuildEvents() + ", freeformTags=" + this.getFreeformTags() + ", definedTags=" + this.getDefinedTags() + ", systemTags=" + this.getSystemTags() + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @ConstructorProperties(value={"id", "name", "compartmentId", "namespace", "projectId", "projectName", "sshUrl", "httpUrl", "description", "defaultBranch", "repositoryType", "mirrorRepositoryConfig", "timeCreated", "timeUpdated", "lifecycleState", "lifecyleDetails", "branchCount", "commitCount", "sizeInBytes", "triggerBuildEvents", "freeformTags", "definedTags", "systemTags"})
    @Deprecated
    public Repository(String id, String name, String compartmentId, String namespace, String projectId, String projectName, String sshUrl, String httpUrl, String description, String defaultBranch, RepositoryType repositoryType, MirrorRepositoryConfig mirrorRepositoryConfig, Date timeCreated, Date timeUpdated, LifecycleState lifecycleState, String lifecyleDetails, Integer branchCount, Integer commitCount, Long sizeInBytes, List<TriggerBuildEvents> triggerBuildEvents, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags) {
        this.id = id;
        this.name = name;
        this.compartmentId = compartmentId;
        this.namespace = namespace;
        this.projectId = projectId;
        this.projectName = projectName;
        this.sshUrl = sshUrl;
        this.httpUrl = httpUrl;
        this.description = description;
        this.defaultBranch = defaultBranch;
        this.repositoryType = repositoryType;
        this.mirrorRepositoryConfig = mirrorRepositoryConfig;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.lifecycleState = lifecycleState;
        this.lifecyleDetails = lifecyleDetails;
        this.branchCount = branchCount;
        this.commitCount = commitCount;
        this.sizeInBytes = sizeInBytes;
        this.triggerBuildEvents = triggerBuildEvents;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.systemTags = systemTags;
    }

    public static enum TriggerBuildEvents {
        Push("PUSH"),
        CommitUpdates("COMMIT_UPDATES"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, TriggerBuildEvents> map;

        private TriggerBuildEvents(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static TriggerBuildEvents create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'TriggerBuildEvents', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(TriggerBuildEvents.class);
            map = new HashMap<String, TriggerBuildEvents>();
            for (TriggerBuildEvents v : TriggerBuildEvents.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LifecycleState {
        Active("ACTIVE"),
        Creating("CREATING"),
        Deleted("DELETED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum RepositoryType {
        Mirrored("MIRRORED"),
        Hosted("HOSTED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, RepositoryType> map;

        private RepositoryType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static RepositoryType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'RepositoryType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(RepositoryType.class);
            map = new HashMap<String, RepositoryType>();
            for (RepositoryType v : RepositoryType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="namespace")
        private String namespace;
        @JsonProperty(value="projectId")
        private String projectId;
        @JsonProperty(value="projectName")
        private String projectName;
        @JsonProperty(value="sshUrl")
        private String sshUrl;
        @JsonProperty(value="httpUrl")
        private String httpUrl;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="defaultBranch")
        private String defaultBranch;
        @JsonProperty(value="repositoryType")
        private RepositoryType repositoryType;
        @JsonProperty(value="mirrorRepositoryConfig")
        private MirrorRepositoryConfig mirrorRepositoryConfig;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="lifecyleDetails")
        private String lifecyleDetails;
        @JsonProperty(value="branchCount")
        private Integer branchCount;
        @JsonProperty(value="commitCount")
        private Integer commitCount;
        @JsonProperty(value="sizeInBytes")
        private Long sizeInBytes;
        @JsonProperty(value="triggerBuildEvents")
        private List<TriggerBuildEvents> triggerBuildEvents;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder namespace(String namespace) {
            this.namespace = namespace;
            this.__explicitlySet__.add("namespace");
            return this;
        }

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            this.__explicitlySet__.add("projectId");
            return this;
        }

        public Builder projectName(String projectName) {
            this.projectName = projectName;
            this.__explicitlySet__.add("projectName");
            return this;
        }

        public Builder sshUrl(String sshUrl) {
            this.sshUrl = sshUrl;
            this.__explicitlySet__.add("sshUrl");
            return this;
        }

        public Builder httpUrl(String httpUrl) {
            this.httpUrl = httpUrl;
            this.__explicitlySet__.add("httpUrl");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder defaultBranch(String defaultBranch) {
            this.defaultBranch = defaultBranch;
            this.__explicitlySet__.add("defaultBranch");
            return this;
        }

        public Builder repositoryType(RepositoryType repositoryType) {
            this.repositoryType = repositoryType;
            this.__explicitlySet__.add("repositoryType");
            return this;
        }

        public Builder mirrorRepositoryConfig(MirrorRepositoryConfig mirrorRepositoryConfig) {
            this.mirrorRepositoryConfig = mirrorRepositoryConfig;
            this.__explicitlySet__.add("mirrorRepositoryConfig");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecyleDetails(String lifecyleDetails) {
            this.lifecyleDetails = lifecyleDetails;
            this.__explicitlySet__.add("lifecyleDetails");
            return this;
        }

        public Builder branchCount(Integer branchCount) {
            this.branchCount = branchCount;
            this.__explicitlySet__.add("branchCount");
            return this;
        }

        public Builder commitCount(Integer commitCount) {
            this.commitCount = commitCount;
            this.__explicitlySet__.add("commitCount");
            return this;
        }

        public Builder sizeInBytes(Long sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
            this.__explicitlySet__.add("sizeInBytes");
            return this;
        }

        public Builder triggerBuildEvents(List<TriggerBuildEvents> triggerBuildEvents) {
            this.triggerBuildEvents = triggerBuildEvents;
            this.__explicitlySet__.add("triggerBuildEvents");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public Repository build() {
            Repository __instance__ = new Repository(this.id, this.name, this.compartmentId, this.namespace, this.projectId, this.projectName, this.sshUrl, this.httpUrl, this.description, this.defaultBranch, this.repositoryType, this.mirrorRepositoryConfig, this.timeCreated, this.timeUpdated, this.lifecycleState, this.lifecyleDetails, this.branchCount, this.commitCount, this.sizeInBytes, this.triggerBuildEvents, this.freeformTags, this.definedTags, this.systemTags);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(Repository o) {
            Builder copiedBuilder = this.id(o.getId()).name(o.getName()).compartmentId(o.getCompartmentId()).namespace(o.getNamespace()).projectId(o.getProjectId()).projectName(o.getProjectName()).sshUrl(o.getSshUrl()).httpUrl(o.getHttpUrl()).description(o.getDescription()).defaultBranch(o.getDefaultBranch()).repositoryType(o.getRepositoryType()).mirrorRepositoryConfig(o.getMirrorRepositoryConfig()).timeCreated(o.getTimeCreated()).timeUpdated(o.getTimeUpdated()).lifecycleState(o.getLifecycleState()).lifecyleDetails(o.getLifecyleDetails()).branchCount(o.getBranchCount()).commitCount(o.getCommitCount()).sizeInBytes(o.getSizeInBytes()).triggerBuildEvents(o.getTriggerBuildEvents()).freeformTags(o.getFreeformTags()).definedTags(o.getDefinedTags()).systemTags(o.getSystemTags());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }

        Builder() {
        }

        public String toString() {
            return "Repository.Builder(id=" + this.id + ", name=" + this.name + ", compartmentId=" + this.compartmentId + ", namespace=" + this.namespace + ", projectId=" + this.projectId + ", projectName=" + this.projectName + ", sshUrl=" + this.sshUrl + ", httpUrl=" + this.httpUrl + ", description=" + this.description + ", defaultBranch=" + this.defaultBranch + ", repositoryType=" + (Object)((Object)this.repositoryType) + ", mirrorRepositoryConfig=" + this.mirrorRepositoryConfig + ", timeCreated=" + this.timeCreated + ", timeUpdated=" + this.timeUpdated + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ", lifecyleDetails=" + this.lifecyleDetails + ", branchCount=" + this.branchCount + ", commitCount=" + this.commitCount + ", sizeInBytes=" + this.sizeInBytes + ", triggerBuildEvents=" + this.triggerBuildEvents + ", freeformTags=" + this.freeformTags + ", definedTags=" + this.definedTags + ", systemTags=" + this.systemTags + ")";
        }
    }
}

