/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetBuildRunRequest
extends BmcRequest<Void> {
    private String buildRunId;
    private String opcRequestId;

    @ConstructorProperties(value={"buildRunId", "opcRequestId"})
    GetBuildRunRequest(String buildRunId, String opcRequestId) {
        this.buildRunId = buildRunId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().buildRunId(this.buildRunId).opcRequestId(this.opcRequestId);
    }

    public String toString() {
        return "GetBuildRunRequest(super=" + super.toString() + ", buildRunId=" + this.getBuildRunId() + ", opcRequestId=" + this.getOpcRequestId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetBuildRunRequest)) {
            return false;
        }
        GetBuildRunRequest other = (GetBuildRunRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$buildRunId = this.getBuildRunId();
        String other$buildRunId = other.getBuildRunId();
        if (this$buildRunId == null ? other$buildRunId != null : !this$buildRunId.equals(other$buildRunId)) {
            return false;
        }
        String this$opcRequestId = this.getOpcRequestId();
        String other$opcRequestId = other.getOpcRequestId();
        return !(this$opcRequestId == null ? other$opcRequestId != null : !this$opcRequestId.equals(other$opcRequestId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GetBuildRunRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $buildRunId = this.getBuildRunId();
        result = result * 59 + ($buildRunId == null ? 43 : $buildRunId.hashCode());
        String $opcRequestId = this.getOpcRequestId();
        result = result * 59 + ($opcRequestId == null ? 43 : $opcRequestId.hashCode());
        return result;
    }

    public String getBuildRunId() {
        return this.buildRunId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetBuildRunRequest, Void> {
        private String buildRunId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetBuildRunRequest o) {
            this.buildRunId(o.getBuildRunId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetBuildRunRequest build() {
            GetBuildRunRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder buildRunId(String buildRunId) {
            this.buildRunId = buildRunId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetBuildRunRequest buildWithoutInvocationCallback() {
            return new GetBuildRunRequest(this.buildRunId, this.opcRequestId);
        }

        public String toString() {
            return "GetBuildRunRequest.Builder(buildRunId=" + this.buildRunId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

