/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.bookmarks;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.text.Document;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.bookmarks.BookmarkChange;
import org.netbeans.modules.editor.bookmarks.BookmarkInfo;
import org.netbeans.modules.editor.bookmarks.BookmarkManagerEvent;
import org.netbeans.modules.editor.bookmarks.BookmarkManagerListener;
import org.netbeans.modules.editor.bookmarks.BookmarkUtils;
import org.netbeans.modules.editor.bookmarks.BookmarksPersistence;
import org.netbeans.modules.editor.bookmarks.FileBookmarks;
import org.netbeans.modules.editor.bookmarks.FileBookmarksChange;
import org.netbeans.modules.editor.bookmarks.ProjectBookmarks;
import org.netbeans.modules.editor.bookmarks.ProjectBookmarksChange;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class BookmarkManager {
    private static final BookmarkManager INSTANCE = new BookmarkManager();
    private final Map<URI, ProjectBookmarks> projectURI2Bookmarks = new HashMap<URI, ProjectBookmarks>();
    private List<BookmarkManagerListener> listenerList = new CopyOnWriteArrayList<BookmarkManagerListener>();
    private Thread locker;
    private int lockDepth;
    private Map<URI, ProjectBookmarksChange> transactionChanges;
    private boolean structureChange;
    private boolean firingChange;

    public static BookmarkManager getLocked() {
        return INSTANCE.lock();
    }

    private BookmarkManager() {
        this.resetTransactionChanges();
    }

    synchronized BookmarkManager lock() {
        try {
            Thread currentThread = Thread.currentThread();
            while (this.locker != null) {
                if (currentThread == this.locker) {
                    ++this.lockDepth;
                    return this;
                }
                this.wait();
            }
            this.locker = currentThread;
            this.lockDepth = 1;
        }
        catch (InterruptedException e) {
            throw new Error("Interrupted lock attempt.");
        }
        return this;
    }

    public synchronized void unlock() {
        Thread currentThread = Thread.currentThread();
        if (currentThread != this.locker) {
            throw new IllegalStateException("currentThread=" + currentThread + " != locker=" + this.locker);
        }
        if (--this.lockDepth <= 0) {
            this.locker = null;
            this.lockDepth = 0;
            if (!this.transactionChanges.isEmpty()) {
                this.fireChange();
            }
            this.notifyAll();
        }
    }

    private void resetTransactionChanges() {
        this.transactionChanges = new HashMap<URI, ProjectBookmarksChange>();
        this.structureChange = false;
    }

    public List<ProjectBookmarks> activeProjectBookmarks() {
        return new ArrayList<ProjectBookmarks>(this.projectURI2Bookmarks.values());
    }

    public void keepOpenProjectsBookmarksLoaded() {
        BookmarksPersistence.get().keepOpenProjectsBookmarksLoaded();
    }

    public BookmarkInfo findBookmarkByNameOrKey(String nameOrKey, boolean byKey) {
        for (ProjectBookmarks projectBookmarks : this.activeProjectBookmarks()) {
            for (FileBookmarks fileBookmarks : projectBookmarks.getFileBookmarks()) {
                for (BookmarkInfo info : fileBookmarks.getBookmarks()) {
                    if (!nameOrKey.equals(info.getName())) continue;
                    return info;
                }
            }
        }
        return null;
    }

    public void addBookmarkManagerListener(BookmarkManagerListener l) {
        this.listenerList.add(l);
    }

    public void removeBookmarkManagerListener(BookmarkManagerListener l) {
        this.listenerList.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireChange() {
        BookmarkManagerEvent evt = new BookmarkManagerEvent(this, this.transactionChanges, this.structureChange);
        this.resetTransactionChanges();
        this.firingChange = true;
        try {
            for (BookmarkManagerListener l : this.listenerList) {
                l.bookmarksChanged(evt);
            }
        }
        finally {
            this.firingChange = false;
        }
    }

    public ProjectBookmarks[] getSortedActiveProjectBookmarks() {
        ArrayList<ProjectBookmarks> sortedProjectBookmarks = new ArrayList<ProjectBookmarks>(this.projectURI2Bookmarks.values());
        Iterator it = sortedProjectBookmarks.iterator();
        while (it.hasNext()) {
            ProjectBookmarks projectBookmarks = (ProjectBookmarks)it.next();
            if (projectBookmarks.containsAnyBookmarks()) {
                URI prjURI = projectBookmarks.getProjectURI();
                Project prj = BookmarkUtils.findProject(prjURI);
                String projectDisplayName = prj != null ? ProjectUtils.getInformation((Project)prj).getDisplayName() : NbBundle.getMessage(BookmarkManager.class, (String)"LBL_NullProjectDisplayName");
                projectBookmarks.setProjectDisplayName(projectDisplayName);
                continue;
            }
            it.remove();
        }
        Collections.sort(sortedProjectBookmarks, new Comparator<ProjectBookmarks>(){

            @Override
            public int compare(ProjectBookmarks pb1, ProjectBookmarks pb2) {
                return pb1.getProjectDisplayName().compareTo(pb2.getProjectDisplayName());
            }
        });
        return sortedProjectBookmarks.toArray(new ProjectBookmarks[sortedProjectBookmarks.size()]);
    }

    public FileBookmarks[] getSortedFileBookmarks(ProjectBookmarks projectBookmarks) {
        List<FileBookmarks> fbList;
        if (projectBookmarks != null) {
            Collection<FileBookmarks> allFileBookmarks = projectBookmarks.getFileBookmarks();
            fbList = new ArrayList(allFileBookmarks.size());
            for (FileBookmarks fileBookmarks : allFileBookmarks) {
                if (!fileBookmarks.containsAnyBookmarks()) continue;
                fbList.add(fileBookmarks);
            }
            Collections.sort(fbList, new Comparator<FileBookmarks>(){

                @Override
                public int compare(FileBookmarks fb1, FileBookmarks fb2) {
                    FileObject fo1 = fb1.getFileObject();
                    FileObject fo2 = fb2.getFileObject();
                    if (fo1 == null) {
                        return fo2 == null ? 0 : -1;
                    }
                    if (fo2 == null) {
                        return 1;
                    }
                    return fo1.getNameExt().compareTo(fo2.getNameExt());
                }
            });
        } else {
            fbList = Collections.emptyList();
        }
        return fbList.toArray(new FileBookmarks[fbList.size()]);
    }

    public BookmarkInfo[] getSortedBookmarks(FileBookmarks fileBookmarks) {
        ArrayList<BookmarkInfo> sortedBookmarks = new ArrayList<BookmarkInfo>(fileBookmarks.getBookmarks());
        Collections.sort(sortedBookmarks, new Comparator<BookmarkInfo>(){

            @Override
            public int compare(BookmarkInfo b1, BookmarkInfo b2) {
                return b1.getCurrentLineIndex() - b2.getCurrentLineIndex();
            }
        });
        return sortedBookmarks.toArray(new BookmarkInfo[sortedBookmarks.size()]);
    }

    public FileBookmarks getFileBookmarks(Document document) {
        ProjectBookmarks projectBookmarks = this.getProjectBookmarks(document);
        if (projectBookmarks != null) {
            FileObject fo = NbEditorUtilities.getFileObject((Document)document);
            URI relativeURI = BookmarkUtils.getRelativeURI(projectBookmarks, fo.toURI());
            return this.getOrAddFileBookmarks(projectBookmarks, relativeURI);
        }
        return null;
    }

    public ProjectBookmarks getProjectBookmarks(Document document) {
        FileObject fo = NbEditorUtilities.getFileObject((Document)document);
        return this.getProjectBookmarks(fo);
    }

    public ProjectBookmarks getProjectBookmarks(FileObject fo) {
        ProjectBookmarks projectBookmarks = null;
        if (fo != null) {
            Project project = FileOwnerQuery.getOwner((FileObject)fo);
            projectBookmarks = this.getProjectBookmarks(project, true, true);
        }
        return projectBookmarks;
    }

    public ProjectBookmarks getProjectBookmarks(Project project, boolean load, boolean forceCreation) {
        URI projectURI = project != null ? project.getProjectDirectory().toURI() : null;
        return this.getProjectBookmarks(project, projectURI, load, forceCreation);
    }

    ProjectBookmarks getProjectBookmarks(final Project project, URI projectURI, boolean load, boolean forceCreation) {
        ProjectBookmarks projectBookmarks = this.projectURI2Bookmarks.get(projectURI);
        if (projectBookmarks == null && forceCreation) {
            projectBookmarks = new ProjectBookmarks(projectURI);
            this.projectURI2Bookmarks.put(projectURI, projectBookmarks);
        }
        if (load && projectBookmarks != null && !projectBookmarks.isLoadingScheduled()) {
            projectBookmarks.markLoadScheduled();
            final ProjectBookmarks finalProjectBookmarks = projectBookmarks;
            BookmarkUtils.postTask(new Runnable(){

                @Override
                public void run() {
                    BookmarksPersistence.get().loadProjectBookmarks(finalProjectBookmarks, project);
                }
            });
        }
        return projectBookmarks;
    }

    private ProjectBookmarksChange getProjectBookmarksChange(ProjectBookmarks projectBookmarks) {
        ProjectBookmarksChange change = this.transactionChanges.get(projectBookmarks.getProjectURI());
        if (change == null) {
            change = new ProjectBookmarksChange(projectBookmarks);
            this.transactionChanges.put(projectBookmarks.getProjectURI(), change);
        }
        return change;
    }

    private FileBookmarksChange getFileBookmarksChange(FileBookmarks fileBookmarks) {
        ProjectBookmarksChange prjChange = this.getProjectBookmarksChange(fileBookmarks.getProjectBookmarks());
        FileBookmarksChange change = prjChange.getFileBookmarksChange(fileBookmarks.getRelativeURI());
        if (change == null) {
            change = new FileBookmarksChange(fileBookmarks);
            prjChange.addChange(change);
        }
        return change;
    }

    private BookmarkChange getBookmarkChange(BookmarkInfo bookmark) {
        FileBookmarksChange fileChange = this.getFileBookmarksChange(bookmark.getFileBookmarks());
        BookmarkChange change = fileChange.getBookmarkChange(bookmark);
        if (change == null) {
            change = new BookmarkChange(bookmark);
            fileChange.addChange(change);
        }
        return change;
    }

    public void releaseProjectBookmarks(ProjectBookmarks projectBookmarks) {
        this.projectURI2Bookmarks.remove(projectBookmarks.getProjectURI());
        this.getProjectBookmarksChange(projectBookmarks).markReleased();
        this.structureChange = true;
    }

    public FileBookmarks getOrAddFileBookmarks(ProjectBookmarks projectBookmarks, URI relativeURI) {
        FileBookmarks fileBookmarks = projectBookmarks.getFileBookmarks(relativeURI);
        if (fileBookmarks == null) {
            this.checkModDuringFire();
            fileBookmarks = new FileBookmarks(projectBookmarks, relativeURI);
            projectBookmarks.add(fileBookmarks);
            fileBookmarks.getProjectBookmarks().setModified(true);
            this.structureChange = true;
        }
        return fileBookmarks;
    }

    public void addBookmark(FileBookmarks fileBookmarks, BookmarkInfo bookmark) {
        this.checkModDuringFire();
        fileBookmarks.add(bookmark);
        BookmarkChange change = this.getBookmarkChange(bookmark);
        change.markAdded();
        bookmark.getFileBookmarks().getProjectBookmarks().setModified(true);
        this.structureChange = true;
    }

    public void removeBookmarks(List<BookmarkInfo> bookmarks) {
        this.checkModDuringFire();
        for (BookmarkInfo bookmark : bookmarks) {
            FileBookmarks fileBookmarks = bookmark.getFileBookmarks();
            fileBookmarks.remove(bookmark);
            BookmarkChange change = this.getBookmarkChange(bookmark);
            change.markRemoved();
            bookmark.getFileBookmarks().getProjectBookmarks().setModified(true);
            this.structureChange = true;
        }
    }

    private void checkModDuringFire() {
        if (this.firingChange) {
            throw new IllegalStateException("Modification during change firing");
        }
    }

    public void updateLineIndex(BookmarkInfo bookmark, int lineIndex) {
        if (bookmark.getLineIndex() != lineIndex) {
            BookmarkChange change = this.getBookmarkChange(bookmark);
            bookmark.setLineIndex(lineIndex);
            bookmark.getFileBookmarks().getProjectBookmarks().setModified(true);
            change.markLineIndexChanged();
        }
    }

    public void updateNameOrKey(BookmarkInfo bookmark, boolean nameChanged, boolean keyChanged) {
        BookmarkChange change = this.getBookmarkChange(bookmark);
        if (nameChanged) {
            change.markNameChanged();
            bookmark.getFileBookmarks().getProjectBookmarks().setModified(true);
        }
        if (keyChanged) {
            change.markKeyChanged();
            bookmark.getFileBookmarks().getProjectBookmarks().setModified(true);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        for (ProjectBookmarks projectBookmarks : this.activeProjectBookmarks()) {
            sb.append("Project ").append(projectBookmarks.getProjectURI()).append('\n');
            for (FileBookmarks fileBookmarks : projectBookmarks.getFileBookmarks()) {
                sb.append("    ");
                fileBookmarks.appendInfo(sb, 4);
            }
        }
        return sb.toString();
    }
}

