/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CloudDatabaseManagementConfig {
    @JsonProperty(value="managementStatus")
    private final ManagementStatus managementStatus;
    @JsonProperty(value="managementType")
    private final ManagementType managementType;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().managementStatus(this.managementStatus).managementType(this.managementType);
    }

    public ManagementStatus getManagementStatus() {
        return this.managementStatus;
    }

    public ManagementType getManagementType() {
        return this.managementType;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CloudDatabaseManagementConfig)) {
            return false;
        }
        CloudDatabaseManagementConfig other = (CloudDatabaseManagementConfig)o;
        ManagementStatus this$managementStatus = this.getManagementStatus();
        ManagementStatus other$managementStatus = other.getManagementStatus();
        if (this$managementStatus == null ? other$managementStatus != null : !((Object)((Object)this$managementStatus)).equals((Object)other$managementStatus)) {
            return false;
        }
        ManagementType this$managementType = this.getManagementType();
        ManagementType other$managementType = other.getManagementType();
        if (this$managementType == null ? other$managementType != null : !((Object)((Object)this$managementType)).equals((Object)other$managementType)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ManagementStatus $managementStatus = this.getManagementStatus();
        result = result * 59 + ($managementStatus == null ? 43 : ((Object)((Object)$managementStatus)).hashCode());
        ManagementType $managementType = this.getManagementType();
        result = result * 59 + ($managementType == null ? 43 : ((Object)((Object)$managementType)).hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public String toString() {
        return "CloudDatabaseManagementConfig(managementStatus=" + (Object)((Object)this.getManagementStatus()) + ", managementType=" + (Object)((Object)this.getManagementType()) + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @ConstructorProperties(value={"managementStatus", "managementType"})
    @Deprecated
    public CloudDatabaseManagementConfig(ManagementStatus managementStatus, ManagementType managementType) {
        this.managementStatus = managementStatus;
        this.managementType = managementType;
    }

    public static enum ManagementType {
        Basic("BASIC"),
        Advanced("ADVANCED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ManagementType> map;

        private ManagementType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ManagementType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ManagementType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ManagementType.class);
            map = new HashMap<String, ManagementType>();
            for (ManagementType v : ManagementType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ManagementStatus {
        Enabling("ENABLING"),
        Enabled("ENABLED"),
        Disabling("DISABLING"),
        Disabled("DISABLED"),
        Updating("UPDATING"),
        FailedEnabling("FAILED_ENABLING"),
        FailedDisabling("FAILED_DISABLING"),
        FailedUpdating("FAILED_UPDATING"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ManagementStatus> map;

        private ManagementStatus(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ManagementStatus create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ManagementStatus', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ManagementStatus.class);
            map = new HashMap<String, ManagementStatus>();
            for (ManagementStatus v : ManagementStatus.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="managementStatus")
        private ManagementStatus managementStatus;
        @JsonProperty(value="managementType")
        private ManagementType managementType;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder managementStatus(ManagementStatus managementStatus) {
            this.managementStatus = managementStatus;
            this.__explicitlySet__.add("managementStatus");
            return this;
        }

        public Builder managementType(ManagementType managementType) {
            this.managementType = managementType;
            this.__explicitlySet__.add("managementType");
            return this;
        }

        public CloudDatabaseManagementConfig build() {
            CloudDatabaseManagementConfig __instance__ = new CloudDatabaseManagementConfig(this.managementStatus, this.managementType);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(CloudDatabaseManagementConfig o) {
            Builder copiedBuilder = this.managementStatus(o.getManagementStatus()).managementType(o.getManagementType());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }

        Builder() {
        }

        public String toString() {
            return "CloudDatabaseManagementConfig.Builder(managementStatus=" + (Object)((Object)this.managementStatus) + ", managementType=" + (Object)((Object)this.managementType) + ")";
        }
    }
}

