/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.database.model.AutonomousDatabaseSummary;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListAutonomousDatabasesRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String autonomousContainerDatabaseId;
    private Integer limit;
    private String page;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private AutonomousDatabaseSummary.InfrastructureType infrastructureType;
    private AutonomousDatabaseSummary.LifecycleState lifecycleState;
    private AutonomousDatabaseSummary.DbWorkload dbWorkload;
    private String dbVersion;
    private Boolean isFreeTier;
    private String displayName;
    private String opcRequestId;
    private Boolean isRefreshableClone;
    private Boolean isDataGuardEnabled;

    @ConstructorProperties(value={"compartmentId", "autonomousContainerDatabaseId", "limit", "page", "sortBy", "sortOrder", "infrastructureType", "lifecycleState", "dbWorkload", "dbVersion", "isFreeTier", "displayName", "opcRequestId", "isRefreshableClone", "isDataGuardEnabled"})
    ListAutonomousDatabasesRequest(String compartmentId, String autonomousContainerDatabaseId, Integer limit, String page, SortBy sortBy, SortOrder sortOrder, AutonomousDatabaseSummary.InfrastructureType infrastructureType, AutonomousDatabaseSummary.LifecycleState lifecycleState, AutonomousDatabaseSummary.DbWorkload dbWorkload, String dbVersion, Boolean isFreeTier, String displayName, String opcRequestId, Boolean isRefreshableClone, Boolean isDataGuardEnabled) {
        this.compartmentId = compartmentId;
        this.autonomousContainerDatabaseId = autonomousContainerDatabaseId;
        this.limit = limit;
        this.page = page;
        this.sortBy = sortBy;
        this.sortOrder = sortOrder;
        this.infrastructureType = infrastructureType;
        this.lifecycleState = lifecycleState;
        this.dbWorkload = dbWorkload;
        this.dbVersion = dbVersion;
        this.isFreeTier = isFreeTier;
        this.displayName = displayName;
        this.opcRequestId = opcRequestId;
        this.isRefreshableClone = isRefreshableClone;
        this.isDataGuardEnabled = isDataGuardEnabled;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).autonomousContainerDatabaseId(this.autonomousContainerDatabaseId).limit(this.limit).page(this.page).sortBy(this.sortBy).sortOrder(this.sortOrder).infrastructureType(this.infrastructureType).lifecycleState(this.lifecycleState).dbWorkload(this.dbWorkload).dbVersion(this.dbVersion).isFreeTier(this.isFreeTier).displayName(this.displayName).opcRequestId(this.opcRequestId).isRefreshableClone(this.isRefreshableClone).isDataGuardEnabled(this.isDataGuardEnabled);
    }

    public String toString() {
        return "ListAutonomousDatabasesRequest(super=" + super.toString() + ", compartmentId=" + this.getCompartmentId() + ", autonomousContainerDatabaseId=" + this.getAutonomousContainerDatabaseId() + ", limit=" + this.getLimit() + ", page=" + this.getPage() + ", sortBy=" + (Object)((Object)this.getSortBy()) + ", sortOrder=" + (Object)((Object)this.getSortOrder()) + ", infrastructureType=" + (Object)((Object)this.getInfrastructureType()) + ", lifecycleState=" + (Object)((Object)this.getLifecycleState()) + ", dbWorkload=" + (Object)((Object)this.getDbWorkload()) + ", dbVersion=" + this.getDbVersion() + ", isFreeTier=" + this.getIsFreeTier() + ", displayName=" + this.getDisplayName() + ", opcRequestId=" + this.getOpcRequestId() + ", isRefreshableClone=" + this.getIsRefreshableClone() + ", isDataGuardEnabled=" + this.getIsDataGuardEnabled() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListAutonomousDatabasesRequest)) {
            return false;
        }
        ListAutonomousDatabasesRequest other = (ListAutonomousDatabasesRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        Boolean this$isFreeTier = this.getIsFreeTier();
        Boolean other$isFreeTier = other.getIsFreeTier();
        if (this$isFreeTier == null ? other$isFreeTier != null : !((Object)this$isFreeTier).equals(other$isFreeTier)) {
            return false;
        }
        Boolean this$isRefreshableClone = this.getIsRefreshableClone();
        Boolean other$isRefreshableClone = other.getIsRefreshableClone();
        if (this$isRefreshableClone == null ? other$isRefreshableClone != null : !((Object)this$isRefreshableClone).equals(other$isRefreshableClone)) {
            return false;
        }
        Boolean this$isDataGuardEnabled = this.getIsDataGuardEnabled();
        Boolean other$isDataGuardEnabled = other.getIsDataGuardEnabled();
        if (this$isDataGuardEnabled == null ? other$isDataGuardEnabled != null : !((Object)this$isDataGuardEnabled).equals(other$isDataGuardEnabled)) {
            return false;
        }
        String this$compartmentId = this.getCompartmentId();
        String other$compartmentId = other.getCompartmentId();
        if (this$compartmentId == null ? other$compartmentId != null : !this$compartmentId.equals(other$compartmentId)) {
            return false;
        }
        String this$autonomousContainerDatabaseId = this.getAutonomousContainerDatabaseId();
        String other$autonomousContainerDatabaseId = other.getAutonomousContainerDatabaseId();
        if (this$autonomousContainerDatabaseId == null ? other$autonomousContainerDatabaseId != null : !this$autonomousContainerDatabaseId.equals(other$autonomousContainerDatabaseId)) {
            return false;
        }
        String this$page = this.getPage();
        String other$page = other.getPage();
        if (this$page == null ? other$page != null : !this$page.equals(other$page)) {
            return false;
        }
        SortBy this$sortBy = this.getSortBy();
        SortBy other$sortBy = other.getSortBy();
        if (this$sortBy == null ? other$sortBy != null : !((Object)((Object)this$sortBy)).equals((Object)other$sortBy)) {
            return false;
        }
        SortOrder this$sortOrder = this.getSortOrder();
        SortOrder other$sortOrder = other.getSortOrder();
        if (this$sortOrder == null ? other$sortOrder != null : !((Object)((Object)this$sortOrder)).equals((Object)other$sortOrder)) {
            return false;
        }
        AutonomousDatabaseSummary.InfrastructureType this$infrastructureType = this.getInfrastructureType();
        AutonomousDatabaseSummary.InfrastructureType other$infrastructureType = other.getInfrastructureType();
        if (this$infrastructureType == null ? other$infrastructureType != null : !((Object)((Object)this$infrastructureType)).equals((Object)other$infrastructureType)) {
            return false;
        }
        AutonomousDatabaseSummary.LifecycleState this$lifecycleState = this.getLifecycleState();
        AutonomousDatabaseSummary.LifecycleState other$lifecycleState = other.getLifecycleState();
        if (this$lifecycleState == null ? other$lifecycleState != null : !((Object)((Object)this$lifecycleState)).equals((Object)other$lifecycleState)) {
            return false;
        }
        AutonomousDatabaseSummary.DbWorkload this$dbWorkload = this.getDbWorkload();
        AutonomousDatabaseSummary.DbWorkload other$dbWorkload = other.getDbWorkload();
        if (this$dbWorkload == null ? other$dbWorkload != null : !((Object)((Object)this$dbWorkload)).equals((Object)other$dbWorkload)) {
            return false;
        }
        String this$dbVersion = this.getDbVersion();
        String other$dbVersion = other.getDbVersion();
        if (this$dbVersion == null ? other$dbVersion != null : !this$dbVersion.equals(other$dbVersion)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$opcRequestId = this.getOpcRequestId();
        String other$opcRequestId = other.getOpcRequestId();
        return !(this$opcRequestId == null ? other$opcRequestId != null : !this$opcRequestId.equals(other$opcRequestId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ListAutonomousDatabasesRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        Boolean $isFreeTier = this.getIsFreeTier();
        result = result * 59 + ($isFreeTier == null ? 43 : ((Object)$isFreeTier).hashCode());
        Boolean $isRefreshableClone = this.getIsRefreshableClone();
        result = result * 59 + ($isRefreshableClone == null ? 43 : ((Object)$isRefreshableClone).hashCode());
        Boolean $isDataGuardEnabled = this.getIsDataGuardEnabled();
        result = result * 59 + ($isDataGuardEnabled == null ? 43 : ((Object)$isDataGuardEnabled).hashCode());
        String $compartmentId = this.getCompartmentId();
        result = result * 59 + ($compartmentId == null ? 43 : $compartmentId.hashCode());
        String $autonomousContainerDatabaseId = this.getAutonomousContainerDatabaseId();
        result = result * 59 + ($autonomousContainerDatabaseId == null ? 43 : $autonomousContainerDatabaseId.hashCode());
        String $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : $page.hashCode());
        SortBy $sortBy = this.getSortBy();
        result = result * 59 + ($sortBy == null ? 43 : ((Object)((Object)$sortBy)).hashCode());
        SortOrder $sortOrder = this.getSortOrder();
        result = result * 59 + ($sortOrder == null ? 43 : ((Object)((Object)$sortOrder)).hashCode());
        AutonomousDatabaseSummary.InfrastructureType $infrastructureType = this.getInfrastructureType();
        result = result * 59 + ($infrastructureType == null ? 43 : ((Object)((Object)$infrastructureType)).hashCode());
        AutonomousDatabaseSummary.LifecycleState $lifecycleState = this.getLifecycleState();
        result = result * 59 + ($lifecycleState == null ? 43 : ((Object)((Object)$lifecycleState)).hashCode());
        AutonomousDatabaseSummary.DbWorkload $dbWorkload = this.getDbWorkload();
        result = result * 59 + ($dbWorkload == null ? 43 : ((Object)((Object)$dbWorkload)).hashCode());
        String $dbVersion = this.getDbVersion();
        result = result * 59 + ($dbVersion == null ? 43 : $dbVersion.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $opcRequestId = this.getOpcRequestId();
        result = result * 59 + ($opcRequestId == null ? 43 : $opcRequestId.hashCode());
        return result;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getAutonomousContainerDatabaseId() {
        return this.autonomousContainerDatabaseId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public AutonomousDatabaseSummary.InfrastructureType getInfrastructureType() {
        return this.infrastructureType;
    }

    public AutonomousDatabaseSummary.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public AutonomousDatabaseSummary.DbWorkload getDbWorkload() {
        return this.dbWorkload;
    }

    public String getDbVersion() {
        return this.dbVersion;
    }

    public Boolean getIsFreeTier() {
        return this.isFreeTier;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Boolean getIsRefreshableClone() {
        return this.isRefreshableClone;
    }

    public Boolean getIsDataGuardEnabled() {
        return this.isDataGuardEnabled;
    }

    public static class Builder
    implements BmcRequest.Builder<ListAutonomousDatabasesRequest, Void> {
        private String compartmentId;
        private String autonomousContainerDatabaseId;
        private Integer limit;
        private String page;
        private SortBy sortBy;
        private SortOrder sortOrder;
        private AutonomousDatabaseSummary.InfrastructureType infrastructureType;
        private AutonomousDatabaseSummary.LifecycleState lifecycleState;
        private AutonomousDatabaseSummary.DbWorkload dbWorkload;
        private String dbVersion;
        private Boolean isFreeTier;
        private String displayName;
        private String opcRequestId;
        private Boolean isRefreshableClone;
        private Boolean isDataGuardEnabled;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListAutonomousDatabasesRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.autonomousContainerDatabaseId(o.getAutonomousContainerDatabaseId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.infrastructureType(o.getInfrastructureType());
            this.lifecycleState(o.getLifecycleState());
            this.dbWorkload(o.getDbWorkload());
            this.dbVersion(o.getDbVersion());
            this.isFreeTier(o.getIsFreeTier());
            this.displayName(o.getDisplayName());
            this.opcRequestId(o.getOpcRequestId());
            this.isRefreshableClone(o.getIsRefreshableClone());
            this.isDataGuardEnabled(o.getIsDataGuardEnabled());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListAutonomousDatabasesRequest build() {
            ListAutonomousDatabasesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder autonomousContainerDatabaseId(String autonomousContainerDatabaseId) {
            this.autonomousContainerDatabaseId = autonomousContainerDatabaseId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder infrastructureType(AutonomousDatabaseSummary.InfrastructureType infrastructureType) {
            this.infrastructureType = infrastructureType;
            return this;
        }

        public Builder lifecycleState(AutonomousDatabaseSummary.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder dbWorkload(AutonomousDatabaseSummary.DbWorkload dbWorkload) {
            this.dbWorkload = dbWorkload;
            return this;
        }

        public Builder dbVersion(String dbVersion) {
            this.dbVersion = dbVersion;
            return this;
        }

        public Builder isFreeTier(Boolean isFreeTier) {
            this.isFreeTier = isFreeTier;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder isRefreshableClone(Boolean isRefreshableClone) {
            this.isRefreshableClone = isRefreshableClone;
            return this;
        }

        public Builder isDataGuardEnabled(Boolean isDataGuardEnabled) {
            this.isDataGuardEnabled = isDataGuardEnabled;
            return this;
        }

        public ListAutonomousDatabasesRequest buildWithoutInvocationCallback() {
            return new ListAutonomousDatabasesRequest(this.compartmentId, this.autonomousContainerDatabaseId, this.limit, this.page, this.sortBy, this.sortOrder, this.infrastructureType, this.lifecycleState, this.dbWorkload, this.dbVersion, this.isFreeTier, this.displayName, this.opcRequestId, this.isRefreshableClone, this.isDataGuardEnabled);
        }

        public String toString() {
            return "ListAutonomousDatabasesRequest.Builder(compartmentId=" + this.compartmentId + ", autonomousContainerDatabaseId=" + this.autonomousContainerDatabaseId + ", limit=" + this.limit + ", page=" + this.page + ", sortBy=" + (Object)((Object)this.sortBy) + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", infrastructureType=" + (Object)((Object)this.infrastructureType) + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ", dbWorkload=" + (Object)((Object)this.dbWorkload) + ", dbVersion=" + this.dbVersion + ", isFreeTier=" + this.isFreeTier + ", displayName=" + this.displayName + ", opcRequestId=" + this.opcRequestId + ", isRefreshableClone=" + this.isRefreshableClone + ", isDataGuardEnabled=" + this.isDataGuardEnabled + ")";
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy {
        Timecreated("TIMECREATED"),
        Displayname("DISPLAYNAME");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

