/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.problems;

import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.execute.BeanRunConfig;
import org.netbeans.modules.maven.execute.MavenProxySupport;
import org.netbeans.modules.maven.problems.Bundle;
import org.netbeans.modules.maven.problems.MavenModelProblemsProvider;
import org.netbeans.spi.project.ui.ProjectProblemResolver;
import org.netbeans.spi.project.ui.ProjectProblemsProvider;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class SanityBuildAction
implements ProjectProblemResolver {
    private static final Logger LOG = Logger.getLogger(SanityBuildAction.class.getName());
    private final Project nbproject;
    private volatile CompletableFuture<ProjectProblemsProvider.Result> pendingResult;

    public SanityBuildAction(Project nbproject) {
        this.nbproject = nbproject;
    }

    public SanityBuildAction(Project nbproject, Future<ProjectProblemsProvider.Result> otherResult) {
        this.nbproject = nbproject;
    }

    public Future<ProjectProblemsProvider.Result> getPendingResult() {
        return this.pendingResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<ProjectProblemsProvider.Result> resolve() {
        CompletableFuture<ProjectProblemsProvider.Result> pr = this.pendingResult;
        if (pr != null && !pr.isDone()) {
            LOG.log(Level.FINE, "SanityBuild.resolve returns: {0}", this.pendingResult);
            return this.pendingResult;
        }
        final CompletableFuture<ProjectProblemsProvider.Result> publicResult = new CompletableFuture<ProjectProblemsProvider.Result>();
        Runnable toRet = new Runnable(){

            @Override
            public void run() {
                try {
                    LOG.log(Level.FINE, "Configuring sanity build");
                    BeanRunConfig config = new BeanRunConfig();
                    config.setExecutionDirectory(FileUtil.toFile((FileObject)SanityBuildAction.this.nbproject.getProjectDirectory()));
                    NbMavenProject mavenPrj = (NbMavenProject)SanityBuildAction.this.nbproject.getLookup().lookup(NbMavenProject.class);
                    if (mavenPrj != null && mavenPrj.getMavenProject().getVersion() != null && mavenPrj.getMavenProject().getVersion().endsWith("SNAPSHOT")) {
                        config.setGoals(Arrays.asList("--fail-at-end", "install"));
                    } else {
                        config.setGoals(Arrays.asList("--fail-at-end", "package"));
                    }
                    config.setReactorStyle(RunConfig.ReactorStyle.ALSO_MAKE);
                    config.setProperty("skipTests", "true");
                    config.setProject(SanityBuildAction.this.nbproject);
                    String label = Bundle.build_label(SanityBuildAction.this.nbproject.getProjectDirectory().getNameExt());
                    config.setExecutionName(label);
                    config.setTaskDisplayName(label);
                    MavenProxySupport mps = (MavenProxySupport)SanityBuildAction.this.nbproject.getLookup().lookup(MavenProxySupport.class);
                    if (mps != null) {
                        try {
                            MavenProxySupport.ProxyResult res = mps.checkProxySettings().get();
                            if (res.getStatus() == MavenProxySupport.Status.ABORT) {
                                ProjectProblemsProvider.Result r = ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.UNRESOLVED, (String)Bundle.ERR_SanityBuildCancalled());
                                publicResult.complete(r);
                                return;
                            }
                        }
                        catch (ExecutionException ex) {
                            ProjectProblemsProvider.Result r = ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.UNRESOLVED, (String)Bundle.ERR_ProxyUpdateFailed(ex.getLocalizedMessage()));
                            publicResult.complete(r);
                            return;
                        }
                        catch (InterruptedException ex) {
                            ProjectProblemsProvider.Result r = ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.UNRESOLVED, (String)Bundle.ERR_SanityBuildCancalled());
                            publicResult.complete(r);
                            return;
                        }
                    }
                    LOG.log(Level.FINE, "Executing sanity build: goals = {0}, properties = {1}", new Object[]{config.getGoals(), config.getProperties()});
                    ExecutorTask et = RunUtils.run(config);
                    et.addTaskListener(t -> {
                        ProjectProblemsProvider.Result r = ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.RESOLVED, (String)Bundle.ACT_start_validate());
                        LOG.log(Level.FINE, "Sanity build finished.");
                        publicResult.complete(r);
                    });
                }
                catch (Error | RuntimeException e) {
                    LOG.log(Level.FINE, "Sanity build failed", e);
                    publicResult.completeExceptionally(e);
                    throw e;
                }
            }
        };
        SanityBuildAction sanityBuildAction = this;
        synchronized (sanityBuildAction) {
            if (this.pendingResult != pr) {
                return this.pendingResult;
            }
            this.pendingResult = publicResult;
        }
        MavenModelProblemsProvider.RP.submit(toRet);
        return publicResult;
    }

    public int hashCode() {
        int hash = SanityBuildAction.class.hashCode();
        hash = 67 * hash + (this.nbproject != null ? this.nbproject.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SanityBuildAction other = (SanityBuildAction)obj;
        return this.nbproject == other.nbproject || this.nbproject != null && this.nbproject.equals(other.nbproject);
    }
}

