/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.identity.model.IdentityProvider;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ListIdentityProviderGroupsRequest
extends BmcRequest<Void> {
    private String identityProviderId;
    private String page;
    private Integer limit;
    private String name;
    private IdentityProvider.LifecycleState lifecycleState;

    @ConstructorProperties(value={"identityProviderId", "page", "limit", "name", "lifecycleState"})
    ListIdentityProviderGroupsRequest(String identityProviderId, String page, Integer limit, String name, IdentityProvider.LifecycleState lifecycleState) {
        this.identityProviderId = identityProviderId;
        this.page = page;
        this.limit = limit;
        this.name = name;
        this.lifecycleState = lifecycleState;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().identityProviderId(this.identityProviderId).page(this.page).limit(this.limit).name(this.name).lifecycleState(this.lifecycleState);
    }

    public String toString() {
        return "ListIdentityProviderGroupsRequest(super=" + super.toString() + ", identityProviderId=" + this.getIdentityProviderId() + ", page=" + this.getPage() + ", limit=" + this.getLimit() + ", name=" + this.getName() + ", lifecycleState=" + (Object)((Object)this.getLifecycleState()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListIdentityProviderGroupsRequest)) {
            return false;
        }
        ListIdentityProviderGroupsRequest other = (ListIdentityProviderGroupsRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        String this$identityProviderId = this.getIdentityProviderId();
        String other$identityProviderId = other.getIdentityProviderId();
        if (this$identityProviderId == null ? other$identityProviderId != null : !this$identityProviderId.equals(other$identityProviderId)) {
            return false;
        }
        String this$page = this.getPage();
        String other$page = other.getPage();
        if (this$page == null ? other$page != null : !this$page.equals(other$page)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        IdentityProvider.LifecycleState this$lifecycleState = this.getLifecycleState();
        IdentityProvider.LifecycleState other$lifecycleState = other.getLifecycleState();
        return !(this$lifecycleState == null ? other$lifecycleState != null : !((Object)((Object)this$lifecycleState)).equals((Object)other$lifecycleState));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ListIdentityProviderGroupsRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        String $identityProviderId = this.getIdentityProviderId();
        result = result * 59 + ($identityProviderId == null ? 43 : $identityProviderId.hashCode());
        String $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : $page.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        IdentityProvider.LifecycleState $lifecycleState = this.getLifecycleState();
        result = result * 59 + ($lifecycleState == null ? 43 : ((Object)((Object)$lifecycleState)).hashCode());
        return result;
    }

    public String getIdentityProviderId() {
        return this.identityProviderId;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getName() {
        return this.name;
    }

    public IdentityProvider.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public static class Builder
    implements BmcRequest.Builder<ListIdentityProviderGroupsRequest, Void> {
        private String identityProviderId;
        private String page;
        private Integer limit;
        private String name;
        private IdentityProvider.LifecycleState lifecycleState;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListIdentityProviderGroupsRequest o) {
            this.identityProviderId(o.getIdentityProviderId());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.name(o.getName());
            this.lifecycleState(o.getLifecycleState());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListIdentityProviderGroupsRequest build() {
            ListIdentityProviderGroupsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder identityProviderId(String identityProviderId) {
            this.identityProviderId = identityProviderId;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder lifecycleState(IdentityProvider.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public ListIdentityProviderGroupsRequest buildWithoutInvocationCallback() {
            return new ListIdentityProviderGroupsRequest(this.identityProviderId, this.page, this.limit, this.name, this.lifecycleState);
        }

        public String toString() {
            return "ListIdentityProviderGroupsRequest.Builder(identityProviderId=" + this.identityProviderId + ", page=" + this.page + ", limit=" + this.limit + ", name=" + this.name + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ")";
        }
    }
}

