/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.identity.model.OAuth2ClientCredentialSummary;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ListOAuthClientCredentialsRequest
extends BmcRequest<Void> {
    private String userId;
    private String page;
    private Integer limit;
    private OAuth2ClientCredentialSummary.LifecycleState lifecycleState;

    @ConstructorProperties(value={"userId", "page", "limit", "lifecycleState"})
    ListOAuthClientCredentialsRequest(String userId, String page, Integer limit, OAuth2ClientCredentialSummary.LifecycleState lifecycleState) {
        this.userId = userId;
        this.page = page;
        this.limit = limit;
        this.lifecycleState = lifecycleState;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().userId(this.userId).page(this.page).limit(this.limit).lifecycleState(this.lifecycleState);
    }

    public String toString() {
        return "ListOAuthClientCredentialsRequest(super=" + super.toString() + ", userId=" + this.getUserId() + ", page=" + this.getPage() + ", limit=" + this.getLimit() + ", lifecycleState=" + (Object)((Object)this.getLifecycleState()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListOAuthClientCredentialsRequest)) {
            return false;
        }
        ListOAuthClientCredentialsRequest other = (ListOAuthClientCredentialsRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$page = this.getPage();
        String other$page = other.getPage();
        if (this$page == null ? other$page != null : !this$page.equals(other$page)) {
            return false;
        }
        OAuth2ClientCredentialSummary.LifecycleState this$lifecycleState = this.getLifecycleState();
        OAuth2ClientCredentialSummary.LifecycleState other$lifecycleState = other.getLifecycleState();
        return !(this$lifecycleState == null ? other$lifecycleState != null : !((Object)((Object)this$lifecycleState)).equals((Object)other$lifecycleState));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ListOAuthClientCredentialsRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : $page.hashCode());
        OAuth2ClientCredentialSummary.LifecycleState $lifecycleState = this.getLifecycleState();
        result = result * 59 + ($lifecycleState == null ? 43 : ((Object)((Object)$lifecycleState)).hashCode());
        return result;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public OAuth2ClientCredentialSummary.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public static class Builder
    implements BmcRequest.Builder<ListOAuthClientCredentialsRequest, Void> {
        private String userId;
        private String page;
        private Integer limit;
        private OAuth2ClientCredentialSummary.LifecycleState lifecycleState;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListOAuthClientCredentialsRequest o) {
            this.userId(o.getUserId());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.lifecycleState(o.getLifecycleState());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListOAuthClientCredentialsRequest build() {
            ListOAuthClientCredentialsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder lifecycleState(OAuth2ClientCredentialSummary.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public ListOAuthClientCredentialsRequest buildWithoutInvocationCallback() {
            return new ListOAuthClientCredentialsRequest(this.userId, this.page, this.limit, this.lifecycleState);
        }

        public String toString() {
            return "ListOAuthClientCredentialsRequest.Builder(userId=" + this.userId + ", page=" + this.page + ", limit=" + this.limit + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ")";
        }
    }
}

