/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.openjdk.project;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.swing.Action;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.java.openjdk.common.BuildUtils;
import org.netbeans.modules.java.openjdk.common.ShortcutUtils;
import org.netbeans.modules.java.openjdk.project.Bundle;
import org.netbeans.modules.java.openjdk.project.JDKProject;
import org.netbeans.modules.java.openjdk.project.Settings;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.ActionProgress;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.ui.support.ProjectSensitiveActions;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Pair;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public class ActionProviderImpl
implements ActionProvider {
    private static final String COMMAND_BUILD_FAST = "build-fast";
    private static final String COMMAND_BUILD_GENERIC_FAST = "build-generic-fast";
    private static final String COMMAND_SELECT_TOOL = "select.tool";
    private static final Map<Pair<String, RootKind>, String[]> command2Targets = new HashMap<Pair<String, RootKind>, String[]>(){
        {
            this.put(Pair.of((Object)"build", (Object)((Object)RootKind.SOURCE)), new String[]{"build"});
            this.put(Pair.of((Object)"build", (Object)((Object)RootKind.TEST)), new String[]{"build"});
            this.put(Pair.of((Object)ActionProviderImpl.COMMAND_BUILD_FAST, (Object)((Object)RootKind.SOURCE)), new String[]{ActionProviderImpl.COMMAND_BUILD_FAST});
            this.put(Pair.of((Object)ActionProviderImpl.COMMAND_BUILD_FAST, (Object)((Object)RootKind.TEST)), new String[]{ActionProviderImpl.COMMAND_BUILD_FAST});
            this.put(Pair.of((Object)"clean", (Object)((Object)RootKind.SOURCE)), new String[]{"clean"});
            this.put(Pair.of((Object)"clean", (Object)((Object)RootKind.TEST)), new String[]{"clean"});
            this.put(Pair.of((Object)"rebuild", (Object)((Object)RootKind.SOURCE)), new String[]{"clean", "build"});
            this.put(Pair.of((Object)"rebuild", (Object)((Object)RootKind.TEST)), new String[]{"clean", "build"});
            this.put(Pair.of((Object)"compile.single", (Object)((Object)RootKind.SOURCE)), new String[]{"compile-single"});
            this.put(Pair.of((Object)"compile.single", (Object)((Object)RootKind.TEST)), new String[]{"compile-single"});
            this.put(Pair.of((Object)"run", (Object)((Object)RootKind.SOURCE)), new String[]{"run"});
            this.put(Pair.of((Object)"run", (Object)((Object)RootKind.TEST)), new String[]{"run"});
            this.put(Pair.of((Object)"run.single", (Object)((Object)RootKind.SOURCE)), new String[]{"run-single"});
            this.put(Pair.of((Object)"run.single", (Object)((Object)RootKind.TEST)), new String[]{"jtreg"});
            this.put(Pair.of((Object)"debug", (Object)((Object)RootKind.SOURCE)), new String[]{"debug"});
            this.put(Pair.of((Object)"debug", (Object)((Object)RootKind.TEST)), new String[]{"debug"});
            this.put(Pair.of((Object)"debug.single", (Object)((Object)RootKind.SOURCE)), new String[]{"debug-single"});
            this.put(Pair.of((Object)"debug.single", (Object)((Object)RootKind.TEST)), new String[]{"debug-jtreg"});
            this.put(Pair.of((Object)ActionProviderImpl.COMMAND_SELECT_TOOL, (Object)((Object)RootKind.SOURCE)), new String[]{"select-tool"});
            this.put(Pair.of((Object)ActionProviderImpl.COMMAND_SELECT_TOOL, (Object)((Object)RootKind.TEST)), new String[]{"select-tool"});
        }
    };
    private static final Map<Pair<String, RootKind>, RunSingleConfig> command2Properties = new HashMap<Pair<String, RootKind>, RunSingleConfig>(){
        {
            this.put(Pair.of((Object)"compile.single", (Object)((Object)RootKind.SOURCE)), new RunSingleConfig("includes", RunSingleConfig.Type.RELATIVE, ","));
            this.put(Pair.of((Object)"compile.single", (Object)((Object)RootKind.TEST)), new RunSingleConfig("includes", RunSingleConfig.Type.RELATIVE, ","));
            this.put(Pair.of((Object)"run.single", (Object)((Object)RootKind.SOURCE)), new RunSingleConfig("run.classname", RunSingleConfig.Type.CLASSNAME, null));
            this.put(Pair.of((Object)"run.single", (Object)((Object)RootKind.TEST)), new RunSingleConfig("jtreg.tests", RunSingleConfig.Type.RELATIVE, " "));
            this.put(Pair.of((Object)"debug.single", (Object)((Object)RootKind.SOURCE)), new RunSingleConfig("debug.classname", RunSingleConfig.Type.CLASSNAME, null));
            this.put(Pair.of((Object)"debug.single", (Object)((Object)RootKind.TEST)), new RunSingleConfig("jtreg.tests", RunSingleConfig.Type.RELATIVE, " "));
        }
    };
    private final JDKProject project;
    private final FileObject repository;
    private final FileObject script;
    private final FileObject genericScript;
    private final String[] supportedActions;
    private final String[] genericSupportedActions;

    public ActionProviderImpl(JDKProject project) {
        FileObject repo;
        this.project = project;
        this.repository = repo = project.currentModule != null ? project.getProjectDirectory().getParent().getParent() : project.getProjectDirectory().getParent();
        File scriptFile = InstalledFileLocator.getDefault().locate("scripts/build-generic.xml", "org.netbeans.modules.java.openjdk.project", false);
        this.genericScript = FileUtil.toFileObject((File)scriptFile);
        if (project.currentModule != null && project.moduleRepository.isConsolidatedRepo()) {
            String repoName = ShortcutUtils.getDefault().inferLegacyRepository(project);
            File fastBuild = InstalledFileLocator.getDefault().locate("scripts/build-" + repoName + "-consol.xml", "org.netbeans.modules.java.openjdk.project", false);
            if (fastBuild != null && ShortcutUtils.getDefault().shouldUseCustomBuild(repoName, FileUtil.getRelativePath((FileObject)repo, (FileObject)project.getProjectDirectory()))) {
                scriptFile = fastBuild;
            }
        } else {
            String repoName = repo.getNameExt();
            File fastBuild = InstalledFileLocator.getDefault().locate("scripts/build-" + repoName + ".xml", "org.netbeans.modules.java.openjdk.project", false);
            if (fastBuild != null && ShortcutUtils.getDefault().shouldUseCustomBuild(repoName, FileUtil.getRelativePath((FileObject)repo, (FileObject)project.getProjectDirectory()))) {
                scriptFile = fastBuild;
            }
        }
        this.script = FileUtil.toFileObject((File)scriptFile);
        this.supportedActions = this.readSupportedActions(this.script);
        this.genericSupportedActions = this.readSupportedActions(this.genericScript);
    }

    private String[] readSupportedActions(FileObject from) {
        String[] supported = new String[]{};
        try {
            for (String l : from.asLines("UTF-8")) {
                if (!l.contains("SUPPORTED_ACTIONS:")) continue;
                String[] actions = l.substring(l.indexOf(58) + 1).trim().split(",");
                HashSet<String> filteredActions = new HashSet<String>();
                for (Pair<String, RootKind> k : command2Targets.keySet()) {
                    filteredActions.add((String)k.first());
                }
                filteredActions.retainAll(Arrays.asList(actions));
                filteredActions.add(COMMAND_BUILD_GENERIC_FAST);
                filteredActions.add("profile.test.single");
                supported = filteredActions.toArray(new String[0]);
                break;
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return supported;
    }

    public String[] getSupportedActions() {
        Settings settings = (Settings)this.project.getLookup().lookup(Settings.class);
        return settings.isUseAntBuild() ? this.supportedActions : this.genericSupportedActions;
    }

    public void invokeAction(String command, Lookup context) throws IllegalArgumentException {
        if ("profile.test.single".equals(command)) {
            for (ActionProvider ap : Lookup.getDefault().lookupAll(ActionProvider.class)) {
                if (!new HashSet<String>(Arrays.asList(ap.getSupportedActions())).contains("profile.test.single") || !ap.isActionEnabled("profile.test.single", context)) continue;
                ap.invokeAction("profile.test.single", context);
                return;
            }
        }
        FileObject scriptFO = this.script;
        Settings settings = (Settings)this.project.getLookup().lookup(Settings.class);
        Properties props = new Properties();
        if (settings.isUseAntBuild()) {
            props.put("langtools.build.location", settings.getAntBuildLocation());
        } else {
            scriptFO = this.genericScript;
            if (COMMAND_BUILD_FAST.equals(command)) {
                command = COMMAND_BUILD_GENERIC_FAST;
            }
        }
        if (COMMAND_BUILD_GENERIC_FAST.equals(command)) {
            switch (settings.getRunBuildSetting()) {
                case NEVER: {
                    ActionProgress.start((Lookup)context).finished(true);
                    return;
                }
            }
            scriptFO = this.genericScript;
            command = COMMAND_BUILD_FAST;
        }
        String extraTargets = context.lookupAll(BuildUtils.ExtraMakeTargets.class).stream().flatMap(emt -> Arrays.stream(emt.getExtraMakeTargets())).collect(Collectors.joining(" "));
        FileObject basedirFO = this.project.currentModule != null ? (scriptFO == this.genericScript ? this.project.moduleRepository.getJDKRoot() : this.repository) : this.repository.getParent();
        props.put("basedir", FileUtil.toFile((FileObject)basedirFO).getAbsolutePath());
        props.put("CONF", this.project.configurations.getActiveConfiguration().getLocation().getName());
        props.put("nb.jdk.project.target.java.home", BuildUtils.findTargetJavaHome(this.project.getProjectDirectory()).getAbsolutePath());
        props.put("nb.extra.make.targets", extraTargets);
        RootKind kind = this.getKind(context);
        RunSingleConfig singleFileProperty = command2Properties.get(Pair.of((Object)command, (Object)((Object)kind)));
        if (singleFileProperty != null) {
            String srcdir = "";
            String moduleName = "";
            StringBuilder value = new StringBuilder();
            String sep = "";
            for (FileObject file : context.lookupAll(FileObject.class)) {
                ClassPath sourceCP;
                value.append(sep);
                switch (kind) {
                    case SOURCE: {
                        sourceCP = ClassPath.getClassPath((FileObject)file, (String)"classpath/source");
                        break;
                    }
                    case TEST: {
                        sourceCP = ClassPathSupport.createClassPath((FileObject[])new FileObject[]{BuildUtils.getFileObject(this.project.getProjectDirectory(), "../../test")});
                        break;
                    }
                    default: {
                        throw new IllegalStateException(kind.name());
                    }
                }
                value.append(singleFileProperty.valueType.convert(sourceCP, file));
                sep = singleFileProperty.separator;
                FileObject ownerRoot = sourceCP.findOwnerRoot(file);
                srcdir = FileUtil.getRelativePath((FileObject)BuildUtils.getFileObject(this.project.getProjectDirectory(), "../.."), (FileObject)ownerRoot);
                moduleName = ownerRoot.getParent().getParent().getNameExt();
            }
            props.put(singleFileProperty.propertyName, value.toString());
            props.put("srcdir", srcdir);
            props.put("module.name", moduleName);
        }
        final ActionProgress progress = ActionProgress.start((Lookup)context);
        try {
            ActionUtils.runTarget((FileObject)scriptFO, (String[])command2Targets.get(Pair.of((Object)command, (Object)((Object)kind))), (Properties)props).addTaskListener(new TaskListener(){

                public void taskFinished(Task task) {
                    progress.finished(((ExecutorTask)task).result() == 0);
                }
            });
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            progress.finished(false);
        }
    }

    public boolean isActionEnabled(String command, Lookup context) throws IllegalArgumentException {
        int fileCount;
        RootKind kind = this.getKind(context);
        RunSingleConfig singleFileProperty = command2Properties.get(Pair.of((Object)command, (Object)((Object)kind)));
        return singleFileProperty == null || (fileCount = context.lookupAll(FileObject.class).size()) != 0 && (fileCount <= 1 || singleFileProperty.separator != null);
    }

    private RootKind getKind(Lookup context) {
        FileObject aFile = (FileObject)context.lookup(FileObject.class);
        FileObject testDir = BuildUtils.getFileObject(this.project.getProjectDirectory(), "../../test");
        return aFile != null && testDir != null && FileUtil.isParentOf((FileObject)testDir, (FileObject)aFile) ? RootKind.TEST : RootKind.SOURCE;
    }

    public static Action selectToolAction() {
        return ProjectSensitiveActions.projectCommandAction((String)COMMAND_SELECT_TOOL, (String)Bundle.DN_SelectTool(), null);
    }

    private static enum RootKind {
        SOURCE,
        TEST;

    }

    private static final class RunSingleConfig {
        public final String propertyName;
        public final Type valueType;
        public final String separator;

        public RunSingleConfig(String propertyName, Type valueType, String separator) {
            this.propertyName = propertyName;
            this.valueType = valueType;
            this.separator = separator;
        }

        static enum Type {
            RELATIVE{

                @Override
                public String convert(ClassPath sourceCP, FileObject file) {
                    return sourceCP.getResourceName(file);
                }
            }
            ,
            CLASSNAME{

                @Override
                public String convert(ClassPath sourceCP, FileObject file) {
                    return sourceCP.getResourceName(file, '.', false);
                }
            };


            public abstract String convert(ClassPath var1, FileObject var2);
        }
    }
}

